---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-lint_yaml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Yaml/Command/LintCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Component/Yaml/Command/LintCommand.php` L36（AsCommand属性定義）
- E-03: `src/Symfony/Component/Yaml/Command/LintCommand.php` L53-87（configure メソッド）
- E-04: `src/Symfony/Component/Yaml/Command/LintCommand.php` L89-128（execute メソッド）
- E-05: `src/Symfony/Component/Yaml/Command/LintCommand.php` L130-149（validate メソッド）
- E-06: `src/Symfony/Component/Yaml/Command/LintCommand.php` L218-233（getFiles メソッド）
- E-07: `src/Symfony/Component/Yaml/Command/LintCommand.php` L273-276（getAvailableFormatOptions）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L28（No.27エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `lint:yaml` である | E-02 | ○ |
| C-02 | filename引数は配列型で複数指定可能 | E-03 L56 | ○ |
| C-03 | 出力フォーマットはtxt, json, githubの3種類 | E-07 | ○ |
| C-04 | --excludeオプションで複数パスを除外可能 | E-03 L58, E-04 L121 | ○ |
| C-05 | --parse-tagsオプションがnegatableである | E-03 L59 | ○ |
| C-06 | GitHub Actions環境で自動的にgithubフォーマットが選択される | E-04 L97-99 | ○ |
| C-07 | STDINからの入力に対応（"-"指定） | E-04 L106-108 | ○ |
| C-08 | .yml, .yaml拡張子のファイルを対象とする | E-06 L227 | ○ |
| C-09 | Yaml::PARSE_CONSTANTフラグが常に適用される | E-05 L141 | ○ |
| C-10 | --parse-tags時にYaml::PARSE_CUSTOM_TAGSが追加される | E-04 L102 | ○ |
| C-11 | E_USER_DEPRECATEDがParseExceptionに変換される | E-05 L132-136 | ○ |
| C-12 | カスタムタグエラー時に--parse-tagsの提案が表示される | E-01 L179-181, L192 | ○ |
| C-13 | カスタムディレクトリイテレータプロバイダーを注入可能 | E-01 L45-51 | ○ |
| C-14 | Parserインスタンスは遅延初期化される | E-01 L236-238 | ○ |
| C-15 | 基盤実装パスが正しい | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PARSE_CONSTANTフラグの影響範囲が正しく理解されているか
- [ ] --parse-tagsオプションのnegatable動作が正確に記述されているか
