---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-debug_security_role-hierarchy.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php`（ソースコード全体）
- E-02: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` L29（AsCommand属性定義）
- E-03: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` L38-58（configure メソッド）
- E-04: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` L61-79（execute メソッド）
- E-05: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` L32-36（コンストラクタ）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` L31（No.30エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `debug:security:role-hierarchy` である | E-02 | ○ |
| C-02 | --directionオプションのデフォルト値はTB（Top to Bottom） | E-03 L47 | ○ |
| C-03 | -dショートオプションで方向を指定可能 | E-03 L44 | ○ |
| C-04 | MermaidDirection enumを使用して方向を解決する | E-04 L66 | ○ |
| C-05 | 不正な方向値でFAILUREを返す | E-04 L67-69 | ○ |
| C-06 | MermaidDumperでダンプを実行する | E-04 L72 | ○ |
| C-07 | OUTPUT_RAWモードで出力する | E-04 L75 | ○ |
| C-08 | 成功時にSUCCESSを返す | E-04 L78 | ○ |
| C-09 | RoleHierarchyInterfaceをreadonly依存として注入 | E-05 L33 | ○ |
| C-10 | MermaidDirection::cases()から利用可能な方向値を取得 | E-03 L46, E-04 L67 | ○ |
| C-11 | カテゴリは「SecurityBundle」である | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張がソースコードに基づいている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] MermaidDirection enumの値がコマンドヘルプと一致しているか
- [ ] MermaidDumperの出力形式が正しいMermaid構文であるか（外部クラス参照）
