---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-lint_twig.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **CI/CDパイプラインでの実行タイミング**：一般的な利用方法として記載したが、コード上に直接の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bridge/Twig/Command/LintCommand.php` - LintCommandクラス全体
- E-02: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 39行目 - `#[AsCommand(name: 'lint:twig', ...)]`
- E-03: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 52-81行目 - `configure()` メソッド
- E-04: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 83-111行目 - `execute()` メソッド
- E-05: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 136-174行目 - `validate()` メソッド
- E-06: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 176-184行目 - `display()` メソッド
- E-07: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 125-134行目 - `findFiles()` メソッド
- E-08: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 303-306行目 - `getAvailableFormatOptions()` メソッド
- E-09: `src/Symfony/Bridge/Twig/Command/LintCommand.php` 89行目 - GitHub Actions環境検出

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `lint:twig` である | E-02 | ○ |
| C-02 | Twigテンプレートの構文検証を行う | E-05 | ○ |
| C-03 | 入力はファイル、ディレクトリ、STDINの3種類 | E-03, E-04 | ○ |
| C-04 | 出力フォーマットはtxt/json/githubの3種類 | E-08 | ○ |
| C-05 | --show-deprecationsオプションで非推奨検出可能 | E-03, E-05 | ○ |
| C-06 | --excludesオプションで除外ディレクトリ指定可能 | E-03, E-07 | ○ |
| C-07 | ファイル未指定時はFilesystemLoaderからパスを自動取得 | E-04 | ○ |
| C-08 | Finderを使用してテンプレートファイルを探索する | E-07 | ○ |
| C-09 | tokenize→parse→compileの順で検証する | E-05 | ○ |
| C-10 | ArrayLoaderで一時的にテンプレートを設定する | E-05 | ○ |
| C-11 | GitHub Actions環境を自動検出してフォーマットを切り替える | E-09 | ○ |
| C-12 | GithubActionReporterでアノテーション出力を行う | E-04, E-06 | ○ |
| C-13 | エラーなし・非推奨なしで終了コード0を返す | E-04 | ○ |
| C-14 | エラーまたは非推奨ありで終了コード1を返す | E-04 | ○ |
| C-15 | データベース操作は行わない | E-01 | ○ |
| C-16 | 読み取り専用でファイルを変更しない | E-01 | ○ |
| C-17 | ファイル名パターンは`*.twig`がデフォルト | E-01 | ○ |
| C-18 | CI/CDパイプラインで自動実行される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のCI/CDパイプラインでの利用は一般的なベストプラクティスとして記載したが、ソースコード上には直接的な根拠がない
  - 候補：Symfony公式ドキュメント / CI設定ファイル / プロジェクトのワークフロー定義

## 5) リスクフラグ（レビュー観点）
- 0: 全体的にソースコードに基づいた正確な記述

## 6) レビュアーチェックリスト（最小）
- [ ] 出力フォーマット3種類（txt/json/github）の説明が正確か
- [ ] 非推奨検出機能の説明が実際の動作と一致しているか
- [ ] CI/CDパイプラインでの利用に関する記述が組織のプラクティスと整合しているか
