---
generated_at: 2026-02-04 10:01:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-server_dump.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` - ServerDumpCommandクラス全体
- E-02: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` 38行目 - `#[AsCommand(name: 'server:dump', ...)]`
- E-03: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` 56-74行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` 76-98行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` 44-54行目 - コンストラクタ
- E-06: `src/Symfony/Component/VarDumper/Command/ServerDumpCommand.php` 107-110行目 - `getAvailableFormats()` メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `server:dump` である | E-02 | ○ |
| C-02 | ダンプサーバーを起動してダンプデータを収集・表示する | E-04 | ○ |
| C-03 | 出力フォーマットはcliとhtmlの2種類 | E-05, E-06 | ○ |
| C-04 | デフォルトフォーマットはcli | E-03 | ○ |
| C-05 | DumpServerインスタンスをコンストラクタで受け取る | E-05 | ○ |
| C-06 | CliDescriptorとHtmlDescriptorがデフォルトで登録される | E-05 | ○ |
| C-07 | server->start()でリスニング開始する | E-04 | ○ |
| C-08 | server->listen()でコールバック登録してデータ受信する | E-04 | ○ |
| C-09 | 不正フォーマット指定時にInvalidArgumentExceptionが発生する | E-04 | ○ |
| C-10 | 起動メッセージをSTDERRに出力する | E-04 | ○ |
| C-11 | CONTROL-Cで手動停止する | E-03 | ○ |
| C-12 | html形式はリダイレクトでファイル出力可能 | E-03 | ○ |
| C-13 | データベース操作は行わない | E-01 | ○ |
| C-14 | 常駐型のサーバープロセスである | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。ソースコードが比較的シンプルで全体を網羅的に確認できている。

## 6) レビュアーチェックリスト（最小）
- [ ] DumpServerの接続先ホスト・ポートのデフォルト値がプロジェクト設定と一致しているか
- [ ] DebugBundleでの登録方法が正確か
