---
generated_at: 2026-02-04 10:02:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-debug_twig.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` - DebugCommandクラス全体
- E-02: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 36行目 - `#[AsCommand(name: 'debug:twig', ...)]`
- E-03: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 54-84行目 - `configure()` メソッド
- E-04: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 86-103行目 - `execute()` メソッド
- E-05: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 209-241行目 - `displayGeneralText()` メソッド
- E-06: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 116-189行目 - `displayPathsText()` メソッド
- E-07: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 389-415行目 - `findWrongBundleOverrides()` メソッド
- E-08: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 522-537行目 - `findAlternatives()` メソッド
- E-09: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 297-351行目 - `getMetadata()` メソッド
- E-10: `src/Symfony/Bridge/Twig/Command/DebugCommand.php` 583-586行目 - `getAvailableFormatOptions()` メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `debug:twig` である | E-02 | ○ |
| C-02 | 関数・フィルタ・テスト・グローバル変数を一覧表示する | E-04, E-05 | ○ |
| C-03 | テンプレート名指定でパス解決情報を表示する | E-04, E-06 | ○ |
| C-04 | 出力フォーマットはtxtとjsonの2種類 | E-10 | ○ |
| C-05 | --filterオプションで名前フィルタリング可能 | E-03, E-05 | ○ |
| C-06 | FilesystemLoaderが必要（テンプレート名引数使用時） | E-04 | ○ |
| C-07 | バンドルオーバーライド不整合を検出・警告する | E-07 | ○ |
| C-08 | Levenshtein距離で類似名候補を提示する | E-08 | ○ |
| C-09 | テンプレート名のnamespace/shortname分離を行う | E-06 | ○ |
| C-10 | オーバーライドファイルの表示を行う | E-06 | ○ |
| C-11 | PHPリフレクションでメタデータを取得する | E-09 | ○ |
| C-12 | 関数・フィルタのパラメータ情報を表示する | E-09 | ○ |
| C-13 | needsEnvironment/needsContextの引数を除外する | E-09 | ○ |
| C-14 | データベース操作は行わない | E-01 | ○ |
| C-15 | 読み取り専用の処理である | E-01 | ○ |
| C-16 | デフォルトフォーマットはtxt | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。ソースコードから直接的に確認可能な内容で構成されている。

## 6) レビュアーチェックリスト（最小）
- [ ] 関数・フィルタ・テスト・グローバル変数の各セクションが正確に記述されているか
- [ ] バンドルオーバーライド検出のロジック説明が実際の動作と一致しているか
