---
generated_at: 2026-02-04 10:04:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：35-messenger_consume.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **Supervisorでの管理**：一般的な運用方法として記載したが、コード上には直接の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` - ConsumeMessagesCommandクラス全体
- E-02: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 42行目 - `#[AsCommand(name: 'messenger:consume', ...)]`
- E-03: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 63-138行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 184-303行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 140-149行目 - `initialize()` メソッド
- E-06: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 151-182行目 - `interact()` メソッド
- E-07: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 322-346行目 - `handleSignal()` メソッド
- E-08: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 348-371行目 - `convertToBytes()` メソッド
- E-09: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 43行目 - `SignalableCommandInterface`
- E-10: `src/Symfony/Component/Messenger/Command/ConsumeMessagesCommand.php` 45行目 - `DEFAULT_KEEPALIVE_INTERVAL`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `messenger:consume` である | E-02 | ○ |
| C-02 | メッセージキューからメッセージを消費してディスパッチする | E-04 | ○ |
| C-03 | receivers引数は正規表現パターンに対応 | E-04 | ○ |
| C-04 | --limitで受信メッセージ数を制限可能 | E-03, E-04 | ○ |
| C-05 | --failure-limitで失敗数制限可能 | E-03, E-04 | ○ |
| C-06 | --memory-limitでメモリ制限可能 | E-03, E-04 | ○ |
| C-07 | --time-limitで時間制限可能 | E-03, E-04 | ○ |
| C-08 | --sleepでスリープ秒数を設定可能（デフォルト1秒） | E-03, E-04 | ○ |
| C-09 | --busでディスパッチ先バスを指定可能 | E-03, E-04 | ○ |
| C-10 | --queuesでキューを制限可能 | E-03, E-04 | ○ |
| C-11 | --no-resetでサービスリセットを無効化可能 | E-03, E-04 | ○ |
| C-12 | --allで全レシーバーから消費 | E-03, E-04 | ○ |
| C-13 | --exclude-receiversは--allと併用時のみ有効 | E-05, E-04 | ○ |
| C-14 | --keepaliveでキープアライブ間隔設定可能（デフォルト5秒） | E-03, E-05, E-10 | ○ |
| C-15 | SyncTransportは自動的に除外される | E-04 | ○ |
| C-16 | SignalableCommandInterfaceを実装 | E-09 | ○ |
| C-17 | SIGTERM/SIGINT/SIGQUITでWorker停止 | E-07 | ○ |
| C-18 | SIGALRMでキープアライブ処理 | E-07 | ○ |
| C-19 | メモリ制限のK/M/G/T単位変換に対応 | E-08 | ○ |
| C-20 | RateLimiterが設定時に適用される | E-04 | ○ |
| C-21 | ResetServicesListenerによるサービスリセット | E-04 | ○ |
| C-22 | 対話モードでレシーバー選択が可能 | E-06 | ○ |
| C-23 | Workerインスタンスを生成してrun()で消費ループ開始 | E-04 | ○ |
| C-24 | Supervisorなどのプロセスマネージャーで管理される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24のSupervisorでの管理は一般的な運用方法として記載したが、ソースコード上には直接的な根拠がない（helpテキストにプロセスマネージャーの言及はあるがSupervisor名指しではない）
  - 候補：Symfony公式ドキュメント / デプロイメントガイド / Supervisorの設定例

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク。本コマンドは長時間実行型であり、メモリリークやシグナルハンドリングの正確性が運用上重要である。

## 6) レビュアーチェックリスト（最小）
- [ ] 全入力パラメータの説明が正確か
- [ ] シグナルハンドリングの動作が正確に記述されているか
- [ ] 停止条件のリスナー登録順序が正しいか
- [ ] メモリ制限の単位変換ロジックが正確か
- [ ] RateLimiter適用の説明が実装と一致しているか
