---
generated_at: 2026-02-04 10:06:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：37-messenger_stop-workers.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **ワーカー側のタイムスタンプ比較ロジック**：StopWorkerOnRestartSignalListenerの実装詳細は本コマンドのコードには含まれない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` - StopWorkersCommandクラス全体
- E-02: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` 25行目 - `#[AsCommand(name: 'messenger:stop-workers', ...)]`
- E-03: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` 34-49行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` 51-62行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/Messenger/Command/StopWorkersCommand.php` 55行目 - `StopWorkerOnRestartSignalListener::RESTART_REQUESTED_TIMESTAMP_KEY`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `messenger:stop-workers` である | E-02 | ○ |
| C-02 | キャッシュベースのシグナリング機構で停止シグナルを送信 | E-04 | ○ |
| C-03 | CacheItemPoolInterfaceを使用する | E-01 | ○ |
| C-04 | RESTART_REQUESTED_TIMESTAMP_KEYをキャッシュキーとして使用 | E-05 | ○ |
| C-05 | microtime(true)をタイムスタンプとして保存 | E-04 | ○ |
| C-06 | 入力パラメータなし | E-03 | ○ |
| C-07 | 「Signal successfully sent...」の成功メッセージを出力 | E-04 | ○ |
| C-08 | ワーカーが実行中でなくても問題なく実行可能 | E-04 | ○ |
| C-09 | データベース操作なし | E-01 | ○ |
| C-10 | 冪等な操作である | E-04 | ○ |
| C-11 | ワーカーは現在処理中のメッセージを完了してから停止する | E-03 | ○ |
| C-12 | ワーカー側がタイムスタンプを比較して停止判定する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: ワーカー側のStopWorkerOnRestartSignalListenerの具体的な実装はこのコマンドのソースコードには含まれていない
  - 候補：`src/Symfony/Component/Messenger/EventListener/StopWorkerOnRestartSignalListener.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。コマンド自体はシンプルなキャッシュ書き込みのみ。

## 6) レビュアーチェックリスト（最小）
- [ ] キャッシュプールがワーカーと共有されていることの確認
- [ ] StopWorkerOnRestartSignalListenerの動作がドキュメントの記述と一致しているか
