---
generated_at: 2026-02-04 10:07:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-messenger_stats.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/StatsCommand.php` - StatsCommandクラス全体
- E-02: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 30行目 - `#[AsCommand(name: 'messenger:stats', ...)]`
- E-03: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 40-59行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 61-102行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 104-111行目 - `outputText()` メソッド
- E-06: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 113-125行目 - `outputJson()` メソッド
- E-07: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 127-133行目 - `formatSupportsWarnings()` メソッド
- E-08: `src/Symfony/Component/Messenger/Command/StatsCommand.php` 143-146行目 - `getAvailableFormatOptions()` メソッド

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `messenger:stats` である | E-02 | ○ |
| C-02 | トランスポートのメッセージ数を表示する | E-04 | ○ |
| C-03 | transport_names引数で特定トランスポートを指定可能 | E-03, E-04 | ○ |
| C-04 | 引数未指定時は全トランスポートが対象 | E-04 | ○ |
| C-05 | 出力フォーマットはtxtとjsonの2種類 | E-08 | ○ |
| C-06 | MessageCountAwareInterface非実装時はuncountableリストに追加 | E-04 | ○ |
| C-07 | txt形式: テーブル形式で出力 | E-05 | ○ |
| C-08 | json形式: JSON形式で出力 | E-06 | ○ |
| C-09 | JSON出力形式が正しい構造である | E-06 | ○ |
| C-10 | txt形式でカウント不可トランスポートのノート出力 | E-05 | ○ |
| C-11 | 存在しないトランスポート指定時に警告（txt形式のみ） | E-04, E-07 | ○ |
| C-12 | JSON形式では警告を出力しない | E-07 | ○ |
| C-13 | 不正フォーマット指定時にInvalidArgumentException | E-04 | ○ |
| C-14 | データベース操作なし（トランスポート内部操作を除く） | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。シンプルな統計情報表示コマンドで、全ての主張がソースコードに基づいている。

## 6) レビュアーチェックリスト（最小）
- [ ] JSON出力形式の構造説明が正確か
- [ ] MessageCountAwareInterface非対応トランスポートの取り扱いが正確か
