---
generated_at: 2026-02-04 10:08:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-messenger_failed_show.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` - FailedMessagesShowCommandクラス全体
- E-02: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 28行目 - `#[AsCommand(name: 'messenger:failed:show', ...)]`
- E-03: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 31-52行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 54-85行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 87-141行目 - `listMessages()` メソッド
- E-06: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 143-173行目 - `listMessagesPerClass()` メソッド
- E-07: `src/Symfony/Component/Messenger/Command/FailedMessagesShowCommand.php` 175-197行目 - `showMessage()` メソッド
- E-08: `src/Symfony/Component/Messenger/Command/AbstractFailedMessagesCommand.php` - AbstractFailedMessagesCommandクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `messenger:failed:show` である | E-02 | ○ |
| C-02 | 失敗トランスポートのメッセージを一覧表示する | E-04, E-05 | ○ |
| C-03 | id引数で個別メッセージの詳細を表示する | E-03, E-07 | ○ |
| C-04 | --max でリスト最大件数を指定可能（デフォルト50） | E-03, E-05 | ○ |
| C-05 | --transport で失敗トランスポートを指定可能 | E-03, E-04 | ○ |
| C-06 | --stats でクラス別メッセージ件数を表示 | E-03, E-06 | ○ |
| C-07 | --class-filter で特定クラスをフィルタリング | E-03, E-05 | ○ |
| C-08 | ListableReceiverInterface非実装時はRuntimeException | E-04 | ○ |
| C-09 | 一覧はId, Class, Failed at, Error列のテーブル | E-05 | ○ |
| C-10 | 失敗メッセージ0件時に「No failed messages were found.」 | E-05 | ○ |
| C-11 | 個別表示時にretry/removeコマンドの案内を出力 | E-07 | ○ |
| C-12 | RedeliveryStampから失敗日時を取得 | E-05 | ○ |
| C-13 | ErrorDetailsStampからエラーメッセージを取得 | E-05 | ○ |
| C-14 | PhpSerializerでacceptPhpIncompleteClass()を使用 | E-05, E-06 | ○ |
| C-15 | 複数失敗トランスポート時に対話的選択可能 | E-04, E-08 | ○ |
| C-16 | 保留メッセージ数を表示する | E-04, E-08 | ○ |
| C-17 | AbstractFailedMessagesCommandを継承 | E-01 | ○ |
| C-18 | -vvオプションでメッセージ内容・例外詳細をダンプ表示 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。読み取り専用のコマンドであり、全主張がソースコードで確認できている。

## 6) レビュアーチェックリスト（最小）
- [ ] 3つの表示モード（一覧/統計/個別）の切り替え条件が正確か
- [ ] 各モードの出力内容がソースコードと一致しているか
