---
generated_at: 2026-02-04 10:09:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-messenger_failed_retry.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` - FailedMessagesRetryCommandクラス全体
- E-02: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 40行目 - `#[AsCommand(name: 'messenger:failed:retry', ...)]`
- E-03: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 61-90行目 - `configure()` メソッド
- E-04: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 99-143行目 - `execute()` メソッド
- E-05: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 172-210行目 - `runInteractive()` メソッド
- E-06: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 212-261行目 - `runWorker()` メソッド
- E-07: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 263-289行目 - `retrySpecificIds()` メソッド
- E-08: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 150-170行目 - `handleSignal()` メソッド
- E-09: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 92-97行目 - `initialize()` メソッド
- E-10: `src/Symfony/Component/Messenger/Command/FailedMessagesRetryCommand.php` 41行目 - `SignalableCommandInterface`
- E-11: `src/Symfony/Component/Messenger/Command/AbstractFailedMessagesCommand.php` - AbstractFailedMessagesCommandクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `messenger:failed:retry` である | E-02 | ○ |
| C-02 | 失敗メッセージを再処理（リトライ）する | E-04 | ○ |
| C-03 | id引数で特定メッセージを指定可能（複数対応） | E-03, E-07 | ○ |
| C-04 | --forceで確認なしの強制リトライ | E-03, E-04 | ○ |
| C-05 | --transportで失敗トランスポートを指定可能 | E-03, E-04 | ○ |
| C-06 | --keepaliveでキープアライブ間隔設定可能 | E-03, E-09 | ○ |
| C-07 | StopWorkerOnMessageLimitListener(1)を登録 | E-04 | ○ |
| C-08 | 対話モードでretry/delete/skipの3択を提示 | E-06 | ○ |
| C-09 | MessageDecodingFailedStampのメッセージはリトライ不可 | E-06 | ○ |
| C-10 | ListableReceiver対応時はfind()で個別取得 | E-07 | ○ |
| C-11 | ListableReceiver対応時はall(1)で1件ずつ取得（対話モード） | E-05 | ○ |
| C-12 | 非ListableReceiverはrunWorker()でget()経由取得 | E-05, E-06 | ○ |
| C-13 | SignalableCommandInterfaceを実装 | E-10 | ○ |
| C-14 | SIGTERM/SIGINT/SIGQUITでWorker停止 | E-08 | ○ |
| C-15 | SIGALRMでキープアライブ処理 | E-08 | ○ |
| C-16 | forceExit制御で対話中シグナル時に即座に終了 | E-06, E-08 | ○ |
| C-17 | delete選択時にreceiver->reject()を呼び出す | E-06 | ○ |
| C-18 | skip選択時にWorkerMessageSkipEventを発行 | E-06 | ○ |
| C-19 | 非対話モードでID未指定時にRuntimeException | E-04 | ○ |
| C-20 | 全リトライにmessenger:consume {failureTransport}を案内 | E-04 | ○ |
| C-21 | AbstractFailedMessagesCommandを継承 | E-01 | ○ |
| C-22 | ID指定リトライ時にListableReceiverInterface必須 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク。リトライはメッセージハンドラの再実行を伴うため、冪等性のないハンドラでの副作用に注意が必要。

## 6) レビュアーチェックリスト（最小）
- [ ] 対話モードとID指定モードの切り替え条件が正確か
- [ ] retry/delete/skipの各選択肢の動作が正確に記述されているか
- [ ] シグナルハンドリングとforceExit制御の動作が正確か
- [ ] MessageDecodingFailedStampメッセージの取り扱いが正確か
- [ ] ListableReceiver対応/非対応時の動作の違いが正確か
