---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：41-messenger_failed_remove.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **トランザクション仕様の詳細**：トランスポート実装依存のため具体的な仕様が不明
  2. **定期クリーンアップの推奨設定**：cron実行に関する記述はソースコードに直接的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Messenger/Command/FailedMessagesRemoveCommand.php`
- E-02: `src/Symfony/Component/Messenger/Command/AbstractFailedMessagesCommand.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.41行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が messenger:failed:remove である | E-01 (L27 #[AsCommand]) | ○ |
| C-02 | 失敗トランスポートから指定メッセージを削除する機能 | E-01 (L27 description), E-03 | ○ |
| C-03 | id引数で複数のメッセージIDを指定可能 | E-01 (L34 InputArgument::IS_ARRAY) | ○ |
| C-04 | --allオプションで全メッセージ削除可能 | E-01 (L35) | ○ |
| C-05 | --forceオプションで確認をスキップ可能 | E-01 (L36) | ○ |
| C-06 | --transportオプションで失敗トランスポート指定可能 | E-01 (L37) | ○ |
| C-07 | --show-messagesオプションでメッセージ内容表示可能 | E-01 (L38) | ○ |
| C-08 | --class-filterオプションでクラス名フィルタ可能 | E-01 (L39) | ○ |
| C-09 | ListableReceiverInterface実装が必須 | E-01 (L74-76) | ○ |
| C-10 | --allとid同時指定でRuntimeException | E-01 (L93-95) | ○ |
| C-11 | IDもallも未指定でRuntimeException | E-01 (L91-92) | ○ |
| C-12 | receiver.reject()でメッセージを削除 | E-01 (L128, L177) | ○ |
| C-13 | PhpSerializerのacceptPhpIncompleteClass対応 | E-01 (L111, L141) | ○ |
| C-14 | class-filterで該当なしの場合RuntimeException | E-01 (L82-84) | ○ |
| C-15 | MessageCountAwareInterfaceで件数表示 | E-01 (L160-161) | ○ |
| C-16 | 全件削除時のメッセージ単位イテレーション | E-01 (L172-179) | ○ |
| C-17 | リターンコードは常に0 | E-01 (L105) | ○ |
| C-18 | 削除結果のメッセージ出力 | E-01 (L130, L132, L181) | ○ |
| C-19 | トランザクションはメッセージ単位 | **根拠なし** | △ |
| C-20 | cron定期実行の推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション仕様の詳細はトランスポート実装（Doctrine, Redis等）に依存するため、本コマンドのソースコードからは特定不可
  - 候補：DoctrineTransport実装 / RedisTransport実装 / AmqpTransport実装
- cron定期実行に関する記述はSymfony公式ドキュメントには存在するがソースコードには直接的根拠なし
  - 候補：Symfony Messenger公式ドキュメント / 運用ガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド名・パラメータ・基本処理フローはソースコードと完全に一致
- 1: 中リスク - トランザクション仕様はトランスポート実装依存のため、実際の動作と異なる可能性あり
- 0: 低リスク - エラー処理はソースコードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] トランザクション仕様がプロジェクトで使用するトランスポート実装と整合しているか確認
- [ ] 定期クリーンアップ運用の記述がプロジェクトの運用方針と合致しているか確認
- [ ] 削除操作の不可逆性に関する注意事項が十分か確認
