---
generated_at: 2026-02-04 10:01:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-debug_messenger.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張にソースコード上の根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Messenger/Command/DebugCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.42行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:messenger である | E-01 (L29 #[AsCommand]) | ○ |
| C-02 | メッセージバスでディスパッチ可能なメッセージを一覧表示する | E-01 (L29 description), E-02 | ○ |
| C-03 | bus引数でバスIDを指定可能（オプション） | E-01 (L41 InputArgument::OPTIONAL) | ○ |
| C-04 | 存在しないバス名指定でRuntimeException | E-01 (L64-66) | ○ |
| C-05 | バスごとにセクション表示 | E-01 (L71) | ○ |
| C-06 | メッセージクラスのDocCommentを表示 | E-01 (L75-77, L117-131) | ○ |
| C-07 | ハンドラ名と条件を表示 | E-01 (L82-83, L103-115) | ○ |
| C-08 | ハンドラクラスのDocCommentも表示 | E-01 (L84-86) | ○ |
| C-09 | 空バスに対する警告表示 | E-01 (L96) | ○ |
| C-10 | コンストラクタでマッピング配列を受け取る | E-01 (L32-34) | ○ |
| C-11 | テーブル形式で出力 | E-01 (L94) | ○ |
| C-12 | リターンコードは常に0 | E-01 (L100) | ○ |
| C-13 | コンソール補完に対応（bus引数） | E-01 (L133-138) | ○ |
| C-14 | 条件は「(when key=value)」形式 | E-01 (L114) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコード上の根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のデバッグコマンドであり、全機能がソースコードから正確に特定可能

## 6) レビュアーチェックリスト（最小）
- [ ] マッピング情報の構造（バス名 → メッセージ → ハンドラ）がプロジェクトの実設定と整合しているか確認
- [ ] 出力フォーマットの説明が実際のコンソール出力と一致しているか確認
