---
generated_at: 2026-02-04 10:02:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：43-translation_push.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **CI/CDパイプラインへの組み込み**：ソースコードに直接的根拠なし
  2. **翻訳プロバイダーの具体例（Crowdin, Loco, Lokalise）**：ソースコードに具体的プロバイダー名の記述なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Command/TranslationPushCommand.php`
- E-02: `src/Symfony/Component/Translation/Command/TranslationTrait.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.43行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が translation:push である | E-01 (L32 #[AsCommand]) | ○ |
| C-02 | 指定プロバイダーに翻訳をプッシュする | E-01 (L32 description), E-03 | ○ |
| C-03 | provider引数でプロバイダー指定（1つの場合はオプション） | E-01 (L76-78) | ○ |
| C-04 | --forceオプションで既存翻訳を上書き | E-01 (L79) | ○ |
| C-05 | --delete-missingオプションでプロバイダー上の不要翻訳を削除 | E-01 (L80) | ○ |
| C-06 | --domainsオプションでドメイン指定 | E-01 (L81) | ○ |
| C-07 | --localesオプションでロケール指定（デフォルトはenabledLocales） | E-01 (L82) | ○ |
| C-08 | enabledLocales未設定でInvalidArgumentException | E-01 (L112-113) | ○ |
| C-09 | forceかつdelete-missing未指定時はローカル翻訳をそのままwrite | E-01 (L134-140) | ○ |
| C-10 | delete-missing時にプロバイダー差分を削除 | E-01 (L144-145) | ○ |
| C-11 | デフォルトでは差分のみプッシュ | E-01 (L154-160) | ○ |
| C-12 | FilteringProviderからドメイン自動取得 | E-01 (L122-124) | ○ |
| C-13 | TranslationTraitでローカル翻訳読み込み | E-01 (L35), E-02 | ○ |
| C-14 | コンソール補完対応 | E-01 (L47-69) | ○ |
| C-15 | delete-missing後にプロバイダー翻訳再取得 | E-01 (L150-151) | ○ |
| C-16 | リターンコードは常に0 | E-01 (L139, L164) | ○ |
| C-17 | CI/CDパイプラインでの自動実行推奨 | **根拠なし** | △ |
| C-18 | 翻訳プロバイダーの具体例（Crowdin, Loco, Lokalise） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CI/CDパイプラインでの実行に関する記述はソースコードに直接的根拠がなく、一般的なベストプラクティスからの推論
  - 候補：Symfony公式ドキュメント / プロジェクト固有のCI/CD設定
- 翻訳プロバイダーの具体名はソースコードではなく、Symfonyの翻訳プロバイダーエコシステムに関する一般知識
  - 候補：symfony/crowdin-translation-provider / symfony/loco-translation-provider / symfony/lokalise-translation-provider

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの入出力仕様、処理フローはソースコードから正確に抽出
- 1: 中リスク - 翻訳プロバイダーの具体的な挙動はプロバイダー実装依存
- 0: 低リスク - エラー処理はソースコードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] 翻訳プロバイダーの具体名がプロジェクトで使用しているものと一致するか確認
- [ ] --forceと--delete-missingの組み合わせによる影響がプロジェクトの運用方針と合致するか確認
- [ ] CI/CDパイプラインへの組み込みに関する推奨がプロジェクトに適用可能か確認
