---
generated_at: 2026-02-04 10:03:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：44-translation_pull.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **CI/CDパイプラインへの組み込み**：ソースコードに直接的根拠なし
  2. **翻訳プロバイダーの具体例**：ソースコードに具体的プロバイダー名の記述なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Translation/Command/TranslationPullCommand.php`
- E-02: `src/Symfony/Component/Translation/Command/TranslationTrait.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.44行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が translation:pull である | E-01 (L32 #[AsCommand]) | ○ |
| C-02 | 指定プロバイダーから翻訳をプルする | E-01 (L32 description), E-03 | ○ |
| C-03 | provider引数でプロバイダー指定（1つの場合はオプション） | E-01 (L85) | ○ |
| C-04 | --forceオプションで既存ローカル翻訳を上書き | E-01 (L86) | ○ |
| C-05 | --intl-icuオプションでintl-icuドメイン形式の書き出し | E-01 (L87) | ○ |
| C-06 | --domainsオプションでドメイン指定 | E-01 (L88) | ○ |
| C-07 | --localesオプションでロケール指定 | E-01 (L89) | ○ |
| C-08 | --formatオプションでフォーマット指定（デフォルトxlf12） | E-01 (L90) | ○ |
| C-09 | --as-treeオプションでYAMLツリー構造出力 | E-01 (L91) | ○ |
| C-10 | --intl-icuは--forceなしでは無効（注意メッセージ） | E-01 (L126-128) | ○ |
| C-11 | xlf12/xlf20のxlfへの正規化とバージョン設定 | E-01 (L130-134) | ○ |
| C-12 | forceモードでTargetOperationを使用 | E-01 (L151-157) | ○ |
| C-13 | デフォルトではローカルにプロバイダー差分を追加 | E-01 (L164-171) | ○ |
| C-14 | transPathsの最後のパスに出力 | E-01 (L137) | ○ |
| C-15 | TranslationTraitでローカル翻訳読み込み | E-01 (L35), E-02 | ○ |
| C-16 | コンソール補完対応（provider, domains, locales, format） | E-01 (L49-76) | ○ |
| C-17 | リターンコードは常に0 | E-01 (L161, L175) | ○ |
| C-18 | CI/CDパイプラインでの自動実行推奨 | **根拠なし** | △ |
| C-19 | 翻訳プロバイダーの具体例（Crowdin, Loco, Lokalise） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CI/CDパイプラインでの実行に関する記述はソースコードに直接的根拠がなく、一般的なベストプラクティスからの推論
  - 候補：Symfony公式ドキュメント / プロジェクト固有のCI/CD設定
- 翻訳プロバイダーの具体名はソースコードではなく、Symfonyの翻訳プロバイダーエコシステムに関する一般知識
  - 候補：symfony/crowdin-translation-provider / symfony/loco-translation-provider

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの入出力仕様、処理フローはソースコードから正確に抽出
- 1: 中リスク - 翻訳プロバイダーの具体的挙動はプロバイダー実装依存
- 0: 低リスク - ファイル出力仕様はソースコードから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] --formatオプションのデフォルト値がプロジェクトの翻訳ファイルフォーマットと一致するか確認
- [ ] --forceモードでの既存翻訳上書きの影響を理解しているか確認
- [ ] 出力先（transPathsの最後のパス）がプロジェクトの翻訳ファイル配置と一致するか確認
