---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：46-asset-map_compile.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **出力先ディレクトリのデフォルト値（public/assets）**：ソースコードのヘルプテキストに記載はあるが、実際のデフォルトパスはDI設定依存

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/AssetMapper/Command/AssetMapperCompileCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.46行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が asset-map:compile である | E-01 (L34 #[AsCommand]) | ○ |
| C-02 | 全マップ済みアセットをコンパイルして出力 | E-01 (L34 description), E-02 | ○ |
| C-03 | PreAssetsCompileEventを発行 | E-01 (L65) | ○ |
| C-04 | 既存マニフェストファイルを削除 | E-01 (L68) | ○ |
| C-05 | 既存インポートマップキャッシュを削除 | E-01 (L69) | ○ |
| C-06 | 既存エントリポイントキャッシュを削除 | E-01 (L71-75) | ○ |
| C-07 | content非nullのアセットはwrite、nullはcopy | E-01 (L110-115) | ○ |
| C-08 | マニフェストをksort()でソート | E-01 (L119) | ○ |
| C-09 | マニフェストファイルを保存 | E-01 (L78) | ○ |
| C-10 | インポートマップデータを保存 | E-01 (L81) | ○ |
| C-11 | エントリポイントメタデータを保存 | E-01 (L84-86) | ○ |
| C-12 | デバッグモード時に警告表示 | E-01 (L90-95) | ○ |
| C-13 | リターンコードは常に0 | E-01 (L97) | ○ |
| C-14 | コンパイル件数の出力 | E-01 (L120) | ○ |
| C-15 | shortenPathでプロジェクトルートからの相対パス表示 | E-01 (L100-103) | ○ |
| C-16 | EventDispatcherはオプション（nullable） | E-01 (L44) | ○ |
| C-17 | コンストラクタでisDebugフラグを受け取る | E-01 (L43) | ○ |
| C-18 | デフォルト出力先がpublic/assets | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルト出力先「public/assets」はヘルプテキスト中のコメント（L54）に「usually public/assets」と記載があるが、実際のパスはPublicAssetsFilesystemInterfaceの設定に依存
  - 候補：Symfony FrameworkBundle設定 / AssetMapper DI設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの処理フロー、ファイル出力はソースコードから正確に抽出
- 1: 中リスク - 実際の出力先パスはDI設定依存のため、プロジェクトごとに異なる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] アセット出力先ディレクトリがプロジェクトのWebサーバー設定と一致しているか確認
- [ ] デバッグモードでのコンパイルに関する注意事項を理解しているか確認
- [ ] PreAssetsCompileEventを利用したカスタム前処理がある場合、その影響を確認
