---
generated_at: 2026-02-04 10:07:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-debug_asset-map.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張にソースコード上の根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/AssetMapper/Command/DebugAssetMapperCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.48行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が debug:asset-map である | E-01 (L29 #[AsCommand]) | ○ |
| C-02 | 全マップ済みアセットを出力する | E-01 (L29 description), E-02 | ○ |
| C-03 | name引数でアセット名またはパスの検索が可能 | E-01 (L45) | ○ |
| C-04 | --extオプションで拡張子フィルタ | E-01 (L46) | ○ |
| C-05 | --fullオプションで完全パス表示 | E-01 (L47) | ○ |
| C-06 | --vendorオプション（negatable） | E-01 (L48) | ○ |
| C-07 | ディレクトリ一覧を--ext未指定時に表示 | E-01 (L92-111) | ○ |
| C-08 | アセット一覧をテーブル形式で表示 | E-01 (L123) | ○ |
| C-09 | パス短縮（50文字制限、中央省略） | E-01 (L168-179) | ○ |
| C-10 | パス短縮時に--fullオプション案内 | E-01 (L124-126) | ○ |
| C-11 | name検索はstr_containsで部分一致 | E-01 (L100, L147) | ○ |
| C-12 | ディレクトリはネームスペースの有無でソート | E-01 (L105) | ○ |
| C-13 | アセットは論理パスでソート | E-01 (L122) | ○ |
| C-14 | 警告: No paths found / No assets found | E-01 (L109, L128) | ○ |
| C-15 | vendorフィルタでisVendor判定 | E-01 (L144) | ○ |
| C-16 | リターンコードは常に0 | E-01 (L131) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全主張にソースコード上の根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のデバッグコマンドであり、全機能がソースコードから正確に特定可能

## 6) レビュアーチェックリスト（最小）
- [ ] パス短縮の50文字制限が出力結果の可読性に影響しないか確認
- [ ] --vendorオプションのnegatable動作が期待通りか確認
