---
generated_at: 2026-02-04 10:08:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：49-importmap_require.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **CDNからのURL解決の具体的メカニズム**：ImportMapManagerの内部実装に依存
  2. **依存パッケージの自動追加**：ImportMapManager実装の内部動作

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/AssetMapper/Command/ImportMapRequireCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.49行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名が importmap:require である | E-01 (L31 #[AsCommand]) | ○ |
| C-02 | JavaScriptパッケージを要求する | E-01 (L31 description), E-02 | ○ |
| C-03 | packages引数で追加パッケージ指定（必須・複数可） | E-01 (L47) | ○ |
| C-04 | --entrypointオプションでエントリポイント登録 | E-01 (L48) | ○ |
| C-05 | --pathオプションでローカルファイルパス指定 | E-01 (L49) | ○ |
| C-06 | --dry-runオプションでシミュレーション実行 | E-01 (L50) | ○ |
| C-07 | --pathオプションは単一パッケージのみ | E-01 (L95-99) | ○ |
| C-08 | parsePackageNameでパッケージ名解析 | E-01 (L110) | ○ |
| C-09 | 不正なパッケージ名でエラー | E-01 (L111-115) | ○ |
| C-10 | PackageRequireOptionsの構築 | E-01 (L117-123) | ○ |
| C-11 | dry-runでrequirePackagesを呼び出し | E-01 (L127) | ○ |
| C-12 | 通常モードでrequireを呼び出し | E-01 (L129) | ○ |
| C-13 | VersionProblemCommandTraitによるバージョンチェック | E-01 (L34, L132) | ○ |
| C-14 | verbose時にパッケージ詳細テーブル表示 | E-01 (L142-151) | ○ |
| C-15 | 1パッケージ/複数パッケージでメッセージ分岐 | E-01 (L136-139) | ○ |
| C-16 | リターンコードはSUCCESS/FAILURE | E-01 (L98, L114, L163) | ○ |
| C-17 | CDNからのURL解決メカニズム | **根拠なし** | △ |
| C-18 | 依存パッケージの自動追加 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CDNからのURL解決はImportMapManagerの内部実装に委譲されており、本コマンドのソースコードからは具体的メカニズムを特定不可
  - 候補：ImportMapManager.php / ImportMapConfigReader.php
- 依存パッケージの自動追加はヘルプテキスト（L68-69）に言及があるが、具体的ロジックはImportMapManager内部
  - 候補：ImportMapManager::require() / ImportMapManager::requirePackages()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの入出力仕様はソースコードから正確に抽出
- 1: 中リスク - ImportMapManagerの内部動作はコマンドソースコードからは特定不可

## 6) レビュアーチェックリスト（最小）
- [ ] CDNの設定（jsDelivr等）がプロジェクトの要件と合致しているか確認
- [ ] --dry-runオプションでの事前確認がプロジェクトのワークフローに組み込まれているか確認
- [ ] パッケージ名フォーマットの説明が十分か確認
