---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-importmap_install.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様のHttpClientデフォルト設定依存**：具体的なリトライ回数の根拠がコマンドソースコード内に存在しない
  2. **排他制御の不在**：明示的なロック機構がないことのみ確認
  3. **パフォーマンス要件**：具体的な数値が示されていない（プロジェクト依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/AssetMapper/Command/ImportMapInstallCommand.php`
- E-02: `src/Symfony/Component/AssetMapper/ImportMap/RemotePackageDownloader.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は importmap:install である | E-01 L28 (#[AsCommand(name: 'importmap:install')]) | ○ |
| C-02 | コマンドの説明は「Download all assets that should be downloaded」 | E-01 L28 (description) | ○ |
| C-03 | 入力引数・オプションはない | E-01 (configureメソッドが未定義) | ○ |
| C-04 | RemotePackageDownloaderに処理を委譲する | E-01 L31-34 (コンストラクタ), L45 (downloadPackages呼び出し) | ○ |
| C-05 | プログレスバーで進捗を表示する | E-01 L43-56 (ProgressBar生成とコールバック) | ○ |
| C-06 | ダウンロード不要時は「No assets to install.」を表示 | E-01 L60-64 | ○ |
| C-07 | ダウンロード完了時にパッケージ数とvendorディレクトリを表示 | E-01 L66-71 | ○ |
| C-08 | 常にCommand::SUCCESSを返す | E-01 L63, L73 | ○ |
| C-09 | installed.phpとバージョン比較で差分ダウンロードを行う | E-02 L54-63 | ○ |
| C-10 | PackageResolverInterface経由でHTTPダウンロード | E-02 L72 | ○ |
| C-11 | ダウンロード後にRemotePackageStorageにファイル保存 | E-02 L79-82 | ○ |
| C-12 | installed.phpにバージョン・依存関係・extraFilesを記録 | E-02 L84-88, L150-157 | ○ |
| C-13 | パッケージ未ダウンロード時にLogicExceptionを送出 | E-02 L76-77 | ○ |
| C-14 | installed.phpのバージョン欠如時にInvalidArgumentException | E-02 L134-136 | ○ |
| C-15 | installed.phpの依存関係欠如時にLogicException | E-02 L138-139 | ○ |
| C-16 | extraFilesの存在もチェックする | E-02 L59, L159-168 | ○ |
| C-17 | projectDirをコンストラクタで受け取る | E-01 L33 | ○ |
| C-18 | リトライはHttpClientデフォルト設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ仕様について、ImportMapInstallCommand自体にはリトライロジックが実装されていない。Symfony HttpClientのデフォルトリトライ動作に依存するが、その具体的な設定値はコマンドのソースコードからは確認できない。
  - 候補：Symfony HttpClientのドキュメント / HttpClient設定ファイル / フレームワーク設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド本体のロジックは単純で、主要処理はRemotePackageDownloaderに委譲されている
- 0: 低リスク - 入力パラメータがないためバリデーションエラーのリスクが低い
- 1: 中リスク - ネットワーク障害時のエラーハンドリングがコマンドレベルでは行われていない

## 6) レビュアーチェックリスト（最小）
- [ ] ダウンロード対象パッケージの特定ロジック（バージョン比較・ファイル存在チェック）が正確に記述されているか
- [ ] エラー発生時の挙動（例外メッセージ）がソースコードと一致しているか
- [ ] installed.phpのデータ構造の記述が実際のフォーマットと一致しているか
