---
generated_at: 2026-02-04 10:02:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-importmap_outdated.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **色分けの定義（赤=semver互換、黄=メジャー）**：コード上のCOLOR_MAPPINGとの対応確認
  2. **終了コードの意味**：FAILURE=更新ありという仕様の正確性
  3. **npm registryのリクエストヘッダ仕様**：Acceptヘッダの正確性

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/AssetMapper/Command/ImportMapOutdatedCommand.php`
- E-02: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapUpdateChecker.php`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は importmap:outdated | E-01 L26 | ○ |
| C-02 | packages引数はオプションの配列型 | E-01 L43-46 | ○ |
| C-03 | formatオプションはtxtがデフォルト | E-01 L48-53 | ○ |
| C-04 | 利用可能なフォーマットはtxtとjson | E-01 L122-125 | ○ |
| C-05 | ImportMapUpdateCheckerに処理を委譲 | E-01 L76 | ○ |
| C-06 | hasUpdate()がtrueのパッケージのみフィルタ | E-01 L77 | ○ |
| C-07 | 更新なし時は「No updates found.」を表示 | E-01 L82 | ○ |
| C-08 | 更新なし時にjsonフォーマットでは空配列を出力 | E-01 L80 | ○ |
| C-09 | 更新なし時はSUCCESSを返す | E-01 L85 | ○ |
| C-10 | 更新あり時はFAILUREを返す | E-01 L111 | ○ |
| C-11 | 赤色はsemver-safe-update | E-01 L30-31 | ○ |
| C-12 | 黄色はupdate-possible（メジャー更新） | E-01 L30 | ○ |
| C-13 | txt形式ではテーブル形式で出力 | E-01 L98-108 | ○ |
| C-14 | json形式ではJSON_PRETTY_PRINTで出力 | E-01 L96 | ○ |
| C-15 | npm registryにGETリクエストを送信 | E-02 L51 | ○ |
| C-16 | Acceptヘッダにapplication/vnd.npm.install-v1+jsonを設定 | E-02 L51 | ○ |
| C-17 | dist-tags.latestから最新バージョンを取得 | E-02 L61 | ○ |
| C-18 | バージョン比較でメジャー/マイナー/パッチを判定 | E-02 L77-96 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張にソースコード上の根拠が存在する。特段の不足情報はない。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンドであり、システムへの影響なし
- 0: 低リスク - 入出力の仕様がソースコードで明確に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] COLOR_MAPPINGの色分け（semver-safe-update=red, update-possible=yellow）が設計書の記述と一致しているか
- [ ] 終了コードの仕様（更新あり=FAILURE）が正しく記述されているか
- [ ] npm registryのリクエスト仕様（URL、ヘッダ）が正確か
