---
generated_at: 2026-02-04 10:06:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：57-error_dump.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトのステータスコード数（約30コード）**：Response::$statusTextsの400番台以上の正確な数
  2. **Webpack Encoreのアセット重複防止ロジック**：EntrypointLookupの動作確認
  3. **インタラクティブ確認のデフォルト値**：confirm関数のデフォルト値

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/ErrorHandler/Command/ErrorDumpCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は error:dump | E-01 L33 | ○ |
| C-02 | path引数は必須 | E-01 L49 | ○ |
| C-03 | status-codes引数はオプションの配列 | E-01 L50 | ○ |
| C-04 | --force (-f) オプションでディレクトリを強制削除 | E-01 L51 | ○ |
| C-05 | デフォルトは400番台以上の全ステータスコード | E-01 L71 | ○ |
| C-06 | --forceまたはインタラクティブ確認でディレクトリ削除 | E-01 L74-75 | ○ |
| C-07 | 確認ダイアログのデフォルトはfalse（No） | E-01 L74 | ○ |
| C-08 | EntrypointLookupのリセットを各ページ前に実行 | E-01 L80 | ○ |
| C-09 | HttpExceptionを生成してErrorRendererでレンダリング | E-01 L82 | ○ |
| C-10 | Filesystemでファイル出力 | E-01 L82 (dumpFile) | ○ |
| C-11 | ファイル名は{status_code}.html | E-01 L82 | ○ |
| C-12 | 成功メッセージの表示 | E-01 L63 | ○ |
| C-13 | タイトル「Dumping error pages」の表示 | E-01 L60 | ○ |
| C-14 | EntrypointLookupInterfaceはオプション（nullable） | E-01 L41 | ○ |
| C-15 | デフォルトで約30のステータスコードが対象 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Response::$statusTextsの400番台以上のステータスコードの正確な数は、HttpFoundation Responseクラスのソースコードを参照しないと確認できない。「約30」という数は推定値である。
  - 候補：`src/Symfony/Component/HttpFoundation/Response.php` の$statusTexts定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力はHTMLファイルのみで、システムへの重大な影響なし
- 1: 中リスク - --forceオプションによるディレクトリ削除は不可逆操作
- 0: 低リスク - EntrypointLookupがnullの場合も安全に動作（null safe operator使用）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトのステータスコードフィルタ条件（>= 400）が正確か
- [ ] --forceオプションとインタラクティブ確認の動作が正確に記述されているか
- [ ] ファイル出力パス（{path}/{status_code}.html）が正確か
