---
generated_at: 2026-02-04 10:07:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：58-debug_form.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DescriptorHelperのフォーマット種類**：getFormats()の返り値確認
  2. **レーベンシュタイン距離の閾値**：findAlternatives関数の正確なロジック
  3. **コアタイプ取得のリフレクション使用**：loadTypes呼び出しの安全性

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Form/Command/DebugCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は debug:form | E-01 L35 | ○ |
| C-02 | class引数はオプション | E-01 L53 | ○ |
| C-03 | option引数はオプション | E-01 L54 | ○ |
| C-04 | --show-deprecatedオプション | E-01 L55 | ○ |
| C-05 | --formatオプション（デフォルトtxt） | E-01 L56 | ○ |
| C-06 | classなしの場合、コアタイプ・サービスタイプ・拡張・ゲッサー一覧を表示 | E-01 L94-106 | ○ |
| C-07 | CoreExtensionのloadTypesをリフレクションで呼び出し | E-01 L195-198 | ○ |
| C-08 | サービスタイプはコアタイプを除外 | E-01 L97 | ○ |
| C-09 | --show-deprecatedで非推奨オプション持ちのタイプをフィルタ | E-01 L98-101 | ○ |
| C-10 | 短縮名のFQCN解決（ネームスペース検索） | E-01 L175-192 | ○ |
| C-11 | デフォルトネームスペースは Symfony\Component\Form\Extension\Core\Type | E-01 L40 | ○ |
| C-12 | 複数一致時にインタラクティブ選択 | E-01 L172 | ○ |
| C-13 | 非インタラクティブ時に複数一致でInvalidArgumentException | E-01 L169 | ○ |
| C-14 | オプション未定義時にInvalidArgumentException | E-01 L117-129 | ○ |
| C-15 | 代替候補提案にレーベンシュタイン距離使用 | E-01 L221-235 | ○ |
| C-16 | レーベンシュタイン距離の閾値は名前の長さの1/3以下 | E-01 L225 | ○ |
| C-17 | FileLinkFormatterのオプション対応 | E-01 L44, L138 | ○ |
| C-18 | DescriptorHelperが利用可能なフォーマット一覧を提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DescriptorHelperのgetFormats()が返すフォーマット一覧の具体的な内容は、Form\Console\Helper\DescriptorHelperクラスのソースコードを参照しないと確認できない。コマンド側のコードからは「txt」がデフォルトであることのみ確認できる。
  - 候補：`src/Symfony/Component/Form/Console/Helper/DescriptorHelper.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンドであり、システムへの影響なし
- 0: 低リスク - CoreExtensionのリフレクション呼び出しは安全な読み取り操作
- 0: 低リスク - FormRegistryへの依存は標準的なDI使用

## 6) レビュアーチェックリスト（最小）
- [ ] 3つの表示モード（一覧/タイプ詳細/オプション詳細）の条件分岐が正確か
- [ ] 短縮名からFQCNへの解決ロジック（4パターンの検索）が正確か
- [ ] レーベンシュタイン距離の閾値と代替候補提案のロジックが正確か
