---
generated_at: 2026-02-04 10:09:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-security_hash-password.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **ソルト処理の分岐ロジック**：LegacyPasswordHasherInterface判定と各パスの正確性
  2. **インタラクティブ/非インタラクティブの挙動差異**：複数の分岐パスの正確性
  3. **パスワード入力のバリデーション**：空白チェックとリトライ回数

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/PasswordHasher/Command/UserPasswordHashCommand.php`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は security:hash-password | E-01 L38 | ○ |
| C-02 | password引数はオプション | E-01 L51 | ○ |
| C-03 | user-class引数はオプション | E-01 L52 | ○ |
| C-04 | --empty-saltオプション | E-01 L53 | ○ |
| C-05 | PasswordHasherFactoryInterfaceをコンストラクタ注入 | E-01 L42 | ○ |
| C-06 | userClassesをコンストラクタで受け取る | E-01 L43 | ○ |
| C-07 | インタラクティブ時にタイトル表示 | E-01 L101 | ○ |
| C-08 | 非インタラクティブ+パスワード未指定でエラー | E-01 L115-118 | ○ |
| C-09 | パスワード入力は非表示（setHidden(true)） | E-01 L181 | ○ |
| C-10 | パスワード入力は最大20回リトライ | E-01 L181 (setMaxAttempts(20)) | ○ |
| C-11 | 空白パスワードでInvalidArgumentException | E-01 L176-178 | ○ |
| C-12 | self-saltingハッシャーはLegacyPasswordHasherInterface非実装で判定 | E-01 L108 | ○ |
| C-13 | self-salting時はemptySalt=true | E-01 L110-112 | ○ |
| C-14 | インタラクティブ時にソルト生成確認ダイアログ | E-01 L126-134 | ○ |
| C-15 | ソルト生成はrandom_bytes(30)+base64_encode | E-01 L184-187 | ○ |
| C-16 | hasher.hash(password, salt)でハッシュ化 | E-01 L139 | ○ |
| C-17 | テーブル形式で結果表示（Hasher used / Password hash / Generated salt） | E-01 L141-148 | ○ |
| C-18 | ソルト保存フィールド長の注記 | E-01 L151 | ○ |
| C-19 | self-salting使用時の注記 | E-01 L153 | ○ |
| C-20 | 複数ユーザークラス時にインタラクティブ選択 | E-01 L199-207 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張にソースコード上の根拠が存在する。特段の不足情報はない。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンドであり、システムへの影響なし
- 0: 低リスク - パスワードハッシュ化は標準的なセキュリティ処理
- 1: 中リスク - ソルト処理の分岐が複雑であり、各パスの正確な理解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ソルト処理の分岐（self-salting / --empty-salt / インタラクティブ / 非インタラクティブ）が正確に記述されているか
- [ ] パスワード入力のバリデーション（空白チェック、リトライ回数）が正確か
- [ ] ユーザークラス選択の分岐（引数指定 / インタラクティブ選択 / デフォルト）が正確か
- [ ] 結果テーブルの表示項目（Hasher used / Password hash / Generated salt）が正確か
