---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：61-debug_scheduler.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間）**：根拠不足
  2. **想定処理件数**：根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Scheduler/Command/DebugCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `debug:scheduler` である | E-01 (L30: AsCommand属性) | ○ |
| C-02 | 説明は「List schedules and their recurring messages」である | E-01 (L30) | ○ |
| C-03 | schedule引数はオプションで複数指定可 | E-01 (L45: OPTIONAL, IS_ARRAY) | ○ |
| C-04 | --dateオプションのデフォルト値は"now" | E-01 (L46: VALUE_REQUIRED, default 'now') | ○ |
| C-05 | --allオプションは終了済みメッセージ表示用 | E-01 (L47: VALUE_NONE) | ○ |
| C-06 | --sortオプションは次回実行日時ソート用 | E-01 (L48: VALUE_NONE) | ○ |
| C-07 | スケジュール名0件でエラーコード2を返す | E-01 (L77-79) | ○ |
| C-08 | ServiceProviderInterfaceでスケジュールにアクセス | E-01 (L35: コンストラクタ引数) | ○ |
| C-09 | ScheduleProviderInterfaceからスケジュール取得 | E-01 (L91-92) | ○ |
| C-10 | RecurringMessageからTrigger/Provider/NextRunを取得 | E-01 (L116-128) | ○ |
| C-11 | --allがfalseの場合nextがnullのメッセージを除外 | E-01 (L121-123) | ○ |
| C-12 | --sort指定時に次回実行日時で昇順ソート | E-01 (L100-102) | ○ |
| C-13 | テーブル形式で3列出力（Trigger/Provider/Next Run） | E-01 (L104-107) | ○ |
| C-14 | メッセージ0件時に警告表示 | E-01 (L93-96) | ○ |
| C-15 | 作者はKevin Bond | E-01 (L28) | ○ |
| C-16 | データベース操作なし | E-01 (全体) | ○ |
| C-17 | 想定処理件数は数十件程度 | **根拠なし** | △ |
| C-18 | 目標処理時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-17, C-18）はソースコードに明示的な記載がなく、一般的なCLIデバッグコマンドの特性から推測した値である。
  - 候補：パフォーマンステスト結果 / 運用実績データ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のデバッグコマンドであり、システムへの影響はない

## 6) レビュアーチェックリスト（最小）
- [ ] schedule引数の補完候補がスケジュール名一覧と一致するか確認
- [ ] --dateオプションに不正な日時文字列を渡した場合の挙動を確認
- [ ] パフォーマンス要件が実運用に即しているか確認
