---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：62-security_oidc_generate-token.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **署名鍵の前提条件**：コード上に明示的な鍵チェックなし
  2. **パフォーマンス要件**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Security/Http/Command/OidcTokenGenerateCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `security:oidc:generate-token` | E-01 (L25: AsCommand属性) | ○ |
| C-02 | user-identifier引数は必須 | E-01 (L38: REQUIRED) | ○ |
| C-03 | --firewallオプションはVALUE_REQUIRED | E-01 (L39) | ○ |
| C-04 | --algorithmオプションで署名アルゴリズムを指定 | E-01 (L40) | ○ |
| C-05 | --issuerオプションでIssuer claimを設定 | E-01 (L41) | ○ |
| C-06 | --ttlオプションでExpiration Time claimを設定 | E-01 (L42) | ○ |
| C-07 | --not-beforeオプションでNot Before claimを設定 | E-01 (L43) | ○ |
| C-08 | addGeneratorメソッドでファイアウォールごとにジェネレーター登録 | E-01 (L51-62) | ○ |
| C-09 | ジェネレーター0件で「No OIDC token generator configured.」エラー | E-01 (L82-84) | ○ |
| C-10 | 指定ファイアウォール未登録で「Invalid firewall」エラー | E-01 (L87) | ○ |
| C-11 | 複数ファイアウォール時のファイアウォール未指定でエラー | E-01 (L94) | ○ |
| C-12 | ファイアウォール1つのみの場合は自動選択 | E-01 (L90-92) | ○ |
| C-13 | トークン生成にgenerate()メソッドを使用 | E-01 (L67-73) | ○ |
| C-14 | 生成結果を標準出力に出力 | E-01 (L75) | ○ |
| C-15 | コンソール補完機能サポート | E-01 (L97-113) | ○ |
| C-16 | 署名鍵の設定が前提条件 | **根拠なし** | △ |
| C-17 | 目標処理時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 署名鍵の前提条件（C-16）はOidcTokenGeneratorの内部実装に依存しており、本コマンドのソースコードには直接的な記載がない。
  - 候補：OidcTokenGenerator.php / セキュリティ設定ドキュメント
- パフォーマンス要件（C-17）はソースコードに明示的な記載がなく、一般的なCLIコマンドの特性から推測した値。
  - 候補：パフォーマンステスト結果 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - OIDCトークン生成はセキュリティに関わるため、生成されたトークンの取り扱いに注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] OidcTokenGeneratorの内部実装（署名アルゴリズム・鍵管理）を確認
- [ ] --ttlオプションに不正な値を渡した場合の挙動を確認
- [ ] --not-beforeオプションの日時パース仕様を確認
- [ ] 生成されたトークンのセキュリティ要件が満たされているか確認
