---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：64-uuid_generate.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間）**：根拠不足
  2. **メモリ使用量上限**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Uid/Command/GenerateUuidCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `uuid:generate` | E-01 (L27: AsCommand属性) | ○ |
| C-02 | --time-basedオプションでタイムスタンプ指定 | E-01 (L40) | ○ |
| C-03 | --nodeオプションでノードUUID指定 | E-01 (L41) | ○ |
| C-04 | --name-basedオプションで名前指定 | E-01 (L42) | ○ |
| C-05 | --namespaceオプションで名前空間指定（dns,url,oid,x500対応） | E-01 (L43, L137) | ○ |
| C-06 | --random-basedオプションでランダム生成 | E-01 (L44) | ○ |
| C-07 | --countオプションのデフォルトは1 | E-01 (L45) | ○ |
| C-08 | --formatオプションのデフォルトはrfc4122 | E-01 (L46) | ○ |
| C-09 | サポートフォーマット: base32, base58, rfc4122 | E-01 (L201-205) | ○ |
| C-10 | 排他チェック: 複数方式の同時指定不可 | E-01 (L95-99) | ○ |
| C-11 | 依存チェック: --nodeは--time-basedと同時 | E-01 (L101-105) | ○ |
| C-12 | 依存チェック: --namespaceは--name-basedと同時 | E-01 (L107-111) | ○ |
| C-13 | 無効なノード値でエラー | E-01 (L116-122) | ○ |
| C-14 | 無効なタイムスタンプでエラー | E-01 (L125-131) | ○ |
| C-15 | 無効な名前空間でエラー | E-01 (L139-144) | ○ |
| C-16 | エラー出力はConsoleOutputInterface::getErrorOutput()使用 | E-01 (L87) | ○ |
| C-17 | コンソール補完機能サポート（format） | E-01 (L191-196) | ○ |
| C-18 | UuidFactoryのデフォルトはnew UuidFactory() | E-01 (L31) | ○ |
| C-19 | 目標処理時間は1秒以内 | **根拠なし** | △ |
| C-20 | メモリ使用量上限は通常のCLI範囲内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-19, C-20）はソースコードに明示的な記載がなく、一般的なCLIコマンドの特性から推測した値。
  - 候補：パフォーマンステスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UUID生成のみのユーティリティコマンドであり、システムへの影響はない

## 6) レビュアーチェックリスト（最小）
- [ ] --countに非常に大きい値を指定した場合のメモリ・時間影響を確認
- [ ] 名前空間キーワード（dns, url, oid, x500）の動作を確認
- [ ] パフォーマンス要件が実運用に即しているか確認
