---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：67-ulid_inspect.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Uid/Command/InspectUlidCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `ulid:inspect` | E-01 (L24: AsCommand属性) | ○ |
| C-02 | ulid引数は必須 | E-01 (L31: REQUIRED) | ○ |
| C-03 | Ulid::fromString()でパース | E-01 (L49) | ○ |
| C-04 | パース失敗時にエラーコード1 | E-01 (L50-54) | ○ |
| C-05 | 4種類の表現形式を表示（toBase32, toBase58, toRfc4122, toHex） | E-01 (L57-60) | ○ |
| C-06 | toBase32がcanonical表記 | E-01 (L57) | ○ |
| C-07 | TableSeparatorで表示を分離 | E-01 (L61) | ○ |
| C-08 | タイムスタンプは常に表示される | E-01 (L62: 条件分岐なし) | ○ |
| C-09 | タイムスタンプフォーマットは Y-m-d H:i:s.v UTC | E-01 (L62) | ○ |
| C-10 | Label/Valueの2列テーブル出力 | E-01 (L56) | ○ |
| C-11 | 3形式のULID入力をサポート（ヘルプテキスト） | E-01 (L36-38) | ○ |
| C-12 | エラー出力はConsoleOutputInterface::getErrorOutput()使用 | E-01 (L46) | ○ |
| C-13 | 目標処理時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-13）はソースコードに明示的な記載がなく推測値。
  - 候補：パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のユーティリティコマンド

## 6) レビュアーチェックリスト（最小）
- [ ] ULIDのミリ秒精度タイムスタンプ表示が正しいか確認
- [ ] 各入力形式（Base32, Base58, RFC 4122）での動作を確認
