---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：68-debug_validator.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間）**：根拠不足
  2. **ディレクトリ走査のパフォーマンス影響**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Validator/Command/DebugCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `debug:validator` | E-01 (L38: AsCommand属性) | ○ |
| C-02 | class引数は必須 | E-01 (L50: REQUIRED) | ○ |
| C-03 | --show-allオプションでバリデーション制約なしクラスも表示 | E-01 (L51) | ○ |
| C-04 | class_exists()でクラス名判定 | E-01 (L65) | ○ |
| C-05 | ディレクトリ走査にFinderを使用 | E-01 (L220-221) | ○ |
| C-06 | DirectoryNotFoundExceptionキャッチ | E-01 (L75) | ○ |
| C-07 | Property/Name/Groups/Optionsの4列テーブル | E-01 (L129) | ○ |
| C-08 | Options列の最大幅80文字 | E-01 (L131) | ○ |
| C-09 | クラスレベル制約はPropertyに"-"表示 | E-01 (L97) | ○ |
| C-10 | cascadeStrategy: Cascade or None | E-01 (L183) | ○ |
| C-11 | autoMappingStrategy: Enabled/Disabled/None/Not supported | E-01 (L165-169) | ○ |
| C-12 | traversalStrategy: Traverse/Implicit/None | E-01 (L171-177) | ○ |
| C-13 | 名前空間正規表現 `/namespace (.+);/` | E-01 (L227) | ○ |
| C-14 | クラス名正規表現 `/class +([^{ ]+)/` | E-01 (L231) | ○ |
| C-15 | Finderで.phpファイルを名前順ソート | E-01 (L221) | ○ |
| C-16 | 制約なし/show-all=falseの場合はスキップ | E-01 (L115-118) | ○ |
| C-17 | Dumperクラスでオプション値フォーマット | E-01 (L90) | ○ |
| C-18 | 作者はLoic Fremont | E-01 (L36) | ○ |
| C-19 | クラス指定時の目標処理時間1秒以内 | **根拠なし** | △ |
| C-20 | ディレクトリ指定時のパフォーマンスはファイル数依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-19, C-20）はソースコードに明示的な記載がなく、一般的なCLIデバッグコマンドの特性から推測した値。
  - 候補：パフォーマンステスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のデバッグコマンドであり、システムへの影響はない
- 1: 中リスク - ディレクトリ走査時に大量のファイルを含むディレクトリを指定するとパフォーマンスに影響する可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] ディレクトリ走査時に大量のファイルを含む場合のパフォーマンスを確認
- [ ] 名前空間・クラス名の正規表現が一般的なPHPコードに対応しているか確認
- [ ] autoMappingStrategy/traversalStrategyの表示が正しいか確認
