---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：69-workflow_dump.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（目標処理時間）**：根拠不足
  2. **メモリ使用量（複雑なワークフロー）**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Component/Workflow/Command/WorkflowDumpCommand.php` - メインソースコード
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `workflow:dump` | E-01 (L37: AsCommand属性) | ○ |
| C-02 | name引数は必須 | E-01 (L56: REQUIRED) | ○ |
| C-03 | marking引数は配列（IS_ARRAY） | E-01 (L57) | ○ |
| C-04 | --labelオプションでグラフラベル指定 | E-01 (L58) | ○ |
| C-05 | --with-metadataオプションでメタデータ含有 | E-01 (L59) | ○ |
| C-06 | --dump-formatのデフォルトはdot | E-01 (L60) | ○ |
| C-07 | サポートダンプ形式: puml, mermaid, dot | E-01 (L40-44) | ○ |
| C-08 | ServiceProviderでワークフロー取得 | E-01 (L47, L78-81) | ○ |
| C-09 | 未登録ワークフローでInvalidArgumentException | E-01 (L79) | ○ |
| C-10 | TraceableWorkflowからgetInner()で内部取得 | E-01 (L82-84) | ○ |
| C-11 | StateMachineの判定でstate_machine/workflowを決定 | E-01 (L85) | ○ |
| C-12 | puml形式でPlantUmlDumperを使用 | E-01 (L89-91) | ○ |
| C-13 | mermaid形式でMermaidDumperを使用 | E-01 (L94-96) | ○ |
| C-14 | dot形式でGraphvizDumper/StateMachineGraphvizDumperを使用 | E-01 (L99-101) | ○ |
| C-15 | marking引数からMarkingオブジェクト生成 | E-01 (L104-108) | ○ |
| C-16 | nofooter: trueオプション設定 | E-01 (L113) | ○ |
| C-17 | コンソール補完機能サポート（name, dump-format） | E-01 (L121-130) | ○ |
| C-18 | 作者はGregoire Pineau | E-01 (L33) | ○ |
| C-19 | 目標処理時間は1秒以内 | **根拠なし** | △ |
| C-20 | メモリ使用量はワークフローの複雑さに依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（C-19, C-20）はソースコードに明示的な記載がなく、一般的なCLIコマンドの特性から推測した値。
  - 候補：パフォーマンステスト結果 / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のユーティリティコマンドであり、システムへの影響はない

## 6) レビュアーチェックリスト（最小）
- [ ] 各ダンプ形式（dot, puml, mermaid）の出力が正しいか確認
- [ ] StateMachineとWorkflowでダンパーが正しく切り替わるか確認
- [ ] --with-metadataオプションの出力内容を確認
- [ ] 非常に複雑なワークフロー（多数のプレース・トランジション）でのパフォーマンスを確認
