---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-cache_pool_invalidate-tags.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特記すべき優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bundle/FrameworkBundle/Command/CachePoolInvalidateTagsCommand.php` - メインソースコード
- E-02: `CachePoolInvalidateTagsCommand::configure()` メソッド（L43-56）- コマンド定義・引数・オプション
- E-03: `CachePoolInvalidateTagsCommand::execute()` メソッド（L58-100）- メイン処理ロジック
- E-04: `#[AsCommand]` アトリビュート（L30）- コマンド名・説明
- E-05: コンストラクタ（L35-41）- 依存性注入（ServiceProviderInterface）
- E-06: `CachePoolInvalidateTagsCommand::complete()` メソッド（L102-107）- シェル補完

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンド名は `cache:pool:invalidate-tags` である | E-04 | ○ |
| C-02 | tags引数は必須で配列 | E-02 (L46) | ○ |
| C-03 | --poolオプションで対象プールを限定可能 | E-02 (L47) | ○ |
| C-04 | --pool未指定時は全登録プールを対象 | E-03 (L61) | ○ |
| C-05 | ServiceProviderからプールインスタンスを取得 | E-03 (L70) | ○ |
| C-06 | ServiceNotFoundException時にエラーメッセージ出力 | E-03 (L71-75) | ○ |
| C-07 | TagAwareCacheInterface非実装時にエラー出力 | E-03 (L78-83) | ○ |
| C-08 | invalidateTags()で指定タグを無効化 | E-03 (L85) | ○ |
| C-09 | 無効化失敗時にエラーメッセージ出力 | E-03 (L86-88) | ○ |
| C-10 | エラーあり時に終了コード1 | E-03 (L91-94) | ○ |
| C-11 | 全成功時に成功メッセージと終了コード0 | E-03 (L97-99) | ○ |
| C-12 | シェル補完機能をサポート（pool名） | E-06 | ○ |
| C-13 | プール名はgetProvidedServices()から取得 | E-05 (L40) | ○ |
| C-14 | ServiceProviderInterfaceが依存注入される | E-05 | ○ |
| C-15 | エラー時も他プールの処理を継続 | E-03 (L74のcontinue) | ○ |
| C-16 | 進捗メッセージにタグリストとプール名を含む | E-03 (L67) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコードベースの根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 処理フローがソースコードの `execute()` メソッドの実装と一致しているか
- [ ] エラーケース（プール未発見・タグ非対応・無効化失敗）の処理が正確に記載されているか
- [ ] ServiceProviderInterfaceとTagAwareCacheInterfaceの役割が正確に記載されているか
