---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 247
  claims_with_evidence: 238
  claims_without_evidence: 9
confidence_derived: 0.96
---

# 根拠レポート：Bridge-Doctrine 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：238 / 247、根拠なし：9
- 優先レビュー（高）
  1. **ManagerRegistry.resetService の遅延プロキシリセット動作**：PHP 8.4のReflectionClass lazy objectsを使用しており実行時挙動の完全な検証が困難
  2. **DoctrineExtractor.getType のassociationMapping indexBy解決ロジック**：多段階のメタデータ参照チェーンが複雑で入力パターンの網羅性に要確認
  3. **DoctrineTokenProvider.verifyToken の並行リクエスト検証**：タイミング依存のテストケースで60秒ウィンドウの境界値テストが不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bridge/Doctrine/ContainerAwareEventManager.php` - イベントマネージャー実装（217行）
- E-02: `src/Symfony/Bridge/Doctrine/ManagerRegistry.php` - マネージャーレジストリ（90行）
- E-03: `src/Symfony/Bridge/Doctrine/Attribute/MapEntity.php` - MapEntityアトリビュート（84行）
- E-04: `src/Symfony/Bridge/Doctrine/ArgumentResolver/EntityValueResolver.php` - HTTPエンティティリゾルバ（153行）
- E-05: `src/Symfony/Bridge/Doctrine/ArgumentResolver/EntityValueResolverTrait.php` - エンティティリゾルバ共通トレイト（152行）
- E-06: `src/Symfony/Bridge/Doctrine/ArgumentResolver/Console/EntityValueResolver.php` - コンソールエンティティリゾルバ（181行）
- E-07: `src/Symfony/Bridge/Doctrine/DataCollector/DoctrineDataCollector.php` - データコレクター（222行）
- E-08: `src/Symfony/Bridge/Doctrine/DataCollector/ObjectParameter.php` - オブジェクトパラメータ（46行）
- E-09: `src/Symfony/Bridge/Doctrine/Middleware/Debug/Query.php` - クエリデバッグ情報（113行）
- E-10: `src/Symfony/Bridge/Doctrine/Middleware/Debug/DebugDataHolder.php` - デバッグデータホルダー（48行）
- E-11: `src/Symfony/Bridge/Doctrine/Middleware/Debug/Middleware.php` - デバッグミドルウェア（36行）
- E-12: `src/Symfony/Bridge/Doctrine/Middleware/Debug/Driver.php` - デバッグドライバ（46行）
- E-13: `src/Symfony/Bridge/Doctrine/Middleware/Debug/Connection.php` - デバッグコネクション（126行）
- E-14: `src/Symfony/Bridge/Doctrine/Middleware/Debug/Statement.php` - デバッグステートメント（64行）
- E-15: `src/Symfony/Bridge/Doctrine/Middleware/IdleConnection/Driver.php` - アイドル接続ドライバ（40行）
- E-16: `src/Symfony/Bridge/Doctrine/Middleware/IdleConnection/Listener.php` - アイドル接続リスナー（59行）
- E-17: `src/Symfony/Bridge/Doctrine/Types/AbstractUidType.php` - 抽象UID型（105行）
- E-18: `src/Symfony/Bridge/Doctrine/Types/UuidType.php` - UUID型（29行）
- E-19: `src/Symfony/Bridge/Doctrine/Types/UlidType.php` - ULID型（29行）
- E-20: `src/Symfony/Bridge/Doctrine/Types/DatePointType.php` - DatePoint型（44行）
- E-21: `src/Symfony/Bridge/Doctrine/Types/DayPointType.php` - DayPoint型（40行）
- E-22: `src/Symfony/Bridge/Doctrine/Types/TimePointType.php` - TimePoint型（40行）
- E-23: `src/Symfony/Bridge/Doctrine/Validator/Constraints/UniqueEntity.php` - UniqueEntity制約（89行）
- E-24: `src/Symfony/Bridge/Doctrine/Validator/Constraints/UniqueEntityValidator.php` - UniqueEntityバリデータ（314行）
- E-25: `src/Symfony/Bridge/Doctrine/Validator/DoctrineInitializer.php` - Doctrineイニシャライザ（33行）
- E-26: `src/Symfony/Bridge/Doctrine/Validator/DoctrineLoader.php` - Doctrineローダー（144行）
- E-27: `src/Symfony/Bridge/Doctrine/Security/User/EntityUserProvider.php` - エンティティユーザープロバイダ（165行）
- E-28: `src/Symfony/Bridge/Doctrine/Security/RememberMe/DoctrineTokenProvider.php` - Doctrineトークンプロバイダ（216行）
- E-29: `src/Symfony/Bridge/Doctrine/PropertyInfo/DoctrineExtractor.php` - Doctrineプロパティ情報抽出（255行）
- E-30: `src/Symfony/Bridge/Doctrine/Form/DoctrineOrmTypeGuesser.php` - フォーム型推測（203行）
- E-31: `src/Symfony/Bridge/Doctrine/Form/ChoiceList/DoctrineChoiceLoader.php` - 選択肢ローダー（107行）
- E-32: `src/Symfony/Bridge/Doctrine/Form/ChoiceList/IdReader.php` - ID読み取り（109行）
- E-33: `src/Symfony/Bridge/Doctrine/Form/ChoiceList/ORMQueryBuilderLoader.php` - ORM QueryBuilderローダー（102行）
- E-34: `src/Symfony/Bridge/Doctrine/Form/DataTransformer/CollectionToArrayTransformer.php` - Collection変換（56行）
- E-35: `src/Symfony/Bridge/Doctrine/Form/EventListener/MergeDoctrineCollectionListener.php` - コレクションマージリスナー（52行）
- E-36: `src/Symfony/Bridge/Doctrine/IdGenerator/UlidGenerator.php` - ULID生成器（34行）
- E-37: `src/Symfony/Bridge/Doctrine/IdGenerator/UuidGenerator.php` - UUID生成器（72行）
- E-38: `src/Symfony/Bridge/Doctrine/CacheWarmer/ProxyCacheWarmer.php` - プロキシキャッシュウォーマー（71行）
- E-39: `src/Symfony/Bridge/Doctrine/Messenger/AbstractDoctrineMiddleware.php` - 抽象Doctrineミドルウェア（46行）
- E-40: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineTransactionMiddleware.php` - トランザクションミドルウェア（56行）
- E-41: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineClearEntityManagerWorkerSubscriber.php` - EMクリアサブスクライバ（55行）
- E-42: `src/Symfony/Bridge/Doctrine/Messenger/DoctrinePingConnectionMiddleware.php` - 接続Pingミドルウェア（87行）
- E-43: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineCloseConnectionMiddleware.php` - 接続クローズミドルウェア（38行）
- E-44: `src/Symfony/Bridge/Doctrine/Messenger/DoctrineOpenTransactionLoggerMiddleware.php` - トランザクションログミドルウェア（57行）
- E-45: `src/Symfony/Bridge/Doctrine/DependencyInjection/CompilerPass/RegisterEventListenersAndSubscribersPass.php` - イベントリスナー登録パス（144行）
- E-46: `src/Symfony/Bridge/Doctrine/DependencyInjection/CompilerPass/DoctrineValidationPass.php` - バリデーションパス（56行）
- E-47: `src/Symfony/Bridge/Doctrine/DependencyInjection/CompilerPass/RegisterUidTypePass.php` - UID型登録パス（44行）
- E-48: `src/Symfony/Bridge/Doctrine/DependencyInjection/CompilerPass/RegisterDatePointTypePass.php` - DatePoint型登録パス（41行）
- E-49: `src/Symfony/Bridge/Doctrine/DependencyInjection/CompilerPass/RegisterMappingsPass.php` - マッピング登録パス（173行）
- E-50: `src/Symfony/Bridge/Doctrine/DependencyInjection/Security/UserProvider/EntityFactory.php` - ユーザープロバイダファクトリ（64行）
- E-51: `src/Symfony/Bridge/Doctrine/SchemaListener/PdoSessionHandlerSchemaListener.php` - PDOセッションスキーマリスナー（38行）
- E-52: `src/Symfony/Bridge/Doctrine/SchemaListener/MessengerTransportDoctrineSchemaListener.php` - メッセンジャースキーマリスナー（43行）
- E-53: `src/Symfony/Bridge/Doctrine/SchemaListener/AbstractSchemaListener.php` - 抽象スキーマリスナー（72行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-15 | ContainerAwareEventManagerのイベントディスパッチ・リスナー管理・遅延ロード・__invokeフォールバック | E-01 | ○ |
| C-16〜C-19 | ManagerRegistryのサービス取得・リセット・LazyObject対応 | E-02 | ○ |
| C-20〜C-24 | MapEntityアトリビュートのコンストラクタ・バリデーション・withDefaults | E-03 | ○ |
| C-25〜C-31 | EntityValueResolverのHTTPリクエストからのエンティティ解決 | E-04 | ○ |
| C-32〜C-45 | EntityValueResolverTraitのマネージャー取得・ID検索・式評価・criteria構築 | E-05 | ○ |
| C-46〜C-55 | DoctrineDataCollectorのデータ収集・サニタイズ・リセット | E-07 | ○ |
| C-56〜C-61 | ObjectParameterの基本動作 | E-08 | ○ |
| C-62〜C-71 | Queryクラスのタイマー・パラメータ管理・クローン | E-09 | ○ |
| C-72〜C-75 | DebugDataHolderのクエリ追加・取得・リセット | E-10 | ○ |
| C-76〜C-85 | Debug Middleware/Driver/Connection/Statementのラップ・記録動作 | E-11, E-12, E-13, E-14 | ○ |
| C-86〜C-90 | IdleConnection Driver/Listenerの接続期限管理 | E-15, E-16 | ○ |
| C-91〜C-104 | AbstractUidType/UuidType/UlidTypeの型変換・SQL宣言 | E-17, E-18, E-19 | ○ |
| C-105〜C-111 | DatePointType/DayPointType/TimePointTypeの変換 | E-20, E-21, E-22 | ○ |
| C-112〜C-115 | UniqueEntity制約の基本動作 | E-23 | ○ |
| C-116〜C-125 | UniqueEntityValidatorの検証ロジック | E-24 | ○ |
| C-126〜C-127 | DoctrineInitializerのプロキシ初期化 | E-25 | ○ |
| C-128〜C-131 | DoctrineLoaderの自動制約追加 | E-26 | ○ |
| C-132〜C-143 | EntityUserProviderのユーザー読み込み・リフレッシュ・パスワード更新 | E-27 | ○ |
| C-144〜C-155 | DoctrineTokenProviderのトークンCRUD・検証・スキーマ設定 | E-28 | ○ |
| C-156〜C-167 | DoctrineExtractorのプロパティ一覧・型抽出・書き込み判定 | E-29 | ○ |
| C-168〜C-175 | DoctrineOrmTypeGuesserの型推測 | E-30 | ○ |
| C-176〜C-179 | DoctrineChoiceLoaderの選択肢読み込み | E-31 | ○ |
| C-180〜C-185 | IdReaderのID判定・値取得 | E-32 | ○ |
| C-186〜C-189 | ORMQueryBuilderLoaderのエンティティ取得 | E-33 | ○ |
| C-190〜C-196 | CollectionToArrayTransformerの変換 | E-34 | ○ |
| C-197〜C-199 | MergeDoctrineCollectionListenerのコレクション管理 | E-35 | ○ |
| C-200〜C-201 | UlidGeneratorのID生成 | E-36 | ○ |
| C-202〜C-206 | UuidGeneratorのID生成・ファクトリ切替 | E-37 | ○ |
| C-207〜C-210 | ProxyCacheWarmerのキャッシュウォーム | E-38 | ○ |
| C-211〜C-226 | Messengerミドルウェア群（Transaction/Clear/Ping/Close/OpenTransactionLogger） | E-39〜E-44 | ○ |
| C-227〜C-232 | DI CompilerPass群（EventListener/Validation） | E-45, E-46 | ○ |
| C-233〜C-237 | DI CompilerPass群（RegisterUidType/RegisterDatePointType） | E-47, E-48 | ○ |
| C-238〜C-239 | EntityFactoryの定義生成 | E-50 | ○ |
| C-240〜C-243 | SchemaListener群のスキーマ設定 | E-51, E-52 | ○ |
| C-244〜C-247 | Console EntityValueResolverのエンティティ解決 | E-06 | ○ |
| C-016 | ManagerRegistry.resetService - LazyObjectリセットの細部動作 | E-02 | △ |
| C-040 | findById - evictCacheの実行パス | E-05 | △ |
| C-151 | verifyToken - 60秒以内の前回トークン検証 | E-28 | △ |
| C-162 | DoctrineExtractor.getType - indexByの多段解決 | E-29 | △ |
| C-203 | UuidGenerator - entityGetterがプロパティアクセスの場合 | E-37 | △ |
| C-208 | ProxyCacheWarmer - scandir結果のファイル返却 | E-38 | △ |
| C-210 | ProxyCacheWarmer - mkdir失敗時の例外 | E-38 | △ |
| C-221 | DoctrinePingConnectionMiddleware - リコネクト動作 | E-42 | △ |
| C-226 | DoctrineOpenTransactionLoggerMiddleware - 再帰防止 | E-44 | △ |

## 4) 不足情報（Unknown / Missing）
- ManagerRegistryのresetServiceで使用されるPHP 8.4 ReflectionClassのlazy object APIの挙動は実行時依存であり、コードレビューだけでは完全な検証が困難
  - 候補：PHP 8.4リリースノート / ReflectionClass公式ドキュメント / Symfony VarExporter LazyObjectInterface仕様
- DoctrineTokenProviderのverifyTokenにおける60秒ウィンドウの境界値テスト（60秒ちょうど、61秒）が不足
  - 候補：セキュリティ要件ドキュメント / Remember Me機能仕様書
- DoctrineExtractorのindexByメタデータ解決チェーンの全パターン網羅は外部メタデータ構造に依存
  - 候補：Doctrine ORM ClassMetadata仕様 / indexByフィールド解決ルール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DataCollector, ObjectParameter, Types, Form関連, IdGenerator, SchemaListener, DI CompilerPass (全体の約60%)
- 1: 中リスク - ContainerAwareEventManager, EntityValueResolver, Middleware/Debug, Messenger Middleware (全体の約30%)
- 2: 高リスク - ManagerRegistry.resetService (PHP 8.4 lazy objects), UniqueEntityValidator (データ整合性), DoctrineTokenProvider (セキュリティ), EntityUserProvider (認証) (全体の約10%)

## 6) レビュアーチェックリスト（最小）
- [ ] UniqueEntityValidatorのテストケースがidentifierFieldNames比較ロジックをカバーしているか確認
- [ ] DoctrineTokenProvider.verifyTokenの60秒境界値テストを追加検討
- [ ] ManagerRegistry.resetServiceのLazyObject/Ghost/Proxyの各パスが正しくテストされるか確認
- [ ] EntityUserProvider.refreshUserのDoctrineプロキシ初期化パスが網羅されているか確認
- [ ] DoctrineExtractor.getTypeのenumType対応テストケースの追加検討
- [ ] RegisterMappingsPass (抽象クラス) のprocess()メソッドのテストケース追加を検討（現在テストケースに含まれていない）
- [ ] AbstractSchemaListener.getIsSameDatabaseCheckerのテストケース追加を検討（DB依存のため単体テスト困難）
