---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 162
  claims_with_evidence: 158
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Bridge-Monolog 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 162、根拠なし：4
- 優先レビュー（高）
  1. **ServerLogHandler socket通信テスト**：実際のソケット接続が必要なためモック戦略の確認が必要
  2. **ElasticsearchLogstashHandler HttpClient不在テスト**：クラス存在チェックのテスト方法に要確認
  3. **ServerLogCommand execute/displayLog**：ストリーム系の処理で実際のソケットが必要
  4. **VarDumperFormatter formatBatch**：コード上のバグの可能性（$record[$k]が$records[$k]であるべき）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bridge/Monolog/Handler/MailerHandler.php` - MailerHandlerクラスの実装
- E-02: `src/Symfony/Bridge/Monolog/Handler/ConsoleHandler.php` - ConsoleHandlerクラスの実装
- E-03: `src/Symfony/Bridge/Monolog/Handler/FingersCrossed/HttpCodeActivationStrategy.php` - HttpCodeActivationStrategyクラスの実装
- E-04: `src/Symfony/Bridge/Monolog/Handler/ServerLogHandler.php` - ServerLogHandlerクラスの実装
- E-05: `src/Symfony/Bridge/Monolog/Handler/NotifierHandler.php` - NotifierHandlerクラスの実装
- E-06: `src/Symfony/Bridge/Monolog/Handler/FirePHPHandler.php` - FirePHPHandlerクラスの実装
- E-07: `src/Symfony/Bridge/Monolog/Handler/ChromePhpHandler.php` - ChromePhpHandlerクラスの実装
- E-08: `src/Symfony/Bridge/Monolog/Handler/ElasticsearchLogstashHandler.php` - ElasticsearchLogstashHandlerクラスの実装
- E-09: `src/Symfony/Bridge/Monolog/Processor/AbstractTokenProcessor.php` - AbstractTokenProcessorクラスの実装
- E-10: `src/Symfony/Bridge/Monolog/Processor/TokenProcessor.php` - TokenProcessorクラスの実装
- E-11: `src/Symfony/Bridge/Monolog/Processor/SwitchUserTokenProcessor.php` - SwitchUserTokenProcessorクラスの実装
- E-12: `src/Symfony/Bridge/Monolog/Processor/WebProcessor.php` - WebProcessorクラスの実装
- E-13: `src/Symfony/Bridge/Monolog/Processor/RouteProcessor.php` - RouteProcessorクラスの実装
- E-14: `src/Symfony/Bridge/Monolog/Processor/ConsoleCommandProcessor.php` - ConsoleCommandProcessorクラスの実装
- E-15: `src/Symfony/Bridge/Monolog/Processor/DebugProcessor.php` - DebugProcessorクラスの実装
- E-16: `src/Symfony/Bridge/Monolog/Formatter/ConsoleFormatter.php` - ConsoleFormatterクラスの実装
- E-17: `src/Symfony/Bridge/Monolog/Formatter/VarDumperFormatter.php` - VarDumperFormatterクラスの実装
- E-18: `src/Symfony/Bridge/Monolog/Command/ServerLogCommand.php` - ServerLogCommandクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MailerHandler: Emailテンプレートでのインスタンス生成 | E-01 (L26-39) | ○ |
| C-02 | MailerHandler: callableテンプレートのClosure変換 | E-01 (L38) | ○ |
| C-03 | MailerHandler: handleBatchでレベルフィルタリング後に送信 | E-01 (L41-55) | ○ |
| C-04 | MailerHandler: handleBatchの空結果時の非送信 | E-01 (L46-52) | ○ |
| C-05 | MailerHandler: handleBatchの空配列入力 | E-01 (L41-55) | ○ |
| C-06 | MailerHandler: writeメソッドでsendが呼ばれる | E-01 (L57-59) | ○ |
| C-07 | MailerHandler: buildMessageでEmailのclone | E-01 (L91-92) | ○ |
| C-08 | MailerHandler: buildMessageでcallableからEmail生成 | E-01 (L93-94) | ○ |
| C-09 | MailerHandler: callableがEmail以外を返した場合の例外 | E-01 (L95-97) | ○ |
| C-10 | MailerHandler: HtmlFormatterの場合のhtml設定 | E-01 (L107-112) | ○ |
| C-11 | MailerHandler: 非HtmlFormatterの場合のtext設定 | E-01 (L113-118) | ○ |
| C-12 | MailerHandler: htmlCharset付きの場合 | E-01 (L108-109) | ○ |
| C-13 | MailerHandler: subjectのフォーマット | E-01 (L102-105) | ○ |
| C-14 | MailerHandler: getHighestRecordの最高レベル選択 | E-01 (L124-134) | ○ |
| C-15 | MailerHandler: getHighestRecordの1件のみ | E-01 (L124-134) | ○ |
| C-16 | ConsoleHandler: デフォルトパラメータでの生成 | E-02 (L65-77) | ○ |
| C-17 | ConsoleHandler: カスタムverbosityLevelMap | E-02 (L74-76) | ○ |
| C-18 | ConsoleHandler: isHandlingでtrue | E-02 (L79-86) | ○ |
| C-19 | ConsoleHandler: output=nullでfalse | E-02 (L186-189) | ○ |
| C-20 | ConsoleHandler: interactiveOnlyフラグ | E-02 (L84) | ○ |
| C-21 | ConsoleHandler: getBubbleの基本動作 | E-02 (L88-95) | ○ |
| C-22 | ConsoleHandler: getBubbleのinteractiveOnly制御 | E-02 (L90-91) | ○ |
| C-23 | ConsoleHandler: handleの基本動作 | E-02 (L97-102) | ○ |
| C-24 | ConsoleHandler: handleでoutput=null時false | E-02 (L97-102, L186-189) | ○ |
| C-25 | ConsoleHandler: setOutput | E-02 (L112-115) | ○ |
| C-26 | ConsoleHandler: setInput | E-02 (L104-107) | ○ |
| C-27 | ConsoleHandler: close | E-02 (L120-126) | ○ |
| C-28 | ConsoleHandler: onCommand | E-02 (L132-142) | ○ |
| C-29 | ConsoleHandler: ConsoleOutputInterface時errorOutput使用 | E-02 (L137-139) | ○ |
| C-30 | ConsoleHandler: onTerminate | E-02 (L147-150) | ○ |
| C-31 | ConsoleHandler: getSubscribedEvents | E-02 (L152-158) | ○ |
| C-32 | ConsoleHandler: writeでoutputに書き込み | E-02 (L160-164) | ○ |
| C-33 | ConsoleHandler: getDefaultFormatter | E-02 (L166-179) | ○ |
| C-34 | ConsoleHandler: VERBOSITY_SILENTでfalse | E-02 (L195-196) | ○ |
| C-35 | ConsoleHandler: 未定義verbosityでDebug | E-02 (L197-198) | ○ |
| C-36 | HttpCodeActivationStrategy: 有効なexclusionsでの生成 | E-03 (L30-43) | ○ |
| C-37 | HttpCodeActivationStrategy: codeキー欠落で例外 | E-03 (L36-38) | ○ |
| C-38 | HttpCodeActivationStrategy: urlsキー欠落で例外 | E-03 (L39-41) | ○ |
| C-39 | HttpCodeActivationStrategy: inner非アクティブ時false | E-03 (L47) | ○ |
| C-40 | HttpCodeActivationStrategy: 除外パターン一致でfalse | E-03 (L55-64) | ○ |
| C-41 | HttpCodeActivationStrategy: URL不一致時true | E-03 (L61) | ○ |
| C-42 | HttpCodeActivationStrategy: 空URL配列でfalse | E-03 (L60, L64) | ○ |
| C-43 | HttpCodeActivationStrategy: 非HTTP例外 | E-03 (L52) | ○ |
| C-44 | HttpCodeActivationStrategy: 例外なし | E-03 (L51) | ○ |
| C-45 | ServerLogHandler: プロトコル自動付与 | E-04 (L43-44) | ○ |
| C-46 | ServerLogHandler: 既存プロトコルの保持 | E-04 (L43) | ○ |
| C-47 | ServerLogHandler: レベルフィルタリング | E-04 (L52-55) | ○ |
| C-48 | ServerLogHandler: デフォルトフォーマッタ | E-04 (L90-93) | ○ |
| C-49 | ServerLogHandler: formatRecordのbase64エンコード | E-04 (L120) | ○ |
| C-50 | ServerLogHandler: log_uuid優先のlog_id抽出 | E-04 (L113-118) | ○ |
| C-51 | ServerLogHandler: uuid使用のlog_id抽出 | E-04 (L113-118) | ○ |
| C-52 | NotifierHandler: Error以上のレベルでの生成 | E-05 (L28-34) | ○ |
| C-53 | NotifierHandler: Error未満の場合のレベル引き上げ | E-05 (L33) | ○ |
| C-54 | NotifierHandler: handle基本動作 | E-05 (L36-45) | ○ |
| C-55 | NotifierHandler: handleでレベルフィルタリング | E-05 (L38-39) | ○ |
| C-56 | NotifierHandler: handleBatch基本動作 | E-05 (L47-52) | ○ |
| C-57 | NotifierHandler: handleBatchで条件不一致 | E-05 (L49) | ○ |
| C-58 | NotifierHandler: Throwable例外からの通知生成 | E-05 (L57-58) | ○ |
| C-59 | NotifierHandler: メッセージからの通知生成 | E-05 (L59-60) | ○ |
| C-60 | FirePHPHandler: メインリクエストでFirePHP UA時のヘッダー設定 | E-06 (L33-53) | ○ |
| C-61 | FirePHPHandler: サブリクエストのスキップ | E-06 (L35-37) | ○ |
| C-62 | FirePHPHandler: 非FirePHPブラウザ時sendHeaders=false | E-06 (L40-47) | ○ |
| C-63 | FirePHPHandler: X-FirePHP-Versionによる検出 | E-06 (L41) | ○ |
| C-64 | FirePHPHandler: response設定時の直接設定 | E-06 (L61-62) | ○ |
| C-65 | FirePHPHandler: response未設定時のバッファリング | E-06 (L63-64) | ○ |
| C-66 | FirePHPHandler: sendHeaders=false時の無操作 | E-06 (L57-59) | ○ |
| C-67 | FirePHPHandler: headersAccepted常時true | E-06 (L71-74) | ○ |
| C-68 | ChromePhpHandler: メインリクエストでChromePHP UA時のヘッダー設定 | E-07 (L33-51) | ○ |
| C-69 | ChromePhpHandler: サブリクエストのスキップ | E-07 (L35-37) | ○ |
| C-70 | ChromePhpHandler: 非ChromePHP UA時sendHeaders=false | E-07 (L39-44) | ○ |
| C-71 | ChromePhpHandler: response設定時の直接設定 | E-07 (L59-60) | ○ |
| C-72 | ChromePhpHandler: response未設定時のバッファリング | E-07 (L61-63) | ○ |
| C-73 | ChromePhpHandler: headersAccepted常時true | E-07 (L69-72) | ○ |
| C-74 | ElasticsearchLogstashHandler: カスタムクライアントでの生成 | E-08 (L56-71) | ○ |
| C-75 | ElasticsearchLogstashHandler: デフォルトクライアント生成 | E-08 (L69) | ○ |
| C-76 | ElasticsearchLogstashHandler: HttpClient不在時の例外 | E-08 (L64-66) | △ |
| C-77 | ElasticsearchLogstashHandler: handle基本動作 | E-08 (L73-82) | ○ |
| C-78 | ElasticsearchLogstashHandler: handleでレベルフィルタリング | E-08 (L75-77) | ○ |
| C-79 | ElasticsearchLogstashHandler: バッチ処理 | E-08 (L84-91) | ○ |
| C-80 | ElasticsearchLogstashHandler: 条件不一致バッチ | E-08 (L86-88) | ○ |
| C-81 | ElasticsearchLogstashHandler: ES7形式 | E-08 (L102-107) | ○ |
| C-82 | ElasticsearchLogstashHandler: ES6形式 | E-08 (L108-114) | ○ |
| C-83 | ElasticsearchLogstashHandler: デフォルトフォーマッタ | E-08 (L93-96) | ○ |
| C-84 | ElasticsearchLogstashHandler: シリアライズ禁止 | E-08 (L141-144) | ○ |
| C-85 | ElasticsearchLogstashHandler: アンシリアライズ禁止 | E-08 (L146-149) | ○ |
| C-86 | AbstractTokenProcessor: トークン存在時の情報設定 | E-09 (L37-48) | ○ |
| C-87 | AbstractTokenProcessor: トークン不在時のnull設定 | E-09 (L39) | ○ |
| C-88 | AbstractTokenProcessor: ユーザーなし時authenticated=false | E-09 (L43) | ○ |
| C-89 | TokenProcessor: getKeyが'token'を返す | E-10 (L24-27) | ○ |
| C-90 | TokenProcessor: getTokenがtokenStorageのtokenを返す | E-10 (L29-32) | ○ |
| C-91 | TokenProcessor: __invoke統合テスト | E-10, E-09 | ○ |
| C-92 | SwitchUserTokenProcessor: getKeyが'impersonator_token'を返す | E-11 (L24-27) | ○ |
| C-93 | SwitchUserTokenProcessor: SwitchUserToken時originalToken返却 | E-11 (L29-36) | ○ |
| C-94 | SwitchUserTokenProcessor: 非SwitchUserToken時null | E-11 (L35) | ○ |
| C-95 | SwitchUserTokenProcessor: トークンnull時null | E-11 (L31) | ○ |
| C-96 | WebProcessor: コンストラクタの安全性 | E-12 (L28-31) | ○ |
| C-97 | WebProcessor: メインリクエスト時serverData更新 | E-12 (L34-39) | ○ |
| C-98 | WebProcessor: REMOTE_ADDRのgetClientIp上書き | E-12 (L38) | ○ |
| C-99 | WebProcessor: サブリクエスト時スキップ | E-12 (L36) | ○ |
| C-100 | WebProcessor: getSubscribedEvents | E-12 (L42-47) | ○ |
| C-101 | RouteProcessor: コンストラクタの基本動作 | E-13 (L33-37) | ○ |
| C-102 | RouteProcessor: __invokeでルート情報付加 | E-13 (L39-46) | ○ |
| C-103 | RouteProcessor: 空データ時のスキップ | E-13 (L41) | ○ |
| C-104 | RouteProcessor: 既存データの保護 | E-13 (L41) | ○ |
| C-105 | RouteProcessor: reset処理 | E-13 (L48-51) | ○ |
| C-106 | RouteProcessor: メインリクエストでリセット後追加 | E-13 (L53-73) | ○ |
| C-107 | RouteProcessor: サブリクエストで追加のみ | E-13 (L55-57) | ○ |
| C-108 | RouteProcessor: _controllerなし時スキップ | E-13 (L60-62) | ○ |
| C-109 | RouteProcessor: includeParams=trueでパラメータ含有 | E-13 (L69-71) | ○ |
| C-110 | RouteProcessor: includeParams=falseでパラメータ除外 | E-13 (L69) | ○ |
| C-111 | RouteProcessor: removeRouteData | E-13 (L76-80) | ○ |
| C-112 | RouteProcessor: getSubscribedEvents | E-13 (L82-88) | ○ |
| C-113 | ConsoleCommandProcessor: コンストラクタ基本動作 | E-14 (L30-33) | ○ |
| C-114 | ConsoleCommandProcessor: __invokeでコマンド情報付加 | E-14 (L36-43) | ○ |
| C-115 | ConsoleCommandProcessor: 未設定時スキップ | E-14 (L38) | ○ |
| C-116 | ConsoleCommandProcessor: 既存データの保護 | E-14 (L38) | ○ |
| C-117 | ConsoleCommandProcessor: reset処理 | E-14 (L45-48) | ○ |
| C-118 | ConsoleCommandProcessor: コマンド名の設定 | E-14 (L50-61) | ○ |
| C-119 | ConsoleCommandProcessor: includeArguments=trueで引数含有 | E-14 (L55-57) | ○ |
| C-120 | ConsoleCommandProcessor: includeArguments=falseで引数除外 | E-14 (L55) | ○ |
| C-121 | ConsoleCommandProcessor: includeOptions=trueでオプション含有 | E-14 (L58-60) | ○ |
| C-122 | ConsoleCommandProcessor: includeOptions=falseでオプション除外 | E-14 (L58) | ○ |
| C-123 | ConsoleCommandProcessor: getSubscribedEvents | E-14 (L63-68) | ○ |
| C-124 | DebugProcessor: RequestStackなしでの生成 | E-15 (L27-29) | ○ |
| C-125 | DebugProcessor: RequestStackありでの生成 | E-15 (L27-29) | ○ |
| C-126 | DebugProcessor: __invokeでレコード記録 | E-15 (L32-55) | ○ |
| C-127 | DebugProcessor: リクエスト単位の記録 | E-15 (L34) | ○ |
| C-128 | DebugProcessor: Warning超のerrorCountインクリメント | E-15 (L50-52) | ○ |
| C-129 | DebugProcessor: Warning以下のerrorCount非インクリメント | E-15 (L50) | ○ |
| C-130 | DebugProcessor: getLogs全取得 | E-15 (L57-68) | ○ |
| C-131 | DebugProcessor: getLogsリクエスト指定 | E-15 (L59-60) | ○ |
| C-132 | DebugProcessor: getLogs空 | E-15 (L63-65) | ○ |
| C-133 | DebugProcessor: getLogs該当なし | E-15 (L60) | ○ |
| C-134 | DebugProcessor: countErrors全カウント | E-15 (L70-77) | ○ |
| C-135 | DebugProcessor: countErrorsリクエスト指定 | E-15 (L71-72) | ○ |
| C-136 | DebugProcessor: countErrorsエラーなし | E-15 (L76) | ○ |
| C-137 | DebugProcessor: countErrors該当なし | E-15 (L72) | ○ |
| C-138 | DebugProcessor: clear処理 | E-15 (L79-83) | ○ |
| C-139 | DebugProcessor: reset処理 | E-15 (L85-88) | ○ |
| C-140 | ConsoleFormatter: デフォルトオプション | E-16 (L62-88) | ○ |
| C-141 | ConsoleFormatter: カスタムオプション | E-16 (L64) | ○ |
| C-142 | ConsoleFormatter: formatの基本動作 | E-16 (L99-127) | ○ |
| C-143 | ConsoleFormatter: 空contextの省略 | E-16 (L103-108) | ○ |
| C-144 | ConsoleFormatter: contextの出力 | E-16 (L103-105) | ○ |
| C-145 | ConsoleFormatter: レベル色マッピング | E-16 (L34-43, L119) | ○ |
| C-146 | ConsoleFormatter: formatBatch | E-16 (L90-97) | ○ |
| C-147 | ConsoleFormatter: 空バッチ | E-16 (L90-97) | ○ |
| C-148 | ConsoleFormatter: プレースホルダ置換 | E-16 (L156-175) | ○ |
| C-149 | ConsoleFormatter: プレースホルダなし | E-16 (L160-162) | ○ |
| C-150 | ConsoleFormatter: echoLine (depth != -1) | E-16 (L132-137) | ○ |
| C-151 | ConsoleFormatter: echoLine (depth = -1) | E-16 (L134-136) | ○ |
| C-152 | ConsoleFormatter: castObject multiline=true | E-16 (L142-154) | ○ |
| C-153 | ConsoleFormatter: castObject multiline=false nested | E-16 (L148-151) | ○ |
| C-154 | ConsoleFormatter: castObject DateTimeInterface除外 | E-16 (L148) | ○ |
| C-155 | VarDumperFormatter: デフォルトCloner | E-17 (L25-28) | ○ |
| C-156 | VarDumperFormatter: カスタムCloner | E-17 (L25-28) | ○ |
| C-157 | VarDumperFormatter: formatの基本動作 | E-17 (L30-38) | ○ |
| C-158 | VarDumperFormatter: formatBatch | E-17 (L40-47) | △ |
| C-159 | ServerLogCommand: isEnabled (true) | E-18 (L40-52) | ○ |
| C-160 | ServerLogCommand: isEnabled (false) | E-18 (L42-44) | ○ |
| C-161 | ServerLogCommand: configure | E-18 (L54-77) | ○ |
| C-162 | ServerLogCommand: displayLog log_id表示 | E-18 (L149-170) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-76 (ElasticsearchLogstashHandler HttpClient不在時テスト)**: `class_exists(HttpClient::class)` のモック方法が言語的に特殊であり、テスト実装時にクラスローダのモックが必要になる可能性がある
  - 候補：PHPUnit の `@runInSeparateProcess` / Mockery のクラスモック / テスト用の名前空間分離
- **C-158 (VarDumperFormatter formatBatch)**: ソースコード上で `$record[$k]` と記述されているが `$records[$k]` が正しい可能性がある。バグの可能性があるため実際の挙動の確認が必要
  - 候補：既存テストの確認 / Symfonyのissueトラッカーの確認
- **C-162 (ServerLogCommand displayLog)**: displayLogメソッドはprivateであり、executeメソッド経由でのみテスト可能。ストリームソケットの生成が必要なため統合テストに近い
  - 候補：ReflectionMethodでのテスト / executeメソッド全体のテスト

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: VarDumperFormatter::formatBatch のコード `$record[$k] = $this->format($record)` は `$records[$k]` のタイプミスの可能性がある。テストケースではこの実装を前提としているが、意図した動作であるか要確認
- **リスク0 (低)**: ServerLogHandler のソケット通信テストは、実際のTCPソケット接続を伴うため、CI環境でのテスト安定性に注意が必要
- **リスク0 (低)**: ServerLogCommand の execute メソッドは無限ループ（stream_select）を含むため、単体テストでの直接テストは困難。タイムアウト設定が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MailerHandler の buildMessage メソッドの条件分岐（Email/callable/HtmlFormatter/TextFormatter）が全て網羅されているか
- [ ] ConsoleHandler の verbosityLevelMap の各レベル（QUIET/NORMAL/VERBOSE/VERY_VERBOSE/DEBUG/SILENT）が適切にテストされているか
- [ ] HttpCodeActivationStrategy の URL パターンマッチング（正規表現）の境界ケースが十分か
- [ ] NotifierHandler の最低レベル制約（Level::Error未満は引き上げ）のテストが正確か
- [ ] DebugProcessor のリクエスト別ログ管理（spl_object_id ベース）のテストが適切か
- [ ] VarDumperFormatter::formatBatch のバグの可能性を確認したか
- [ ] ElasticsearchLogstashHandler の Elasticsearch バージョン別（v6 vs v7）のリクエストボディ形式の違いが正しくテストされているか
- [ ] AbstractTokenProcessor/TokenProcessor/SwitchUserTokenProcessor のセキュリティトークン情報の漏洩リスクに関するテストが含まれているか
