---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 82
  claims_with_evidence: 79
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：Bridge-PsrHttpMessage 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：79 / 82、根拠なし：3
- 優先レビュー（高）
  1. **UT-PSR-037（null URI処理）**：ストリームメタデータがnullを返すケースの実装パスはコードから推測できるが、具体的なPSR-7実装依存のため要確認
  2. **UT-PSR-042（パーミッション設定）**：chmodの具体的な挙動はOS依存であり、テスト環境での検証方法が不明確
  3. **UT-PSR-047（部分指定の自動補完）**：matchのフォールスルー動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bridge/PsrHttpMessage/Factory/HttpFoundationFactory.php` - HttpFoundationFactoryクラス実装（157行）
- E-02: `src/Symfony/Bridge/PsrHttpMessage/Factory/PsrHttpFactory.php` - PsrHttpFactoryクラス実装（204行）
- E-03: `src/Symfony/Bridge/PsrHttpMessage/Factory/UploadedFile.php` - UploadedFileクラス実装（69行）
- E-04: `src/Symfony/Bridge/PsrHttpMessage/ArgumentValueResolver/PsrServerRequestResolver.php` - PsrServerRequestResolverクラス実装（49行）
- E-05: `src/Symfony/Bridge/PsrHttpMessage/EventListener/PsrResponseListener.php` - PsrResponseListenerクラス実装（56行）
- E-06: `src/Symfony/Bridge/PsrHttpMessage/HttpFoundationFactoryInterface.php` - HttpFoundationFactoryInterfaceインタフェース定義（35行）
- E-07: `src/Symfony/Bridge/PsrHttpMessage/HttpMessageFactoryInterface.php` - HttpMessageFactoryInterfaceインタフェース定義（35行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-PSR-001: HttpFoundationFactory コンストラクタのデフォルト値(16372) | E-01 L32-34 | ○ |
| C-02 | UT-PSR-002: カスタムバッファサイズ指定 | E-01 L32-34 | ○ |
| C-03 | UT-PSR-003: PSR-7→Symfony基本リクエスト変換 | E-01 L37-74 | ○ |
| C-04 | UT-PSR-004: HTTPS判定でserver['HTTPS']='on'設定 | E-01 L51-53 | ○ |
| C-05 | UT-PSR-005: HTTP時のHTTPSパラメータ不在 | E-01 L51-53 | ○ |
| C-06 | UT-PSR-006: カスタムポート設定 | E-01 L43 | ○ |
| C-07 | UT-PSR-007: HTTPS時デフォルトポート443 | E-01 L43 | ○ |
| C-08 | UT-PSR-008: HTTP時デフォルトポート80 | E-01 L43 | ○ |
| C-09 | UT-PSR-009: 空クエリ時のREQUEST_URI | E-01 L47-49 | ○ |
| C-10 | UT-PSR-010: クエリ文字列付きREQUEST_URI | E-01 L47-49 | ○ |
| C-11 | UT-PSR-011: ヘッダーのコピー | E-01 L71 | ○ |
| C-12 | UT-PSR-012: 配列parsedBodyのPOSTパラメータ変換 | E-01 L59-60 | ○ |
| C-13 | UT-PSR-013: 非配列parsedBodyの空配列変換 | E-01 L60 | ○ |
| C-14 | UT-PSR-014: null parsedBodyの処理 | E-01 L60 | ○ |
| C-15 | UT-PSR-015: クッキーパラメータの変換 | E-01 L62-64 | ○ |
| C-16 | UT-PSR-016: 属性の変換 | E-01 L62-65 | ○ |
| C-17 | UT-PSR-017: streamed=falseのボディ文字列変換 | E-01 L69 | ○ |
| C-18 | UT-PSR-018: streamed=trueのストリーム変換 | E-01 L69 | ○ |
| C-19 | UT-PSR-019: アップロードファイルの変換 | E-01 L67, L79-92 | ○ |
| C-20 | UT-PSR-020: ネストファイルの再帰変換 | E-01 L83-88 | ○ |
| C-21 | UT-PSR-021: 空ファイル配列 | E-01 L79-92 | ○ |
| C-22 | UT-PSR-022: サーバーパラメータのマージ | E-01 L57 | ○ |
| C-23 | UT-PSR-023: PSR-7→Symfony基本レスポンス変換 | E-01 L110-136 | ○ |
| C-24 | UT-PSR-024: Set-Cookieヘッダーの変換 | E-01 L112-113, L131-133 | ○ |
| C-25 | UT-PSR-025: 複数Set-Cookie変換 | E-01 L131-133 | ○ |
| C-26 | UT-PSR-026: プロトコルバージョン設定 | E-01 L129 | ○ |
| C-27 | UT-PSR-027: streamed=trueでStreamedResponse返却 | E-01 L115-120 | ○ |
| C-28 | UT-PSR-028: streamed=falseでResponse返却 | E-01 L121-127 | ○ |
| C-29 | UT-PSR-029: seekableストリームのrewind | E-01 L141-143 | ○ |
| C-30 | UT-PSR-030: readableでないストリームのecho出力 | E-01 L145-148 | ○ |
| C-31 | UT-PSR-031: 空ボディレスポンス | E-01 L110-136 | ○ |
| C-32 | UT-PSR-032: Set-Cookieのヘッダーからの除外 | E-01 L112-113 | ○ |
| C-33 | UT-PSR-033: 一時ファイルパス生成 | E-01 L105-108 | ○ |
| C-34 | UT-PSR-034: UPLOAD_ERR_OK時の初期化 | E-03 L26-49 | ○ |
| C-35 | UT-PSR-035: UPLOAD_ERR_NO_FILEの空パス初期化 | E-03 L33-40 | ○ |
| C-36 | UT-PSR-036: 非アップロードファイルの一時パス移動 | E-03 L36-39 | ○ |
| C-37 | UT-PSR-037: null URIのテストモード初期化 | E-03 L34-36 | △ |
| C-38 | UT-PSR-038: 有効・非テストモード時のmoveTo呼出 | E-03 L51-67 | ○ |
| C-39 | UT-PSR-039: テストモード時のparent::move呼出 | E-03 L53-55 | ○ |
| C-40 | UT-PSR-040: 無効ファイル時のparent::move呼出 | E-03 L53-55 | ○ |
| C-41 | UT-PSR-041: RuntimeException→FileException変換 | E-03 L59-63 | ○ |
| C-42 | UT-PSR-042: 移動後のchmod | E-03 L65 | △ |
| C-43 | UT-PSR-043: 全ファクトリ指定のコンストラクタ | E-02 L43-66 | ○ |
| C-44 | UT-PSR-044: DiscoveryPsr17Factoryの自動検出 | E-02 L49-54 | ○ |
| C-45 | UT-PSR-045: NyholmPsr17Factoryの自動検出 | E-02 L49-54 | ○ |
| C-46 | UT-PSR-046: LogicExceptionスロー | E-02 L53 | ○ |
| C-47 | UT-PSR-047: 部分指定の自動補完 | E-02 L49-59 | △ |
| C-48 | UT-PSR-048: Symfony→PSR-7基本リクエスト変換 | E-02 L68-113 | ○ |
| C-49 | UT-PSR-049: 空クエリの処理 | E-02 L70-71 | ○ |
| C-50 | UT-PSR-050: ヘッダーのPSR-7へのコピー | E-02 L79-85 | ○ |
| C-51 | UT-PSR-051: 無効ヘッダーの無視 | E-02 L82-84 | ○ |
| C-52 | UT-PSR-052: JSONボディのパース | E-02 L88-95 | ○ |
| C-53 | UT-PSR-053: 不正JSONのnull設定 | E-02 L91-95 | ○ |
| C-54 | UT-PSR-054: フォームデータのparsedBody設定 | E-02 L96-98 | ○ |
| C-55 | UT-PSR-055: 非配列JSON結果のnull設定 | E-02 L93-95 | ○ |
| C-56 | UT-PSR-056: アップロードファイルPSR-7変換 | E-02 L102, L118-135 | ○ |
| C-57 | UT-PSR-057: nullファイルのUPLOAD_ERR_NO_FILE変換 | E-02 L123-125 | ○ |
| C-58 | UT-PSR-058: ネストファイルの再帰変換 | E-02 L129-131 | ○ |
| C-59 | UT-PSR-059: クッキーのPSR-7設定 | E-02 L103 | ○ |
| C-60 | UT-PSR-060: 属性のPSR-7設定 | E-02 L108-110 | ○ |
| C-61 | UT-PSR-061: Symfony→PSR-7基本レスポンス変換 | E-02 L153-203 | ○ |
| C-62 | UT-PSR-062: BinaryFileResponseのストリーム変換 | E-02 L157-160 | ○ |
| C-63 | UT-PSR-063: Content-Range付きBinaryFileResponse | E-02 L157, L162-177 | ○ |
| C-64 | UT-PSR-064: StreamedResponseのob_start変換 | E-02 L163-174 | ○ |
| C-65 | UT-PSR-065: クッキーのSet-Cookieヘッダー変換 | E-02 L183-189 | ○ |
| C-66 | UT-PSR-066: レスポンスプロトコルバージョン設定 | E-02 L200-202 | ○ |
| C-67 | UT-PSR-067: 無効ヘッダーの無視 | E-02 L193-196 | ○ |
| C-68 | UT-PSR-068: 空クッキー時のSet-Cookie不追加 | E-02 L184 | ○ |
| C-69 | UT-PSR-069: ステータステキスト設定 | E-02 L155 | ○ |
| C-70 | UT-PSR-070: 未定義ステータスコードの空reasonPhrase | E-02 L155 | ○ |
| C-71 | UT-PSR-071: PsrServerRequestResolverコンストラクタ | E-04 L36-38 | ○ |
| C-72 | UT-PSR-072: ServerRequestInterface解決 | E-04 L30-34, L41-48 | ○ |
| C-73 | UT-PSR-073: RequestInterface解決 | E-04 L30-34, L41-48 | ○ |
| C-74 | UT-PSR-074: MessageInterface解決 | E-04 L30-34, L41-48 | ○ |
| C-75 | UT-PSR-075: サポート外型の空Traversable | E-04 L43-44 | ○ |
| C-76 | UT-PSR-076: null型の空Traversable | E-04 L43-44 | ○ |
| C-77 | UT-PSR-077: PsrResponseListenerコンストラクタ(指定) | E-05 L31-34 | ○ |
| C-78 | UT-PSR-078: デフォルトHttpFoundationFactory使用 | E-05 L33 | ○ |
| C-79 | UT-PSR-079: ResponseInterface→Symfony Response変換 | E-05 L39-48 | ○ |
| C-80 | UT-PSR-080: 非ResponseInterface結果のスキップ | E-05 L43-45 | ○ |
| C-81 | UT-PSR-081: null結果のスキップ | E-05 L43-45 | ○ |
| C-82 | UT-PSR-082: イベント購読の確認 | E-05 L50-54 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-37（null URI処理）**: PSR-7実装によってストリームメタデータのuri値がnullを返すかどうかは実装依存。PHPの`is_string()`チェックによりnull時にテストモードへ分岐することはコードから読み取れるが、実際にnullを返すPSR-7実装の存在は未確認。
  - 候補：PSR-7仕様書 / 各PSR-7実装のドキュメント / Symfonyの既存テスト
- **C-42（パーミッション設定）**: `@chmod`による静的なパーミッション設定はOS環境依存であり、テスト時のアサーション方法が限定される。
  - 候補：PHPマニュアル / ファイルシステムテストのベストプラクティス
- **C-47（部分指定の自動補完）**: コンストラクタで一部のファクトリのみnullの場合のmatch式の挙動。null合体演算子(`??=`)で補完される動作はコードから読み取れるが、様々な組み合わせの網羅的テストは要検討。
  - 候補：PHPマニュアル（null合体代入演算子） / Symfonyの既存テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: テストケースの大半（79/82）はソースコードから直接根拠を確認可能
- **1 (中リスク)**: UploadedFileのコンストラクタ内のis_uploaded_file判定パスは、テスト環境での再現が困難であり、モック戦略の検討が必要
- **1 (中リスク)**: PsrHttpFactoryのコンストラクタにおける自動検出ロジックは、クラス存在判定（class_exists）に依存しており、テスト環境でのクラスローダ制御が必要
- **0 (低リスク)**: PsrServerRequestResolverとPsrResponseListenerは単純な委譲パターンであり、モックベースのテストで十分検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのpublicメソッドに対して正常系テストケースが存在するか確認
- [ ] 条件分岐（if/else, match, 三項演算子）に対応する異常系・境界値テストケースが存在するか確認
- [ ] PSR-7インタフェースのモック方針が各テストケースの前提条件として適切か確認
- [ ] UploadedFileのis_uploaded_file判定に関するテストケース（UT-PSR-034〜037）のテスト実行可能性を確認
- [ ] PsrHttpFactory.createResponseのBinaryFileResponse/StreamedResponse分岐が網羅されているか確認
- [ ] Set-Cookieヘッダーの分離処理（UT-PSR-024, 025, 032）の期待結果が正確か確認
- [ ] 無効ヘッダー無視のテストケース（UT-PSR-051, 067）で適切なモック例外が設計されているか確認
