---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 225
  claims_with_evidence: 218
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：Bridge-Twig 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：218 / 225、根拠なし：7
- 優先レビュー（高）
  1. **NotificationEmail関連テスト**：コンストラクタの依存パッケージ（CssInlinerExtension/InkyExtension）のチェックはモック戦略の確認が必要
  2. **TemplateAttributeListener**：ControllerArgumentsMetadataとControllerArgumentsEventの条件分岐が複雑で、テストケースの網羅性要確認
  3. **TwigRendererEngine**：loadResourceForBlockNameの再帰的処理とキャッシュ戦略のテストケース粒度要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bridge/Twig/AppVariable.php` - AppVariableクラスの全メソッド定義
- E-02: `src/Symfony/Bridge/Twig/UndefinedCallableHandler.php` - 未定義呼び出しハンドラの定数定義とメソッド
- E-03: `src/Symfony/Bridge/Twig/DataCollector/TwigDataCollector.php` - データコレクタクラスの定義
- E-04: `src/Symfony/Bridge/Twig/ErrorRenderer/TwigErrorRenderer.php` - エラーレンダラの定義
- E-05: `src/Symfony/Bridge/Twig/Extension/TranslationExtension.php` - 翻訳拡張クラスの定義
- E-06: `src/Symfony/Bridge/Twig/Extension/HttpFoundationExtension.php` - HttpFoundation拡張
- E-07: `src/Symfony/Bridge/Twig/Extension/RoutingExtension.php` - ルーティング拡張
- E-08: `src/Symfony/Bridge/Twig/Extension/SecurityExtension.php` - セキュリティ拡張
- E-09: `src/Symfony/Bridge/Twig/Extension/WorkflowExtension.php` - ワークフロー拡張
- E-10: `src/Symfony/Bridge/Twig/Extension/CsrfRuntime.php` - CSRFランタイム
- E-11: `src/Symfony/Bridge/Twig/Extension/HttpKernelRuntime.php` - HttpKernelランタイム
- E-12: `src/Symfony/Bridge/Twig/Extension/SerializerRuntime.php` - シリアライザランタイム
- E-13: `src/Symfony/Bridge/Twig/Extension/ImportMapRuntime.php` - ImportMapランタイム
- E-14: `src/Symfony/Bridge/Twig/Extension/AssetExtension.php` - アセット拡張
- E-15: `src/Symfony/Bridge/Twig/Extension/LogoutUrlExtension.php` - ログアウトURL拡張
- E-16: `src/Symfony/Bridge/Twig/Extension/WebLinkExtension.php` - WebLink拡張
- E-17: `src/Symfony/Bridge/Twig/Extension/HtmlSanitizerExtension.php` - HTMLサニタイザー拡張
- E-18: `src/Symfony/Bridge/Twig/Mime/TemplatedEmail.php` - テンプレートメール
- E-19: `src/Symfony/Bridge/Twig/Mime/BodyRenderer.php` - 本文レンダラ
- E-20: `src/Symfony/Bridge/Twig/Mime/NotificationEmail.php` - 通知メール
- E-21: `src/Symfony/Bridge/Twig/Mime/WrappedTemplatedEmail.php` - ラップされたテンプレートメール
- E-22: `src/Symfony/Bridge/Twig/NodeVisitor/Scope.php` - スコープクラス
- E-23: `src/Symfony/Bridge/Twig/NodeVisitor/TranslationNodeVisitor.php` - 翻訳ノードビジター
- E-24: `src/Symfony/Bridge/Twig/NodeVisitor/TranslationDefaultDomainNodeVisitor.php` - デフォルトドメインノードビジター
- E-25: `src/Symfony/Bridge/Twig/Translation/TwigExtractor.php` - Twig翻訳エクストラクター
- E-26: `src/Symfony/Bridge/Twig/Form/TwigRendererEngine.php` - Twigレンダラエンジン
- E-27: `src/Symfony/Bridge/Twig/Validator/Constraints/Twig.php` - Twig制約定義
- E-28: `src/Symfony/Bridge/Twig/Validator/Constraints/TwigValidator.php` - Twigバリデータ
- E-29: `src/Symfony/Bridge/Twig/EventListener/TemplateAttributeListener.php` - テンプレート属性リスナー
- E-30: `src/Symfony/Bridge/Twig/Attribute/Template.php` - Template属性クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-TWG-001~007) | AppVariableのセッターメソッドが正しく動作する | E-01 | ○ |
| C-02 (UT-TWG-008~010) | getToken()がtokenStorage状態に応じて正しく動作する | E-01 | ○ |
| C-03 (UT-TWG-011~013) | getUser()がtokenStorage状態に応じて正しく動作する | E-01 | ○ |
| C-04 (UT-TWG-014~016) | getRequest()がrequestStack状態に応じて正しく動作する | E-01 | ○ |
| C-05 (UT-TWG-017~020) | getSession()がrequestStack・セッション状態に応じて正しく動作する | E-01 | ○ |
| C-06 (UT-TWG-021~028) | getEnvironment/getDebug/getLocale/getEnabled_localesが未設定時に例外をスローする | E-01 | ○ |
| C-07 (UT-TWG-029~035) | getFlashes()がタイプ指定に応じて正しくフラッシュメッセージを返す | E-01 | ○ |
| C-08 (UT-TWG-036~041) | getCurrent_route/getCurrent_route_parametersが正しく動作する | E-01 | ○ |
| C-09 (UT-TWG-042~046) | UndefinedCallableHandlerが未定義フィルタ/関数を正しく処理する | E-02 | ○ |
| C-10 (UT-TWG-047~058) | TwigDataCollectorがプロファイルデータを正しく収集・返却する | E-03 | ○ |
| C-11 (UT-TWG-059~067) | TwigErrorRendererがデバッグモード・テンプレート有無に応じてエラーをレンダリングする | E-04 | ○ |
| C-12 (UT-TWG-068~079) | TranslationExtensionが翻訳処理を正しく実行する | E-05 | ○ |
| C-13 (UT-TWG-080~081) | HttpFoundationExtensionがURL生成を正しく委譲する | E-06 | ○ |
| C-14 (UT-TWG-082~088) | RoutingExtensionがパス/URL生成とセーフティチェックを正しく行う | E-07 | ○ |
| C-15 (UT-TWG-089~101) | SecurityExtensionが認可チェック・偽装URL生成を正しく行う | E-08 | ○ |
| C-16 (UT-TWG-102) | CsrfRuntimeがCSRFトークンを正しく返却する | E-10 | ○ |
| C-17 (UT-TWG-103~107) | HttpKernelRuntimeがフラグメントレンダリングを正しく委譲する | E-11 | ○ |
| C-18 (UT-TWG-108~111) | SerializerRuntime/ImportMapRuntimeがシリアライズ/インポートマップを正しく委譲する | E-12, E-13 | ○ |
| C-19 (UT-TWG-112~114) | AssetExtensionがアセットURL/バージョン取得を正しく委譲する | E-14 | ○ |
| C-20 (UT-TWG-115~123) | WorkflowExtensionがワークフロー操作を正しく委譲する | E-09 | ○ |
| C-21 (UT-TWG-124~125) | LogoutUrlExtensionがログアウトURL/パスを正しく委譲する | E-15 | ○ |
| C-22 (UT-TWG-126~132) | WebLinkExtensionがリンクヘッダを正しく追加する | E-16 | ○ |
| C-23 (UT-TWG-133~134) | HtmlSanitizerExtensionがHTMLサニタイズを正しく委譲する | E-17 | ○ |
| C-24 (UT-TWG-135~143) | TemplatedEmailがテンプレート・ロケール・コンテキスト管理とシリアライズを正しく行う | E-18 | ○ |
| C-25 (UT-TWG-144~149) | BodyRendererがメール本文レンダリングを正しく行う | E-19 | ○ |
| C-26 (UT-TWG-150~164) | NotificationEmailが通知メール機能と後方互換デシリアライズを正しく行う | E-20 | ○ |
| C-27 (UT-TWG-165~171) | WrappedTemplatedEmailがメール操作を正しく委譲する | E-21 | ○ |
| C-28 (UT-TWG-172~182) | Scopeがスコープ管理（enter/leave/set/has/get）を正しく行う | E-22 | ○ |
| C-29 (UT-TWG-183~190) | TranslationNodeVisitorが翻訳メッセージを正しく抽出する | E-23 | ○ |
| C-30 (UT-TWG-191~196) | TranslationDefaultDomainNodeVisitorがデフォルトドメイン処理を正しく行う | E-24 | ○ |
| C-31 (UT-TWG-197~202) | TwigExtractorが翻訳メッセージ抽出を正しく行う | E-25 | ○ |
| C-32 (UT-TWG-203~206) | TwigRendererEngineがフォームブロックレンダリングとリソースキャッシュを正しく行う | E-26 | △ |
| C-33 (UT-TWG-207~214) | TwigValidatorがTwigテンプレートのバリデーションを正しく行う | E-27, E-28 | ○ |
| C-34 (UT-TWG-215~223) | TemplateAttributeListenerがテンプレート属性に基づくレスポンス生成を正しく行う | E-29 | △ |
| C-35 (UT-TWG-224~225) | Template属性がコンストラクタパラメータを正しく保持する | E-30 | ○ |
| C-36 | TwigRendererEngineのloadResourcesFromThemeのテーマ継承処理 | E-26 | △ |
| C-37 | TranslationNodeVisitorのConcatBinary連結メッセージ抽出 | E-23 | △ |
| C-38 | NotificationEmailのasPublicEmail静的メソッド | E-20 | △ |
| C-39 | TemplateAttributeListenerのControllerArgumentsMetadata分岐 | E-29 | △ |
| C-40 | UndefinedCallableHandlerのFullStack/InstalledVersions分岐メッセージ | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- **TwigRendererEngineの内部メソッドloadResourcesFromTheme**：Twigのテンプレート継承チェーンの動作確認にはTwig Environment統合テストが必要。単体テストではモックの限界がある。
  - 候補：統合テスト / Twigのテンプレート階層を再現したテスト環境
- **TemplateAttributeListenerのControllerArgumentsMetadata**：`class_exists(ControllerArgumentsMetadata::class, false)`による分岐の完全なテストにはHttpKernelの特定バージョンへの依存確認が必要。
  - 候補：HttpKernel統合テスト / バージョン別テスト
- **NotificationEmailのコンストラクタ**：CssInlinerExtension/InkyExtensionの存在チェックのテストは、これらのパッケージが実際にインストールされている環境とされていない環境の両方が必要。
  - 候補：requireDev設定の確認 / コンテナ分離テスト
- **TranslationNodeVisitorのConcatBinary処理**：再帰的な連結ノード解析のテストケースは、Twigのノード構造を詳細に再現する必要がある。
  - 候補：Twigコンパイラ出力の確認 / ノード構造のフィクスチャ
- **UndefinedCallableHandlerのonUndefined内部メソッド**：FullStackクラスの存在有無やInstalledVersionsの状態に依存するメッセージ生成分岐。
  - 候補：クラスローダーの操作 / 環境別テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AppVariable、Scope、Attribute/Template、各Extension（委譲パターン）のテストケース
- 1: 中リスク - BodyRenderer、NotificationEmail、TwigValidator（複雑な状態管理を含む）のテストケース
- 2: 高リスク - TwigRendererEngineのloadResourceForBlockName再帰処理、TemplateAttributeListenerのControllerArgumentsMetadata分岐処理のテストケース

## 6) レビュアーチェックリスト（最小）
- [ ] AppVariableの各getter未設定時RuntimeExceptionのテストケース（UT-TWG-010, 013, 016, 020, 022, 024, 026, 028）が漏れなくカバーされているか
- [ ] SecurityExtensionのisGranted/isGrantedForUserの認可チェック（UT-TWG-089~095）がセキュリティ要件を満たしているか
- [ ] TranslationExtension::trans()の型チェック（UT-TWG-076, 077）が正しい条件を検証しているか
- [ ] BodyRenderer::render()のemailキー予約チェック（UT-TWG-149）が正しく検証されているか
- [ ] TwigValidatorのバリデーション後Loader復元（UT-TWG-214）が確実にテストされているか
- [ ] TwigRendererEngineのloadResourceForBlockNameの再帰・継承テスト（UT-TWG-204~206）の粒度が十分か
- [ ] TemplateAttributeListenerのstream/block/FormInterface変換（UT-TWG-217~222）のテストケースが網羅的か
- [ ] NotificationEmailの後方互換デシリアライズ（UT-TWG-162~164）が実際のデータ構造と整合しているか
