---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：Bundle-DebugBundle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **UT-DEB-048**：Commandクラス不存在時の挙動はclass_exists()による分岐であり、実行環境依存のため直接根拠を確認しづらい
  2. **UT-DEB-049**：ServerLogCommandクラス不存在時の挙動も同様に実行環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/DebugBundle/DebugBundle.php` - メインバンドルクラス（boot/build/registerCommands）
- E-02: `src/Symfony/Bundle/DebugBundle/Command/ServerDumpPlaceholderCommand.php` - プレースホルダコマンド
- E-03: `src/Symfony/Bundle/DebugBundle/DependencyInjection/Configuration.php` - 設定構造定義
- E-04: `src/Symfony/Bundle/DebugBundle/DependencyInjection/Compiler/DumpDataCollectorPass.php` - コンパイラパス
- E-05: `src/Symfony/Bundle/DebugBundle/DependencyInjection/DebugExtension.php` - DI拡張
- E-06: `src/Symfony/Bundle/DebugBundle/Resources/config/services.php` - サービス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kernel.debugがtrueの場合にVarDumperハンドラが設定される | E-01 (L27-48) | ○ |
| C-02 | ハンドラ内でclonerとdumperがコンテナから取得される | E-01 (L36-37) | ○ |
| C-03 | ラベル付きdumpが正しく処理される | E-01 (L40-42) | ○ |
| C-04 | ラベルがnullの場合withContextが呼ばれない | E-01 (L40-42) | ○ |
| C-05 | kernel.debugがfalseの場合VarDumperハンドラが設定されない | E-01 (L27) | ○ |
| C-06 | 2回目以降のdump呼び出しで最適化されたハンドラが使用される | E-01 (L46-47) | ○ |
| C-07 | DumpDataCollectorPassがコンパイラパスとして追加される | E-01 (L56) | ○ |
| C-08 | 親クラスのbuild()が呼ばれる | E-01 (L54) | ○ |
| C-09 | registerCommandsがnoopである | E-01 (L59-62) | ○ |
| C-10 | コンストラクタでServerDumpCommandが内部的に作成される | E-02 (L36) | ○ |
| C-11 | DumpServerがリフレクションで引数なしに生成される | E-02 (L36) | ○ |
| C-12 | parent::__construct()が呼ばれる | E-02 (L38) | ○ |
| C-13 | 定義がreplacedCommandから正しくコピーされる | E-02 (L43-45) | ○ |
| C-14 | 警告メッセージが出力される | E-02 (L50) | ○ |
| C-15 | 戻り値が8である | E-02 (L52) | ○ |
| C-16 | TreeBuilderが'debug'ルートノードで生成される | E-03 (L26) | ○ |
| C-17 | max_itemsのデフォルト値が2500 | E-03 (L35) | ○ |
| C-18 | min_depthのデフォルト値が1 | E-03 (L40) | ○ |
| C-19 | max_string_lengthのデフォルト値が-1 | E-03 (L45) | ○ |
| C-20 | dump_destinationのデフォルト値がnull | E-03 (L50) | ○ |
| C-21 | themeのデフォルト値が'dark' | E-03 (L56) | ○ |
| C-22 | max_itemsの最小値が-1 | E-03 (L34) | ○ |
| C-23 | max_itemsが-2の場合にバリデーションエラー | E-03 (L34) | ○ |
| C-24 | min_depthの最小値が0 | E-03 (L39) | ○ |
| C-25 | min_depthが-1の場合にバリデーションエラー | E-03 (L39) | ○ |
| C-26 | max_string_lengthの最小値が-1 | E-03 (L44) | ○ |
| C-27 | max_string_lengthが-2の場合にバリデーションエラー | E-03 (L44) | ○ |
| C-28 | themeに'light'を設定できる | E-03 (L55) | ○ |
| C-29 | themeに不正な値でエラー | E-03 (L55) | ○ |
| C-30 | data_collector.dump未定義で即座にreturn | E-04 (L28-30) | ○ |
| C-31 | .virtual_request_stack未定義でrequest_stackに置換 | E-04 (L34-36) | ○ |
| C-32 | .virtual_request_stack定義済みで引数変更なし | E-04 (L34-36) | ○ |
| C-33 | web_profiler.debug_toolbar.mode未設定で第3引数null | E-04 (L38-40) | ○ |
| C-34 | ツールバーDISABLEDで第3引数null | E-04 (L38-40) | ○ |
| C-35 | ツールバー有効時に第3引数がnullにならない | E-04 (L38-40) | ○ |
| C-36 | services.phpが読み込まれる | E-05 (L34-35) | ○ |
| C-37 | max_items設定がclonerに反映 | E-05 (L38) | ○ |
| C-38 | min_depth設定がclonerに反映 | E-05 (L39) | ○ |
| C-39 | max_string_length設定がclonerに反映 | E-05 (L40) | ○ |
| C-40 | ReflectionCaster::UNSET_CLOSURE_FILE_INFOが追加 | E-05 (L41) | ○ |
| C-41 | theme='dark'でsetTheme未呼び出し | E-05 (L43) | ○ |
| C-42 | theme='light'でsetTheme呼び出し | E-05 (L43-46) | ○ |
| C-43 | dump_destination=nullでPlaceholderCommand設定 | E-05 (L48-51) | ○ |
| C-44 | dump_destination=tcp://でサーバー接続設定 | E-05 (L52-64) | ○ |
| C-45 | dump_destination=ファイルパスでcli_dumper設定 | E-05 (L65-75) | ○ |
| C-46 | ファイルパス時にPlaceholderCommand設定 | E-05 (L72-74) | ○ |
| C-47 | cli_dumperにfileLinkFormat設定 | E-05 (L77-81) | ○ |
| C-48 | Commandクラス不存在でmonolog定義削除 | E-05 (L83-85) | △ |
| C-49 | ServerLogCommand不存在でmonolog定義削除 | E-05 (L83-85) | △ |
| C-50 | カスタム設定値の反映 | E-05 (L37-41) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-48, C-49: `class_exists()` による分岐は実行環境に依存するため、テスト実行時にクラスの存在をモック/制御する方法に関する根拠が不足
  - 候補：既存テストコードの確認 / PHPUnitのクラスモック機能 / autoloader操作

## 5) リスクフラグ（レビュー観点）
- 0 (低リスク): 全体的にコードが小規模（6ファイル）で見通しが良い。ソースコードから直接テストケースを導出可能
- 0 (低リスク): Configuration.phpの設定ノード定義はSymfonyの標準パターンに従っており、テスト観点が明確
- 1 (中リスク): DebugBundle.boot()の遅延読み込みパターンはクロージャのネストが深く、テスト実装が複雑になる可能性がある
- 1 (中リスク): class_exists()による条件分岐のテストは環境依存の制御が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのpublicメソッドに対してテストケースが網羅されているか確認
- [ ] Configuration.phpの各設定ノードに対して正常系/異常系/境界値が網羅されているか確認
- [ ] DumpDataCollectorPass.process()の条件分岐が全パターン網羅されているか確認
- [ ] DebugExtension.load()のdump_destinationの3分岐（null/tcp/その他）が網羅されているか確認
- [ ] テストIDの連番に欠番がないか確認
- [ ] services.phpはサービス定義ファイルであり、テスト対象外として適切か確認
