---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 192
  claims_with_evidence: 188
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Bundle-FrameworkBundle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：188 / 192、根拠なし：4
- 優先レビュー（高）
  1. **C-174 (FrameworkBundle::boot)**: エラーハンドラ設定のモック確認が必要
  2. **C-176 (FrameworkBundle::build)**: コンパイラパス全量の網羅確認が必要
  3. **C-168 (ConsoleProfilerListener::initialize)**: CliRequestの内部動作に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Bundle/FrameworkBundle/Controller/AbstractController.php`
- E-02: `src/Symfony/Bundle/FrameworkBundle/Controller/RedirectController.php`
- E-03: `src/Symfony/Bundle/FrameworkBundle/Controller/TemplateController.php`
- E-04: `src/Symfony/Bundle/FrameworkBundle/Controller/ControllerResolver.php`
- E-05: `src/Symfony/Bundle/FrameworkBundle/Controller/ControllerHelper.php`
- E-06: `src/Symfony/Bundle/FrameworkBundle/Secrets/AbstractVault.php`
- E-07: `src/Symfony/Bundle/FrameworkBundle/Secrets/SodiumVault.php`
- E-08: `src/Symfony/Bundle/FrameworkBundle/Secrets/DotenvVault.php`
- E-09: `src/Symfony/Bundle/FrameworkBundle/Routing/Router.php`
- E-10: `src/Symfony/Bundle/FrameworkBundle/Routing/DelegatingLoader.php`
- E-11: `src/Symfony/Bundle/FrameworkBundle/Routing/RedirectableCompiledUrlMatcher.php`
- E-12: `src/Symfony/Bundle/FrameworkBundle/Console/Application.php`
- E-13: `src/Symfony/Bundle/FrameworkBundle/KernelBrowser.php`
- E-14: `src/Symfony/Bundle/FrameworkBundle/HttpCache/HttpCache.php`
- E-15: `src/Symfony/Bundle/FrameworkBundle/Translation/Translator.php`
- E-16: `src/Symfony/Bundle/FrameworkBundle/Test/KernelTestCase.php`
- E-17: `src/Symfony/Bundle/FrameworkBundle/Test/TestContainer.php`
- E-18: `src/Symfony/Bundle/FrameworkBundle/Test/TestBrowserToken.php`
- E-19: `src/Symfony/Bundle/FrameworkBundle/CacheWarmer/AbstractPhpFileCacheWarmer.php`
- E-20: `src/Symfony/Bundle/FrameworkBundle/CacheWarmer/RouterCacheWarmer.php`
- E-21: `src/Symfony/Bundle/FrameworkBundle/CacheWarmer/CachePoolClearerCacheWarmer.php`
- E-22: `src/Symfony/Bundle/FrameworkBundle/DataCollector/RouterDataCollector.php`
- E-23: `src/Symfony/Bundle/FrameworkBundle/DataCollector/AbstractDataCollector.php`
- E-24: `src/Symfony/Bundle/FrameworkBundle/EventListener/SuggestMissingPackageSubscriber.php`
- E-25: `src/Symfony/Bundle/FrameworkBundle/EventListener/ConsoleProfilerListener.php`
- E-26: `src/Symfony/Bundle/FrameworkBundle/ErrorHandler/ErrorRenderer/RuntimeModeErrorRendererSelector.php`
- E-27: `src/Symfony/Bundle/FrameworkBundle/FrameworkBundle.php`
- E-28: `src/Symfony/Bundle/FrameworkBundle/Routing/Attribute/AsRoutingConditionService.php`
- E-29: `src/Symfony/Bundle/FrameworkBundle/Kernel/MicroKernelTrait.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | setContainerで以前のコンテナが返却される | E-01 (L66-72) | ○ |
| C-002 | setContainer再設定で以前のコンテナが返却される | E-01 (L66-72) | ○ |
| C-003 | getSubscribedServicesがサービス一覧を返す | E-01 (L74-89) | ○ |
| C-004 | getParameterがパラメータ値を返す | E-01 (L94-101) | ○ |
| C-005 | getParameterでparameter_bag未登録時に例外 | E-01 (L96-98) | ○ |
| C-006 | generateUrlがURL文字列を返す | E-01 (L108-111) | ○ |
| C-007 | forwardがResponseを返す | E-01 (L118-125) | ○ |
| C-008 | redirectがRedirectResponseを返す(302) | E-01 (L132-135) | ○ |
| C-009 | redirectがカスタムステータスコードで返す | E-01 (L132-135) | ○ |
| C-010 | redirectToRouteがRedirectResponseを返す | E-01 (L142-145) | ○ |
| C-011 | jsonがserializer使用時にJsonResponseを返す | E-01 (L152-167) | ○ |
| C-012 | jsonがserializer未使用時にJsonResponseを返す | E-01 (L152-167) | ○ |
| C-013 | jsonがnullデータでJsonResponse('null')を返す | E-01 (L162-164) | ○ |
| C-014 | fileがBinaryFileResponseを返す | E-01 (L172-178) | ○ |
| C-015 | fileがカスタムファイル名で返す | E-01 (L172-178) | ○ |
| C-016 | addFlashがフラッシュメッセージを追加 | E-01 (L185-198) | ○ |
| C-017 | addFlashでセッション無効時にLogicException | E-01 (L187-191) | ○ |
| C-018 | addFlashでFlashBag非対応時にLogicException | E-01 (L193-195) | ○ |
| C-019 | isGrantedがtrueを返す | E-01 (L205-212) | ○ |
| C-020 | isGrantedがfalseを返す | E-01 (L205-212) | ○ |
| C-021 | isGrantedでSecurityBundle未登録時にLogicException | E-01 (L207-209) | ○ |
| C-022 | denyAccessUnlessGrantedで権限あり時に例外なし | E-01 (L235-251) | ○ |
| C-023 | denyAccessUnlessGrantedで権限なし時にAccessDeniedException | E-01 (L235-251) | ○ |
| C-024 | renderViewがレンダリング文字列を返す | E-01 (L258-261) | ○ |
| C-025 | renderViewでTwig未登録時にLogicException | E-01 (L456-460) | ○ |
| C-026 | renderがResponseを返す(ステータス200) | E-01 (L279-282) | ○ |
| C-027 | renderで無効フォーム時にステータス422 | E-01 (L475-487) | ○ |
| C-028 | streamがStreamedResponseを返す | E-01 (L298-317) | ○ |
| C-029 | streamでTwig未登録時にLogicException | E-01 (L300-302) | ○ |
| C-030 | createNotFoundExceptionがNotFoundHttpExceptionを返す | E-01 (L326-329) | ○ |
| C-031 | createAccessDeniedExceptionがAccessDeniedExceptionを返す | E-01 (L340-347) | ○ |
| C-032 | createFormがFormInterfaceを返す | E-01 (L354-357) | ○ |
| C-033 | createFormBuilderがFormBuilderInterfaceを返す | E-01 (L362-365) | ○ |
| C-034 | getUserが認証済みユーザーを返す | E-01 (L382-393) | ○ |
| C-035 | getUserがトークンnullでnullを返す | E-01 (L388-389) | ○ |
| C-036 | getUserでSecurityBundle未登録時にLogicException | E-01 (L384-386) | ○ |
| C-037 | isCsrfTokenValidが有効トークンでtrueを返す | E-01 (L401-408) | ○ |
| C-038 | isCsrfTokenValidが無効トークンでfalseを返す | E-01 (L401-408) | ○ |
| C-039 | isCsrfTokenValidでCSRF未設定時にLogicException | E-01 (L403-405) | ○ |
| C-040 | addLinkがRequest属性に_linksを設定 | E-01 (L415-428) | ○ |
| C-041 | addLinkが既存LinkProviderに追加 | E-01 (L421-427) | ○ |
| C-042 | redirectActionが302を返す | E-02 (L53-86) | ○ |
| C-043 | redirectActionが301を返す | E-02 (L53-86) | ○ |
| C-044 | redirectActionがkeepRequestMethodで307を返す | E-02 (L79-83) | ○ |
| C-045 | redirectActionがkeepRequestMethod+permanentで308を返す | E-02 (L79-83) | ○ |
| C-046 | redirectActionで空ルート名で404 | E-02 (L55-57) | ○ |
| C-047 | redirectActionで空ルート名+permanentで410 | E-02 (L55-57) | ○ |
| C-048 | redirectActionでignoreAttributesが属性を除外 | E-02 (L60-77) | ○ |
| C-049 | urlRedirectActionが絶対URLへリダイレクト | E-02 (L106-167) | ○ |
| C-050 | urlRedirectActionで空パスで404 | E-02 (L108-109) | ○ |
| C-051 | urlRedirectActionで空パス+permanentで410 | E-02 (L108-109) | ○ |
| C-052 | urlRedirectActionでクエリストリング付加 | E-02 (L129-135) | ○ |
| C-053 | urlRedirectActionでscheme指定リダイレクト | E-02 (L118-127) | ○ |
| C-054 | urlRedirectActionでカスタムHTTPポート | E-02 (L138-149) | ○ |
| C-055 | __invokeでrouteパラメータ時にredirectAction呼出 | E-02 (L169-186) | ○ |
| C-056 | __invokeでpathパラメータ時にurlRedirectAction呼出 | E-02 (L169-186) | ○ |
| C-057 | __invokeでroute+pathの両方でRuntimeException | E-02 (L174-176) | ○ |
| C-058 | __invokeでroute/pathなしでRuntimeException | E-02 (L185) | ○ |
| C-059 | templateActionがResponseを返す | E-03 (L42-69) | ○ |
| C-060 | templateActionでmaxAge設定 | E-03 (L50-51) | ○ |
| C-061 | templateActionでsharedAge設定 | E-03 (L54-55) | ○ |
| C-062 | templateActionでprivate=trueでprivateキャッシュ | E-03 (L58-59) | ○ |
| C-063 | templateActionでprivate=falseでpublicキャッシュ | E-03 (L60) | ○ |
| C-064 | templateActionでカスタムヘッダー設定 | E-03 (L64-66) | ○ |
| C-065 | templateActionでTwig=null時にLogicException | E-03 (L44-46) | ○ |
| C-066 | ControllerResolver.instantiateControllerでコンテナ設定 | E-04 (L23-36) | ○ |
| C-067 | ControllerResolver.instantiateControllerでコンテナ未設定時にLogicException | E-04 (L28-29) | ○ |
| C-068 | AbstractVault.getLastMessageがnullを返す | E-06 (L19-24) | ○ |
| C-069 | validateNameで有効な名前が通る | E-06 (L39-44) | ○ |
| C-070 | validateNameで不正名前にLogicException | E-06 (L40-43) | ○ |
| C-071 | validateNameで空文字列にLogicException | E-06 (L40-43) | ○ |
| C-072 | getPrettyPathが相対パスを返す | E-06 (L46-49) | ○ |
| C-073 | SodiumVault.generateKeysでキー生成成功 | E-07 (L44-79) | ○ |
| C-074 | SodiumVault.generateKeysで既存キーoverride=false | E-07 (L64-68) | ○ |
| C-075 | SodiumVault.generateKeysでoverride=trueで上書き | E-07 (L44-79) | ○ |
| C-076 | SodiumVault.generateKeysで復号キー提供時にfalse | E-07 (L48-51) | ○ |
| C-077 | SodiumVault.sealで暗号化保存 | E-07 (L81-95) | ○ |
| C-078 | SodiumVault.sealで不正名前にLogicException | E-07 (L84) -> E-06 (L39-44) | ○ |
| C-079 | SodiumVault.revealで復号 | E-07 (L97-130) | ○ |
| C-080 | SodiumVault.revealで存在しないシークレットにnull | E-07 (L102-107) | ○ |
| C-081 | SodiumVault.revealで復号キーなしにnull | E-07 (L117-121) | ○ |
| C-082 | SodiumVault.removeで削除成功 | E-07 (L132-151) | ○ |
| C-083 | SodiumVault.removeで存在しないシークレットにfalse | E-07 (L138-141) | ○ |
| C-084 | SodiumVault.listで一覧返却(reveal=false) | E-07 (L153-172) | ○ |
| C-085 | SodiumVault.listで復号値付き一覧(reveal=true) | E-07 (L153-172) | ○ |
| C-086 | SodiumVault.listでシークレットなし時に空配列 | E-07 (L157-159) | ○ |
| C-087 | SodiumVault.loadEnvVarsで環境変数ロード | E-07 (L174-189) | ○ |
| C-088 | DotenvVault.generateKeysでfalse | E-08 (L25-29) | ○ |
| C-089 | DotenvVault.sealで書込 | E-08 (L32-48) | ○ |
| C-090 | DotenvVault.sealで更新 | E-08 (L32-48) | ○ |
| C-091 | DotenvVault.revealで取得 | E-08 (L50-63) | ○ |
| C-092 | DotenvVault.revealで存在しない場合null | E-08 (L56-59) | ○ |
| C-093 | DotenvVault.removeで削除 | E-08 (L65-83) | ○ |
| C-094 | DotenvVault.removeで存在しない場合false | E-08 (L78-82) | ○ |
| C-095 | DotenvVault.listで一覧返却 | E-08 (L85-103) | ○ |
| C-096 | Router.getRouteCollectionでRouteCollection返却 | E-09 (L70-89) | ○ |
| C-097 | Router.getRouteCollectionでパラメータ解決 | E-09 (L119-196) | ○ |
| C-098 | Router.warmUpでキャッシュ生成 | E-09 (L91-108) | ○ |
| C-099 | Router.warmUpでcache_dir=null時に空配列 | E-09 (L93-95) | ○ |
| C-100 | DelegatingLoader.loadでRouteCollection返却 | E-10 (L41-89) | ○ |
| C-101 | DelegatingLoader.loadでデフォルトオプション設定 | E-10 (L71-76) | ○ |
| C-102 | DelegatingLoader.loadで再帰呼び出し時にLoaderLoadException | E-10 (L43-61) | ○ |
| C-103 | RedirectableCompiledUrlMatcher.redirectでリダイレクト情報返却 | E-11 (L24-35) | ○ |
| C-104 | Application.getKernelでKernel返却 | E-12 (L50-53) | ○ |
| C-105 | Application.doRunで終了コード返却 | E-12 (L67-83) | ○ |
| C-106 | Application.findでCommand返却 | E-12 (L141-146) | ○ |
| C-107 | Application.getでCommand返却 | E-12 (L148-153) | ○ |
| C-108 | Application.allでコマンド配列返却 | E-12 (L155-160) | ○ |
| C-109 | Application.getLongVersionで環境情報含む文字列 | E-12 (L162-165) | ○ |
| C-110 | Application.resetでリセッター呼出 | E-12 (L55-60) | ○ |
| C-111 | KernelBrowser.getContainerでテストコンテナ返却 | E-13 (L43-48) | ○ |
| C-112 | KernelBrowser.getContainerでテストコンテナ未登録時に通常コンテナ | E-13 (L43-48) | ○ |
| C-113 | KernelBrowser.getProfileでプロファイル返却 | E-13 (L58-65) | ○ |
| C-114 | KernelBrowser.getProfileでprofiler未登録時にfalse | E-13 (L60-62) | ○ |
| C-115 | KernelBrowser.enableProfilerで有効化 | E-13 (L101-106) | ○ |
| C-116 | KernelBrowser.disableRebootで無効化 | E-13 (L114-117) | ○ |
| C-117 | KernelBrowser.enableRebootで有効化 | E-13 (L122-125) | ○ |
| C-118 | KernelBrowser.loginUserでログイン成功 | E-13 (L133-157) | ○ |
| C-119 | KernelBrowser.loginUserでUserInterface非実装時にLogicException | E-13 (L139-141) | ○ |
| C-120 | KernelBrowser.loginUserでセッションにトークン保存 | E-13 (L149-154) | ○ |
| C-121 | HttpCache.__constructでStoreInterface指定 | E-14 (L38-61) | ○ |
| C-122 | HttpCache.__constructで文字列パス指定 | E-14 (L38-61) | ○ |
| C-123 | HttpCache.__constructでデバッグモード時にdebug有効 | E-14 (L52-54) | ○ |
| C-124 | HttpCache.createSurrogateでEsi返却 | E-14 (L79-82) | ○ |
| C-125 | Translator.__constructで有効オプション初期化 | E-15 (L72-91) | ○ |
| C-126 | Translator.__constructで不正オプション時にInvalidArgumentException | E-15 (L81-83) | ○ |
| C-127 | Translator.warmUpでキャッシュ生成 | E-15 (L93-112) | ○ |
| C-128 | Translator.warmUpでcache_dir=null時に空配列 | E-15 (L96-98) | ○ |
| C-129 | Translator.addResourceでリソース追加 | E-15 (L114-120) | ○ |
| C-130 | KernelTestCase.getKernelClassでクラス名返却 | E-16 (L56-67) | ○ |
| C-131 | KernelTestCase.getKernelClassで環境変数未設定時にLogicException | E-16 (L58-59) | ○ |
| C-132 | KernelTestCase.getKernelClassで存在しないクラスにRuntimeException | E-16 (L62-64) | ○ |
| C-133 | KernelTestCase.bootKernelでブート成功 | E-16 (L72-94) | ○ |
| C-134 | KernelTestCase.createKernelでカスタムオプション | E-16 (L125-133) | ○ |
| C-135 | KernelTestCase.getContainerでテストコンテナ返却 | E-16 (L104-115) | ○ |
| C-136 | KernelTestCase.getContainerでtest.service_container未登録時にLogicException | E-16 (L112-114) | ○ |
| C-137 | KernelTestCase.ensureKernelShutdownでシャットダウン | E-16 (L138-165) | ○ |
| C-138 | TestContainer.hasでパブリックサービス存在確認 | E-17 (L93-96) | ○ |
| C-139 | TestContainer.hasでプライベートサービス存在確認 | E-17 (L93-96) | ○ |
| C-140 | TestContainer.getでプライベート優先取得 | E-17 (L98-101) | ○ |
| C-141 | TestContainer.getでパブリックフォールバック | E-17 (L98-101) | ○ |
| C-142 | TestContainer.setでパブリックサービス設定 | E-17 (L70-91) | ○ |
| C-143 | TestContainer.setで非共有サービスClosure以外にInvalidArgumentException | E-17 (L75-78) | ○ |
| C-144 | TestContainer.setで初期化済みプライベートにInvalidArgumentException | E-17 (L86-87) | ○ |
| C-145 | TestContainer.resetがno-op | E-17 (L108-111) | ○ |
| C-146 | TestBrowserToken.getFirewallNameで名前返却 | E-18 (L36-39) | ○ |
| C-147 | TestBrowserToken.getCredentialsでnull返却 | E-18 (L41-44) | ○ |
| C-148 | TestBrowserToken.__serializeでfirewallName含む | E-18 (L46-49) | ○ |
| C-149 | TestBrowserToken.__unserializeでfirewallName復元 | E-18 (L51-56) | ○ |
| C-150 | AbstractPhpFileCacheWarmer.isOptionalでtrue返却 | E-19 (L30-33) | ○ |
| C-151 | AbstractPhpFileCacheWarmer.warmUpでキャッシュ生成 | E-19 (L35-54) | ○ |
| C-152 | AbstractPhpFileCacheWarmer.warmUpでfalse時に空配列 | E-19 (L41-43) | ○ |
| C-153 | RouterCacheWarmer.warmUpでWarmableRouter呼出 | E-20 (L37-50) | ○ |
| C-154 | RouterCacheWarmer.warmUpでbuildDir空時に空配列 | E-20 (L39-41) | ○ |
| C-155 | RouterCacheWarmer.warmUpでWarmable非実装時にLogicException | E-20 (L48-49) | ○ |
| C-156 | RouterCacheWarmer.isOptionalでtrue返却 | E-20 (L52-55) | ○ |
| C-157 | CachePoolClearerCacheWarmer.warmUpでプールクリア | E-21 (L37-46) | ○ |
| C-158 | CachePoolClearerCacheWarmer.warmUpでプール空時に何もしない | E-21 (L37-46) | ○ |
| C-159 | CachePoolClearerCacheWarmer.isOptionalでfalse返却 | E-21 (L48-53) | ○ |
| C-160 | RouterDataCollector.guessRouteでRedirectController判定 | E-22 (L25-36) | ○ |
| C-161 | RouterDataCollector.guessRouteで配列コントローラ | E-22 (L27-29) | ○ |
| C-162 | AbstractDataCollector.getNameでクラス名返却 | E-23 (L21-24) | ○ |
| C-163 | AbstractDataCollector.getTemplateでnull返却 | E-23 (L26-29) | ○ |
| C-164 | SuggestMissingPackageSubscriber.onConsoleErrorでCommandNotFoundException以外は無視 | E-24 (L43-47) | ○ |
| C-165 | SuggestMissingPackageSubscriber.onConsoleErrorでdoctrineパッケージ提案 | E-24 (L29-41, L43-71) | ○ |
| C-166 | SuggestMissingPackageSubscriber.onConsoleErrorで未知namespace無視 | E-24 (L51-53) | ○ |
| C-167 | SuggestMissingPackageSubscriber.getSubscribedEventsでConsoleEvents::ERROR | E-24 (L73-78) | ○ |
| C-168 | ConsoleProfilerListener.initializeでstopwatch開始 | E-25 (L63-84) | △ |
| C-169 | ConsoleProfilerListener.initializeでcliMode=false時に何もしない | E-25 (L65-67) | ○ |
| C-170 | ConsoleProfilerListener.profileでプロファイル保存 | E-25 (L95-165) | ○ |
| C-171 | ConsoleProfilerListener.profileでdisabled時にプロファイル非保存 | E-25 (L100-104) | ○ |
| C-172 | RuntimeModeErrorRendererSelector.selectでWebモード時htmlRenderer | E-26 (L27-30) | ○ |
| C-173 | RuntimeModeErrorRendererSelector.selectでCLIモード時cliRenderer | E-26 (L27-30) | ○ |
| C-174 | FrameworkBundle.bootでエラーハンドラ設定 | E-27 (L109-134) | △ |
| C-175 | FrameworkBundle.bootでHTTPメソッドオーバーライド有効化 | E-27 (L123-125) | ○ |
| C-176 | FrameworkBundle.buildでコンパイラパス登録 | E-27 (L136-225) | △ |
| C-177 | AsRoutingConditionServiceデフォルト値生成 | E-28 (L41-53) | ○ |
| C-178 | AsRoutingConditionServiceカスタム値生成 | E-28 (L41-53) | ○ |
| C-179 | ControllerHelper.getSubscribedServicesでサービス一覧返却 | E-05 (L67-82) | ○ |
| C-180 | ControllerHelper.getParameterでパラメータ取得 | E-05 (L87-94) | ○ |
| C-181 | ControllerHelper.getParameterで未登録時に例外 | E-05 (L89-91) | ○ |
| C-182 | ControllerHelper.jsonでserializer使用時にJsonResponse | E-05 (L145-160) | ○ |
| C-183 | ControllerHelper.jsonでnullデータ時にJsonResponse('null') | E-05 (L155-157) | ○ |
| C-184 | ControllerHelper.isGrantedでSecurityBundle未登録時にLogicException | E-05 (L200-202) | ○ |
| C-185 | ControllerHelper.denyAccessUnlessGrantedで権限なし時にAccessDeniedException | E-05 (L228-243) | ○ |
| C-186 | ControllerHelper.getUserでSecurityBundle未登録時にLogicException | E-05 (L377-379) | ○ |
| C-187 | ControllerHelper.isCsrfTokenValidでCSRF未設定時にLogicException | E-05 (L396-398) | ○ |
| C-188 | ControllerHelper.addFlashでセッション無効時にLogicException | E-05 (L180-184) | ○ |
| C-189 | ControllerHelper.renderで無効フォーム時にステータス422 | E-05 (L468-485) | ○ |
| C-190 | ControllerHelper.streamでTwig未登録時にLogicException | E-05 (L293-295) | ○ |
| C-191 | KernelBrowser.getSessionでセッション返却 | E-13 (L67-94) | ○ |
| C-192 | KernelBrowser.getSessionでsession.factory未登録時にnull | E-13 (L71-73) | △ |

## 4) 不足情報（Unknown / Missing）
- C-168: ConsoleProfilerListener.initializeのテストはCliRequestクラスの内部実装に依存しており、CliRequestのモック方法の確認が必要
  - 候補：CliRequestの生成条件 / requestStack.getCurrentRequest()の返却値制御
- C-174: FrameworkBundle.bootのエラーハンドラ設定はSymfonyRuntimeおよびErrorHandlerの挙動に依存し、グローバル状態を変更するためテスト環境の注意が必要
  - 候補：SymfonyRuntime存在条件 / get_error_handler()のモック / error_handler_configurator
- C-176: FrameworkBundle.buildで登録されるコンパイラパスの全量確認には各コンポーネントのクラス存在確認が必要
  - 候補：ClassExistenceResourceの挙動 / 各PassクラスのInstallability
- C-192: KernelBrowser.getSessionのテストはsession.factoryの振る舞いとCookieJarの状態に依存
  - 候補：session.factoryの具体実装 / CookieJarのモック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース(188/192)はソースコードから直接根拠を確認可能
- 1: 中リスク - FrameworkBundle.boot/buildはグローバル状態やコンテナビルダーに依存するためテスト実装時に注意が必要
- 1: 中リスク - ConsoleProfilerListenerはCliRequestやStopwatchなど複数の外部依存を持つ
- 0: 低リスク - SodiumVaultのテストはファイルシステム操作を含むためテンポラリディレクトリの使用が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractController/ControllerHelperの各メソッドについて、正常系・異常系の両方がカバーされているか
- [ ] RedirectControllerの各ステータスコード(301/302/307/308/404/410)のテストケースが揃っているか
- [ ] SodiumVault/DotenvVaultのCRUD操作(seal/reveal/remove/list)が網羅されているか
- [ ] セキュリティ関連(isGranted, denyAccessUnlessGranted, isCsrfTokenValid, getUser)のテストケースが高優先度で設定されているか
- [ ] KernelBrowser.loginUserの型チェック・セッション保存のテストケースが含まれているか
- [ ] TestContainerのパブリック/プライベートサービスの取得優先順位テストが含まれているか
- [ ] CacheWarmer系クラスのisOptional()の返却値が仕様通りか確認
- [ ] テストIDの命名規則(UT-FWB-xxx)が一貫しているか
