---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 172
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Bundle-SecurityBundle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：172 / 180、根拠なし：8
- 優先レビュー（高）
  1. **SecurityExtension の統合的な load メソッド テスト**：多数のサービス定義ロードを含む大規模メソッドのため、個別条件分岐の網羅性に不確実性あり
  2. **SecurityDataCollector のプロファイルトークンCookie設定テスト**：Cookie設定ロジックの条件分岐が複雑で、一部の境界条件が未カバーの可能性
  3. **CompilerPass の DI コンテナ操作テスト**：ContainerBuilder のモック構成が複雑で、実際のテスト実装時に追加ケースが必要になる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bundle/SecurityBundle/Security.php` - Securityクラス定義（getUser, isGranted, login, logout, getAuthenticator）
- E-02: `src/Symfony/Bundle/SecurityBundle/SecurityBundle.php` - SecurityBundleクラス定義（build メソッド）
- E-03: `src/Symfony/Bundle/SecurityBundle/Security/FirewallConfig.php` - FirewallConfigクラス定義（全getter）
- E-04: `src/Symfony/Bundle/SecurityBundle/Security/FirewallContext.php` - FirewallContextクラス定義（getConfig, getListeners, getExceptionListener, getLogoutListener）
- E-05: `src/Symfony/Bundle/SecurityBundle/Security/FirewallMap.php` - FirewallMapクラス定義（getListeners, getFirewallConfig, getFirewallContext）
- E-06: `src/Symfony/Bundle/SecurityBundle/Security/LazyFirewallContext.php` - LazyFirewallContextクラス定義（getListeners, supports, authenticate, getPriority）
- E-07: `src/Symfony/Bundle/SecurityBundle/Security/UserAuthenticator.php` - UserAuthenticatorクラス定義（authenticateUser）
- E-08: `src/Symfony/Bundle/SecurityBundle/Security/FirewallAwareTrait.php` - FirewallAwareTrait定義（getForFirewall）
- E-09: `src/Symfony/Bundle/SecurityBundle/DataCollector/SecurityDataCollector.php` - SecurityDataCollectorクラス定義（collect, reset, lateCollect, 各getter）
- E-10: `src/Symfony/Bundle/SecurityBundle/Command/DebugFirewallCommand.php` - DebugFirewallCommandクラス定義（execute, formatCallable, complete）
- E-11: `src/Symfony/Bundle/SecurityBundle/Command/SecurityRoleHierarchyDumpCommand.php` - SecurityRoleHierarchyDumpCommandクラス定義（execute）
- E-12: `src/Symfony/Bundle/SecurityBundle/CacheWarmer/ExpressionCacheWarmer.php` - ExpressionCacheWarmerクラス定義（isOptional, warmUp）
- E-13: `src/Symfony/Bundle/SecurityBundle/EventListener/FirewallListener.php` - FirewallListenerクラス定義（configureLogoutUrlGenerator, onKernelFinishRequest, getSubscribedEvents）
- E-14: `src/Symfony/Bundle/SecurityBundle/EventListener/VoteListener.php` - VoteListenerクラス定義（onVoterVote, getSubscribedEvents）
- E-15: `src/Symfony/Bundle/SecurityBundle/Debug/TraceableFirewallListener.php` - TraceableFirewallListenerクラス定義（getWrappedListeners, getAuthenticatorsInfo, reset, callListeners）
- E-16: `src/Symfony/Bundle/SecurityBundle/Debug/WrappedLazyListener.php` - WrappedLazyListenerクラス定義（supports, authenticate, getInfo, __call）
- E-17: `src/Symfony/Bundle/SecurityBundle/LoginLink/FirewallAwareLoginLinkHandler.php` - FirewallAwareLoginLinkHandlerクラス定義（createLoginLink, consumeLoginLink）
- E-18: `src/Symfony/Bundle/SecurityBundle/RememberMe/DecoratedRememberMeHandler.php` - DecoratedRememberMeHandlerクラス定義（createRememberMeCookie, consumeRememberMeCookie, clearRememberMeCookie）
- E-19: `src/Symfony/Bundle/SecurityBundle/RememberMe/FirewallAwareRememberMeHandler.php` - FirewallAwareRememberMeHandlerクラス定義（createRememberMeCookie, consumeRememberMeCookie, clearRememberMeCookie）
- E-20: `src/Symfony/Bundle/SecurityBundle/Routing/LogoutRouteLoader.php` - LogoutRouteLoaderクラス定義（__invoke）
- E-21: `src/Symfony/Bundle/SecurityBundle/DependencyInjection/SecurityExtension.php` - SecurityExtensionクラス定義（load, addAuthenticatorFactory, addUserProviderFactory, createStrategyDefinition, isValidIp, isValidIps, getSortedFactories, createRoleHierarchy, createLogoutUrisParameter, prepend）
- E-22: `src/Symfony/Bundle/SecurityBundle/DependencyInjection/Compiler/AddSecurityVotersPass.php` - AddSecurityVotersPassクラス定義（process）
- E-23: `src/Symfony/Bundle/SecurityBundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php` - AddSessionDomainConstraintPassクラス定義（process）
- E-24: `src/Symfony/Bundle/SecurityBundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php` - RegisterCsrfFeaturesPassクラス定義（process, registerCsrfProtectionListener, registerLogoutHandler）
- E-25: `src/Symfony/Bundle/SecurityBundle/DependencyInjection/Compiler/SortFirewallListenersPass.php` - SortFirewallListenersPassクラス定義（process, sortFirewallContextListeners, getListenerPriorities）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Security::getUser - 認証済みトークン存在時にUserInterfaceが返る | E-01 (L50-57) | ○ |
| C-02 | Security::getUser - トークン未存在時にnullが返る | E-01 (L50-57) | ○ |
| C-03 | Security::isGranted - 権限付与時にtrueが返る | E-01 (L62-66) | ○ |
| C-04 | Security::isGranted - 権限未付与時にfalseが返る | E-01 (L62-66) | ○ |
| C-05 | Security::isGranted - subject付き委譲 | E-01 (L62-66) | ○ |
| C-06 | Security::getAccessDecision - AccessDecision返却 | E-01 (L68-74) | ○ |
| C-07 | Security::isGrantedForUser - ユーザー指定認可チェック | E-01 (L81-85) | ○ |
| C-08 | Security::getAccessDecisionForUser - ユーザー指定AccessDecision | E-01 (L87-93) | ○ |
| C-09 | Security::getToken - トークン存在時の返却 | E-01 (L95-98) | ○ |
| C-10 | Security::getToken - トークン未存在時のnull | E-01 (L95-98) | ○ |
| C-11 | Security::getFirewallConfig - 設定返却 | E-01 (L100-103) | ○ |
| C-12 | Security::getFirewallConfig - 対象外時のnull | E-01 (L100-103) | ○ |
| C-13 | Security::login - 正常ログイン | E-01 (L114-133) | ○ |
| C-14 | Security::login - リクエスト未存在エラー | E-01 (L117-119) | ○ |
| C-15 | Security::login - ファイアウォール未特定エラー | E-01 (L121-125) | ○ |
| C-16 | Security::login - authenticator指定ログイン | E-01 (L127) | ○ |
| C-17 | Security::login - バッジ付きログイン | E-01 (L132) | ○ |
| C-18 | Security::logout - 正常ログアウト | E-01 (L144-178) | ○ |
| C-19 | Security::logout - リクエスト未存在エラー | E-01 (L146-149) | ○ |
| C-20 | Security::logout - 未認証エラー | E-01 (L154-156) | ○ |
| C-21 | Security::logout - ファイアウォール外エラー | E-01 (L158-159) | ○ |
| C-22 | Security::logout - CSRFトークン無効エラー | E-01 (L167-169) | ○ |
| C-23 | Security::logout - CSRFスキップ | E-01 (L162) | ○ |
| C-24 | Security::getAuthenticator - authenticator未存在エラー | E-01 (L182-183) | ○ |
| C-25 | Security::getAuthenticator - 名前不一致エラー | E-01 (L207-208) | ○ |
| C-26 | Security::getAuthenticator - 自動選択 | E-01 (L189-198) | ○ |
| C-27 | Security::getAuthenticator - 複数存在時エラー | E-01 (L194-195) | ○ |
| C-28 | FirewallConfig::getName | E-03 (L36-38) | ○ |
| C-29 | FirewallConfig::getRequestMatcher - null | E-03 (L45-48) | ○ |
| C-30 | FirewallConfig::getRequestMatcher - 値あり | E-03 (L45-48) | ○ |
| C-31 | FirewallConfig::isSecurityEnabled - デフォルト | E-03 (L50-53) | ○ |
| C-32 | FirewallConfig::isStateless | E-03 (L55-58) | ○ |
| C-33 | FirewallConfig::getProvider | E-03 (L60-63) | ○ |
| C-34 | FirewallConfig::getContext | E-03 (L68-71) | ○ |
| C-35 | FirewallConfig::getEntryPoint | E-03 (L73-76) | ○ |
| C-36 | FirewallConfig::getUserChecker | E-03 (L78-81) | ○ |
| C-37 | FirewallConfig::getAccessDeniedHandler | E-03 (L83-86) | ○ |
| C-38 | FirewallConfig::getAccessDeniedUrl | E-03 (L88-91) | ○ |
| C-39 | FirewallConfig::getAuthenticators - 値あり | E-03 (L93-96) | ○ |
| C-40 | FirewallConfig::getAuthenticators - 空配列 | E-03 (L93-96) | ○ |
| C-41 | FirewallConfig::getSwitchUser | E-03 (L98-101) | ○ |
| C-42 | FirewallConfig::getLogout | E-03 (L103-106) | ○ |
| C-43 | FirewallContext::getConfig - 値あり | E-04 (L37-39) | ○ |
| C-44 | FirewallContext::getConfig - null | E-04 (L37-39) | ○ |
| C-45 | FirewallContext::getListeners | E-04 (L44-48) | ○ |
| C-46 | FirewallContext::getExceptionListener - 値あり | E-04 (L50-53) | ○ |
| C-47 | FirewallContext::getExceptionListener - null | E-04 (L50-53) | ○ |
| C-48 | FirewallContext::getLogoutListener | E-04 (L55-58) | ○ |
| C-49 | FirewallMap::getListeners - マッチ | E-05 (L33-42) | ○ |
| C-50 | FirewallMap::getListeners - 不一致 | E-05 (L33-42) | ○ |
| C-51 | FirewallMap::getFirewallConfig - マッチ | E-05 (L44-47) | ○ |
| C-52 | FirewallMap::getFirewallConfig - 不一致 | E-05 (L44-47) | ○ |
| C-53 | FirewallMap::getFirewallContext - キャッシュ | E-05 (L51-56) | ○ |
| C-54 | FirewallMap::getFirewallContext - 無効キャッシュ | E-05 (L51-60) | ○ |
| C-55 | FirewallMap::getFirewallContext - ワイルドカード | E-05 (L63) | ○ |
| C-56 | LazyFirewallContext::getListeners | E-06 (L39-42) | ○ |
| C-57 | LazyFirewallContext::supports | E-06 (L44-47) | ○ |
| C-58 | LazyFirewallContext::authenticate - 遅延 | E-06 (L49-79) | ○ |
| C-59 | LazyFirewallContext::authenticate - 即時 | E-06 (L49-79) | ○ |
| C-60 | LazyFirewallContext::authenticate - スキップ | E-06 (L56) | ○ |
| C-61 | LazyFirewallContext::authenticate - 早期リターン | E-06 (L66-68) | ○ |
| C-62 | LazyFirewallContext::getPriority | E-06 (L82-85) | ○ |
| C-63 | UserAuthenticator::authenticateUser - 正常委譲 | E-07 (L41-44), E-08 | ○ |
| C-64 | UserAuthenticator::authenticateUser - リクエスト未存在 | E-08 (L34-35) | ○ |
| C-65 | FirewallAwareTrait::getForFirewall - 正常 | E-08 (L31-53) | ○ |
| C-66 | FirewallAwareTrait::getForFirewall - リクエスト未存在 | E-08 (L34-35) | ○ |
| C-67 | FirewallAwareTrait::getForFirewall - ファイアウォール未発見 | E-08 (L39-41) | ○ |
| C-68 | FirewallAwareTrait::getForFirewall - サービス未登録 | E-08 (L44-51) | ○ |
| C-69 | SecurityDataCollector::collect - 無効状態 | E-09 (L55-69) | ○ |
| C-70 | SecurityDataCollector::collect - 未認証状態 | E-09 (L70-84) | ○ |
| C-71 | SecurityDataCollector::collect - 認証済み | E-09 (L85-126) | ○ |
| C-72 | SecurityDataCollector::collect - SwitchUserToken | E-09 (L90-93) | ○ |
| C-73 | SecurityDataCollector::collect - ロール階層 | E-09 (L95-101) | ○ |
| C-74 | SecurityDataCollector::collect - Voter情報 | E-09 (L129-164) | ○ |
| C-75 | SecurityDataCollector::collect - ファイアウォール情報 | E-09 (L167-194) | ○ |
| C-76 | SecurityDataCollector::collect - exit path | E-09 (L186-192) | ○ |
| C-77 | SecurityDataCollector::reset | E-09 (L226-229) | ○ |
| C-78 | SecurityDataCollector::lateCollect | E-09 (L231-234) | ○ |
| C-79 | SecurityDataCollector::isEnabled | E-09 (L239-242) | ○ |
| C-80 | SecurityDataCollector::getUser | E-09 (L247-250) | ○ |
| C-81 | SecurityDataCollector::getRoles | E-09 (L255-258) | ○ |
| C-82 | SecurityDataCollector::getName | E-09 (L378-381) | ○ |
| C-83 | FirewallListener::configureLogoutUrlGenerator - メインリクエスト | E-13 (L36-45) | ○ |
| C-84 | FirewallListener::configureLogoutUrlGenerator - サブリクエスト | E-13 (L38-39) | ○ |
| C-85 | FirewallListener::onKernelFinishRequest | E-13 (L47-54) | ○ |
| C-86 | FirewallListener::getSubscribedEvents | E-13 (L56-65) | ○ |
| C-87 | VoteListener::onVoterVote | E-14 (L32-34) | ○ |
| C-88 | VoteListener::getSubscribedEvents | E-14 (L36-39) | ○ |
| C-89 | TraceableFirewallListener::getWrappedListeners - 値あり | E-15 (L31-37) | ○ |
| C-90 | TraceableFirewallListener::getWrappedListeners - 空 | E-15 (L31-37) | ○ |
| C-91 | TraceableFirewallListener::getAuthenticatorsInfo - 値あり | E-15 (L39-42) | ○ |
| C-92 | TraceableFirewallListener::getAuthenticatorsInfo - null | E-15 (L39-42) | ○ |
| C-93 | TraceableFirewallListener::reset | E-15 (L44-48) | ○ |
| C-94 | TraceableFirewallListener::callListeners - LazyFirewallContextラップ | E-15 (L50-81) | ○ |
| C-95 | TraceableFirewallListener::callListeners - 通常リスナーラップ | E-15 (L72-80) | ○ |
| C-96 | TraceableFirewallListener::callListeners - supports=false スキップ | E-15 (L84-86) | ○ |
| C-97 | TraceableFirewallListener::callListeners - レスポンスセット時早期リターン | E-15 (L90-92) | ○ |
| C-98 | WrappedLazyListener::supports | E-16 (L42-45) | ○ |
| C-99 | WrappedLazyListener::authenticate - 正常＋時間計測 | E-16 (L47-62) | ○ |
| C-100 | WrappedLazyListener::authenticate - LazyResponseException | E-16 (L53-56) | ○ |
| C-101 | WrappedLazyListener::authenticate - レスポンス記録 | E-16 (L61) | ○ |
| C-102 | WrappedLazyListener::getInfo | E-16 (L64-71) | ○ |
| C-103 | WrappedLazyListener::__call | E-16 (L76-79) | ○ |
| C-104 | ExpressionCacheWarmer::isOptional | E-12 (L29-31) | ○ |
| C-105 | ExpressionCacheWarmer::warmUp - 全式パース | E-12 (L33-40) | ○ |
| C-106 | ExpressionCacheWarmer::warmUp - 空式 | E-12 (L33-40) | ○ |
| C-107 | ExpressionCacheWarmer::warmUp - 変数名リスト | E-12 (L37) | ○ |
| C-108 | DebugFirewallCommand::execute - 一覧表示 | E-10 (L78-114) | ○ |
| C-109 | DebugFirewallCommand::execute - 詳細表示 | E-10 (L78-114) | ○ |
| C-110 | DebugFirewallCommand::execute - 不正名 | E-10 (L92-96) | ○ |
| C-111 | DebugFirewallCommand::execute - --eventsオプション | E-10 (L107-109) | ○ |
| C-112 | DebugFirewallCommand::complete | E-10 (L264-269) | ○ |
| C-113 | DebugFirewallCommand::formatCallable - 配列 | E-10 (L222-228) | ○ |
| C-114 | DebugFirewallCommand::formatCallable - 文字列 | E-10 (L230-232) | ○ |
| C-115 | DebugFirewallCommand::formatCallable - Closure | E-10 (L234-244) | ○ |
| C-116 | DebugFirewallCommand::formatCallable - 未知 | E-10 (L250) | ○ |
| C-117 | SecurityRoleHierarchyDumpCommand::execute - 正常 | E-11 (L61-79) | ○ |
| C-118 | SecurityRoleHierarchyDumpCommand::execute - 不正direction | E-11 (L66-69) | ○ |
| C-119 | SecurityRoleHierarchyDumpCommand::execute - デフォルトdirection | E-11 (L47) | ○ |
| C-120 | FirewallAwareLoginLinkHandler::createLoginLink | E-17 (L41-44) | ○ |
| C-121 | FirewallAwareLoginLinkHandler::consumeLoginLink | E-17 (L46-49) | ○ |
| C-122 | FirewallAwareLoginLinkHandler::createLoginLink - login_link未設定エラー | E-17, E-08 (L44-51) | ○ |
| C-123 | DecoratedRememberMeHandler::createRememberMeCookie | E-18 (L32-35) | ○ |
| C-124 | DecoratedRememberMeHandler::consumeRememberMeCookie | E-18 (L37-40) | ○ |
| C-125 | DecoratedRememberMeHandler::clearRememberMeCookie | E-18 (L42-45) | ○ |
| C-126 | FirewallAwareRememberMeHandler::createRememberMeCookie | E-19 (L40-43) | ○ |
| C-127 | FirewallAwareRememberMeHandler::consumeRememberMeCookie | E-19 (L45-48) | ○ |
| C-128 | FirewallAwareRememberMeHandler::clearRememberMeCookie | E-19 (L50-53) | ○ |
| C-129 | FirewallAwareRememberMeHandler - remember_me未設定エラー | E-19, E-08 (L44-51) | ○ |
| C-130 | LogoutRouteLoader::__invoke - ルート生成 | E-20 (L31-48) | ○ |
| C-131 | LogoutRouteLoader::__invoke - 空URI | E-20 (L31-48) | ○ |
| C-132 | LogoutRouteLoader::__invoke - エイリアス | E-20 (L39-41) | ○ |
| C-133 | LogoutRouteLoader::__invoke - リソース追加 | E-20 (L33) | ○ |
| C-134 | SecurityBundle::build - AuthenticatorFactory登録 | E-02 (L61-85) | ○ |
| C-135 | SecurityBundle::build - UserProviderFactory登録 | E-02 (L87-88) | ○ |
| C-136 | SecurityBundle::build - CompilerPass登録 | E-02 (L89-109) | ○ |
| C-137 | SecurityExtension::load - 正常ロード | E-21 (L93-191) | ○ |
| C-138 | SecurityExtension::load - 空設定エラー | E-21 (L95-98) | ○ |
| C-139 | SecurityExtension::addAuthenticatorFactory | E-21 (L1029-1033) | ○ |
| C-140 | SecurityExtension::addUserProviderFactory | E-21 (L1035-1038) | ○ |
| C-141 | SecurityExtension::createStrategyDefinition - affirmative | E-21 (L196) | ○ |
| C-142 | SecurityExtension::createStrategyDefinition - consensus | E-21 (L197) | ○ |
| C-143 | SecurityExtension::createStrategyDefinition - unanimous | E-21 (L198) | ○ |
| C-144 | SecurityExtension::createStrategyDefinition - priority | E-21 (L199) | ○ |
| C-145 | SecurityExtension::createStrategyDefinition - 不正 | E-21 (L200) | ○ |
| C-146 | SecurityExtension::isValidIp - IPv4 | E-21 (L1063-1087) | ○ |
| C-147 | SecurityExtension::isValidIp - IPv6 | E-21 (L1063-1087) | ○ |
| C-148 | SecurityExtension::isValidIp - CIDR | E-21 (L1063-1087) | ○ |
| C-149 | SecurityExtension::isValidIp - 不正IP | E-21 (L1063-1087) | ○ |
| C-150 | SecurityExtension::isValidIp - IPv4 CIDR境界 | E-21 (L1079) | ○ |
| C-151 | SecurityExtension::isValidIp - IPv6 CIDR境界 | E-21 (L1083) | ○ |
| C-152 | SecurityExtension::isValidIps - 空配列 | E-21 (L1046-1061) | ○ |
| C-153 | SecurityExtension::isValidIps - カンマ区切り | E-21 (L1048) | ○ |
| C-154 | SecurityExtension::getSortedFactories - ソート | E-21 (L1092-1106) | ○ |
| C-155 | SecurityExtension::getSortedFactories - 安定ソート | E-21 (L1100) | ○ |
| C-156 | AddSecurityVotersPass::process - Voter登録 | E-22 (L33-71) | ○ |
| C-157 | AddSecurityVotersPass::process - Voter未存在エラー | E-22 (L41-42) | ○ |
| C-158 | AddSecurityVotersPass::process - インターフェース未実装 | E-22 (L53-54) | ○ |
| C-159 | AddSecurityVotersPass::process - debugモードラップ | E-22 (L57-63) | ○ |
| C-160 | AddSecurityVotersPass::process - decision_manager未存在 | E-22 (L35-37) | ○ |
| C-161 | AddSessionDomainConstraintPass::process - ドメイン制約 | E-23 (L24-44) | ○ |
| C-162 | AddSessionDomainConstraintPass::process - auto secure | E-23 (L33-39) | ○ |
| C-163 | AddSessionDomainConstraintPass::process - パラメータ未存在 | E-23 (L26-28) | ○ |
| C-164 | RegisterCsrfFeaturesPass::process - CSRFリスナー登録 | E-24 (L37-55) | ○ |
| C-165 | RegisterCsrfFeaturesPass::process - CSRFマネージャ未存在 | E-24 (L43-45) | ○ |
| C-166 | RegisterCsrfFeaturesPass::registerLogoutHandler | E-24 (L57-73) | ○ |
| C-167 | SortFirewallListenersPass::process - リスナーソート | E-25 (L29-38) | ○ |
| C-168 | SortFirewallListenersPass::process - パラメータ未存在 | E-25 (L31-33) | ○ |
| C-169 | SortFirewallListenersPass::process - クラス未発見エラー | E-25 (L64-66) | ○ |
| C-170 | SecurityExtension::createRoleHierarchy - 設定あり | E-21 (L204-214) | ○ |
| C-171 | SecurityExtension::createRoleHierarchy - 設定なし | E-21 (L206-208) | ○ |
| C-172 | SecurityExtension::getConfiguration | E-21 (L1040-1044) | ○ |
| C-173 | SecurityExtension::createLogoutUrisParameter - パラメータセット | E-21 (L1108-1122) | ○ |
| C-174 | SecurityExtension::createLogoutUrisParameter - 相対パス除外 | E-21 (L1116-1118) | ○ |
| C-175 | SecurityDataCollector::collect - 認証Cookie設定 | E-09 (L204-223) | ○ |
| C-176 | SecurityDataCollector::collect - 未認証Cookie設定 | E-09 (L217-222) | ○ |
| C-177 | SecurityDataCollector::getAuthProfileToken | E-09 (L368-371) | ○ |
| C-178 | SecurityDataCollector::getDeauthProfileToken | E-09 (L373-376) | ○ |
| C-179 | SecurityDataCollector::getAuthProfileToken - null | E-09 (L370) | ○ |
| C-180 | SecurityExtension::prepend - ファクトリーprepend | E-21 (L84-91) | ○ |

**根拠不足の項目（△）:**

以下の項目はソースコードの解析から推定したが、完全な確認が困難な部分を含む：

| Claim ID | 主張 | 状態 | 理由 |
|---|---|---|---|
| C-137 | SecurityExtension::load の統合テスト | △ | load()メソッドは非常に大規模で、内部で多数のprivateメソッドを呼び出すため、全分岐の網羅に不確実性がある |
| C-134 | SecurityBundle::build - 全ファクトリー登録 | △ | 登録されるファクトリーの完全なリストがバージョンにより変更される可能性 |
| C-136 | SecurityBundle::build - 全CompilerPass登録 | △ | CompilerPassの完全なリストとその登録順序・タイプが正確か要確認 |
| C-58 | LazyFirewallContext::authenticate - 遅延認証条件 | △ | isMethodCacheable()の挙動とsupports()=nullの組合せ条件が複雑 |
| C-94 | TraceableFirewallListener::callListeners - Closureバインド | △ | Closure::bindによるprivateプロパティアクセスの動作検証が必要 |
| C-162 | AddSessionDomainConstraintPass - auto secure | △ | 正規表現生成ロジックの全パターンを網羅的に検証することが困難 |
| C-175 | SecurityDataCollector - 認証Cookie条件 | △ | Cookie設定のstateless/listeners/auth状態の組合せ条件が複雑 |
| C-176 | SecurityDataCollector - 未認証Cookie条件 | △ | 上記と同様 |

## 4) 不足情報（Unknown / Missing）
- SecurityExtensionのcreateFirewalls/createFirewallメソッドは非常に大規模で多数の分岐を含むため、全てのパスを個別のテストケースとして列挙するには追加のコード解析が必要
  - 候補：MainConfiguration.php のスキーマ定義 / 各AuthenticatorFactory の createAuthenticator 実装 / 既存テストスイート
- DependencyInjection/Security/AccessToken/ 配下のTokenHandlerFactory群は設定ノード定義が主であり、単体テストの観点が限定的
  - 候補：OidcTokenHandlerFactory.php / CasTokenHandlerFactory.php / OAuth2TokenHandlerFactory.php
- DependencyInjection/Security/Factory/ 配下のAuthenticatorFactory群のcreateAuthenticator/addConfiguration メソッドは個別テスト対象となりうるが、DI統合テストの性質が強い
  - 候補：FormLoginFactory.php / HttpBasicFactory.php / AccessTokenFactory.php

## 5) リスクフラグ（レビュー観点）
- 0: FirewallConfig, FirewallContext, DecoratedRememberMeHandler - シンプルなデータオブジェクト/デリゲータで低リスク
- 1: SecurityDataCollector, DebugFirewallCommand - データ収集・表示ロジックで中リスク
- 2: Security::login/logout, SecurityExtension::load, AddSecurityVotersPass - セキュリティ関連の認証・認可・DI設定で高リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Security::login/logout のテストケースが全てのLogicException/LogoutExceptionの条件をカバーしているか
- [ ] FirewallAwareTrait::getForFirewall の全3つのエラーパスがカバーされているか
- [ ] SecurityExtension::createStrategyDefinition の全ストラテジー（affirmative, consensus, unanimous, priority, invalid）がカバーされているか
- [ ] AddSecurityVotersPass のVoterInterface未実装チェックが含まれているか
- [ ] isValidIp/isValidIps のIPv4/IPv6/CIDR境界値テストが含まれているか
- [ ] SecurityDataCollector::collect の各トークン状態（null, 通常, SwitchUserToken）がカバーされているか
- [ ] LazyFirewallContext::authenticate の遅延/即時認証の条件分岐が正確か
- [ ] CSVのNo列が1から180まで連番であること
