---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 123
  claims_with_evidence: 120
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：Bundle-TwigBundle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Bundle-TwigBundle.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：120 / 123、根拠なし：3
- 優先レビュー（高）
  1. **C-031 (UT-TWB-031)**：存在しないバンドル指定時の例外の具体的な型がソースから読み取れない（locateResource内部の実装依存）
  2. **C-078 (UT-TWB-078)**：normalizeBundleName に空文字列を渡した場合の挙動は推論に基づく（str_ends_withの空文字列挙動）
  3. **C-079 (UT-TWB-079)**：normalizeBundleName に 'Bundle' のみを渡した場合の挙動は推論に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bundle/TwigBundle/TwigBundle.php` - TwigBundleクラス（build, registerCommands メソッド）
- E-02: `src/Symfony/Bundle/TwigBundle/TemplateIterator.php` - TemplateIteratorクラス（getIterator, findTemplatesInDirectory メソッド）
- E-03: `src/Symfony/Bundle/TwigBundle/CacheWarmer/TemplateCacheWarmer.php` - TemplateCacheWarmerクラス（warmUp, isOptional, getSubscribedServices メソッド）
- E-04: `src/Symfony/Bundle/TwigBundle/Command/LintCommand.php` - LintCommandクラス（configure, findFiles メソッド）
- E-05: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Configuration.php` - Configurationクラス（getConfigTreeBuilder, 各addXxxSectionメソッド）
- E-06: `src/Symfony/Bundle/TwigBundle/DependencyInjection/TwigExtension.php` - TwigExtensionクラス（load, getBundleTemplatePaths, normalizeBundleName メソッド）
- E-07: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Configurator/EnvironmentConfigurator.php` - EnvironmentConfiguratorクラス（configure メソッド）
- E-08: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/ExtensionPass.php` - ExtensionPassクラス（process メソッド）
- E-09: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigLoaderPass.php` - TwigLoaderPassクラス（process メソッド）
- E-10: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/TwigEnvironmentPass.php` - TwigEnvironmentPassクラス（process メソッド）
- E-11: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/AttributeExtensionPass.php` - AttributeExtensionPassクラス（autoconfigureFromAttribute, process メソッド）
- E-12: `src/Symfony/Bundle/TwigBundle/DependencyInjection/Compiler/RuntimeLoaderPass.php` - RuntimeLoaderPassクラス（process メソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | TwigBundle.buildで5つのコンパイラパスが登録される | E-01 (L36-40) | ○ |
| C-002 | ExtensionPassがpriority 10でBEFORE_OPTIMIZATIONに登録される | E-01 (L36) | ○ |
| C-003 | RuntimeLoaderPassがTYPE_BEFORE_REMOVINGで登録される | E-01 (L40) | ○ |
| C-004 | registerCommandsがnoopである | E-01 (L43-46) | ○ |
| C-005 | TemplateIteratorコンストラクタの依存注入 | E-02 (L35-41) | ○ |
| C-006 | defaultPath設定時のテンプレート収集 | E-02 (L49) | ○ |
| C-007 | defaultPath=null時のバンドルテンプレートのみ | E-02 (L49) | ○ |
| C-008 | バンドル名末尾Bundle除去のnamespace | E-02 (L53-55) | ○ |
| C-009 | '!'プレフィックスnamespace登録 | E-02 (L68) | ○ |
| C-010 | 追加pathsのnamespace付き収集 | E-02 (L71-73) | ○ |
| C-011 | 2回目のgetIterator呼び出しでキャッシュ | E-02 (L45-47) | ○ |
| C-012 | 重複テンプレート除去 | E-02 (L75: array_unique) | ○ |
| C-013 | Resources/views優先 | E-02 (L57) | ○ |
| C-014 | templatesディレクトリ使用 | E-02 (L57) | ○ |
| C-015 | バンドル0件で空イテレータ | E-02 (L51, L75) | ○ |
| C-016 | 存在しないディレクトリで空配列 | E-02 (L85-87) | ○ |
| C-017 | defaultPath/bundlesオーバーライドテンプレート | E-02 (L60-61) | ○ |
| C-018 | bundlesディレクトリの除外 | E-02 (L49: excludeDirs=['bundles']) | ○ |
| C-019 | テンプレートキャッシュウォームアップ | E-03 (L42-81) | ○ |
| C-020 | NullCache時のスキップ | E-03 (L46-49) | ○ |
| C-021 | cache設定済み+buildDir=null時のスキップ | E-03 (L51-57) | ○ |
| C-022 | cache設定済み+buildDirあり時のキャッシュ差し替え | E-03 (L59) | ○ |
| C-023 | テンプレートエラー時のcatch | E-03 (L66) | ○ |
| C-024 | finally でキャッシュ復元 | E-03 (L77-79) | ○ |
| C-025 | twigのlazy-load | E-03 (L43) | ○ |
| C-026 | isOptionalがtrue | E-03 (L84-87) | ○ |
| C-027 | getSubscribedServicesの戻り値 | E-03 (L89-93) | ○ |
| C-028 | LintCommand configureのヘルプテキスト | E-04 (L27-41) | ○ |
| C-029 | '@'プレフィックス付きファイル名のlocateResource解決 | E-04 (L45-47) | ○ |
| C-030 | '@'なしファイル名の親クラス委譲 | E-04 (L49) | ○ |
| C-031 | 存在しないバンドル指定時のエラー | E-04 (L46) | △ |
| C-032 | TreeBuilder 'twig'ルートノード | E-05 (L31) | ○ |
| C-033 | form_themesデフォルト値 | E-05 (L53) | ○ |
| C-034 | form_themes自動追加 | E-05 (L56-57) | ○ |
| C-035 | globals '@'プレフィックスのサービス参照 | E-05 (L75-81) | ○ |
| C-036 | globals '@@'エスケープ | E-05 (L77-78) | ○ |
| C-037 | globalsスカラー値の正規化 | E-05 (L95) | ○ |
| C-038 | cacheデフォルトtrue | E-05 (L119) | ○ |
| C-039 | charsetデフォルト%kernel.charset% | E-05 (L120) | ○ |
| C-040 | debugデフォルト%kernel.debug% | E-05 (L121) | ○ |
| C-041 | dateフォーマットデフォルト値 | E-05 (L175-180) | ○ |
| C-042 | number_formatデフォルト値 | E-05 (L187-189) | ○ |
| C-043 | default_pathデフォルト値 | E-05 (L127) | ○ |
| C-044 | optimizations最小値-1 | E-05 (L124) | ○ |
| C-045 | globals type不正値エラー | E-05 (L100-103) | ○ |
| C-046 | paths XML形式正規化 | E-05 (L143-146) | ○ |
| C-047 | pathsキーが数値時namespace=null | E-05 (L149-152) | ○ |
| C-048 | mailer html_to_text_converterデフォルトnull | E-05 (L203) | ○ |
| C-049 | twig.phpのロード | E-06 (L46) | ○ |
| C-050 | form.phpの条件ロード | E-06 (L48-50) | ○ |
| C-051 | console.phpの条件ロード | E-06 (L52-54) | ○ |
| C-052 | translation.extractor削除 | E-06 (L56-58) | ○ |
| C-053 | validator.phpの条件ロード | E-06 (L60-62) | ○ |
| C-054 | mailer.phpの条件ロード | E-06 (L81-82) | ○ |
| C-055 | mailer html_to_text_converter設定 | E-06 (L84-86) | ○ |
| C-056 | importmap.phpの条件ロード | E-06 (L93-95) | ○ |
| C-057 | form_themesパラメータ設定 | E-06 (L97) | ○ |
| C-058 | EnvironmentConfigurator引数設定 | E-06 (L101-107) | ○ |
| C-059 | カスタムpathsのFilesystemLoader登録 | E-06 (L112-118) | ○ |
| C-060 | namespace無しパス登録 | E-06 (L113-114) | ○ |
| C-061 | バンドルテンプレートパス登録 | E-06 (L129-139) | ○ |
| C-062 | '!'プレフィックスnamespace登録 | E-06 (L137) | ○ |
| C-063 | defaultTwigPath存在時の追加 | E-06 (L141-143) | ○ |
| C-064 | globalsサービス型のReference設定 | E-06 (L149-150) | ○ |
| C-065 | globals値型の直接設定 | E-06 (L151) | ○ |
| C-066 | cache=true+auto_reloadのキャッシュディレクトリ | E-06 (L157-165) | ○ |
| C-067 | cache=trueのチェーンキャッシュReference | E-06 (L167-168) | ○ |
| C-068 | cache=false時のサービス削除 | E-06 (L170-176) | ○ |
| C-069 | cache=文字列パス時の処理 | E-06 (L170-179) | ○ |
| C-070 | autoescape_service設定時のcallable | E-06 (L182-183) | ○ |
| C-071 | autoescape_service未設定時のデフォルト | E-06 (L185-186) | ○ |
| C-072 | Twigオプションフィルタリング | E-06 (L188-196) | ○ |
| C-073 | インターフェース自動設定 | E-06 (L198-200) | ○ |
| C-074 | Twig属性自動設定 | E-06 (L202-204) | ○ |
| C-075 | globals key正規化 | E-06 (L64-75) | ○ |
| C-076 | normalizeBundleName Bundle除去 | E-06 (L227-234) | ○ |
| C-077 | normalizeBundleName非Bundle名 | E-06 (L229-230) | ○ |
| C-078 | normalizeBundleName空文字列 | E-06 (L229) | △ |
| C-079 | normalizeBundleName 'Bundle'のみ | E-06 (L229-231) | △ |
| C-080 | configure日付フォーマット設定 | E-07 (L37) | ○ |
| C-081 | configureタイムゾーン設定(値あり) | E-07 (L39-41) | ○ |
| C-082 | configureタイムゾーンnull時スキップ | E-07 (L39) | ○ |
| C-083 | configure数値フォーマット設定 | E-07 (L43) | ○ |
| C-084 | UndefinedFilterCallback登録 | E-07 (L46) | ○ |
| C-085 | UndefinedFunctionCallback登録 | E-07 (L47) | ○ |
| C-086 | Packages不在時のassets削除 | E-08 (L33-35) | ○ |
| C-087 | EmojiTransliterator不在時の削除 | E-08 (L37-39) | ○ |
| C-088 | Expression不在時の削除 | E-08 (L41-43) | ○ |
| C-089 | UrlGeneratorInterface不在時の削除 | E-08 (L45-47) | ○ |
| C-090 | Yaml不在時の削除 | E-08 (L49-51) | ○ |
| C-091 | asset_mapper未登録時のimportmap削除 | E-08 (L53-57) | ○ |
| C-092 | mailer有時のEmailパス登録 | E-08 (L64-69) | ○ |
| C-093 | form.extension有時のFormパス登録 | E-08 (L71-77) | ○ |
| C-094 | router有時のroutingタグ付与 | E-08 (L81-83) | ○ |
| C-095 | debug時のprofilerタグ付与 | E-08 (L104-105) | ○ |
| C-096 | debug時dump不在でdebugタグ付与 | E-08 (L108-110) | ○ |
| C-097 | filesystemエイリアス設定 | E-08 (L117) | ○ |
| C-098 | serializer有時のタグ付与 | E-08 (L145-148) | ○ |
| C-099 | Workflow有時のタグ付与 | E-08 (L139-143) | ○ |
| C-100 | Workflow不在時の定義削除 | E-08 (L139-140) | ○ |
| C-101 | TwigLoaderPass twig未定義時スキップ | E-09 (L28-29) | ○ |
| C-102 | ローダー0件時のLogicException | E-09 (L41-42) | ○ |
| C-103 | 単一ローダーのエイリアス | E-09 (L45-46) | ○ |
| C-104 | 複数ローダーのChainLoader | E-09 (L47-58) | ○ |
| C-105 | ローダーpriority順ソート | E-09 (L49) | ○ |
| C-106 | デフォルトpriority=0 | E-09 (L36) | ○ |
| C-107 | TwigEnvironmentPass twig未定義時スキップ | E-10 (L29-30) | ○ |
| C-108 | extensionタグ付きサービスの登録 | E-10 (L42-43) | ○ |
| C-109 | TwigBridge拡張の優先登録 | E-10 (L46-47, L54) | ○ |
| C-110 | 既存メソッドコールの順序 | E-10 (L54) | ○ |
| C-111 | extension0件時のメソッドコール不変 | E-10 (L53) | ○ |
| C-112 | autoconfigureFromAttribute正常系 | E-11 (L37-48) | ○ |
| C-113 | 非staticメソッドのruntimeタグ | E-11 (L50-52) | ○ |
| C-114 | staticメソッドのruntimeタグ無し | E-11 (L50) | ○ |
| C-115 | AbstractExtension継承時のLogicException | E-11 (L41-42) | ○ |
| C-116 | ExtensionInterface実装時のLogicException | E-11 (L43-44) | ○ |
| C-117 | タグ付きサービスのAttributeExtension登録 | E-11 (L56-61) | ○ |
| C-118 | AttributeExtensionへのtwig.extensionタグ | E-11 (L60) | ○ |
| C-119 | タグ付きサービス0件時の処理 | E-11 (L57) | ○ |
| C-120 | RuntimeLoaderPass runtime_loader未定義時スキップ | E-12 (L26-28) | ○ |
| C-121 | runtimeタグ付きサービスのServiceLocatorマッピング | E-12 (L30-37) | ○ |
| C-122 | runtimeタグ0件時の空ServiceLocator | E-12 (L31-37) | ○ |
| C-123 | マッピングキーがクラス名 | E-12 (L34) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-031: `LintCommand::findFiles` で `@NonExistentBundle` を渡した場合、`Kernel::locateResource()` は例外をスローする可能性が高いが、具体的な例外型はHttpKernelコンポーネントの実装に依存する
  - 候補：`\InvalidArgumentException` / `\RuntimeException` / `\Symfony\Component\HttpKernel\Exception\*`
- C-078: `normalizeBundleName('')` の挙動 - PHPの `str_ends_with('', 'Bundle')` は `false` を返すため空文字列がそのまま返されるが、テスト環境での動作確認が望ましい
  - 候補：PHPマニュアル / 実行時検証
- C-079: `normalizeBundleName('Bundle')` の挙動 - `str_ends_with('Bundle', 'Bundle')` は `true` で `substr('Bundle', 0, -6)` は `''` を返す推論だが、確認が望ましい
  - 候補：PHPマニュアル / 実行時検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードの構造が明確で、テストケースとの対応が取れている
- 0: 低リスク - TwigBundle は比較的小規模なモジュール（18ファイル）で解析範囲が明確
- 1: 中リスク - ExtensionPass.process() は多数のサービス存在チェック条件分岐を含み、組み合わせテストが必要になる場合がある
- 1: 中リスク - TwigExtension.load() は多くの条件分岐を含み、設定の組み合わせに対するテストケースが不足する可能性がある
- 0: 低リスク - Configuration クラスのバリデーションロジックは Symfony Config コンポーネントに委譲されており、テスト対象は設定値の定義のみ

## 6) レビュアーチェックリスト（最小）
- [ ] C-031 の `locateResource` 例外型を HttpKernel ソースで確認し、テストケースの期待結果を具体化する
- [ ] C-078, C-079 の境界値テストケースが実際の PHP 動作と一致するか確認する
- [ ] ExtensionPass.process() の条件分岐が全網羅されているか確認する（特にhtml_sanitizer, web_link, stopwatch等のサービス有無条件）
- [ ] TwigExtension.load() の cache=true かつ buildDir==cacheDir の場合の挙動テストが UT-TWB-066 でカバーされているか確認する
- [ ] Configuration の paths 正規化ロジックについて、XMLとYAML両方の入力パターンがカバーされているか確認する
- [ ] TemplateCacheWarmer.warmUp() の Twig\Error 以外の例外発生時のfinally動作が UT-TWB-024 で十分にカバーされているか確認する
