---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 153
  claims_with_evidence: 148
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：Bundle-WebProfilerBundle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 153、根拠なし：5
- 優先レビュー（高）
  1. **UT-WPB-025 (xdebugAction正常系)**：Xdebugのインストール状態に依存しテスト環境での動作確認が必要
  2. **UT-WPB-024 (phpinfoAction正常系)**：phpinfo()の実行結果に依存し環境差異の確認が必要
  3. **UT-WPB-067 (CodeExtension fileLinkFormatフォールバック)**：xdebug.file_link_format のini設定に依存
  4. **UT-WPB-088 (fileExcerpt srcContext負値)**：負値の挙動はコードから読み取れるが仕様書での明記なし
  5. **UT-WPB-150 (EventStreamResponse)**：EventStreamResponse/ServerEventの具体的な挙動は外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Bundle/WebProfilerBundle/Controller/ProfilerController.php` - プロファイラコントローラの全アクション定義
- E-02: `src/Symfony/Bundle/WebProfilerBundle/Controller/ExceptionPanelController.php` - 例外パネルコントローラ定義
- E-03: `src/Symfony/Bundle/WebProfilerBundle/Controller/RouterController.php` - ルーターコントローラ定義
- E-04: `src/Symfony/Bundle/WebProfilerBundle/Csp/NonceGenerator.php` - CSP nonce生成クラス
- E-05: `src/Symfony/Bundle/WebProfilerBundle/Csp/ContentSecurityPolicyHandler.php` - CSPヘッダ処理クラス
- E-06: `src/Symfony/Bundle/WebProfilerBundle/Profiler/TemplateManager.php` - テンプレート管理クラス
- E-07: `src/Symfony/Bundle/WebProfilerBundle/Profiler/CodeExtension.php` - コード表示用Twig拡張
- E-08: `src/Symfony/Bundle/WebProfilerBundle/Twig/WebProfilerExtension.php` - プロファイラ用Twig拡張
- E-09: `src/Symfony/Bundle/WebProfilerBundle/DependencyInjection/WebProfilerExtension.php` - DI拡張クラス
- E-10: `src/Symfony/Bundle/WebProfilerBundle/DependencyInjection/Configuration.php` - バンドル設定定義
- E-11: `src/Symfony/Bundle/WebProfilerBundle/WebProfilerBundle.php` - バンドルクラス
- E-12: `src/Symfony/Bundle/WebProfilerBundle/EventListener/WebDebugToolbarListener.php` - ツールバーイベントリスナー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-WPB-001: homeActionはプロファイラ検索結果ページへリダイレクトする | E-01 (L53-58) | ○ |
| C-02 | UT-WPB-002: profilerがnullの場合NotFoundHttpExceptionをスロー | E-01 (L410-417) | ○ |
| C-03 | UT-WPB-003: panelActionは指定トークンのパネルを表示する | E-01 (L65-117) | ○ |
| C-04 | UT-WPB-004: latestトークンで最新プロファイルを検索する | E-01 (L75-77) | ○ |
| C-05 | UT-WPB-005: プロファイル未検出時にinfo画面を表示 | E-01 (L79-81) | ○ |
| C-06 | UT-WPB-006: パネル未検出時にNotFoundHttpExceptionをスロー | E-01 (L101-103) | ○ |
| C-07 | UT-WPB-007: ExceptionDataCollectorが例外持ちならそのパネルを選択 | E-01 (L88-93) | ○ |
| C-08 | UT-WPB-008: DumpDataCollectorがダンプ持ちならそのパネルを選択 | E-01 (L95-98) | ○ |
| C-09 | UT-WPB-009: panelActionでprofilerがnullの場合の例外 | E-01 (L410-417) | ○ |
| C-10 | UT-WPB-010: toolbarActionで有効トークンのツールバー表示 | E-01 (L124-163) | ○ |
| C-11 | UT-WPB-011: emptyトークンで空レスポンス | E-01 (L137-139) | ○ |
| C-12 | UT-WPB-012: nullトークンで空レスポンス | E-01 (L137-139) | ○ |
| C-13 | UT-WPB-013: プロファイル未検出で404 | E-01 (L143-145) | ○ |
| C-14 | UT-WPB-014: toolbarActionでprofilerがnull | E-01 (L126-128) | ○ |
| C-15 | UT-WPB-015: AutoExpireFlashBagのフラッシュ保持 | E-01 (L130-135) | ○ |
| C-16 | UT-WPB-016: toolbarStylesheetActionでCSS返却 | E-01 (L170-184) | ○ |
| C-17 | UT-WPB-017: toolbarStylesheetActionでprofiler無効時の例外 | E-01 (L170-173) | ○ |
| C-18 | UT-WPB-018: searchBarAction正常表示 | E-01 (L191-218) | ○ |
| C-19 | UT-WPB-019: セッションからの検索パラメータ復元 | E-01 (L197-214) | ○ |
| C-20 | UT-WPB-020: searchResultsAction正常表示 | E-01 (L225-257) | ○ |
| C-21 | UT-WPB-021: searchActionでトークン指定時リダイレクト | E-01 (L292-294) | ○ |
| C-22 | UT-WPB-022: searchActionでトークン未指定時検索実行 | E-01 (L296-309) | ○ |
| C-23 | UT-WPB-023: セッションへの検索パラメータ保存 | E-01 (L278-290) | ○ |
| C-24 | UT-WPB-024: phpinfoAction正常表示 | E-01 (L316-327) | △ |
| C-25 | UT-WPB-025: xdebugAction正常表示 | E-01 (L334-349) | △ |
| C-26 | UT-WPB-026: xdebug未インストール時の例外 | E-01 (L338-340) | ○ |
| C-27 | UT-WPB-027: fontActionでJetBrainsMono返却 | E-01 (L356-371) | ○ |
| C-28 | UT-WPB-028: 不正フォント名での例外 | E-01 (L359-361) | ○ |
| C-29 | UT-WPB-029: openActionでファイル表示 | E-01 (L378-400) | ○ |
| C-30 | UT-WPB-030: baseDirがnullの場合の例外 | E-01 (L380-382) | ○ |
| C-31 | UT-WPB-031: ドットパスでのセキュリティ防止 | E-01 (L391-393) | ○ |
| C-32 | UT-WPB-032: パストラバーサル防止 | E-01 (L391-393) | ○ |
| C-33 | UT-WPB-033: TemplateManagerの遅延初期化 | E-01 (L402-405) | ○ |
| C-34 | UT-WPB-034: TemplateManagerのシングルトン | E-01 (L402-405) | ○ |
| C-35 | UT-WPB-035: ExceptionPanelController.body正常表示 | E-02 (L37-49) | ○ |
| C-36 | UT-WPB-036: ExceptionPanelController.bodyでprofiler無効時 | E-02 (L39-41) | ○ |
| C-37 | UT-WPB-037: stylesheet正常返却 | E-02 (L54-57) | ○ |
| C-38 | UT-WPB-038: RouterControllerでRouteCollection自動取得 | E-03 (L43-45) | ○ |
| C-39 | UT-WPB-039: RouterController.panelAction正常表示 | E-03 (L53-75) | ○ |
| C-40 | UT-WPB-040: RouterController.panelActionでprofiler無効時 | E-03 (L55-57) | ○ |
| C-41 | UT-WPB-041: matcher/routesがnullの場合 | E-03 (L61-63) | ○ |
| C-42 | UT-WPB-042: NonceGenerator.generateが32文字返却 | E-04 (L23-26) | ○ |
| C-43 | UT-WPB-043: NonceGenerator.generateのランダム性 | E-04 (L25) | ○ |
| C-44 | UT-WPB-044: リクエストヘッダからnonce取得 | E-05 (L43-48) | ○ |
| C-45 | UT-WPB-045: レスポンスヘッダからnonce取得 | E-05 (L50-55) | ○ |
| C-46 | UT-WPB-046: 新規nonce生成 | E-05 (L57-66) | ○ |
| C-47 | UT-WPB-047: CSP無効化フラグ | E-05 (L73-76) | ○ |
| C-48 | UT-WPB-048: CSP無効時のヘッダ除去 | E-05 (L85-89, L104-109) | ○ |
| C-49 | UT-WPB-049: CSP有効時のnonce追加 | E-05 (L114-167) | ○ |
| C-50 | UT-WPB-050: 一時ヘッダの削除 | E-05 (L98-102) | ○ |
| C-51 | UT-WPB-051: CSPヘッダなし時のスキップ | E-05 (L158-159) | ○ |
| C-52 | UT-WPB-052: default-srcフォールバック | E-05 (L235-243) | ○ |
| C-53 | UT-WPB-053: unsafe-inlineのみの場合スキップ | E-05 (L207-216) | ○ |
| C-54 | UT-WPB-054: unsafe-inlineとnonce共存時 | E-05 (L215, L218-233) | ○ |
| C-55 | UT-WPB-055: Report-Onlyヘッダ処理 | E-05 (L257-259) | ○ |
| C-56 | UT-WPB-056: X-Content-Security-Policy処理 | E-05 (L261-263) | ○ |
| C-57 | UT-WPB-057: default-src: 'none'のフォールバック | E-05 (L142-146) | ○ |
| C-58 | UT-WPB-058: elem系ディレクティブのフォールバック制限 | E-05 (L237) | ○ |
| C-59 | UT-WPB-059: TemplateManager.getName正常取得 | E-06 (L39-48) | ○ |
| C-60 | UT-WPB-060: TemplateManager.getNameパネル未検出 | E-06 (L43-45) | ○ |
| C-61 | UT-WPB-061: TemplateManager.getNames正常取得 | E-06 (L55-83) | ○ |
| C-62 | UT-WPB-062: null除外処理 | E-06 (L61-63) | ○ |
| C-63 | UT-WPB-063: 拡張子正規化 | E-06 (L71-73) | ○ |
| C-64 | UT-WPB-064: テンプレートファイル未検出例外 | E-06 (L75-77) | ○ |
| C-65 | UT-WPB-065: 未登録collector除外 | E-06 (L67-69) | ○ |
| C-66 | UT-WPB-066: CodeExtensionコンストラクタ(文字列) | E-07 (L30-37) | ○ |
| C-67 | UT-WPB-067: fileLinkFormatフォールバック | E-07 (L35) | △ |
| C-68 | UT-WPB-068: projectDirパス正規化 | E-07 (L36) | ○ |
| C-69 | UT-WPB-069: getFiltersの10フィルタ返却 | E-07 (L39-53) | ○ |
| C-70 | UT-WPB-070: abbrClassのFQCN短縮 | E-07 (L55-61) | ○ |
| C-71 | UT-WPB-071: 名前空間なしクラス名 | E-07 (L57-58) | ○ |
| C-72 | UT-WPB-072: abbrMethodのClass::method形式 | E-07 (L63-75) | ○ |
| C-73 | UT-WPB-073: Closure表示 | E-07 (L68-69) | ○ |
| C-74 | UT-WPB-074: 単純関数名表示 | E-07 (L70-71) | ○ |
| C-75 | UT-WPB-075: formatArgsのobject型 | E-07 (L84-88) | ○ |
| C-76 | UT-WPB-076: formatArgsのarray型 | E-07 (L89-90) | ○ |
| C-77 | UT-WPB-077: formatArgsのnull型 | E-07 (L91-92) | ○ |
| C-78 | UT-WPB-078: formatArgsのboolean型 | E-07 (L93-94) | ○ |
| C-79 | UT-WPB-079: formatArgsのresource型 | E-07 (L95-96) | ○ |
| C-80 | UT-WPB-080: バイナリ文字列表示 | E-07 (L97-98) | ○ |
| C-81 | UT-WPB-081: 名前付き引数表示 | E-07 (L103) | ○ |
| C-82 | UT-WPB-082: 空引数配列 | E-07 (L106) | ○ |
| C-83 | UT-WPB-083: formatArgsAsTextのHTMLタグ除去 | E-07 (L112-115) | ○ |
| C-84 | UT-WPB-084: fileExcerpt正常取得 | E-07 (L120-168) | ○ |
| C-85 | UT-WPB-085: fileExcerptファイル未検出 | E-07 (L122-124) | ○ |
| C-86 | UT-WPB-086: fileExcerptファイル読み取り不可 | E-07 (L122-124) | ○ |
| C-87 | UT-WPB-087: 非PHPファイル処理 | E-07 (L128-140) | ○ |
| C-88 | UT-WPB-088: srcContext負値で全行表示 | E-07 (L131-133, L156-158) | △ |
| C-89 | UT-WPB-089: formatFileリンク生成 | E-07 (L194-218) | ○ |
| C-90 | UT-WPB-090: fileLinkFormat未設定時テキスト返却 | E-07 (L213-217) | ○ |
| C-91 | UT-WPB-091: 相対パス表示 | E-07 (L199-201) | ○ |
| C-92 | UT-WPB-092: カスタムテキスト | E-07 (L205-207) | ○ |
| C-93 | UT-WPB-093: 行番号0 | E-07 (L209-211) | ○ |
| C-94 | UT-WPB-094: getFileLink文字列フォーマット | E-07 (L220-227) | ○ |
| C-95 | UT-WPB-095: getFileLinkのFileLinkFormatter | E-07 (L223) | ○ |
| C-96 | UT-WPB-096: getFileLinkのfalse返却 | E-07 (L226) | ○ |
| C-97 | UT-WPB-097: getFileRelative相対パス取得 | E-07 (L229-238) | ○ |
| C-98 | UT-WPB-098: getFileRelativeプロジェクト外 | E-07 (L237) | ○ |
| C-99 | UT-WPB-099: getFileRelativeバックスラッシュ変換 | E-07 (L231) | ○ |
| C-100 | UT-WPB-100: formatFileFromTextファイル参照変換 | E-07 (L240-243) | ○ |
| C-101 | UT-WPB-101: formatLogMessageコンテキスト置換 | E-07 (L248-264) | ○ |
| C-102 | UT-WPB-102: formatLogMessage空コンテキスト | E-07 (L250, L263) | ○ |
| C-103 | UT-WPB-103: 非スカラーコンテキスト無視 | E-07 (L253) | ○ |
| C-104 | UT-WPB-104: formatLogMessageのHTMLエスケープ | E-07 (L263) | ○ |
| C-105 | UT-WPB-105: fixCodeMarkup行頭span除去 | E-07 (L269-273) | ○ |
| C-106 | UT-WPB-106: fixCodeMarkup行末span追加 | E-07 (L276-280) | ○ |
| C-107 | UT-WPB-107: WebProfilerExtensionデフォルト初期化 | E-08 (L40-44) | ○ |
| C-108 | UT-WPB-108: WebProfilerExtensionカスタム初期化 | E-08 (L40-44) | ○ |
| C-109 | UT-WPB-109: enterでstackLevelインクリメント | E-08 (L46-49) | ○ |
| C-110 | UT-WPB-110: leaveでstackLevel=0時リセット | E-08 (L51-56) | ○ |
| C-111 | UT-WPB-111: leaveでstackLevel>0時リセットなし | E-08 (L53) | ○ |
| C-112 | UT-WPB-112: getFunctionsの2関数返却 | E-08 (L58-64) | ○ |
| C-113 | UT-WPB-113: dumpDataのHTML出力 | E-08 (L66-78) | ○ |
| C-114 | UT-WPB-114: dumpDataの末尾改行除去 | E-08 (L77) | ○ |
| C-115 | UT-WPB-115: dumpLogのコンテキスト埋め込み | E-08 (L80-102) | ○ |
| C-116 | UT-WPB-116: dumpLogコンテキストなし | E-08 (L93-95) | ○ |
| C-117 | UT-WPB-117: dumpLog不一致プレースホルダ | E-08 (L86-95) | ○ |
| C-118 | UT-WPB-118: getName返却値 | E-08 (L104-107) | ○ |
| C-119 | UT-WPB-119: DI Extensionツールバー有効時 | E-09 (L49-55) | ○ |
| C-120 | UT-WPB-120: リダイレクトインターセプト有効時 | E-09 (L49-54) | ○ |
| C-121 | UT-WPB-121: ツールバー完全無効時 | E-09 (L49) | ○ |
| C-122 | UT-WPB-122: profiler.php常時読み込み | E-09 (L47) | ○ |
| C-123 | UT-WPB-123: excluded_ajax_paths設定 | E-09 (L51) | ○ |
| C-124 | UT-WPB-124: ajax_replace設定 | E-09 (L52) | ○ |
| C-125 | UT-WPB-125: TreeBuilder生成 | E-10 (L30-54) | ○ |
| C-126 | UT-WPB-126: toolbarデフォルト値 | E-10 (L38-47) | ○ |
| C-127 | UT-WPB-127: intercept_redirectsデフォルト値 | E-10 (L48) | ○ |
| C-128 | UT-WPB-128: excluded_ajax_pathsデフォルト値 | E-10 (L49) | ○ |
| C-129 | UT-WPB-129: prod環境警告 | E-11 (L21-26) | ○ |
| C-130 | UT-WPB-130: 非prod環境警告なし | E-11 (L23) | ○ |
| C-131 | UT-WPB-131: isEnabled ENABLED時true | E-12 (L57-59) | ○ |
| C-132 | UT-WPB-132: isEnabled DISABLED時false | E-12 (L57-59) | ○ |
| C-133 | UT-WPB-133: setMode ENABLED設定 | E-12 (L62-69) | ○ |
| C-134 | UT-WPB-134: setMode DISABLED設定 | E-12 (L62-69) | ○ |
| C-135 | UT-WPB-135: setMode不正値例外 | E-12 (L64-66) | ○ |
| C-136 | UT-WPB-136: X-Debug-Token-Link設定 | E-12 (L76-85) | ○ |
| C-137 | UT-WPB-137: URL生成エラー時X-Debug-Error | E-12 (L82-84) | ○ |
| C-138 | UT-WPB-138: サブリクエスト除外 | E-12 (L87-89) | ○ |
| C-139 | UT-WPB-139: AJAX置換ヘッダ | E-12 (L101-107) | ○ |
| C-140 | UT-WPB-140: XHR除外 | E-12 (L101-107) | ○ |
| C-141 | UT-WPB-141: リダイレクトインターセプト | E-12 (L109-118) | ○ |
| C-142 | UT-WPB-142: DISABLEDモード除外 | E-12 (L141) | ○ |
| C-143 | UT-WPB-143: X-Debug-Tokenなし除外 | E-12 (L142) | ○ |
| C-144 | UT-WPB-144: Content-Type非HTML除外 | E-12 (L144) | ○ |
| C-145 | UT-WPB-145: リダイレクト除外 | E-12 (L143) | ○ |
| C-146 | UT-WPB-146: Content-Disposition attachment除外 | E-12 (L146) | ○ |
| C-147 | UT-WPB-147: requestFormat非HTML除外 | E-12 (L145) | ○ |
| C-148 | UT-WPB-148: CSPハンドラ呼び出し | E-12 (L92-98) | ○ |
| C-149 | UT-WPB-149: ダンプ時CSP無効化 | E-12 (L93-95) | ○ |
| C-150 | UT-WPB-150: EventStreamResponse対応 | E-12 (L120-139) | △ |
| C-151 | UT-WPB-151: ツールバー注入 | E-12 (L157-177) | ○ |
| C-152 | UT-WPB-152: body未検出時スキップ | E-12 (L160-162) | ○ |
| C-153 | UT-WPB-153: イベント登録 | E-12 (L179-183) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-WPB-024/025 (phpinfo/xdebug)**：phpinfo()およびxdebug_info()はPHP組み込み関数であり、テスト環境での出力内容は環境依存。テストではob_start/ob_get_cleanの動作確認が主眼となるが、具体的な出力形式の仕様書は存在しない。
  - 候補：PHPマニュアル / Xdebugドキュメント / モック化による動作確認
- **UT-WPB-067 (fileLinkFormatフォールバック)**：ini_get('xdebug.file_link_format')およびget_cfg_var('xdebug.file_link_format')の返却値はPHP実行環境に依存する。
  - 候補：テスト環境でのini設定制御 / モック化
- **UT-WPB-088 (srcContext負値)**：ファイル全行を返す挙動はコードから推測可能だが、明文化された仕様がない。
  - 候補：既存テストコードの確認 / コードレビュー
- **UT-WPB-150 (EventStreamResponse)**：EventStreamResponseおよびServerEventはHttpFoundationコンポーネントの機能であり、WebProfilerBundle内のテストではモック化が必要。
  - 候補：HttpFoundationコンポーネントのテスト / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: UT-WPB-031/032 (openActionのパストラバーサル防止) - セキュリティに関わるため正規表現パターン `'(^|[/\\\\])\.'` の網羅的なテストが必要
- **1 (中リスク)**: UT-WPB-048-058 (ContentSecurityPolicyHandler) - CSPヘッダ操作は多数のエッジケースがあり、各CSPディレクティブの組み合わせテストが重要
- **0 (低リスク)**: UT-WPB-129/130 (WebProfilerBundle.boot) - prod環境での警告トリガーはシンプルなロジック
- **0 (低リスク)**: UT-WPB-107-118 (WebProfilerExtension Twig) - Twig拡張は表示に関わるもので、データ整合性への影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] ProfilerControllerの全アクションに対してProfiler無効時のテストが含まれているか確認
- [ ] ContentSecurityPolicyHandlerのCSPディレクティブ組み合わせテストが十分か確認
- [ ] openActionのパストラバーサル防止テストが網羅的か確認（Windows/Unix両方のパス区切り）
- [ ] WebDebugToolbarListenerの各条件分岐（DISABLED, XHR, redirect, Content-Type等）が網羅されているか確認
- [ ] CodeExtensionのformatArgs各データ型（object, array, null, boolean, resource, binary）が網羅されているか確認
- [ ] TemplateManagerのgetNamesメソッドのエッジケース（null要素、未登録collector、テンプレート未検出）が含まれているか確認
