---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：Component-Asset 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **UT-AST-056**：chooseBaseUrlの分散確認テストケースは、crc32の挙動に依存し、特定の入力で異なるインデックスが返る保証がない
  2. **UT-AST-090**：マニフェストキャッシュの動作は内部実装の詳細であり、外部から直接検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Asset/Package.php` - Package クラス本体（getVersion, getUrl, isAbsoluteUrl, getContext, getVersionStrategy）
- E-02: `src/Symfony/Component/Asset/Packages.php` - Packages クラス本体（__construct, setDefaultPackage, addPackage, getPackage, getVersion, getUrl）
- E-03: `src/Symfony/Component/Asset/PathPackage.php` - PathPackage クラス本体（__construct, getUrl, getBasePath）
- E-04: `src/Symfony/Component/Asset/UrlPackage.php` - UrlPackage クラス本体（__construct, getUrl, getBaseUrl, chooseBaseUrl, getSslUrls）
- E-05: `src/Symfony/Component/Asset/Context/ContextInterface.php` - ContextInterface インターフェース
- E-06: `src/Symfony/Component/Asset/Context/NullContext.php` - NullContext クラス本体（getBasePath, isSecure）
- E-07: `src/Symfony/Component/Asset/Context/RequestStackContext.php` - RequestStackContext クラス本体（__construct, getBasePath, isSecure）
- E-08: `src/Symfony/Component/Asset/VersionStrategy/VersionStrategyInterface.php` - VersionStrategyInterface インターフェース
- E-09: `src/Symfony/Component/Asset/VersionStrategy/EmptyVersionStrategy.php` - EmptyVersionStrategy クラス本体（getVersion, applyVersion）
- E-10: `src/Symfony/Component/Asset/VersionStrategy/StaticVersionStrategy.php` - StaticVersionStrategy クラス本体（__construct, getVersion, applyVersion）
- E-11: `src/Symfony/Component/Asset/VersionStrategy/JsonManifestVersionStrategy.php` - JsonManifestVersionStrategy クラス本体（__construct, getVersion, applyVersion, getManifestPath, findAlternatives）
- E-12: `src/Symfony/Component/Asset/Exception/AssetNotFoundException.php` - AssetNotFoundException クラス本体（__construct, getAlternatives）
- E-13: `src/Symfony/Component/Asset/Exception/ExceptionInterface.php` - ExceptionInterface
- E-14: `src/Symfony/Component/Asset/Exception/InvalidArgumentException.php` - InvalidArgumentException
- E-15: `src/Symfony/Component/Asset/Exception/LogicException.php` - LogicException
- E-16: `src/Symfony/Component/Asset/Exception/RuntimeException.php` - RuntimeException
- E-17: `src/Symfony/Component/Asset/PackageInterface.php` - PackageInterface インターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-AST-001) | Package: VersionStrategyとContextを指定してインスタンスが生成される | E-01 | ○ |
| C-02 (UT-AST-002) | Package: Contextがnullの場合NullContextが使用される | E-01 | ○ |
| C-03 (UT-AST-003) | Package: パスに対応するバージョン文字列が返却される | E-01 | ○ |
| C-04 (UT-AST-004) | Package: 空文字列のパスでもバージョンが返却される | E-01 | ○ |
| C-05 (UT-AST-005) | Package: 相対パスにバージョンが付与されたURLが返却される | E-01 | ○ |
| C-06 (UT-AST-006) | Package: 絶対URL(http://)がそのまま返却される | E-01 | ○ |
| C-07 (UT-AST-007) | Package: 絶対URL(https://)がそのまま返却される | E-01 | ○ |
| C-08 (UT-AST-008) | Package: プロトコル相対URL(//)がそのまま返却される | E-01 | ○ |
| C-09 (UT-AST-009) | Package: 空文字列のパスが渡された場合 | E-01 | ○ |
| C-10 (UT-AST-010) | Package: '://'を含むURLがtrueを返す | E-01 | ○ |
| C-11 (UT-AST-011) | Package: '//'で始まるURLがtrueを返す | E-01 | ○ |
| C-12 (UT-AST-012) | Package: 相対パスがfalseを返す | E-01 | ○ |
| C-13 (UT-AST-013) | Package: 空文字列がfalseを返す | E-01 | ○ |
| C-14 (UT-AST-014) | Packages: デフォルトパッケージと名前付きパッケージで初期化される | E-02 | ○ |
| C-15 (UT-AST-015) | Packages: デフォルトパッケージなしで初期化される | E-02 | ○ |
| C-16 (UT-AST-016) | Packages: デフォルトパッケージが設定される | E-02 | ○ |
| C-17 (UT-AST-017) | Packages: 名前付きパッケージが追加される | E-02 | ○ |
| C-18 (UT-AST-018) | Packages: 同名パッケージが上書きされる | E-02 | ○ |
| C-19 (UT-AST-019) | Packages: 名前指定でパッケージが取得される | E-02 | ○ |
| C-20 (UT-AST-020) | Packages: null指定でデフォルトパッケージが取得される | E-02 | ○ |
| C-21 (UT-AST-021) | Packages: 存在しないパッケージ名でInvalidArgumentExceptionがスローされる | E-02, E-14 | ○ |
| C-22 (UT-AST-022) | Packages: デフォルトパッケージ未設定でnull指定時にLogicExceptionがスローされる | E-02, E-15 | ○ |
| C-23 (UT-AST-023) | Packages: パス指定でバージョンが取得される | E-02 | ○ |
| C-24 (UT-AST-024) | Packages: パッケージ名指定でバージョンが取得される | E-02 | ○ |
| C-25 (UT-AST-025) | Packages: パス指定でURLが取得される | E-02 | ○ |
| C-26 (UT-AST-026) | Packages: パッケージ名指定でURLが取得される | E-02 | ○ |
| C-27 (UT-AST-027) | PathPackage: ベースパスが正規化されてインスタンスが生成される | E-03 | ○ |
| C-28 (UT-AST-028) | PathPackage: 先頭スラッシュなしのベースパスが補完される | E-03 | ○ |
| C-29 (UT-AST-029) | PathPackage: 末尾スラッシュ付きベースパスが正規化される | E-03 | ○ |
| C-30 (UT-AST-030) | PathPackage: 空文字列のベースパスで'/'が設定される | E-03 | ○ |
| C-31 (UT-AST-031) | PathPackage: 相対パスにベースパスとバージョンが付与される | E-03 | ○ |
| C-32 (UT-AST-032) | PathPackage: 絶対URLがそのまま返却される | E-03, E-01 | ○ |
| C-33 (UT-AST-033) | PathPackage: スラッシュ始まりのバージョン付きパスがそのまま返却される | E-03 | ○ |
| C-34 (UT-AST-034) | PathPackage: コンテキストのベースパスが付与される | E-03, E-05 | ○ |
| C-35 (UT-AST-035) | PathPackage: 空文字列のパスが渡された場合 | E-03 | ○ |
| C-36 (UT-AST-036) | PathPackage: コンテキストのベースパスとパッケージのベースパスが結合される | E-03 | ○ |
| C-37 (UT-AST-037) | PathPackage: コンテキストのベースパスが空文字列の場合 | E-03, E-06 | ○ |
| C-38 (UT-AST-038) | UrlPackage: 文字列のベースURLでインスタンスが生成される | E-04 | ○ |
| C-39 (UT-AST-039) | UrlPackage: 配列のベースURLでインスタンスが生成される | E-04 | ○ |
| C-40 (UT-AST-040) | UrlPackage: 末尾スラッシュが除去される | E-04 | ○ |
| C-41 (UT-AST-041) | UrlPackage: 空配列でLogicExceptionがスローされる | E-04, E-15 | ○ |
| C-42 (UT-AST-042) | UrlPackage: 無効なURL形式でInvalidArgumentExceptionがスローされる | E-04, E-14 | ○ |
| C-43 (UT-AST-043) | UrlPackage: HTTPSとHTTPが混在する場合にSSLパッケージが生成される | E-04 | ○ |
| C-44 (UT-AST-044) | UrlPackage: すべてHTTPSの場合SSLパッケージが生成されない | E-04 | ○ |
| C-45 (UT-AST-045) | UrlPackage: 相対パスにベースURLとバージョンが付与される | E-04 | ○ |
| C-46 (UT-AST-046) | UrlPackage: 絶対URLがそのまま返却される | E-04 | ○ |
| C-47 (UT-AST-047) | UrlPackage: HTTPS環境でSSLパッケージが使用される | E-04 | ○ |
| C-48 (UT-AST-048) | UrlPackage: HTTP環境で通常のベースURLが使用される | E-04 | ○ |
| C-49 (UT-AST-049) | UrlPackage: 先頭スラッシュなしのパスにスラッシュが補完される | E-04 | ○ |
| C-50 (UT-AST-050) | UrlPackage: VersionStrategyが絶対URLを返す場合そのまま返却される | E-04 | ○ |
| C-51 (UT-AST-051) | UrlPackage: 空文字列のパスが渡された場合 | E-04 | ○ |
| C-52 (UT-AST-052) | UrlPackage: 単一ベースURLの場合そのURLが返却される | E-04 | ○ |
| C-53 (UT-AST-053) | UrlPackage: 複数ベースURLの場合パスに基づいて決定的にURLが選択される | E-04 | ○ |
| C-54 (UT-AST-054) | UrlPackage: 同じパスで常に同じベースURLが返却される | E-04 | ○ |
| C-55 (UT-AST-055) | UrlPackage: crc32ハッシュに基づいてインデックスが返却される | E-04 | ○ |
| C-56 (UT-AST-056) | UrlPackage: 異なるパスで異なるインデックスが返却され得る | E-04 | △ |
| C-57 (UT-AST-057) | NullContext: 空文字列が返却される | E-06 | ○ |
| C-58 (UT-AST-058) | NullContext: falseが返却される | E-06 | ○ |
| C-59 (UT-AST-059) | RequestStackContext: RequestStackとデフォルト値でインスタンスが生成される | E-07 | ○ |
| C-60 (UT-AST-060) | RequestStackContext: カスタムベースパスとセキュアフラグで初期化される | E-07 | ○ |
| C-61 (UT-AST-061) | RequestStackContext: リクエスト存在時にリクエストのベースパスが返却される | E-07 | ○ |
| C-62 (UT-AST-062) | RequestStackContext: リクエスト不在時にデフォルトベースパスが返却される | E-07 | ○ |
| C-63 (UT-AST-063) | RequestStackContext: リクエストなしでデフォルトベースパスが空文字列の場合 | E-07 | ○ |
| C-64 (UT-AST-064) | RequestStackContext: リクエスト存在時にリクエストのセキュア状態が返却される | E-07 | ○ |
| C-65 (UT-AST-065) | RequestStackContext: リクエスト不在時にデフォルトのセキュアフラグが返却される | E-07 | ○ |
| C-66 (UT-AST-066) | RequestStackContext: リクエストなしでデフォルトがfalseの場合 | E-07 | ○ |
| C-67 (UT-AST-067) | EmptyVersionStrategy: 空文字列が返却される | E-09 | ○ |
| C-68 (UT-AST-068) | EmptyVersionStrategy: パスがそのまま返却される | E-09 | ○ |
| C-69 (UT-AST-069) | EmptyVersionStrategy: 空文字列のパスがそのまま返却される | E-09 | ○ |
| C-70 (UT-AST-070) | StaticVersionStrategy: バージョンとデフォルトフォーマットでインスタンスが生成される | E-10 | ○ |
| C-71 (UT-AST-071) | StaticVersionStrategy: カスタムフォーマットでインスタンスが生成される | E-10 | ○ |
| C-72 (UT-AST-072) | StaticVersionStrategy: 設定されたバージョン文字列が返却される | E-10 | ○ |
| C-73 (UT-AST-073) | StaticVersionStrategy: パスに関わらず同じバージョンが返却される | E-10 | ○ |
| C-74 (UT-AST-074) | StaticVersionStrategy: デフォルトフォーマットでバージョンが付与される | E-10 | ○ |
| C-75 (UT-AST-075) | StaticVersionStrategy: カスタムフォーマットでバージョンが付与される | E-10 | ○ |
| C-76 (UT-AST-076) | StaticVersionStrategy: 先頭スラッシュ付きパスで先頭スラッシュが保持される | E-10 | ○ |
| C-77 (UT-AST-077) | StaticVersionStrategy: 空文字列のパスが渡された場合 | E-10 | ○ |
| C-78 (UT-AST-078) | StaticVersionStrategy: フォーマットに%2$sを使用した場合 | E-10 | ○ |
| C-79 (UT-AST-079) | JsonManifestVersionStrategy: ローカルファイルパスでインスタンスが生成される | E-11 | ○ |
| C-80 (UT-AST-080) | JsonManifestVersionStrategy: HttpClientとリモートURLでインスタンスが生成される | E-11 | ○ |
| C-81 (UT-AST-081) | JsonManifestVersionStrategy: HttpClientなしでHTTP URLを指定した場合LogicExceptionがスローされる | E-11, E-15 | ○ |
| C-82 (UT-AST-082) | JsonManifestVersionStrategy: strictMode=trueでインスタンスが生成される | E-11 | ○ |
| C-83 (UT-AST-083) | JsonManifestVersionStrategy: マニフェストに存在するパスのバージョン付きパスが返却される | E-11 | ○ |
| C-84 (UT-AST-084) | JsonManifestVersionStrategy: マニフェストに存在しないパスで元のパスが返却される（非strict） | E-11 | ○ |
| C-85 (UT-AST-085) | JsonManifestVersionStrategy: マニフェストに存在しないパスでAssetNotFoundExceptionがスローされる（strict） | E-11, E-12 | ○ |
| C-86 (UT-AST-086) | JsonManifestVersionStrategy: マニフェスト存在パスのバージョン付きパスが返却される | E-11 | ○ |
| C-87 (UT-AST-087) | JsonManifestVersionStrategy: マニフェスト未登録パスで元のパスが返却される | E-11 | ○ |
| C-88 (UT-AST-088) | JsonManifestVersionStrategy: マニフェストファイル不在でRuntimeExceptionがスローされる | E-11, E-16 | ○ |
| C-89 (UT-AST-089) | JsonManifestVersionStrategy: 不正なJSONでRuntimeExceptionがスローされる | E-11, E-16 | ○ |
| C-90 (UT-AST-090) | JsonManifestVersionStrategy: マニフェストデータが一度だけ読み込まれる | E-11 | △ |
| C-91 (UT-AST-091) | JsonManifestVersionStrategy: リモートURLからマニフェストが取得される | E-11 | ○ |
| C-92 (UT-AST-092) | JsonManifestVersionStrategy: リモートURLでDecodingExceptionの場合RuntimeExceptionがスローされる | E-11, E-16 | ○ |
| C-93 (UT-AST-093) | JsonManifestVersionStrategy: リモートURLでClientExceptionの場合RuntimeExceptionがスローされる | E-11, E-16 | ○ |
| C-94 (UT-AST-094) | JsonManifestVersionStrategy: strictModeで類似パスが提案される | E-11 | ○ |
| C-95 (UT-AST-095) | JsonManifestVersionStrategy: strictModeで部分一致パスが提案される | E-11 | ○ |
| C-96 (UT-AST-096) | JsonManifestVersionStrategy: 類似しないパスで候補なし | E-11 | ○ |
| C-97 (UT-AST-097) | AssetNotFoundException: メッセージと代替候補でインスタンスが生成される | E-12 | ○ |
| C-98 (UT-AST-098) | AssetNotFoundException: 代替候補なしでインスタンスが生成される | E-12 | ○ |
| C-99 (UT-AST-099) | AssetNotFoundException: 代替候補の配列が返却される | E-12 | ○ |
| C-100 (UT-AST-100) | AssetNotFoundException: 代替候補が空の場合空配列が返却される | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-56 (UT-AST-056)**: chooseBaseUrlメソッドの分散テストは、crc32ハッシュ関数の出力に依存する。特定の2つのパスが必ず異なるインデックスを返す保証はないため、テストケースの入力値を実際のcrc32計算結果に基づいて選定する必要がある。
  - 候補: 実際にcrc32('a.css')とcrc32('b.css')を計算し、異なるインデックスとなるパスの組み合わせを事前に特定する
- **C-90 (UT-AST-090)**: マニフェストデータのキャッシュ動作は、`$this->manifestData`プロパティの`isset`チェックに基づく内部実装であり、外部からファイル読み込み回数を直接検証することは困難。モック等を使用した間接的な検証が必要。
  - 候補: ファイルシステムのモック / HttpClientの呼び出し回数検証 / Reflectionによる内部状態確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Package, NullContext, EmptyVersionStrategy等の単純なクラスのテストケースはソースコードから直接導出されており、信頼性が高い
- 0: 低リスク - 例外スロー系のテストケースはコード内の条件分岐から明確に導出されている
- 1: 中リスク - JsonManifestVersionStrategyのリモートURL関連テストはHttpClientのモック設計に依存し、実際のHTTP通信の挙動と異なる可能性がある
- 1: 中リスク - findAlternativesのレーベンシュタイン距離に基づく提案ロジックは、特定の入力値での期待結果が事前計算を要する

## 6) レビュアーチェックリスト（最小）
- [ ] 全10クラス（Package, Packages, PathPackage, UrlPackage, NullContext, RequestStackContext, EmptyVersionStrategy, StaticVersionStrategy, JsonManifestVersionStrategy, AssetNotFoundException）が網羅されていること
- [ ] 各publicメソッドに正常系テストケースが存在すること
- [ ] 例外がスローされる全条件分岐に対応する異常系テストケースが存在すること
- [ ] PathPackageとUrlPackageのコンストラクタでの入力正規化ロジックが境界値テストで検証されていること
- [ ] JsonManifestVersionStrategyのローカルファイル/リモートURL両方のマニフェスト取得パターンがカバーされていること
- [ ] UrlPackageのSSL/非SSL環境での動作切り替えがテストされていること
- [ ] テストIDの命名規則（UT-AST-XXX）が一貫していること
- [ ] CSVの全フィールドがダブルクォートで囲まれていること
