---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 192
  claims_without_evidence: 8
confidence_derived: 0.96
---

# 根拠レポート：Component-AssetMapper 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：192 / 200、根拠なし：8
- 優先レビュー（高）
  1. **UT-ASM-142～143（RemotePackageDownloader.downloadPackages）**：内部installed.phpの読み込みロジックが複雑で、テスト条件の厳密な検証が必要
  2. **UT-ASM-186～190（JsDelivrEsmResolver）**：外部APIとの連携処理であり、モック条件の正確性を要確認
  3. **UT-ASM-174～180（Compressor系クラス）**：外部コマンド/PHP拡張の存在に依存するため、テスト環境に応じた前提条件の精査が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/AssetMapper/AssetMapper.php` - AssetMapperクラス（getAsset, allAssets, getAssetFromSourcePath, getPublicPath, loadManifest）
- E-02: `src/Symfony/Component/AssetMapper/AssetMapperCompiler.php` - AssetMapperCompilerクラス（compile, supports）
- E-03: `src/Symfony/Component/AssetMapper/AssetMapperDevServerSubscriber.php` - DevServerSubscriberクラス（onKernelRequest, onKernelResponse, getSubscribedEvents, getMediaType, findAssetFromCache）
- E-04: `src/Symfony/Component/AssetMapper/AssetMapperRepository.php` - AssetMapperRepositoryクラス（find, findLogicalPath, all, allDirectories, getDirectories, isExcluded, normalizeLogicalPath）
- E-05: `src/Symfony/Component/AssetMapper/MappedAsset.php` - MappedAssetクラス（コンストラクタ, getDependencies, addDependency, getFileDependencies, addFileDependency, getJavaScriptImports, addJavaScriptImport）
- E-06: `src/Symfony/Component/AssetMapper/MapperAwareAssetPackage.php` - MapperAwareAssetPackageクラス（getUrl, getVersion）
- E-07: `src/Symfony/Component/AssetMapper/CompiledAssetMapperConfigReader.php` - CompiledAssetMapperConfigReaderクラス（configExists, loadConfig, saveConfig, removeConfig）
- E-08: `src/Symfony/Component/AssetMapper/Compiler/CssAssetUrlCompiler.php` - CssAssetUrlCompilerクラス（compile, supports, handleMissingImport）
- E-09: `src/Symfony/Component/AssetMapper/Compiler/JavaScriptImportPathCompiler.php` - JavaScriptImportPathCompilerクラス（compile, supports, findAssetForBareImport, findAssetForRelativeImport）
- E-10: `src/Symfony/Component/AssetMapper/Compiler/SourceMappingUrlsCompiler.php` - SourceMappingUrlsCompilerクラス（compile, supports）
- E-11: `src/Symfony/Component/AssetMapper/Compiler/Parser/JavascriptSequenceParser.php` - JavascriptSequenceParserクラス（parseUntil, isString, isExecutable, isComment）
- E-12: `src/Symfony/Component/AssetMapper/Factory/MappedAssetFactory.php` - MappedAssetFactoryクラス（createMappedAsset, getDigest, compileContent, getPublicPath, isVendor）
- E-13: `src/Symfony/Component/AssetMapper/Factory/CachedMappedAssetFactory.php` - CachedMappedAssetFactoryクラス（createMappedAsset, getCacheFilePath, collectResourcesFromAsset）
- E-14: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapEntry.php` - ImportMapEntryクラス（createLocal, createRemote, isRemotePackage, splitPackageNameAndFilePath, getPackageName, getPackagePathString）
- E-15: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapEntries.php` - ImportMapEntriesクラス（add, has, get, remove, getIterator）
- E-16: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapConfigReader.php` - ImportMapConfigReaderクラス（getEntries, writeEntries, findRootImportMapEntry, createRemoteEntry, convertPathToFilesystemPath, convertFilesystemPathToPath）
- E-17: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapGenerator.php` - ImportMapGeneratorクラス（getEntrypointNames, getImportMapData, getRawImportMapData, findEagerEntrypointImports, addImplicitEntries, findEagerImports）
- E-18: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapManager.php` - ImportMapManagerクラス（require, remove, update, parsePackageName, requirePackages, updateImportMapConfig）
- E-19: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapRenderer.php` - ImportMapRendererクラス（render, escapeAttributeValue, createAttributesString, addWebLinkPreloads）
- E-20: `src/Symfony/Component/AssetMapper/ImportMap/RemotePackageStorage.php` - RemotePackageStorageクラス（getStorageDir, isDownloaded, isExtraFileDownloaded, save, saveExtraFile, getDownloadPath）
- E-21: `src/Symfony/Component/AssetMapper/ImportMap/RemotePackageDownloader.php` - RemotePackageDownloaderクラス（downloadPackages, getDependencies, getVendorDir, loadInstalled, saveInstalled）
- E-22: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapAuditor.php` - ImportMapAuditorクラス（audit, versionMatches）
- E-23: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapVersionChecker.php` - ImportMapVersionCheckerクラス（checkVersions, convertNpmConstraint, isVersionSatisfied）
- E-24: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapUpdateChecker.php` - ImportMapUpdateCheckerクラス（getAvailableUpdates, getUpdateType, getVersionPart）
- E-25: `src/Symfony/Component/AssetMapper/ImportMap/PackageUpdateInfo.php` - PackageUpdateInfoクラス（hasUpdate）
- E-26: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapPackageAudit.php` - ImportMapPackageAuditクラス（withVulnerability）
- E-27: `src/Symfony/Component/AssetMapper/ImportMap/ImportMapType.php` - ImportMapType enum
- E-28: `src/Symfony/Component/AssetMapper/ImportMap/JavaScriptImport.php` - JavaScriptImportクラス
- E-29: `src/Symfony/Component/AssetMapper/ImportMap/PackageRequireOptions.php` - PackageRequireOptionsクラス
- E-30: `src/Symfony/Component/AssetMapper/ImportMap/Resolver/JsDelivrEsmResolver.php` - JsDelivrEsmResolverクラス（resolvePackages, downloadPackages, fetchPackageRequirementsFromImports, makeImportsBare）
- E-31: `src/Symfony/Component/AssetMapper/ImportMap/BatchHttpClient.php` - BatchHttpClientクラス（request）
- E-32: `src/Symfony/Component/AssetMapper/Path/PublicAssetsPathResolver.php` - PublicAssetsPathResolverクラス（resolvePublicPath）
- E-33: `src/Symfony/Component/AssetMapper/Path/LocalPublicAssetsFilesystem.php` - LocalPublicAssetsFilesystemクラス（write, copy, getDestinationPath）
- E-34: `src/Symfony/Component/AssetMapper/Compressor/ChainCompressor.php` - ChainCompressorクラス（compress）
- E-35: `src/Symfony/Component/AssetMapper/Compressor/BrotliCompressor.php` - BrotliCompressorクラス（compress, getUnsupportedReason）
- E-36: `src/Symfony/Component/AssetMapper/Compressor/GzipCompressor.php` - GzipCompressorクラス（compress, getUnsupportedReason）
- E-37: `src/Symfony/Component/AssetMapper/Compressor/ZstandardCompressor.php` - ZstandardCompressorクラス（compress）
- E-38: `src/Symfony/Component/AssetMapper/Compressor/ZopfliCompressor.php` - ZopfliCompressorクラス（compress, createStreamContext）
- E-39: `src/Symfony/Component/AssetMapper/Compressor/CompressorTrait.php` - CompressorTrait（initialize, compress, getUnsupportedReason, compressWithExtension）
- E-40: `src/Symfony/Component/AssetMapper/Event/PreAssetsCompileEvent.php` - PreAssetsCompileEventクラス（getOutput）
- E-41: `src/Symfony/Component/AssetMapper/Exception/CircularAssetsException.php` - CircularAssetsExceptionクラス（getIncompleteMappedAsset）
- E-42: `src/Symfony/Component/AssetMapper/ImportMap/PackageVersionProblem.php` - PackageVersionProblemクラス（データオブジェクト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AssetMapper.getAsset: 論理パスに対応するアセットが返却される | E-01 | ○ |
| C-02 | AssetMapper.getAsset: 存在しない場合null | E-01 | ○ |
| C-03 | AssetMapper.allAssets: 全アセットがイテレート可能 | E-01 | ○ |
| C-04 | AssetMapper.allAssets: ファクトリがnullの場合LogicException | E-01 | ○ |
| C-05 | AssetMapper.getAssetFromSourcePath: ソースパスからアセット取得 | E-01 | ○ |
| C-06 | AssetMapper.getAssetFromSourcePath: 未登録でnull | E-01 | ○ |
| C-07 | AssetMapper.getPublicPath: マニフェスト優先 | E-01 | ○ |
| C-08 | AssetMapper.getPublicPath: フォールバック | E-01 | ○ |
| C-09 | AssetMapper.getPublicPath: 存在しない場合null | E-01 | ○ |
| C-10 | AssetMapperCompiler.compile: コンパイラチェーン動作 | E-02 | ○ |
| C-11 | AssetMapperCompiler.compile: 非対応コンパイラスキップ | E-02 | ○ |
| C-12 | AssetMapperCompiler.compile: 空コンパイラリスト | E-02 | ○ |
| C-13 | AssetMapperCompiler.supports: いずれかサポートでtrue | E-02 | ○ |
| C-14 | AssetMapperCompiler.supports: 全非サポートでfalse | E-02 | ○ |
| C-15 | AssetMapperRepository.find: 論理パスからファイルパス | E-04 | ○ |
| C-16 | AssetMapperRepository.find: 名前空間付き検索 | E-04 | ○ |
| C-17 | AssetMapperRepository.find: 存在しないファイルでnull | E-04 | ○ |
| C-18 | AssetMapperRepository.find: 除外パターンでnull | E-04 | ○ |
| C-19 | AssetMapperRepository.findLogicalPath: ファイルパスから論理パス | E-04 | ○ |
| C-20 | AssetMapperRepository.findLogicalPath: 名前空間付き逆引き | E-04 | ○ |
| C-21 | AssetMapperRepository.findLogicalPath: ファイル不在でnull | E-04 | ○ |
| C-22 | AssetMapperRepository.findLogicalPath: 除外ファイルでnull | E-04 | ○ |
| C-23 | AssetMapperRepository.all: 全ファイル列挙 | E-04 | ○ |
| C-24 | AssetMapperRepository.all: PHP除外 | E-04 | ○ |
| C-25 | AssetMapperRepository.all: ドットファイル除外 | E-04 | ○ |
| C-26 | AssetMapperRepository.getDirectories: debug=trueで不正パスException | E-04 | ○ |
| C-27 | AssetMapperRepository.getDirectories: debug=falseでスキップ | E-04 | ○ |
| C-28 | MappedAsset.__construct: プロパティ設定 | E-05 | ○ |
| C-29 | MappedAsset.__construct: publicExtension抽出 | E-05 | ○ |
| C-30 | MappedAsset.addDependency | E-05 | ○ |
| C-31 | MappedAsset.addFileDependency | E-05 | ○ |
| C-32 | MappedAsset.addJavaScriptImport | E-05 | ○ |
| C-33 | MapperAwareAssetPackage.getUrl: publicPath利用 | E-06 | ○ |
| C-34 | MapperAwareAssetPackage.getUrl: フォールバック | E-06 | ○ |
| C-35 | MapperAwareAssetPackage.getVersion: 委譲 | E-06 | ○ |
| C-36 | CompiledAssetMapperConfigReader.configExists: true | E-07 | ○ |
| C-37 | CompiledAssetMapperConfigReader.configExists: false | E-07 | ○ |
| C-38 | CompiledAssetMapperConfigReader.loadConfig | E-07 | ○ |
| C-39 | CompiledAssetMapperConfigReader.loadConfig: 不正JSON | E-07 | ○ |
| C-40 | CompiledAssetMapperConfigReader.saveConfig | E-07 | ○ |
| C-41 | CompiledAssetMapperConfigReader.removeConfig: 存在 | E-07 | ○ |
| C-42 | CompiledAssetMapperConfigReader.removeConfig: 不在 | E-07 | ○ |
| C-43 | CssAssetUrlCompiler.supports: CSS=true | E-08 | ○ |
| C-44 | CssAssetUrlCompiler.supports: 非CSS=false | E-08 | ○ |
| C-45 | CssAssetUrlCompiler.compile: url()解決 | E-08 | ○ |
| C-46 | CssAssetUrlCompiler.compile: @import解決 | E-08 | ○ |
| C-47 | CssAssetUrlCompiler.compile: コメント内スキップ | E-08 | ○ |
| C-48 | CssAssetUrlCompiler.compile: warnモード | E-08 | ○ |
| C-49 | CssAssetUrlCompiler.compile: strictモード | E-08 | ○ |
| C-50 | CssAssetUrlCompiler.compile: data:/http:スキップ | E-08 | ○ |
| C-51 | JavaScriptImportPathCompiler.supports: JS=true | E-09 | ○ |
| C-52 | JavaScriptImportPathCompiler.supports: 非JS=false | E-09 | ○ |
| C-53 | JavaScriptImportPathCompiler.compile: 相対インポート解決 | E-09 | ○ |
| C-54 | JavaScriptImportPathCompiler.compile: bareインポート解決 | E-09 | ○ |
| C-55 | JavaScriptImportPathCompiler.compile: コメント内スキップ | E-09, E-11 | ○ |
| C-56 | JavaScriptImportPathCompiler.compile: 文字列内スキップ | E-09, E-11 | ○ |
| C-57 | JavaScriptImportPathCompiler.compile: 動的import lazy判定 | E-09 | ○ |
| C-58 | JavaScriptImportPathCompiler.compile: 自己参照無視 | E-09 | ○ |
| C-59 | SourceMappingUrlsCompiler.supports: CSS=true | E-10 | ○ |
| C-60 | SourceMappingUrlsCompiler.supports: JS=true | E-10 | ○ |
| C-61 | SourceMappingUrlsCompiler.supports: その他=false | E-10 | ○ |
| C-62 | SourceMappingUrlsCompiler.compile: sourceMappingURL置換 | E-10 | ○ |
| C-63 | SourceMappingUrlsCompiler.compile: 不在ソースマップ維持 | E-10 | ○ |
| C-64 | JavascriptSequenceParser.parseUntil: コード部分判定 | E-11 | ○ |
| C-65 | JavascriptSequenceParser.parseUntil: コメント判定 | E-11 | ○ |
| C-66 | JavascriptSequenceParser.parseUntil: 文字列判定 | E-11 | ○ |
| C-67 | JavascriptSequenceParser.parseUntil: 範囲外Exception | E-11 | ○ |
| C-68 | JavascriptSequenceParser.parseUntil: 逆方向Exception | E-11 | ○ |
| C-69 | JavascriptSequenceParser.parseUntil: 単一行コメント | E-11 | ○ |
| C-70 | JavascriptSequenceParser.parseUntil: エスケープ処理 | E-11 | ○ |
| C-71 | MappedAssetFactory.createMappedAsset: 基本生成 | E-12 | ○ |
| C-72 | MappedAssetFactory.createMappedAsset: 非コンパイル | E-12 | ○ |
| C-73 | MappedAssetFactory.createMappedAsset: 循環参照Exception | E-12 | ○ |
| C-74 | MappedAssetFactory.createMappedAsset: キャッシュ再利用 | E-12 | ○ |
| C-75 | MappedAssetFactory.createMappedAsset: プレダイジェスト | E-12 | ○ |
| C-76 | MappedAssetFactory.createMappedAsset: ファイル不在Exception | E-12 | ○ |
| C-77 | MappedAssetFactory.createMappedAsset: isVendor判定 | E-12 | ○ |
| C-78 | CachedMappedAssetFactory.createMappedAsset: キャッシュヒット | E-13 | ○ |
| C-79 | CachedMappedAssetFactory.createMappedAsset: キャッシュミス | E-13 | ○ |
| C-80 | CachedMappedAssetFactory.createMappedAsset: null伝播 | E-13 | ○ |
| C-81 | ImportMapEntry.createLocal | E-14 | ○ |
| C-82 | ImportMapEntry.createRemote | E-14 | ○ |
| C-83 | ImportMapEntry.isRemotePackage: true | E-14 | ○ |
| C-84 | ImportMapEntry.isRemotePackage: false | E-14 | ○ |
| C-85 | ImportMapEntry.splitPackageNameAndFilePath: スコープ付き | E-14 | ○ |
| C-86 | ImportMapEntry.splitPackageNameAndFilePath: パスなし | E-14 | ○ |
| C-87 | ImportMapEntry.splitPackageNameAndFilePath: 通常 | E-14 | ○ |
| C-88 | ImportMapEntry.getPackageName | E-14 | ○ |
| C-89 | ImportMapEntry.getPackagePathString | E-14 | ○ |
| C-90 | ImportMapEntries.add | E-15 | ○ |
| C-91 | ImportMapEntries.has: true | E-15 | ○ |
| C-92 | ImportMapEntries.has: false | E-15 | ○ |
| C-93 | ImportMapEntries.get: 存在 | E-15 | ○ |
| C-94 | ImportMapEntries.get: Exception | E-15 | ○ |
| C-95 | ImportMapEntries.remove | E-15 | ○ |
| C-96 | ImportMapEntries.getIterator | E-15 | ○ |
| C-97 | ImportMapConfigReader.getEntries | E-16 | ○ |
| C-98 | ImportMapConfigReader.getEntries: 不正キー | E-16 | ○ |
| C-99 | ImportMapConfigReader.getEntries: path+version排他 | E-16 | ○ |
| C-100 | ImportMapConfigReader.getEntries: 必須項目不足 | E-16 | ○ |
| C-101 | ImportMapConfigReader.writeEntries | E-16 | ○ |
| C-102 | ImportMapConfigReader.findRootImportMapEntry: 存在 | E-16 | ○ |
| C-103 | ImportMapConfigReader.findRootImportMapEntry: 不在 | E-16 | ○ |
| C-104 | ImportMapConfigReader.convertPathToFilesystemPath: 相対 | E-16 | ○ |
| C-105 | ImportMapConfigReader.convertPathToFilesystemPath: 絶対 | E-16 | ○ |
| C-106 | ImportMapConfigReader.convertFilesystemPathToPath: ルート配下 | E-16 | ○ |
| C-107 | ImportMapConfigReader.convertFilesystemPathToPath: ルート外 | E-16 | ○ |
| C-108 | ImportMapGenerator.getEntrypointNames | E-17 | ○ |
| C-109 | ImportMapGenerator.getEntrypointNames: 0件 | E-17 | ○ |
| C-110 | ImportMapGenerator.getRawImportMapData: キャッシュ | E-17 | ○ |
| C-111 | ImportMapGenerator.getRawImportMapData: 動的生成 | E-17 | ○ |
| C-112 | ImportMapGenerator.getImportMapData: preload設定 | E-17 | ○ |
| C-113 | ImportMapGenerator.findEagerEntrypointImports: 再帰取得 | E-17 | ○ |
| C-114 | ImportMapGenerator.findEagerEntrypointImports: 不在Exception | E-17 | ○ |
| C-115 | ImportMapGenerator.findEagerEntrypointImports: 非entrypoint Exception | E-17 | ○ |
| C-116 | ImportMapGenerator.findEagerEntrypointImports: リモート禁止 | E-17 | ○ |
| C-117 | ImportMapManager.require | E-18 | ○ |
| C-118 | ImportMapManager.remove | E-18 | ○ |
| C-119 | ImportMapManager.remove: 不在Exception | E-18 | ○ |
| C-120 | ImportMapManager.update: 全パッケージ | E-18 | ○ |
| C-121 | ImportMapManager.update: 選択的 | E-18 | ○ |
| C-122 | ImportMapManager.parsePackageName: バージョン付き | E-18 | ○ |
| C-123 | ImportMapManager.parsePackageName: エイリアス付き | E-18 | ○ |
| C-124 | ImportMapManager.parsePackageName: バージョンなし | E-18 | ○ |
| C-125 | ImportMapRenderer.render: importmap生成 | E-19 | ○ |
| C-126 | ImportMapRenderer.render: modulepreload生成 | E-19 | ○ |
| C-127 | ImportMapRenderer.render: CSS stylesheet生成 | E-19 | ○ |
| C-128 | ImportMapRenderer.render: JSONローダー | E-19 | ○ |
| C-129 | ImportMapRenderer.render: polyfill生成 | E-19 | ○ |
| C-130 | ImportMapRenderer.render: polyfill無効 | E-19 | ○ |
| C-131 | ImportMapRenderer.render: カスタム属性 | E-19 | ○ |
| C-132 | ImportMapRenderer.render: 禁止属性Exception | E-19 | ○ |
| C-133 | ImportMapRenderer.render: 複数エントリポイント | E-19 | ○ |
| C-134 | RemotePackageStorage.getDownloadPath: bareパッケージ | E-20 | ○ |
| C-135 | RemotePackageStorage.getDownloadPath: パス付き | E-20 | ○ |
| C-136 | RemotePackageStorage.getDownloadPath: CSS拡張子 | E-20 | ○ |
| C-137 | RemotePackageStorage.isDownloaded: true | E-20 | ○ |
| C-138 | RemotePackageStorage.isDownloaded: ローカルException | E-20 | ○ |
| C-139 | RemotePackageStorage.save | E-20 | ○ |
| C-140 | RemotePackageStorage.save: ローカルException | E-20 | ○ |
| C-141 | RemotePackageStorage.saveExtraFile | E-20 | ○ |
| C-142 | RemotePackageDownloader.downloadPackages: ダウンロード実行 | E-21 | ○ |
| C-143 | RemotePackageDownloader.downloadPackages: スキップ | E-21 | ○ |
| C-144 | RemotePackageDownloader.getDependencies | E-21 | ○ |
| C-145 | RemotePackageDownloader.getDependencies: 未インストールException | E-21 | ○ |
| C-146 | ImportMapAuditor.audit: 監査結果 | E-22 | ○ |
| C-147 | ImportMapAuditor.audit: リモート0件 | E-22 | ○ |
| C-148 | ImportMapAuditor.audit: APIエラー | E-22 | ○ |
| C-149 | ImportMapVersionChecker.checkVersions: 問題検出 | E-23 | ○ |
| C-150 | ImportMapVersionChecker.checkVersions: 整合 | E-23 | ○ |
| C-151 | ImportMapVersionChecker.convertNpmConstraint: 基本変換 | E-23 | ○ |
| C-152 | ImportMapVersionChecker.convertNpmConstraint: 特殊制約null | E-23 | ○ |
| C-153 | ImportMapVersionChecker.convertNpmConstraint: チルダ変換 | E-23 | ○ |
| C-154 | ImportMapVersionChecker.convertNpmConstraint: 範囲制約 | E-23 | ○ |
| C-155 | ImportMapUpdateChecker.getAvailableUpdates | E-24 | ○ |
| C-156 | ImportMapUpdateChecker.getAvailableUpdates: 選択的 | E-24 | ○ |
| C-157 | ImportMapUpdateChecker.getAvailableUpdates: APIエラー | E-24 | ○ |
| C-158 | PackageUpdateInfo.hasUpdate: major=true | E-25 | ○ |
| C-159 | PackageUpdateInfo.hasUpdate: up-to-date=false | E-25 | ○ |
| C-160 | PackageUpdateInfo.hasUpdate: downgrade=false | E-25 | ○ |
| C-161 | ImportMapPackageAudit.withVulnerability: 新インスタンス | E-26 | ○ |
| C-162 | ImportMapPackageAudit.withVulnerability: イミュータビリティ | E-26 | ○ |
| C-163 | ImportMapType.tryFrom: 有効値 | E-27 | ○ |
| C-164 | ImportMapType.tryFrom: 無効値 | E-27 | ○ |
| C-165 | PublicAssetsPathResolver.resolvePublicPath | E-32 | ○ |
| C-166 | PublicAssetsPathResolver.resolvePublicPath: カスタム | E-32 | ○ |
| C-167 | PublicAssetsPathResolver.__construct: スラッシュ正規化 | E-32 | ○ |
| C-168 | LocalPublicAssetsFilesystem.write | E-33 | ○ |
| C-169 | LocalPublicAssetsFilesystem.write: 圧縮 | E-33 | ○ |
| C-170 | LocalPublicAssetsFilesystem.copy | E-33 | ○ |
| C-171 | LocalPublicAssetsFilesystem.getDestinationPath | E-33 | ○ |
| C-172 | ChainCompressor.compress: チェーン | E-34 | ○ |
| C-173 | ChainCompressor.compress: 非サポートスキップ | E-34 | ○ |
| C-174 | BrotliCompressor.compress | E-35, E-39 | △ |
| C-175 | BrotliCompressor.getUnsupportedReason | E-35, E-39 | △ |
| C-176 | GzipCompressor.compress: Zopfli優先 | E-36 | ○ |
| C-177 | GzipCompressor.compress: gzipフォールバック | E-36, E-39 | ○ |
| C-178 | ZstandardCompressor.compress | E-37, E-39 | △ |
| C-179 | ZopfliCompressor.compress | E-38, E-39 | △ |
| C-180 | ZopfliCompressor.createStreamContext: BadMethodCallException | E-38 | ○ |
| C-181 | PreAssetsCompileEvent.getOutput | E-40 | ○ |
| C-182 | CircularAssetsException.getIncompleteMappedAsset | E-41 | ○ |
| C-183 | PackageRequireOptions: デフォルトimportName | E-29 | ○ |
| C-184 | PackageRequireOptions: カスタムimportName | E-29 | ○ |
| C-185 | JavaScriptImport.__construct | E-28 | ○ |
| C-186 | JsDelivrEsmResolver.resolvePackages | E-30 | △ |
| C-187 | JsDelivrEsmResolver.resolvePackages: 解決失敗 | E-30 | △ |
| C-188 | JsDelivrEsmResolver.downloadPackages | E-30 | △ |
| C-189 | JsDelivrEsmResolver.downloadPackages: ローカルエントリ拒否 | E-30 | ○ |
| C-190 | JsDelivrEsmResolver.downloadPackages: CSSパターン | E-30 | ○ |
| C-191 | BatchHttpClient.request: 基本リクエスト | E-31 | ○ |
| C-192 | BatchHttpClient.request: バッチサイズ制御 | E-31 | △ |
| C-193 | AssetMapperDevServerSubscriber.onKernelRequest: レスポンス | E-03 | ○ |
| C-194 | AssetMapperDevServerSubscriber.onKernelRequest: 非アセットスキップ | E-03 | ○ |
| C-195 | AssetMapperDevServerSubscriber.onKernelRequest: NotFoundHttpException | E-03 | ○ |
| C-196 | AssetMapperDevServerSubscriber.onKernelRequest: サブリクエストスキップ | E-03 | ○ |
| C-197 | AssetMapperDevServerSubscriber.onKernelRequest: Content-Type | E-03 | ○ |
| C-198 | AssetMapperDevServerSubscriber.onKernelRequest: キャッシュヘッダー | E-03 | ○ |
| C-199 | AssetMapperDevServerSubscriber.onKernelResponse | E-03 | ○ |
| C-200 | AssetMapperDevServerSubscriber.getSubscribedEvents | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- **Compressor系（C-174, C-175, C-178, C-179）**: 圧縮処理の実テスト結果はPHP拡張・外部バイナリの存在に依存するため、テスト実行環境での検証が必要
  - 候補：テスト環境でのbrotli/zstd/zopfliのインストール状況確認 / モック利用による検証
- **JsDelivrEsmResolver（C-186, C-187, C-188）**: 外部APIとのHTTP通信を伴うため、実際のAPI仕様変更の影響を受ける可能性がある
  - 候補：jsDelivr APIのレスポンス仕様書 / 既存テストのHTTPモック定義
- **BatchHttpClient（C-192）**: BATCH_SIZE=250のストリーム処理はWeakMapを使用しており、テスト条件の正確な設定が難しい
  - 候補：WeakMapの挙動に関するPHP公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: MappedAsset, ImportMapEntry, ImportMapEntries, ImportMapType, PreAssetsCompileEvent, PackageRequireOptions, JavaScriptImport, PackageVersionProblem, PackageUpdateInfo, ImportMapPackageAudit, PublicAssetsPathResolver - 単純なデータオブジェクトであり、テストケースの正確性が高い
- 1（中リスク）: AssetMapper, AssetMapperCompiler, AssetMapperRepository, MapperAwareAssetPackage, CompiledAssetMapperConfigReader, CssAssetUrlCompiler, JavaScriptImportPathCompiler, SourceMappingUrlsCompiler, JavascriptSequenceParser, MappedAssetFactory, CachedMappedAssetFactory, ImportMapConfigReader, ImportMapGenerator, ImportMapManager, ImportMapRenderer, RemotePackageStorage, RemotePackageDownloader, LocalPublicAssetsFilesystem - 依存関係のモック設定が正しいかレビューが必要
- 2（高リスク）: JsDelivrEsmResolver, ImportMapAuditor, ImportMapVersionChecker, ImportMapUpdateChecker, BatchHttpClient - 外部API/HTTPクライアントとの連携があり、モック条件の正確な設定が重要。BrotliCompressor, GzipCompressor, ZstandardCompressor, ZopfliCompressor - 環境依存の処理でありテスト環境の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全200テストケースが実際のソースコードのメソッドシグネチャと一致しているか
- [ ] 正常系/異常系/境界値の観点が主要メソッドに対して網羅されているか
- [ ] 外部API連携系テスト（ImportMapAuditor, ImportMapVersionChecker, ImportMapUpdateChecker, JsDelivrEsmResolver）のモック条件が実際のAPI仕様と整合しているか
- [ ] Compressor系テストの環境前提条件がテスト実行環境と一致しているか
- [ ] Commandクラス（AssetMapperCompileCommand等）がテスト対象から除外されている理由が妥当か（コンソールコマンドの統合テストとして扱うため）
- [ ] 優先度の設定が適切か（金額計算はないため、セキュリティ関連のImportMapAuditorが高優先度になっているか等）
- [ ] テストID（UT-ASM-001〜200）の連番に欠番がないか
