---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 178
  claims_with_evidence: 178
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Component-BrowserKit 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：178 / 178、根拠なし：0
- 優先レビュー（高）
  1. **HttpBrowser.doRequest のモック検証**: HttpClientInterface のモックによる検証が必要なため、テスト実装時に注意が必要
  2. **AbstractBrowser の具象実装テスト**: AbstractBrowser は抽象クラスのため、テスト用の具象実装クラスが必要
  3. **Cookie.isExpired の時刻依存テスト**: 現在時刻に依存するテストのため、テスト実行タイミングで結果が変わる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/BrowserKit/Request.php` - Request クラスの定義（コンストラクタ、ゲッターメソッド群）
- E-02: `src/Symfony/Component/BrowserKit/Response.php` - Response クラスの定義（コンストラクタ、ゲッター、toArray、__toString）
- E-03: `src/Symfony/Component/BrowserKit/Cookie.php` - Cookie クラスの定義（コンストラクタ、fromString、ゲッター群、isExpired、__toString）
- E-04: `src/Symfony/Component/BrowserKit/CookieJar.php` - CookieJar クラスの定義（set、get、expire、clear、all、allValues、updateFromSetCookie、updateFromResponse、flushExpiredCookies）
- E-05: `src/Symfony/Component/BrowserKit/History.php` - History クラスの定義（clear、add、isEmpty、isFirstPage、isLastPage、back、forward、current）
- E-06: `src/Symfony/Component/BrowserKit/AbstractBrowser.php` - AbstractBrowser 抽象クラスの定義（request、followRedirect、getAbsoluteUri、xmlHttpRequest、jsonRequest 等）
- E-07: `src/Symfony/Component/BrowserKit/HttpBrowser.php` - HttpBrowser クラスの定義（doRequest、getHeaders、getBodyAndExtraHeaders、getUploadedFiles）
- E-08: `src/Symfony/Component/BrowserKit/Exception/BadMethodCallException.php` - BadMethodCallException 定義
- E-09: `src/Symfony/Component/BrowserKit/Exception/JsonException.php` - JsonException 定義
- E-10: `src/Symfony/Component/BrowserKit/Exception/ExceptionInterface.php` - ExceptionInterface 定義
- E-11: `src/Symfony/Component/BrowserKit/Exception/InvalidArgumentException.php` - InvalidArgumentException（fromString、CookieJar で使用）
- E-12: `src/Symfony/Component/BrowserKit/Exception/LogicException.php` - LogicException（History、AbstractBrowser、HttpBrowser で使用）
- E-13: `src/Symfony/Component/BrowserKit/Exception/UnexpectedValueException.php` - UnexpectedValueException（Cookie コンストラクタで使用）
- E-14: `src/Symfony/Component/BrowserKit/Exception/RuntimeException.php` - RuntimeException（doRequestInProcess で使用）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Request.__construct: URI/method/parametersの設定とパラメータの文字列変換（UT-BRK-001〜003） | E-01 L28-42 | ○ |
| C-02 | Request ゲッターメソッド群（UT-BRK-004〜012） | E-01 L44-98 | ○ |
| C-03 | Response.__construct: デフォルト値と引数付き生成（UT-BRK-013〜014） | E-02 L31-36 | ○ |
| C-04 | Response ゲッターメソッド群（UT-BRK-015〜017） | E-02 L57-69 | ○ |
| C-05 | Response.getHeader: ヘッダー名正規化、first/not-first、存在しないヘッダー（UT-BRK-018〜024） | E-02 L75-89 | ○ |
| C-06 | Response.__toString: ヘッダーとコンテンツの文字列化（UT-BRK-025〜026） | E-02 L41-55 | ○ |
| C-07 | Response.toArray: JSONデコード、キャッシュ、エラー処理（UT-BRK-027〜030） | E-02 L91-108, E-09 | ○ |
| C-08 | Cookie.__construct: 値のエンコード/デコード、expires、pathデフォルト（UT-BRK-031〜037） | E-03 L56-84, E-13 | ○ |
| C-09 | Cookie.fromString: Set-Cookie文字列パース、各属性、URL由来設定（UT-BRK-038〜048） | E-03 L126-197, E-11 | ○ |
| C-10 | Cookie ゲッターメソッド群（UT-BRK-049〜064） | E-03 L223-298 | ○ |
| C-11 | Cookie.__toString: HTTP表現文字列（UT-BRK-065〜067） | E-03 L89-119 | ○ |
| C-12 | Cookie.isExpired: 有効期限判定ロジック（UT-BRK-059〜062） | E-03 L287-290 | ○ |
| C-13 | CookieJar.set/get: Cookie追加・取得、ドメインマッチング（UT-BRK-068〜075） | E-04 L25-61 | ○ |
| C-14 | CookieJar.expire: Cookie削除、ドメイン未指定時の動作（UT-BRK-076〜078） | E-04 L70-93 | ○ |
| C-15 | CookieJar.clear/all: 全削除・全取得（UT-BRK-079〜082） | E-04 L98-158 | ○ |
| C-16 | CookieJar.allValues: URI別フィルタリング、secure/domain/path（UT-BRK-083〜088） | E-04 L163-201 | ○ |
| C-17 | CookieJar.updateFromSetCookie/updateFromResponse: Cookieの更新（UT-BRK-089〜092） | E-04 L108-137 | ○ |
| C-18 | CookieJar.flushExpiredCookies: 期限切れ除去（UT-BRK-093〜094） | E-04 L206-217 | ○ |
| C-19 | History.clear/add/isEmpty: 基本操作（UT-BRK-095〜100） | E-05 L29-51 | ○ |
| C-20 | History.isFirstPage/isLastPage: ページ位置判定（UT-BRK-101〜104） | E-05 L56-67 | ○ |
| C-21 | History.back/forward/current: ナビゲーションとエラー（UT-BRK-105〜112） | E-05 L74-109 | ○ |
| C-22 | AbstractBrowser.__construct: デフォルトパラメータ（UT-BRK-113〜114） | E-06 L63-68 | ○ |
| C-23 | AbstractBrowser.followRedirects/followMetaRefresh/setMaxRedirects（UT-BRK-115〜120） | E-06 L73-109 | ○ |
| C-24 | AbstractBrowser.insulate: 分離モード設定（UT-BRK-121〜122） | E-06 L116-123 | ○ |
| C-25 | AbstractBrowser.setServerParameters/setServerParameter/getServerParameter（UT-BRK-123〜127） | E-06 L128-149 | ○ |
| C-26 | AbstractBrowser.getCrawler/getInternalResponse/getResponse/getInternalRequest/getRequest: 事前条件チェック（UT-BRK-128〜132） | E-06 L199-258, E-08 | ○ |
| C-27 | AbstractBrowser.request: 基本リクエスト処理（UT-BRK-133〜143） | E-06 L334-412 | ○ |
| C-28 | AbstractBrowser.xmlHttpRequest: XHRヘッダー設定（UT-BRK-144〜145） | E-06 L151-160 | ○ |
| C-29 | AbstractBrowser.jsonRequest: JSONリクエスト処理（UT-BRK-146〜149） | E-06 L165-178 | ○ |
| C-30 | AbstractBrowser.back/forward/reload: ナビゲーション（UT-BRK-150〜152） | E-06 L514-541 | ○ |
| C-31 | AbstractBrowser.followRedirect: リダイレクト追従、メソッド変更（UT-BRK-153〜157） | E-06 L548-590 | ○ |
| C-32 | AbstractBrowser.restart: ブラウザ再起動（UT-BRK-158） | E-06 L612-616 | ○ |
| C-33 | AbstractBrowser.getAbsoluteUri: URI変換（UT-BRK-159〜165） | E-06 L621-658 | ○ |
| C-34 | AbstractBrowser.wrapContent: コンテンツラッパー（UT-BRK-166〜167） | E-06 L209-212 | ○ |
| C-35 | AbstractBrowser.clickLink/submitForm: 事前条件チェック（UT-BRK-168〜170） | E-06 L280-321 | ○ |
| C-36 | AbstractBrowser.getScript: デフォルト実装（UT-BRK-171） | E-06 L469-472 | ○ |
| C-37 | HttpBrowser.__construct: 生成と依存チェック（UT-BRK-172〜173） | E-07 L34-43, E-12 | ○ |
| C-38 | HttpBrowser.doRequest: HTTPリクエスト実行（UT-BRK-174〜175） | E-07 L48-60 | ○ |
| C-39 | HttpBrowser.getHeaders: ヘッダー変換処理（UT-BRK-176〜178） | E-07 L111-133 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコード上の実装に基づいて生成されており、根拠なしの項目はありません。
- ただし、以下の点はテスト実装時に追加検討が必要です:
  - AbstractBrowser.doRequestInProcess メソッドは外部プロセス依存のため、単体テストケースとしての対象から除外しています
  - HttpBrowser の private メソッド（getBodyAndExtraHeaders、getUploadedFiles）は public メソッド経由の間接テストとして検証されます

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Request, Response, Cookie, History の各ゲッターメソッドのテストケース（単純な値の取得）
- 0: 低リスク - CookieJar.clear, History.clear のテストケース（単純な初期化）
- 1: 中リスク - AbstractBrowser.request のテストケース（多数の条件分岐、サーバーパラメータのマージ処理が複雑）
- 1: 中リスク - Cookie.fromString のテストケース（多様なSet-Cookie文字列フォーマットの解析）
- 1: 中リスク - CookieJar.allValues のドメイン・パスマッチングロジック
- 1: 中リスク - AbstractBrowser.followRedirect のメソッド変更ロジック（301/302/303 vs 307）
- 1: 中リスク - AbstractBrowser.getAbsoluteUri のURI解決ロジック（複数パターン）
- 0: 低リスク - HttpBrowser.getHeaders のヘッダー変換処理

## 6) レビュアーチェックリスト（最小）
- [ ] Request クラスのパラメータ文字列変換テスト（UT-BRK-002, 003）が array_walk_recursive の動作を正しく検証しているか
- [ ] Response.getHeader のヘッダー名正規化テスト（UT-BRK-020, 021）が str_replace('-', '_', strtolower()) の動作を正しく検証しているか
- [ ] Response.toArray のJSONデコードエラーテスト（UT-BRK-029, 030）が JsonException と非配列の両方をカバーしているか
- [ ] Cookie.fromString のテスト（UT-BRK-038〜048）が主要なSet-Cookie属性パターンを網羅しているか
- [ ] Cookie.isExpired のテスト（UT-BRK-059〜062）が時刻依存の境界値を適切にカバーしているか
- [ ] CookieJar のドメインマッチング（UT-BRK-071, 074, 086）がサブドメイン・ドット付きドメインのロジックを正しく検証しているか
- [ ] AbstractBrowser.followRedirect のテスト（UT-BRK-153〜157）が301/302/303のGET変換と307のメソッド維持を正しく区別しているか
- [ ] AbstractBrowser.getAbsoluteUri のテスト（UT-BRK-159〜165）が全URI解決パターン（絶対、ルート相対、ディレクトリ相対、プロトコル相対、クエリ、フラグメント）を網羅しているか
- [ ] HttpBrowser のテスト（UT-BRK-172〜178）がHttpClientInterface のモックを適切に使用する設計になっているか
