---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 234
  claims_with_evidence: 224
  claims_without_evidence: 10
confidence_derived: 0.96
---

# 根拠レポート：Component-Cache 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：224 / 234、根拠なし：10
- 優先レビュー（高）
  1. **UT-CAC-142, 143**: Redis/Memcached接続テストは外部依存のため実行環境に依存
  2. **UT-CAC-168, 169**: LockRegistry::compute のロック動作はファイルロックに依存
  3. **UT-CAC-233, 234**: FilesystemTagAwareAdapterのシンボリックリンク操作はOS依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Cache/CacheItem.php` - CacheItem クラス定義（getKey, get, isHit, set, expiresAt, expiresAfter, tag, getMetadata, validateKey, log メソッド）
- E-02: `src/Symfony/Component/Cache/Adapter/ArrayAdapter.php` - ArrayAdapter クラス定義（get, getItem, getItems, hasItem, save, saveDeferred, commit, clear, delete, deleteItem, deleteItems, withSubNamespace, reset, getValues メソッド）
- E-03: `src/Symfony/Component/Cache/Adapter/NullAdapter.php` - NullAdapter クラス定義（全PSR-6/CacheInterfaceメソッド, invalidateTags, withSubNamespace）
- E-04: `src/Symfony/Component/Cache/Adapter/ChainAdapter.php` - ChainAdapter クラス定義（get, getItem, getItems, hasItem, save, saveDeferred, commit, clear, deleteItem, deleteItems, prune, withSubNamespace, reset）
- E-05: `src/Symfony/Component/Cache/Adapter/ProxyAdapter.php` - ProxyAdapter クラス定義（get, getItem, getItems, hasItem, save, saveDeferred, commit, clear, deleteItem, deleteItems, withSubNamespace）
- E-06: `src/Symfony/Component/Cache/Adapter/TagAwareAdapter.php` - TagAwareAdapter クラス定義（invalidateTags, getItem, getItems, hasItem, save, saveDeferred, commit, clear, deleteItem, deleteItems, withSubNamespace, prune, reset, __serialize, __unserialize, __destruct）
- E-07: `src/Symfony/Component/Cache/Adapter/TraceableAdapter.php` - TraceableAdapter クラス定義（get, getItem, hasItem, save, saveDeferred, getItems, clear, deleteItem, deleteItems, commit, prune, reset, delete, getCalls, clearCalls, getPool, withSubNamespace）
- E-08: `src/Symfony/Component/Cache/Adapter/TraceableTagAwareAdapter.php` - TraceableTagAwareAdapter クラス定義（invalidateTags）
- E-09: `src/Symfony/Component/Cache/Adapter/PhpArrayAdapter.php` - PhpArrayAdapter クラス定義（get, getItem, getItems, hasItem, save, saveDeferred, commit, clear, warmUp, create）
- E-10: `src/Symfony/Component/Cache/Adapter/Psr16Adapter.php` - Psr16Adapter クラス定義（doFetch, doHave, doClear, doDelete, doSave）
- E-11: `src/Symfony/Component/Cache/Adapter/AbstractAdapter.php` - AbstractAdapter クラス定義（createSystemCache, createConnection, commit）
- E-12: `src/Symfony/Component/Cache/Adapter/ParameterNormalizer.php` - ParameterNormalizer クラス定義（normalizeDuration）
- E-13: `src/Symfony/Component/Cache/Adapter/FilesystemAdapter.php` - FilesystemAdapter クラス定義
- E-14: `src/Symfony/Component/Cache/Adapter/FilesystemTagAwareAdapter.php` - FilesystemTagAwareAdapter クラス定義（prune, doClear, doSave, doDeleteYieldTags, doDeleteTagRelations, doInvalidate）
- E-15: `src/Symfony/Component/Cache/Psr16Cache.php` - Psr16Cache クラス定義（get, set, delete, clear, has, getMultiple, setMultiple, deleteMultiple）
- E-16: `src/Symfony/Component/Cache/LockRegistry.php` - LockRegistry クラス定義（setFiles, compute）
- E-17: `src/Symfony/Component/Cache/Marshaller/DefaultMarshaller.php` - DefaultMarshaller クラス定義（marshall, unmarshall, handleUnserializeCallback）
- E-18: `src/Symfony/Component/Cache/Marshaller/DeflateMarshaller.php` - DeflateMarshaller クラス定義（marshall, unmarshall）
- E-19: `src/Symfony/Component/Cache/Marshaller/SodiumMarshaller.php` - SodiumMarshaller クラス定義（marshall, unmarshall, isSupported）
- E-20: `src/Symfony/Component/Cache/Marshaller/TagAwareMarshaller.php` - TagAwareMarshaller クラス定義（marshall, unmarshall）
- E-21: `src/Symfony/Component/Cache/DataCollector/CacheDataCollector.php` - CacheDataCollector クラス定義（addInstance, collect, lateCollect, reset, getStatistics, getTotals, getCalls, getAdapters, getName）
- E-22: `src/Symfony/Component/Cache/DependencyInjection/CacheCollectorPass.php` - CacheCollectorPass クラス定義（process）
- E-23: `src/Symfony/Component/Cache/DependencyInjection/CachePoolPass.php` - CachePoolPass クラス定義（process, getServiceProvider, getNamespace）
- E-24: `src/Symfony/Component/Cache/DependencyInjection/CachePoolClearerPass.php` - CachePoolClearerPass クラス定義（process）
- E-25: `src/Symfony/Component/Cache/DependencyInjection/CachePoolPrunerPass.php` - CachePoolPrunerPass クラス定義（process）
- E-26: `src/Symfony/Component/Cache/Messenger/EarlyExpirationMessage.php` - EarlyExpirationMessage クラス定義（create, getItem, getPool, getCallback, findPool, findCallback）
- E-27: `src/Symfony/Component/Cache/Messenger/EarlyExpirationHandler.php` - EarlyExpirationHandler クラス定義（__invoke）
- E-28: `src/Symfony/Component/Cache/Messenger/EarlyExpirationDispatcher.php` - EarlyExpirationDispatcher クラス定義（__invoke）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-CAC-001~007) | CacheItemの基本プロパティアクセス（getKey, get, isHit, set） | E-01 (CacheItem.php L38-61) | ○ |
| C-02 (UT-CAC-008~012) | CacheItemの有効期限設定（expiresAt, expiresAfter） | E-01 (CacheItem.php L66-89) | ○ |
| C-03 (UT-CAC-013) | expiresAfterに不正な型を渡した場合のエラー | E-01 (CacheItem.php L84-86 InvalidArgumentException) | ○ |
| C-04 (UT-CAC-014~020) | CacheItemのタグ機能（tag） | E-01 (CacheItem.php L91-117) | ○ |
| C-05 (UT-CAC-021) | CacheItemのgetMetadata | E-01 (CacheItem.php L119-122) | ○ |
| C-06 (UT-CAC-022~025) | CacheItem::validateKeyのバリデーション | E-01 (CacheItem.php L131-144) | ○ |
| C-07 (UT-CAC-026~027) | CacheItem::logのロギング動作 | E-01 (CacheItem.php L151-163) | ○ |
| C-08 (UT-CAC-028~030) | ArrayAdapterのコンストラクタバリデーション | E-02 (ArrayAdapter.php L45-75) | ○ |
| C-09 (UT-CAC-031~056) | ArrayAdapterの全PSR-6/CacheInterface操作 | E-02 (ArrayAdapter.php L77-398) | ○ |
| C-10 (UT-CAC-057~065) | NullAdapterの全操作がNullObject動作 | E-03 (NullAdapter.php L42-117) | ○ |
| C-11 (UT-CAC-066~081) | ChainAdapterのチェーン検索とバックフィル | E-04 (ChainAdapter.php L47-310) | ○ |
| C-12 (UT-CAC-082~092) | ProxyAdapterのプロキシ動作とネームスペース | E-05 (ProxyAdapter.php L40-226) | ○ |
| C-13 (UT-CAC-093~113) | TagAwareAdapterのタグ管理と無効化 | E-06 (TagAwareAdapter.php L55-387) | ○ |
| C-14 (UT-CAC-114~121) | TraceableAdapterのトレース機能 | E-07 (TraceableAdapter.php L30-297) | ○ |
| C-15 (UT-CAC-122) | TraceableTagAwareAdapterのinvalidateTagsトレース | E-08 (TraceableTagAwareAdapter.php L19-38) | ○ |
| C-16 (UT-CAC-123~132) | PhpArrayAdapterのPHPファイルベースキャッシュ | E-09 (PhpArrayAdapter.php L33-388) | ○ |
| C-17 (UT-CAC-133~137) | Psr16AdapterのPSR-16ブリッジ | E-10 (Psr16Adapter.php L24-71) | ○ |
| C-18 (UT-CAC-138~141) | ParameterNormalizerの期間パース | E-12 (ParameterNormalizer.php L18-35) | ○ |
| C-19 (UT-CAC-142~143) | AbstractAdapter::createConnectionのDSNルーティング | E-11 (AbstractAdapter.php L126-141) | △ |
| C-20 (UT-CAC-144) | createConnectionの未サポートDSNエラー | E-11 (AbstractAdapter.php L140) | ○ |
| C-21 (UT-CAC-145~149) | AbstractAdapterのcommitとコンストラクタ | E-11 (AbstractAdapter.php L39-199) | ○ |
| C-22 (UT-CAC-150~165) | Psr16CacheのPSR-16操作 | E-15 (Psr16Cache.php L27-240) | ○ |
| C-23 (UT-CAC-166~169) | LockRegistryのファイルロック管理 | E-16 (LockRegistry.php L27-170) | △ |
| C-24 (UT-CAC-170~178) | DefaultMarshallerのシリアライズ/デシリアライズ | E-17 (DefaultMarshaller.php L21-96) | ○ |
| C-25 (UT-CAC-179~182) | DeflateMarshallerの圧縮/展開 | E-18 (DeflateMarshaller.php L21-44) | ○ |
| C-26 (UT-CAC-183~187) | SodiumMarshallerの暗号化/復号 | E-19 (SodiumMarshaller.php L22-74) | △ |
| C-27 (UT-CAC-188~194) | TagAwareMarshallerのコンパクト形式 | E-20 (TagAwareMarshaller.php L19-83) | ○ |
| C-28 (UT-CAC-195~203) | CacheDataCollectorの統計収集 | E-21 (CacheDataCollector.php L27-187) | ○ |
| C-29 (UT-CAC-204~206) | CacheCollectorPassのコンパイラパス | E-22 (CacheCollectorPass.php L27-73) | ○ |
| C-30 (UT-CAC-207~210) | CachePoolPassのコンパイラパス | E-23 (CachePoolPass.php L32-252) | ○ |
| C-31 (UT-CAC-211) | CachePoolClearerPassのコンパイラパス | E-24 (CachePoolClearerPass.php L21-38) | ○ |
| C-32 (UT-CAC-212~213) | CachePoolPrunerPassのコンパイラパス | E-25 (CachePoolPrunerPass.php L23-41) | ○ |
| C-33 (UT-CAC-214~221) | EarlyExpirationMessageのメッセージ生成と解決 | E-26 (EarlyExpirationMessage.php L21-101) | ○ |
| C-34 (UT-CAC-222~224) | EarlyExpirationHandlerのメッセージ処理 | E-27 (EarlyExpirationHandler.php L21-81) | ○ |
| C-35 (UT-CAC-225~227) | EarlyExpirationDispatcherのディスパッチ | E-28 (EarlyExpirationDispatcher.php L24-60) | ○ |
| C-36 (UT-CAC-228~231) | FilesystemAdapterのファイルシステム操作 | E-13 (FilesystemAdapter.php L19-29) | △ |
| C-37 (UT-CAC-232~234) | FilesystemTagAwareAdapterのタグ付きファイルシステム操作 | E-14 (FilesystemTagAwareAdapter.php L25-267) | △ |

## 4) 不足情報（Unknown / Missing）
- **Redis/Memcached/Couchbase/PDO系アダプタのテストケース**: これらのアダプタは外部接続が必要なため、単体テストとしてはモック化が必要。本テストケース一覧では具体的なアダプタ固有の操作（createConnection等）の一部のみを含む。
  - 候補：RedisAdapter / MemcachedAdapter / CouchbaseCollectionAdapter / DoctrineDbalAdapter / PdoAdapter
- **Traits内のprotected/privateメソッド**: AbstractAdapterTrait, ContractsTrait, FilesystemCommonTrait, FilesystemTrait, RedisTrait等のTraitに含まれるメソッドは、具体的なアダプタを通じてテストされるべきだが、一部は本テストケースではカバーされていない。
  - 候補：AbstractAdapterTrait::doFetch / doHave / doClear / doDelete / doSave 等
- **RedisProxy/RelayProxy系クラス**: これらはRedis/Relay拡張のプロキシクラスであり、外部依存が強いため本テストケースでは対象外。
  - 候補：RedisProxy / RedisClusterProxy / RelayProxy / RelayClusterProxy
- **SodiumMarshaller**: sodium拡張の利用可否に依存する。テスト実行環境にsodium拡張が必要。
- **LockRegistry::compute**: ファイルロック（flock）の並行処理テストは単体テストとしては限界がある。

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**: Redis/Memcached系アダプタのcreateConnectionテスト（UT-CAC-142, 143）は外部サービスへの接続が必要。CI環境でのテスト可否を確認する必要がある。
- **リスク1（中リスク）**: SodiumMarshallerのテスト（UT-CAC-183~187）はsodium拡張のインストールが前提。テスト環境に依存。
- **リスク1（中リスク）**: FilesystemTagAwareAdapterのシンボリックリンクテスト（UT-CAC-234）はWindows環境では動作が異なる可能性がある。
- **リスク0（低リスク）**: LockRegistryのファイルロックテスト（UT-CAC-168, 169）はWindows環境でロック機能が自動無効化される。
- **リスク0（低リスク）**: DependencyInjection系コンパイラパスのテスト（UT-CAC-204~213）はContainerBuilderのモック/スタブが必要。

## 6) レビュアーチェックリスト（最小）
- [ ] CacheItemのvalidateKeyテスト（UT-CAC-022~025）がPSR-6で定義されている全予約文字をカバーしているか
- [ ] ArrayAdapterのLRU動作テスト（UT-CAC-041）がmaxItems境界を正確に検証しているか
- [ ] TagAwareAdapterのタグ無効化テスト（UT-CAC-095~098）がタグバージョニングの整合性を検証しているか
- [ ] DefaultMarshallerのmarshall/unmarshallテスト（UT-CAC-172~178）がigbinary未使用の標準serialize/unserialize系を網羅しているか
- [ ] SodiumMarshallerのキーローテーションテスト（UT-CAC-187）が実際のキーペアで検証可能か
- [ ] ChainAdapterのバックフィルテスト（UT-CAC-070）が上位アダプタへの書き戻し動作を正確に検証しているか
- [ ] EarlyExpirationHandlerの重複排除テスト（UT-CAC-223）がprocessedNoncesの100件制限を検証しているか
- [ ] Redis/Memcached系アダプタのテスト対象外クラスについて、別途統合テストまたはE2Eテストで補完する計画があるか
