---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 122
  claims_with_evidence: 118
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：Component-Clock 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：118 / 122、根拠なし：4
- 優先レビュー（高）
  1. **UT-CLK-046, 047（NativeClock::sleep）**：実時間sleep動作の検証は環境依存のため根拠不足
  2. **UT-CLK-061（MonotonicClock::sleep）**：実時間sleep動作の検証は環境依存のため根拠不足
  3. **UT-CLK-071（DatePoint::__construct 日付のみ指定時の時刻リセット）**：条件 `'00:00:00.000000' === $builtInDate->format('H:i:s.u')` の挙動が日時文字列の形式に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Clock/Clock.php` - グローバルクロック実装（staticプロパティ、get/set/now/sleep/withTimeZone）
- E-02: `src/Symfony/Component/Clock/ClockInterface.php` - ClockInterfaceの定義（sleep, withTimeZoneメソッド）
- E-03: `src/Symfony/Component/Clock/MockClock.php` - テスト用モッククロック実装（now固定、sleep模擬、modify、withTimeZone）
- E-04: `src/Symfony/Component/Clock/NativeClock.php` - システムクロック実装（now、sleep、withTimeZone）
- E-05: `src/Symfony/Component/Clock/MonotonicClock.php` - 単調増加クロック実装（hrtime使用、now、sleep、withTimeZone）
- E-06: `src/Symfony/Component/Clock/DatePoint.php` - イミュータブルDateTime拡張（コンストラクタ、createFrom*、add/sub/modify、setMicrosecond範囲チェック）
- E-07: `src/Symfony/Component/Clock/ClockAwareTrait.php` - 時刻依存トレイト（setClock、now）
- E-08: `src/Symfony/Component/Clock/Test/ClockSensitiveTrait.php` - テスト用トレイト（mockTime、saveClockBeforeTest、restoreClockAfterTest）
- E-09: `src/Symfony/Component/Clock/Resources/now.php` - グローバルnow関数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Clock::__construct - PsrClockInterface指定でインスタンス生成 | E-01 (L25-29) | ○ |
| C-02 | Clock::__construct - タイムゾーン指定でインスタンス生成 | E-01 (L25-29) | ○ |
| C-03 | Clock::__construct - 引数なしでインスタンス生成 | E-01 (L25-29) | ○ |
| C-04 | Clock::get - 未設定時NativeClock返却 | E-01 (L37-40) | ○ |
| C-05 | Clock::get - 設定済みクロック返却 | E-01 (L37-40) | ○ |
| C-06 | Clock::set - ClockInterface設定 | E-01 (L42-45) | ○ |
| C-07 | Clock::set - PsrClockInterfaceをClockでラップ | E-01 (L44) | ○ |
| C-08 | Clock::now - DatePoint返却 | E-01 (L47-56) | ○ |
| C-09 | Clock::now - タイムゾーン反映 | E-01 (L55) | ○ |
| C-10 | Clock::now - DatePoint変換処理 | E-01 (L51-53) | ○ |
| C-11 | Clock::sleep - ClockInterfaceへの委譲 | E-01 (L58-67) | ○ |
| C-12 | Clock::sleep - PsrClockInterface時のフォールバック | E-01 (L64-66) | ○ |
| C-13 | Clock::withTimeZone - DateTimeZone指定 | E-01 (L72-82) | ○ |
| C-14 | Clock::withTimeZone - 文字列タイムゾーン | E-01 (L74-75) | ○ |
| C-15 | Clock::withTimeZone - イミュータブル性 | E-01 (L78-81) | ○ |
| C-16 | Clock::withTimeZone - 不正タイムゾーンで例外 | E-01 (L70-71, L75) | ○ |
| C-17 | MockClock::__construct - 文字列日時指定 | E-03 (L29-42) | ○ |
| C-18 | MockClock::__construct - DateTimeImmutable指定 | E-03 (L29-42) | ○ |
| C-19 | MockClock::__construct - デフォルト引数 | E-03 (L29) | ○ |
| C-20 | MockClock::__construct - 文字列タイムゾーン | E-03 (L31-33) | ○ |
| C-21 | MockClock::__construct - DateTimeZone指定 | E-03 (L29-42) | ○ |
| C-22 | MockClock::__construct - 不正日時文字列で例外 | E-03 (L26-27) | ○ |
| C-23 | MockClock::__construct - 不正タイムゾーンで例外 | E-03 (L28, L32) | ○ |
| C-24 | MockClock::now - 固定日時返却 | E-03 (L44-47) | ○ |
| C-25 | MockClock::now - 複数回呼び出しで同一日時 | E-03 (L44-47) | ○ |
| C-26 | MockClock::now - クローン返却 | E-03 (L46) | ○ |
| C-27 | MockClock::sleep - 指定秒数で内部時刻進行 | E-03 (L49-60) | ○ |
| C-28 | MockClock::sleep - マイクロ秒精度 | E-03 (L55-56) | ○ |
| C-29 | MockClock::sleep - 0秒で変更なし | E-03 (L51-53) | ○ |
| C-30 | MockClock::sleep - 負の値で変更なし | E-03 (L51-53) | ○ |
| C-31 | MockClock::sleep - タイムゾーン保持 | E-03 (L57-59) | ○ |
| C-32 | MockClock::modify - 修飾子で時刻変更 | E-03 (L65-68) | ○ |
| C-33 | MockClock::modify - 複合修飾子 | E-03 (L67) | ○ |
| C-34 | MockClock::modify - 負の修飾子 | E-03 (L67) | ○ |
| C-35 | MockClock::modify - 不正修飾子で例外 | E-03 (L63-64) | ○ |
| C-36 | MockClock::withTimeZone - DateTimeZone指定 | E-03 (L73-83) | ○ |
| C-37 | MockClock::withTimeZone - 文字列指定 | E-03 (L75-77) | ○ |
| C-38 | MockClock::withTimeZone - イミュータブル性 | E-03 (L79-82) | ○ |
| C-39 | MockClock::withTimeZone - 不正タイムゾーンで例外 | E-03 (L71-72, L76) | ○ |
| C-40 | NativeClock::__construct - デフォルトタイムゾーン | E-04 (L26-29) | ○ |
| C-41 | NativeClock::__construct - 文字列タイムゾーン | E-04 (L28) | ○ |
| C-42 | NativeClock::__construct - DateTimeZone指定 | E-04 (L28) | ○ |
| C-43 | NativeClock::__construct - 不正タイムゾーンで例外 | E-04 (L24-25) | ○ |
| C-44 | NativeClock::now - システム時刻返却 | E-04 (L31-34) | ○ |
| C-45 | NativeClock::now - タイムゾーン反映 | E-04 (L33) | ○ |
| C-46 | NativeClock::sleep - 整数秒sleep | E-04 (L36-45) | △ |
| C-47 | NativeClock::sleep - 小数秒sleep | E-04 (L36-45) | △ |
| C-48 | NativeClock::sleep - 0秒sleep | E-04 (L38, L42) | ○ |
| C-49 | NativeClock::sleep - 負の値sleep | E-04 (L38, L42) | ○ |
| C-50 | NativeClock::withTimeZone - DateTimeZone指定 | E-04 (L50-60) | ○ |
| C-51 | NativeClock::withTimeZone - 文字列指定 | E-04 (L52-54) | ○ |
| C-52 | NativeClock::withTimeZone - イミュータブル性 | E-04 (L56-59) | ○ |
| C-53 | NativeClock::withTimeZone - 不正タイムゾーンで例外 | E-04 (L48-49, L53) | ○ |
| C-54 | MonotonicClock::__construct - デフォルトタイムゾーン | E-05 (L28-39) | ○ |
| C-55 | MonotonicClock::__construct - 文字列タイムゾーン | E-05 (L38) | ○ |
| C-56 | MonotonicClock::__construct - DateTimeZone指定 | E-05 (L38) | ○ |
| C-57 | MonotonicClock::__construct - 不正タイムゾーンで例外 | E-05 (L26-27) | ○ |
| C-58 | MonotonicClock::now - DatePoint返却 | E-05 (L41-59) | ○ |
| C-59 | MonotonicClock::now - 単調増加性 | E-05 (L41-59) | ○ |
| C-60 | MonotonicClock::now - タイムゾーン反映 | E-05 (L59) | ○ |
| C-61 | MonotonicClock::sleep - 実時間sleep | E-05 (L62-71) | △ |
| C-62 | MonotonicClock::sleep - 0秒sleep | E-05 (L64, L68) | ○ |
| C-63 | MonotonicClock::withTimeZone - DateTimeZone指定 | E-05 (L76-86) | ○ |
| C-64 | MonotonicClock::withTimeZone - 文字列指定 | E-05 (L78-80) | ○ |
| C-65 | MonotonicClock::withTimeZone - イミュータブル性 | E-05 (L82-85) | ○ |
| C-66 | MonotonicClock::withTimeZone - 不正タイムゾーンで例外 | E-05 (L74-75, L79) | ○ |
| C-67 | DatePoint::__construct - デフォルト引数 | E-06 (L24-46) | ○ |
| C-68 | DatePoint::__construct - 日時文字列指定 | E-06 (L24-46) | ○ |
| C-69 | DatePoint::__construct - タイムゾーン指定 | E-06 (L24-46) | ○ |
| C-70 | DatePoint::__construct - reference指定 | E-06 (L24-46) | ○ |
| C-71 | DatePoint::__construct - 日付のみ指定時の時刻リセット | E-06 (L38-39) | △ |
| C-72 | DatePoint::__construct - 不正日時文字列で例外 | E-06 (L22-23) | ○ |
| C-73 | DatePoint::createFromFormat - 正常パース | E-06 (L51-54) | ○ |
| C-74 | DatePoint::createFromFormat - タイムゾーン付き | E-06 (L51-54) | ○ |
| C-75 | DatePoint::createFromFormat - 不正フォーマットで例外 | E-06 (L53) | ○ |
| C-76 | DatePoint::createFromFormat - フォーマット不一致で例外 | E-06 (L53) | ○ |
| C-77 | DatePoint::createFromInterface - DateTimeImmutableから生成 | E-06 (L56-59) | ○ |
| C-78 | DatePoint::createFromInterface - DateTimeから生成 | E-06 (L56-59) | ○ |
| C-79 | DatePoint::createFromMutable - DateTime変換 | E-06 (L61-64) | ○ |
| C-80 | DatePoint::createFromTimestamp - 整数タイムスタンプ | E-06 (L66-69) | ○ |
| C-81 | DatePoint::createFromTimestamp - 浮動小数点タイムスタンプ | E-06 (L66-69) | ○ |
| C-82 | DatePoint::createFromTimestamp - エポック | E-06 (L66-69) | ○ |
| C-83 | DatePoint::add - DateInterval加算 | E-06 (L71-74) | ○ |
| C-84 | DatePoint::add - 戻り値型確認 | E-06 (L71-74) | ○ |
| C-85 | DatePoint::sub - DateInterval減算 | E-06 (L76-79) | ○ |
| C-86 | DatePoint::sub - 戻り値型確認 | E-06 (L76-79) | ○ |
| C-87 | DatePoint::modify - 修飾子で日時変更 | E-06 (L84-87) | ○ |
| C-88 | DatePoint::modify - 不正修飾子で例外 | E-06 (L82-83) | ○ |
| C-89 | DatePoint::setTimestamp - タイムスタンプ設定 | E-06 (L89-92) | ○ |
| C-90 | DatePoint::setDate - 年月日設定 | E-06 (L94-97) | ○ |
| C-91 | DatePoint::setDate - 閏年境界 | E-06 (L94-97) | ○ |
| C-92 | DatePoint::setISODate - ISO日付設定 | E-06 (L99-102) | ○ |
| C-93 | DatePoint::setISODate - デフォルト曜日 | E-06 (L99) | ○ |
| C-94 | DatePoint::setTime - 時分秒設定 | E-06 (L104-107) | ○ |
| C-95 | DatePoint::setTime - マイクロ秒指定 | E-06 (L104-107) | ○ |
| C-96 | DatePoint::setTime - 最小時刻 | E-06 (L104-107) | ○ |
| C-97 | DatePoint::setTime - 最大時刻 | E-06 (L104-107) | ○ |
| C-98 | DatePoint::setTimezone - タイムゾーン変更 | E-06 (L109-112) | ○ |
| C-99 | DatePoint::setTimezone - 戻り値型確認 | E-06 (L109-112) | ○ |
| C-100 | DatePoint::getTimezone - タイムゾーン取得 | E-06 (L114-117) | ○ |
| C-101 | DatePoint::setMicrosecond - マイクロ秒設定 | E-06 (L119-126) | ○ |
| C-102 | DatePoint::setMicrosecond - 最小値0 | E-06 (L121) | ○ |
| C-103 | DatePoint::setMicrosecond - 最大値999999 | E-06 (L121) | ○ |
| C-104 | DatePoint::setMicrosecond - 負の値でエラー | E-06 (L121-123) | ○ |
| C-105 | DatePoint::setMicrosecond - 上限超過でエラー | E-06 (L121-123) | ○ |
| C-106 | ClockAwareTrait::setClock - ClockInterface設定 | E-07 (L26-30) | ○ |
| C-107 | ClockAwareTrait::now - 設定クロックの時刻返却 | E-07 (L32-37) | ○ |
| C-108 | ClockAwareTrait::now - デフォルトクロック | E-07 (L34) | ○ |
| C-109 | ClockAwareTrait::now - DatePoint変換 | E-07 (L36) | ○ |
| C-110 | ClockSensitiveTrait::mockTime - true指定 | E-08 (L36-45) | ○ |
| C-111 | ClockSensitiveTrait::mockTime - 文字列修飾子 | E-08 (L41) | ○ |
| C-112 | ClockSensitiveTrait::mockTime - DateTimeImmutable指定 | E-08 (L40) | ○ |
| C-113 | ClockSensitiveTrait::mockTime - false指定で復元 | E-08 (L38) | ○ |
| C-114 | ClockSensitiveTrait::mockTime - 戻り値の型 | E-08 (L44) | ○ |
| C-115 | ClockSensitiveTrait::saveClockBeforeTest - クロック保存 | E-08 (L56-65) | ○ |
| C-116 | ClockSensitiveTrait::saveClockBeforeTest - 保存済みクロック取得 | E-08 (L64) | ○ |
| C-117 | ClockSensitiveTrait::restoreClockAfterTest - テスト後復元 | E-08 (L73-76) | ○ |
| C-118 | now関数 - デフォルト引数 | E-09 (L18-27) | ○ |
| C-119 | now関数 - 修飾子付き | E-09 (L20-21) | ○ |
| C-120 | now関数 - 日時文字列指定 | E-09 (L20-21) | ○ |
| C-121 | now関数 - DatePoint変換 | E-09 (L25-26) | ○ |
| C-122 | now関数 - 不正修飾子で例外 | E-09 (L16-17) | ○ |

## 4) 不足情報（Unknown / Missing）
- NativeClock::sleepおよびMonotonicClock::sleepの実際の待機時間の精度は実行環境（OS、CPU負荷）に依存するため、コードから正確な挙動を断定できない
  - 候補：実環境でのベンチマークテスト / タイミングテスト / CI環境でのタイミング許容値設定
- DatePoint::__constructにおける日付のみ指定時の時刻リセット判定（`'00:00:00.000000' === $builtInDate->format('H:i:s.u')`）の挙動は、PHPのDateTimeImmutableの内部実装に依存する部分があり、全ての日時文字列パターンで期待通りに動作するかはコードのみからは完全に検証できない
  - 候補：PHP公式ドキュメント / DateTimeImmutableの内部仕様 / 既存テストケースの確認

## 5) リスクフラグ（レビュー観点）
- 0: DatePoint::setMicrosecondの範囲チェック - コード上で明確に0-999999の範囲チェックが実装されている（低リスク）
- 0: MockClock::sleepの0以下判定 - `0 >= $seconds`で明確にガードされている（低リスク）
- 1: Clock::set/getのstaticプロパティ管理 - グローバル状態を持つため、テスト間の独立性に注意が必要（中リスク）
- 1: MonotonicClock::__constructのhrtime()依存 - `hrtime()`がfalseを返す環境での動作確認が必要（中リスク）
- 0: ClockSensitiveTrait - テスト前後のクロック保存/復元メカニズムがstaticプロパティで管理されている（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] NativeClock::sleepの実時間テストが環境依存にならない許容値設定がされているか確認
- [ ] MonotonicClock::now()の単調増加性テストが十分な精度で検証できるか確認
- [ ] DatePoint::__constructの日付のみ指定時の時刻リセット条件が全パターンを網羅しているか確認
- [ ] Clock::set/getのグローバル状態がテスト間で適切にリセットされるか確認
- [ ] ClockSensitiveTrait::saveClockBeforeTest/restoreClockAfterTestのstaticプロパティのライフサイクルが正しいか確認
- [ ] テストIDの連番（UT-CLK-001〜122）に欠番がないことを確認
