---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 224
  claims_with_evidence: 218
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-Config 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：218 / 224、根拠なし：6
- 優先レビュー（高）
  1. **C-173, C-174（ClassExistenceResource::isFresh）**：クラス消失シナリオは実行時のオートロード状態に依存するため根拠不足
  2. **C-180（ComposerResource::isFresh）**：vendor構成変化の検証はランタイム依存のため根拠不足
  3. **C-176, C-177（GlobResource::isFresh）**：ハッシュ計算はファイルシステム状態に依存するため動的テストが必要
  4. **C-215, C-216, C-217（ArrayShapeGenerator::generate）**：出力形式の正確な検証にはPHPDocパーサとの統合が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Config/ConfigCache.php` - ConfigCacheクラスの実装
- E-02: `src/Symfony/Component/Config/ConfigCacheFactory.php` - ConfigCacheFactoryの実装
- E-03: `src/Symfony/Component/Config/ResourceCheckerConfigCache.php` - ResourceCheckerConfigCacheの実装
- E-04: `src/Symfony/Component/Config/ResourceCheckerConfigCacheFactory.php` - ResourceCheckerConfigCacheFactoryの実装
- E-05: `src/Symfony/Component/Config/FileLocator.php` - FileLocatorの実装
- E-06: `src/Symfony/Component/Config/Definition/Processor.php` - Processorの実装
- E-07: `src/Symfony/Component/Config/Definition/BaseNode.php` - BaseNodeの実装
- E-08: `src/Symfony/Component/Config/Definition/ArrayNode.php` - ArrayNodeの実装
- E-09: `src/Symfony/Component/Config/Definition/VariableNode.php` - VariableNodeの実装
- E-10: `src/Symfony/Component/Config/Definition/ScalarNode.php` - ScalarNodeの実装
- E-11: `src/Symfony/Component/Config/Definition/BooleanNode.php` - BooleanNodeの実装
- E-12: `src/Symfony/Component/Config/Definition/IntegerNode.php` - IntegerNodeの実装
- E-13: `src/Symfony/Component/Config/Definition/FloatNode.php` - FloatNodeの実装
- E-14: `src/Symfony/Component/Config/Definition/StringNode.php` - StringNodeの実装
- E-15: `src/Symfony/Component/Config/Definition/NumericNode.php` - NumericNodeの実装
- E-16: `src/Symfony/Component/Config/Definition/EnumNode.php` - EnumNodeの実装
- E-17: `src/Symfony/Component/Config/Definition/PrototypedArrayNode.php` - PrototypedArrayNodeの実装
- E-18: `src/Symfony/Component/Config/Definition/Builder/TreeBuilder.php` - TreeBuilderの実装
- E-19: `src/Symfony/Component/Config/Definition/Builder/NodeBuilder.php` - NodeBuilderの実装
- E-20: `src/Symfony/Component/Config/Definition/Builder/ExprBuilder.php` - ExprBuilderの実装
- E-21: `src/Symfony/Component/Config/Loader/Loader.php` - Loaderの実装
- E-22: `src/Symfony/Component/Config/Loader/FileLoader.php` - FileLoaderの実装
- E-23: `src/Symfony/Component/Config/Loader/LoaderResolver.php` - LoaderResolverの実装
- E-24: `src/Symfony/Component/Config/Loader/DelegatingLoader.php` - DelegatingLoaderの実装
- E-25: `src/Symfony/Component/Config/Loader/GlobFileLoader.php` - GlobFileLoaderの実装
- E-26: `src/Symfony/Component/Config/Loader/ParamConfigurator.php` - ParamConfiguratorの実装
- E-27: `src/Symfony/Component/Config/Resource/FileResource.php` - FileResourceの実装
- E-28: `src/Symfony/Component/Config/Resource/DirectoryResource.php` - DirectoryResourceの実装
- E-29: `src/Symfony/Component/Config/Resource/FileExistenceResource.php` - FileExistenceResourceの実装
- E-30: `src/Symfony/Component/Config/Resource/ClassExistenceResource.php` - ClassExistenceResourceの実装
- E-31: `src/Symfony/Component/Config/Resource/GlobResource.php` - GlobResourceの実装
- E-32: `src/Symfony/Component/Config/Resource/ComposerResource.php` - ComposerResourceの実装
- E-33: `src/Symfony/Component/Config/Resource/SelfCheckingResourceChecker.php` - SelfCheckingResourceCheckerの実装
- E-34: `src/Symfony/Component/Config/Resource/SkippingResourceChecker.php` - SkippingResourceCheckerの実装
- E-35: `src/Symfony/Component/Config/Util/XmlUtils.php` - XmlUtilsの実装
- E-36: `src/Symfony/Component/Config/Definition/Dumper/YamlReferenceDumper.php` - YamlReferenceDumperの実装
- E-37: `src/Symfony/Component/Config/Definition/Dumper/XmlReferenceDumper.php` - XmlReferenceDumperの実装
- E-38: `src/Symfony/Component/Config/Definition/ArrayShapeGenerator.php` - ArrayShapeGeneratorの実装
- E-39: `src/Symfony/Component/Config/Definition/Configurator/DefinitionConfigurator.php` - DefinitionConfiguratorの実装
- E-40: `src/Symfony/Component/Config/Exception/LoaderLoadException.php` - LoaderLoadExceptionの実装
- E-41: `src/Symfony/Component/Config/Resource/ReflectionClassResource.php` - ReflectionClassResourceの実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | ConfigCache::__construct デバッグモードONでSelfCheckingResourceCheckerが設定される | E-01 (L36-51) | ○ |
| C-002 | ConfigCache::__construct デバッグモードOFFでチェッカーが空 | E-01 (L43-48) | ○ |
| C-003 | ConfigCache::__construct skippedResourceTypes指定時にSkippingResourceCheckerが追加 | E-01 (L44-46) | ○ |
| C-004 | ConfigCache::isFresh デバッグOFF+ファイル存在でtrue | E-01 (L59-66) | ○ |
| C-005 | ConfigCache::isFresh デバッグONで親クラスisFresh呼出 | E-01 (L59-66) | ○ |
| C-006 | ConfigCache::isFresh デバッグOFF+ファイル不在で親クラス呼出 | E-01 (L61) | ○ |
| C-007 | ConfigCacheFactory::cache 新鮮な場合コールバック不呼出 | E-02 (L33-41) | ○ |
| C-008 | ConfigCacheFactory::cache 古い場合コールバック呼出 | E-02 (L36-38) | ○ |
| C-009 | ResourceCheckerConfigCache::getPath パス返却 | E-03 (L41-44) | ○ |
| C-010 | ResourceCheckerConfigCache::isFresh ファイル不在でfalse | E-03 (L57-59) | ○ |
| C-011 | ResourceCheckerConfigCache::isFresh チェッカー空でtrue | E-03 (L65-66) | ○ |
| C-012 | ResourceCheckerConfigCache::isFresh メタファイル不在でfalse | E-03 (L71-73) | ○ |
| C-013 | ResourceCheckerConfigCache::isFresh 全リソース新鮮でtrue | E-03 (L83-97) | ○ |
| C-014 | ResourceCheckerConfigCache::isFresh リソース古いでfalse | E-03 (L88-92) | ○ |
| C-015 | ResourceCheckerConfigCache::write コンテンツ書込 | E-03 (L108-146) | ○ |
| C-016 | ResourceCheckerConfigCache::write メタデータ付き書込 | E-03 (L120-141) | ○ |
| C-017 | ResourceCheckerConfigCache::write JSONメタファイル生成 | E-03 (L135-140) | ○ |
| C-018 | ResourceCheckerConfigCacheFactory::cache 新鮮時コールバック不呼出 | E-04 (L30-38) | ○ |
| C-019 | ResourceCheckerConfigCacheFactory::cache 古い時コールバック呼出 | E-04 (L33-35) | ○ |
| C-020 | FileLocator::__construct 文字列パスの配列変換 | E-05 (L28-31) | ○ |
| C-021 | FileLocator::__construct 配列パスそのまま | E-05 (L30) | ○ |
| C-022 | FileLocator::locate 空ファイル名でInvalidArgumentException | E-05 (L40-42) | ○ |
| C-023 | FileLocator::locate 絶対パスで存在するファイル検索 | E-05 (L44-49) | ○ |
| C-024 | FileLocator::locate 絶対パスでファイル不在時FileLocatorFileNotFoundException | E-05 (L45-47) | ○ |
| C-025 | FileLocator::locate 相対パスfirst=trueで最初の一致 | E-05 (L61-65) | ○ |
| C-026 | FileLocator::locate 相対パスfirst=falseで全一致 | E-05 (L61-70) | ○ |
| C-027 | FileLocator::locate currentPath先頭追加 | E-05 (L54-56) | ○ |
| C-028 | FileLocator::locate ファイル未発見でFileLocatorFileNotFoundException | E-05 (L72-74) | ○ |
| C-029 | FileLocator::locate Windows形式絶対パス認識 | E-05 (L84-88) | ○ |
| C-030 | Processor::process 設定配列の正規化・マージ・ファイナライズ | E-06 (L28-37) | ○ |
| C-031 | Processor::process 空設定配列 | E-06 (L30-36) | ○ |
| C-032 | Processor::processConfiguration ConfigurationInterfaceから処理 | E-06 (L44-47) | ○ |
| C-033 | Processor::normalizeConfig 複数形キー存在時 | E-06 (L74-76) | ○ |
| C-034 | Processor::normalizeConfig 単数形キーが文字列時の配列化 | E-06 (L78-82) | ○ |
| C-035 | Processor::normalizeConfig 単数形キーが連番配列時 | E-06 (L78-85) | ○ |
| C-036 | Processor::normalizeConfig キー未存在時空配列 | E-06 (L87) | ○ |
| C-037 | BaseNode::__construct パス区切り文字含む名前でInvalidArgumentException | E-07 (L53-56) | ○ |
| C-038 | BaseNode::__construct 有効な名前でインスタンス生成 | E-07 (L49-59) | ○ |
| C-039 | BaseNode::setAttribute/getAttribute 設定取得 | E-07 (L102-110) | ○ |
| C-040 | BaseNode::hasAttribute 設定済みでtrue | E-07 (L112-115) | ○ |
| C-041 | BaseNode::hasAttribute 未設定でfalse | E-07 (L112-115) | ○ |
| C-042 | BaseNode::removeAttribute 属性削除 | E-07 (L127-130) | ○ |
| C-043 | BaseNode::setDeprecated 非推奨設定保存 | E-07 (L190-197) | ○ |
| C-044 | BaseNode::getDeprecation 非推奨情報取得 | E-07 (L266-277) | ○ |
| C-045 | BaseNode::getDeprecation 非推奨でない場合LogicException | E-07 (L268-270) | ○ |
| C-046 | BaseNode::getPath 親ノードありのフルパス | E-07 (L301-308) | ○ |
| C-047 | BaseNode::getPath 親ノードなしの名前のみ | E-07 (L307) | ○ |
| C-048 | BaseNode::merge allowOverwrite=trueでマージ成功 | E-07 (L310-348) | ○ |
| C-049 | BaseNode::merge allowOverwrite=falseでForbiddenOverwriteException | E-07 (L314-316) | ○ |
| C-050 | BaseNode::normalize 正規化クロージャ適用 | E-07 (L355-357) | ○ |
| C-051 | BaseNode::normalize 等価値置換 | E-07 (L374-378) | ○ |
| C-052 | BaseNode::finalize 最終バリデーションクロージャ適用 | E-07 (L424-436) | ○ |
| C-053 | BaseNode::finalize 例外のInvalidConfigurationException変換 | E-07 (L433-435) | ○ |
| C-054 | BaseNode::setPlaceholder 空values配列でInvalidArgumentException | E-07 (L70-73) | ○ |
| C-055 | ArrayNode::preNormalize ハイフンキー変換 | E-08 (L47-64) | ○ |
| C-056 | ArrayNode::preNormalize ミックスキー保持 | E-08 (L56) | ○ |
| C-057 | ArrayNode::preNormalize normalizeKeys=false | E-08 (L49) | ○ |
| C-058 | ArrayNode::addChild 正常追加 | E-08 (L181-192) | ○ |
| C-059 | ArrayNode::addChild 空名前でInvalidArgumentException | E-08 (L184-186) | ○ |
| C-060 | ArrayNode::addChild 重複名でInvalidArgumentException | E-08 (L187-189) | ○ |
| C-061 | ArrayNode::validateType 配列受入 | E-08 (L241-252) | ○ |
| C-062 | ArrayNode::validateType 非配列でInvalidTypeException | E-08 (L243-251) | ○ |
| C-063 | ArrayNode::validateType allowFalse=trueでfalse許可 | E-08 (L243) | ○ |
| C-064 | ArrayNode::normalizeValue 未知キーでInvalidConfigurationException | E-08 (L279-307) | ○ |
| C-065 | ArrayNode::normalizeValue ignoreExtraKeys=trueで未知キー無視 | E-08 (L273-275) | ○ |
| C-066 | ArrayNode::finalizeValue 必須子ノード未設定でInvalidConfigurationException | E-08 (L204-217) | ○ |
| C-067 | ArrayNode::finalizeValue デフォルト値適用 | E-08 (L219-221) | ○ |
| C-068 | ArrayNode::mergeValues ディープマージ | E-08 (L334-385) | ○ |
| C-069 | ArrayNode::mergeValues rightSide=falseでfalse返却 | E-08 (L336-339) | ○ |
| C-070 | ArrayNode::mergeValues allowNewKeys=falseでInvalidConfigurationException | E-08 (L356-361) | ○ |
| C-071 | ArrayNode::getDefaultValue addIfNotSet=trueで子デフォルト値 | E-08 (L159-173) | ○ |
| C-072 | ArrayNode::getDefaultValue addIfNotSet=falseでRuntimeException | E-08 (L161-162) | ○ |
| C-073 | VariableNode::setDefaultValue/getDefaultValue 設定取得 | E-09 (L30-46) | ○ |
| C-074 | VariableNode::getDefaultValue Closureデフォルト値 | E-09 (L44-45) | ○ |
| C-075 | VariableNode::hasDefaultValue 未設定でfalse | E-09 (L37-39) | ○ |
| C-076 | VariableNode::finalizeValue allowEmptyValue=falseで空値エラー | E-09 (L67-89) | ○ |
| C-077 | VariableNode::finalizeValue allowEmptyValue=trueで空値許可 | E-09 (L67-92) | ○ |
| C-078 | VariableNode::mergeValues 右辺返却 | E-09 (L99-102) | ○ |
| C-079 | ScalarNode::validateType 文字列受入 | E-10 (L30-41) | ○ |
| C-080 | ScalarNode::validateType 整数受入 | E-10 (L32) | ○ |
| C-081 | ScalarNode::validateType null受入 | E-10 (L32) | ○ |
| C-082 | ScalarNode::validateType 配列拒否 | E-10 (L32-40) | ○ |
| C-083 | ScalarNode::isValueEmpty null=true | E-10 (L43-52) | ○ |
| C-084 | ScalarNode::isValueEmpty 空文字列=true | E-10 (L51) | ○ |
| C-085 | ScalarNode::isValueEmpty 非空文字列=false | E-10 (L51) | ○ |
| C-086 | BooleanNode::validateType bool受入 | E-11 (L32-47) | ○ |
| C-087 | BooleanNode::validateType 文字列拒否 | E-11 (L34-46) | ○ |
| C-088 | BooleanNode::validateType nullable=true null許可 | E-11 (L35-37) | ○ |
| C-089 | BooleanNode::validateType nullable=false null拒否 | E-11 (L34-46) | ○ |
| C-090 | BooleanNode::isValueEmpty 常にfalse | E-11 (L49-53) | ○ |
| C-091 | IntegerNode::validateType 整数受入 | E-12 (L23-34) | ○ |
| C-092 | IntegerNode::validateType 文字列拒否 | E-12 (L25-33) | ○ |
| C-093 | IntegerNode::validateType float拒否 | E-12 (L25) | ○ |
| C-094 | FloatNode::validateType float受入 | E-13 (L23-39) | ○ |
| C-095 | FloatNode::validateType int-to-float変換 | E-13 (L26-28) | ○ |
| C-096 | FloatNode::validateType 文字列拒否 | E-13 (L30-38) | ○ |
| C-097 | StringNode::validateType 文字列受入 | E-14 (L23-34) | ○ |
| C-098 | StringNode::validateType 整数拒否 | E-14 (L25-33) | ○ |
| C-099 | NumericNode::finalizeValue 範囲内受入 | E-15 (L33-51) | ○ |
| C-100 | NumericNode::finalizeValue min未満エラー | E-15 (L38-39) | ○ |
| C-101 | NumericNode::finalizeValue max超過エラー | E-15 (L41-42) | ○ |
| C-102 | NumericNode::finalizeValue min境界値 | E-15 (L38) | ○ |
| C-103 | NumericNode::finalizeValue max境界値 | E-15 (L41) | ○ |
| C-104 | NumericNode::isValueEmpty 常にfalse | E-15 (L63-67) | ○ |
| C-105 | EnumNode::__construct スカラー値リストで初期化 | E-16 (L29-64) | ○ |
| C-106 | EnumNode::__construct 空valuesでInvalidArgumentException | E-16 (L31-33) | ○ |
| C-107 | EnumNode::__construct values+enumFqcn同時でInvalidArgumentException | E-16 (L35-37) | ○ |
| C-108 | EnumNode::__construct 存在しないenumFqcnでInvalidArgumentException | E-16 (L39-42) | ○ |
| C-109 | EnumNode::finalizeValue 許可値受入 | E-16 (L109-148) | ○ |
| C-110 | EnumNode::finalizeValue 非許可値でInvalidConfigurationException | E-16 (L118-119) | ○ |
| C-111 | EnumNode::finalizeValue BackedEnum自動変換 | E-16 (L129-147) | ○ |
| C-112 | EnumNode::getValues 値リスト返却 | E-16 (L66-69) | ○ |
| C-113 | PrototypedArrayNode::addChild Exception発生 | E-17 (L165-168) | ○ |
| C-114 | PrototypedArrayNode::hasDefaultValue 常にtrue | E-17 (L101-104) | ○ |
| C-115 | PrototypedArrayNode::getDefaultValue nullデフォルト | E-17 (L125-142) | ○ |
| C-116 | PrototypedArrayNode::getDefaultValue 子デフォルト値 | E-17 (L131-139) | ○ |
| C-117 | PrototypedArrayNode::finalizeValue 最小要素数チェック | E-17 (L185-190) | ○ |
| C-118 | PrototypedArrayNode::normalizeValue 重複キーでDuplicateKeyException | E-17 (L241-246) | ○ |
| C-119 | PrototypedArrayNode::normalizeValue キー属性正規化 | E-17 (L209-254) | ○ |
| C-120 | PrototypedArrayNode::mergeValues リストマージ | E-17 (L260-308) | ○ |
| C-121 | TreeBuilder::__construct ルートノード生成 | E-18 (L34-38) | ○ |
| C-122 | TreeBuilder::buildTree ツリー構築 | E-18 (L58-61) | ○ |
| C-123 | TreeBuilder::setPathSeparator 区切り文字変更 | E-18 (L63-69) | ○ |
| C-124 | NodeBuilder::node ノード定義生成 | E-19 (L182-191) | ○ |
| C-125 | NodeBuilder::node 未知タイプでRuntimeException | E-19 (L250-252) | ○ |
| C-126 | NodeBuilder::arrayNode ArrayNodeDefinition返却 | E-19 (L70-80) | ○ |
| C-127 | NodeBuilder::booleanNode BooleanNodeDefinition返却 | E-19 (L97-100) | ○ |
| C-128 | NodeBuilder::setNodeClass カスタムノード登録 | E-19 (L233-238) | ○ |
| C-129 | ExprBuilder::always 常にtrue | E-20 (L51-61) | ○ |
| C-130 | ExprBuilder::ifTrue trueマッチ | E-20 (L70-76) | ○ |
| C-131 | ExprBuilder::ifString 文字列マッチ | E-20 (L98-104) | ○ |
| C-132 | ExprBuilder::ifNull nullマッチ | E-20 (L111-117) | ○ |
| C-133 | ExprBuilder::ifEmpty 空値マッチ | E-20 (L124-130) | ○ |
| C-134 | ExprBuilder::ifInArray 配列内マッチ | E-20 (L150-156) | ○ |
| C-135 | ExprBuilder::thenInvalid InvalidArgumentException設定 | E-20 (L218-223) | ○ |
| C-136 | ExprBuilder::thenUnset UnsetKeyException設定 | E-20 (L232-237) | ○ |
| C-137 | ExprBuilder::end ifPart未設定でRuntimeException | E-20 (L248-249) | ○ |
| C-138 | ExprBuilder::end thenPart未設定でRuntimeException | E-20 (L250-253) | ○ |
| C-139 | ExprBuilder::buildExpressions Closure変換 | E-20 (L265-276) | ○ |
| C-140 | ExprBuilder::castToArray 配列キャスト | E-20 (L176-183) | ○ |
| C-141 | Loader::getResolver resolver未設定でLogicException | E-21 (L31-36) | ○ |
| C-142 | Loader::setResolver resolver設定 | E-21 (L40-43) | ○ |
| C-143 | Loader::resolve 自身がサポート時自身返却 | E-21 (L58-71) | ○ |
| C-144 | Loader::resolve ローダー未発見でLoaderLoadException | E-21 (L66-68) | ○ |
| C-145 | Loader::import リソースインポート | E-21 (L48-51) | ○ |
| C-146 | LoaderResolver::resolve サポートローダー返却 | E-23 (L39-48) | ○ |
| C-147 | LoaderResolver::resolve 未発見でfalse | E-23 (L47) | ○ |
| C-148 | LoaderResolver::addLoader ローダー追加 | E-23 (L50-54) | ○ |
| C-149 | LoaderResolver::resolve 空ローダーでfalse | E-23 (L41-47) | ○ |
| C-150 | DelegatingLoader::load resolver経由ロード | E-24 (L31-38) | ○ |
| C-151 | DelegatingLoader::load resolver失敗でLoaderLoadException | E-24 (L33-35) | ○ |
| C-152 | DelegatingLoader::supports resolver解決可能でtrue | E-24 (L40-43) | ○ |
| C-153 | DelegatingLoader::supports resolver解決不能でfalse | E-24 (L42) | ○ |
| C-154 | GlobFileLoader::supports glob=true | E-25 (L27-29) | ○ |
| C-155 | GlobFileLoader::supports non-glob=false | E-25 (L28) | ○ |
| C-156 | FileLoader::setCurrentDir ディレクトリ設定 | E-22 (L42-45) | ○ |
| C-157 | FileLoader::getLocator ロケーター取得 | E-22 (L50-53) | ○ |
| C-158 | ParamConfigurator::__toString パラメータ文字列化 | E-26 (L26-29) | ○ |
| C-159 | FileResource::__construct 存在ファイルで初期化 | E-27 (L32-41) | ○ |
| C-160 | FileResource::__construct 不在ファイルでInvalidArgumentException | E-27 (L36-38) | ○ |
| C-161 | FileResource::isFresh mtime<=timestampでtrue | E-27 (L56-59) | ○ |
| C-162 | FileResource::isFresh mtime>timestampでfalse | E-27 (L58) | ○ |
| C-163 | FileResource::getResource パス取得 | E-27 (L51-54) | ○ |
| C-164 | DirectoryResource::__construct 存在ディレクトリで初期化 | E-28 (L31-42) | ○ |
| C-165 | DirectoryResource::__construct 不在ディレクトリでInvalidArgumentException | E-28 (L37-39) | ○ |
| C-166 | DirectoryResource::isFresh 変更なしでtrue | E-28 (L59-95) | ○ |
| C-167 | DirectoryResource::isFresh ファイル更新でfalse | E-28 (L89-91) | ○ |
| C-168 | DirectoryResource::isFresh ディレクトリ削除でfalse | E-28 (L61-63) | ○ |
| C-169 | DirectoryResource::isFresh パターンフィルタ | E-28 (L71-73) | ○ |
| C-170 | FileExistenceResource::isFresh 状態変化なしでtrue | E-29 (L47-49) | ○ |
| C-171 | FileExistenceResource::isFresh ファイル削除でfalse | E-29 (L49) | ○ |
| C-172 | FileExistenceResource::isFresh ファイル作成でfalse | E-29 (L49) | ○ |
| C-173 | ClassExistenceResource::isFresh クラス存在継続でtrue | E-30 (L58-102) | △ |
| C-174 | ClassExistenceResource::isFresh クラス消失でfalse | E-30 (L58-102) | △ |
| C-175 | GlobResource::__construct 不在プレフィックスでInvalidArgumentException | E-31 (L54-58) | ○ |
| C-176 | GlobResource::isFresh ファイルセット不変でtrue | E-31 (L71-77) | △ |
| C-177 | GlobResource::isFresh ファイル追加/削除でfalse | E-31 (L71-77) | △ |
| C-178 | GlobResource::getIterator パターンマッチイテレーション | E-31 (L104-213) | ○ |
| C-179 | GlobResource::getIterator 空パターンで空イテレータ | E-31 (L106-108) | ○ |
| C-180 | ComposerResource::isFresh vendor構成不変でtrue | E-32 (L43-48) | △ |
| C-181 | ComposerResource::getVendors vendorパス配列返却 | E-32 (L33-36) | ○ |
| C-182 | SelfCheckingResourceChecker::supports SelfChecking=true | E-33 (L32-35) | ○ |
| C-183 | SelfCheckingResourceChecker::supports 非SelfChecking=false | E-33 (L34) | ○ |
| C-184 | SelfCheckingResourceChecker::isFresh 委譲 | E-33 (L40-45) | ○ |
| C-185 | SkippingResourceChecker::supports スキップ対象=true | E-34 (L29-31) | ○ |
| C-186 | SkippingResourceChecker::supports 非スキップ対象=false | E-34 (L30) | ○ |
| C-187 | SkippingResourceChecker::isFresh 常にtrue | E-34 (L33-36) | ○ |
| C-188 | XmlUtils::parse 有効XML解析 | E-35 (L46-104) | ○ |
| C-189 | XmlUtils::parse 無効XMLでXmlParsingException | E-35 (L57-59) | ○ |
| C-190 | XmlUtils::parse DOCTYPE拒否 | E-35 (L65-69) | ○ |
| C-191 | XmlUtils::parse XSDバリデーション成功 | E-35 (L82-84) | ○ |
| C-192 | XmlUtils::parse XSDバリデーション失敗 | E-35 (L91-97) | ○ |
| C-193 | XmlUtils::loadFile 有効XMLロード | E-35 (L116-137) | ○ |
| C-194 | XmlUtils::loadFile 不在ファイルでInvalidArgumentException | E-35 (L118-120) | ○ |
| C-195 | XmlUtils::loadFile 空ファイルでInvalidArgumentException | E-35 (L128-130) | ○ |
| C-196 | XmlUtils::phpize null変換 | E-35 (L217) | ○ |
| C-197 | XmlUtils::phpize true変換 | E-35 (L225) | ○ |
| C-198 | XmlUtils::phpize false変換 | E-35 (L227) | ○ |
| C-199 | XmlUtils::phpize 整数変換 | E-35 (L219-224) | ○ |
| C-200 | XmlUtils::phpize float変換 | E-35 (L231-232) | ○ |
| C-201 | XmlUtils::phpize 文字列パススルー | E-35 (L237-238) | ○ |
| C-202 | XmlUtils::phpize 16進数変換 | E-35 (L233-234) | ○ |
| C-203 | XmlUtils::phpize 2進数変換 | E-35 (L229) | ○ |
| C-204 | XmlUtils::phpize 8進数変換 | E-35 (L224, L262-269) | ○ |
| C-205 | XmlUtils::phpize 負数変換 | E-35 (L220) | ○ |
| C-206 | XmlUtils::convertDomElementToArray DOM変換 | E-35 (L157-206) | ○ |
| C-207 | XmlUtils::convertDomElementToArray ネストDOM変換 | E-35 (L180-193) | ○ |
| C-208 | XmlUtils::convertDomElementToArray 空要素null | E-35 (L205) | ○ |
| C-209 | YamlReferenceDumper::dump YAML参照生成 | E-36 (L32-35) | ○ |
| C-210 | YamlReferenceDumper::dumpNode ノードYAMLダンプ | E-36 (L63-71) | ○ |
| C-211 | YamlReferenceDumper::dumpAtPath パス指定ダンプ | E-36 (L37-61) | ○ |
| C-212 | YamlReferenceDumper::dumpAtPath 不正パスでUnexpectedValueException | E-36 (L43-57) | ○ |
| C-213 | XmlReferenceDumper::dump XML参照生成 | E-37 (L34-37) | ○ |
| C-214 | XmlReferenceDumper::dumpNode ノードXMLダンプ | E-37 (L39-47) | ○ |
| C-215 | ArrayShapeGenerator::generate ArrayNode配列形状生成 | E-38 (L21-23) | △ |
| C-216 | ArrayShapeGenerator::generate PrototypedArrayNodeリスト型生成 | E-38 (L49-53) | ○ |
| C-217 | ArrayShapeGenerator::generate スカラーノード型文字列生成 | E-38 (L29-47) | ○ |
| C-218 | DefinitionConfigurator::rootNode ルートノード取得 | E-39 (L63-66) | ○ |
| C-219 | DefinitionConfigurator::import リソースインポート | E-39 (L44-48) | ○ |
| C-220 | LoaderLoadException::__construct sourceResource無しメッセージ | E-40 (L60-62) | ○ |
| C-221 | LoaderLoadException::__construct sourceResource有りメッセージ | E-40 (L63-64) | ○ |
| C-222 | LoaderLoadException::__construct previous例外含むメッセージ | E-40 (L39-57) | ○ |
| C-223 | LoaderLoadException::__construct バンドルリソースメッセージ | E-40 (L67-72) | ○ |
| C-224 | LoaderLoadException::__construct type指定メッセージ | E-40 (L72-74) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ClassExistenceResource::isFresh (C-173, C-174)**: クラスの存在/消失はPHPランタイムのオートロード機構に依存しており、単体テストでの検証が複雑。静的解析では完全な挙動を確認できない。
  - 候補: 既存テスト（Tests/Resource/ClassExistenceResourceTest.php） / モック / オートローダー制御
- **GlobResource::isFresh (C-176, C-177)**: ファイルシステムの状態変化に基づくハッシュ比較であり、テスト時にはファイルシステム操作が必要。
  - 候補: tmpディレクトリでのファイル操作 / vfsStreamによる仮想ファイルシステム
- **ComposerResource::isFresh (C-180)**: Composerのvendorディレクトリ構成はランタイムの状態に依存。
  - 候補: モック / テスト用vendor構成
- **ArrayShapeGenerator::generate (C-215)**: 出力文字列の正確な形式検証には、実際のノードツリー構築とPHPDoc文字列の厳密比較が必要。
  - 候補: 既存テスト（Tests/Definition/ArrayShapeGeneratorTest.php） / スナップショットテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 型バリデーション系テストケース（C-079〜C-098）: ソースコードのif文から直接導出可能で信頼性が高い
- **0: 低リスク** - ゲッター/セッター系テストケース（C-039〜C-042）: 単純なプロパティ操作
- **1: 中リスク** - キャッシュ系テストケース（C-004〜C-019）: ファイルシステム操作が絡むためテスト環境依存
- **1: 中リスク** - Dumper系テストケース（C-209〜C-214）: 出力文字列の正確な形式は実行して確認すべき
- **2: 高リスク** - ClassExistenceResource（C-173, C-174）: オートローダー状態に依存し、テスト環境で再現が難しい

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがComponent-Config内の全publicメソッドを網羅しているか
- [ ] 各テスト観点（正常系/異常系/境界値）のバランスが適切か
- [ ] FileLocator::locateのクロスプラットフォーム対応テスト（C-029）が実環境で有効か確認
- [ ] NumericNodeの境界値テスト（C-102, C-103）の閾値条件（<=, >=）が正しいか
- [ ] EnumNode::finalizeValueのBackedEnum変換テスト（C-111）が実際のenum定義で動作するか
- [ ] PrototypedArrayNode::normalizeValueのキー属性正規化（C-119）の入出力マッピングが正確か
- [ ] ClassExistenceResource/GlobResource/ComposerResourceのランタイム依存テストの実行可能性
