---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 250
  claims_with_evidence: 244
  claims_without_evidence: 6
confidence_derived: 0.98
---

# 根拠レポート：Component-CssSelector 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：244 / 250、根拠なし：6
- 優先レビュー（高）
  1. **UT-CSS-007（キャッシュ機構テスト）**：静的キャッシュの内部状態の検証方法が不明確
  2. **UT-CSS-008（空文字列入力時の挙動）**：EmptyStringParserの`==`演算子による比較の挙動がPHP型の暗黙変換に依存
  3. **UT-CSS-164（nth-child境界値 0n+0）**：実際のブラウザ挙動と一致するかの検証が必要
  4. **UT-CSS-184/187/191（null値のAttributeMatching）**：PHPの型安全性の観点で実行時の挙動確認が必要
  5. **UT-CSS-192（HtmlExtension初期化）**：Translatorとの連携による副作用の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/CssSelector/CssSelectorConverter.php` - メインエントリポイントクラス
- E-02: `src/Symfony/Component/CssSelector/XPath/Translator.php` - XPath変換のコアロジック
- E-03: `src/Symfony/Component/CssSelector/XPath/XPathExpr.php` - XPath式の値オブジェクト
- E-04: `src/Symfony/Component/CssSelector/Parser/Parser.php` - CSSパーサー本体
- E-05: `src/Symfony/Component/CssSelector/Parser/Reader.php` - 文字列リーダー
- E-06: `src/Symfony/Component/CssSelector/Parser/Token.php` - トークンクラス
- E-07: `src/Symfony/Component/CssSelector/Parser/TokenStream.php` - トークンストリーム
- E-08: `src/Symfony/Component/CssSelector/Node/Specificity.php` - CSS詳細度計算
- E-09: `src/Symfony/Component/CssSelector/Node/ElementNode.php` - 要素ノード
- E-10: `src/Symfony/Component/CssSelector/Node/ClassNode.php` - クラスノード
- E-11: `src/Symfony/Component/CssSelector/Node/HashNode.php` - ハッシュ(ID)ノード
- E-12: `src/Symfony/Component/CssSelector/Node/AttributeNode.php` - 属性ノード
- E-13: `src/Symfony/Component/CssSelector/Node/CombinedSelectorNode.php` - 結合セレクタノード
- E-14: `src/Symfony/Component/CssSelector/Node/FunctionNode.php` - 関数ノード
- E-15: `src/Symfony/Component/CssSelector/Node/PseudoNode.php` - 疑似クラスノード
- E-16: `src/Symfony/Component/CssSelector/Node/NegationNode.php` - 否定ノード
- E-17: `src/Symfony/Component/CssSelector/Node/MatchingNode.php` - :is()ノード
- E-18: `src/Symfony/Component/CssSelector/Node/SpecificityAdjustmentNode.php` - :where()ノード
- E-19: `src/Symfony/Component/CssSelector/Node/SelectorNode.php` - セレクタノード
- E-20: `src/Symfony/Component/CssSelector/Node/AbstractNode.php` - 抽象ノード
- E-21: `src/Symfony/Component/CssSelector/XPath/Extension/NodeExtension.php` - ノード変換拡張
- E-22: `src/Symfony/Component/CssSelector/XPath/Extension/CombinationExtension.php` - コンビネータ拡張
- E-23: `src/Symfony/Component/CssSelector/XPath/Extension/FunctionExtension.php` - 関数拡張
- E-24: `src/Symfony/Component/CssSelector/XPath/Extension/PseudoClassExtension.php` - 疑似クラス拡張
- E-25: `src/Symfony/Component/CssSelector/XPath/Extension/AttributeMatchingExtension.php` - 属性マッチング拡張
- E-26: `src/Symfony/Component/CssSelector/XPath/Extension/HtmlExtension.php` - HTML拡張
- E-27: `src/Symfony/Component/CssSelector/XPath/Extension/AbstractExtension.php` - 抽象拡張
- E-28: `src/Symfony/Component/CssSelector/Parser/Shortcut/EmptyStringParser.php` - 空文字列ショートカットパーサー
- E-29: `src/Symfony/Component/CssSelector/Parser/Shortcut/ElementParser.php` - 要素ショートカットパーサー
- E-30: `src/Symfony/Component/CssSelector/Parser/Shortcut/ClassParser.php` - クラスショートカットパーサー
- E-31: `src/Symfony/Component/CssSelector/Parser/Shortcut/HashParser.php` - ハッシュショートカットパーサー
- E-32: `src/Symfony/Component/CssSelector/Parser/Tokenizer/Tokenizer.php` - トークナイザー
- E-33: `src/Symfony/Component/CssSelector/Parser/Tokenizer/TokenizerEscaping.php` - エスケープ処理
- E-34: `src/Symfony/Component/CssSelector/Parser/Tokenizer/TokenizerPatterns.php` - パターン定義
- E-35: `src/Symfony/Component/CssSelector/Parser/Handler/WhitespaceHandler.php` - 空白ハンドラー
- E-36: `src/Symfony/Component/CssSelector/Parser/Handler/IdentifierHandler.php` - 識別子ハンドラー
- E-37: `src/Symfony/Component/CssSelector/Parser/Handler/HashHandler.php` - ハッシュハンドラー
- E-38: `src/Symfony/Component/CssSelector/Parser/Handler/StringHandler.php` - 文字列ハンドラー
- E-39: `src/Symfony/Component/CssSelector/Parser/Handler/NumberHandler.php` - 数値ハンドラー
- E-40: `src/Symfony/Component/CssSelector/Parser/Handler/CommentHandler.php` - コメントハンドラー
- E-41: `src/Symfony/Component/CssSelector/Exception/SyntaxErrorException.php` - 構文エラー例外

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CssSelectorConverter: HTMLモードでHtmlExtensionが登録される | E-01 (L42-44) | ○ |
| C-02 | CssSelectorConverter: XMLモードでHtmlExtensionは登録されない | E-01 (L42-47) | ○ |
| C-03 | CssSelectorConverter: toXPathでCSS→XPath変換が行われる | E-01 (L63-66), E-02 | ○ |
| C-04 | CssSelectorConverter: IDセレクタのXPath変換 | E-01, E-02, E-31 | ○ |
| C-05 | CssSelectorConverter: クラスセレクタのXPath変換 | E-01, E-02, E-30 | ○ |
| C-06 | CssSelectorConverter: カスタムprefix対応 | E-01 (L63) | ○ |
| C-07 | CssSelectorConverter: キャッシュ機構の動作 | E-01 (L65) | △ |
| C-08 | CssSelectorConverter: 空文字列のワイルドカード変換 | E-01, E-28 | △ |
| C-09 | Translator: デフォルト初期化で5つのExtensionが登録される | E-02 (L55-61) | ○ |
| C-10 | Translator: getXpathLiteralのシングルクォート変換 | E-02 (L66-67) | ○ |
| C-11 | Translator: getXpathLiteralのダブルクォート変換 | E-02 (L70-71) | ○ |
| C-12 | Translator: getXpathLiteralの両クォートconcat変換 | E-02 (L74-88) | ○ |
| C-13 | Translator: cssToXPathの基本変換 | E-02 (L90-103) | ○ |
| C-14 | Translator: 複数セレクタのパイプ区切り変換 | E-02 (L102) | ○ |
| C-15 | Translator: 疑似要素でExpressionErrorException | E-02 (L95-97) | ○ |
| C-16 | Translator: registerExtensionの動作 | E-02 (L113-124) | ○ |
| C-17 | Translator: getExtensionの未登録エラー | E-02 (L131-133) | ○ |
| C-18 | Translator: nodeToXPathの未対応ノードエラー | E-02 (L153-155) | ○ |
| C-19 | Translator: addCombinationの未対応エラー | E-02 (L165-167) | ○ |
| C-20 | Translator: addFunctionの未対応エラー | E-02 (L177-179) | ○ |
| C-21 | Translator: addPseudoClassの未対応エラー | E-02 (L189-191) | ○ |
| C-22 | Translator: addAttributeMatchingの未対応エラー | E-02 (L201-203) | ○ |
| C-23 | Translator: registerParserShortcutの動作 | E-02 (L141-146) | ○ |
| C-24 | XPathExpr: デフォルト引数での初期化 | E-03 (L26-35) | ○ |
| C-25 | XPathExpr: starPrefix=trueでの初期化 | E-03 (L32-34) | ○ |
| C-26 | XPathExpr: getElementの動作 | E-03 (L37-40) | ○ |
| C-27 | XPathExpr: addConditionの初回追加 | E-03 (L46-49) | ○ |
| C-28 | XPathExpr: addConditionのand結合 | E-03 (L47) | ○ |
| C-29 | XPathExpr: addConditionのor結合 | E-03 (L47) | ○ |
| C-30 | XPathExpr: addNameTestの動作（非ワイルドカード） | E-03 (L61-67) | ○ |
| C-31 | XPathExpr: addNameTestの動作（ワイルドカード） | E-03 (L62) | ○ |
| C-32 | XPathExpr: addStarPrefixの動作 | E-03 (L74-77) | ○ |
| C-33 | XPathExpr: joinの動作 | E-03 (L85-98) | ○ |
| C-34 | XPathExpr: joinでのwildcard path省略 | E-03 (L89-91) | ○ |
| C-35 | XPathExpr: __toStringの条件なし | E-03 (L100-106) | ○ |
| C-36 | XPathExpr: __toStringの条件あり | E-03 (L100-106) | ○ |
| C-37 | Parser: parseの基本動作 | E-04 (L37-43) | ○ |
| C-38 | Parser: 複数セレクタのパース | E-04 (L90-111) | ○ |
| C-39 | Parser: 子孫コンビネータ（スペース） | E-04 (L136-137) | ○ |
| C-40 | Parser: 子コンビネータ(>) | E-04 (L133-134) | ○ |
| C-41 | Parser: 隣接兄弟コンビネータ(+) | E-04 (L133-134) | ○ |
| C-42 | Parser: 一般兄弟コンビネータ(~) | E-04 (L133-134) | ○ |
| C-43 | Parser: 属性セレクタ(exists) | E-04 (L350-351) | ○ |
| C-44 | Parser: 属性セレクタ(=) | E-04 (L352-353) | ○ |
| C-45 | Parser: 属性セレクタ(^=) | E-04 (L354-358) | ○ |
| C-46 | Parser: 属性セレクタ($=) | E-04 (L354-358) | ○ |
| C-47 | Parser: 属性セレクタ(*=) | E-04 (L354-358) | ○ |
| C-48 | Parser: 属性セレクタ(~=) | E-04 (L354-358) | ○ |
| C-49 | Parser: 属性セレクタ(|=) | E-04 (L330-341) | ○ |
| C-50 | Parser: 属性セレクタ(!=) | E-04 (L354-358) | ○ |
| C-51 | Parser: :not()のパース | E-04 (L221-237) | ○ |
| C-52 | Parser: :is()のパース | E-04 (L238-246) | ○ |
| C-53 | Parser: :where()のパース | E-04 (L247-255) | ○ |
| C-54 | Parser: :nth-child()のパース | E-04 (L257-282) | ○ |
| C-55 | Parser: 名前空間付きセレクタ | E-04 (L296-319) | ○ |
| C-56 | Parser: ネストされた:not()のエラー | E-04 (L222-223) | ○ |
| C-57 | Parser: 不正構文のエラー | E-04 | ○ |
| C-58 | Parser: 疑似要素(::before)のパース | E-04 (L185-189) | ○ |
| C-59 | Parser: CSS2.1疑似要素(:before) | E-04 (L192-198) | ○ |
| C-60 | Parser: 疑似要素位置エラー | E-04 (L170-171) | ○ |
| C-61 | Parser: parseSeries('odd') | E-04 (L71-72) | ○ |
| C-62 | Parser: parseSeries('even') | E-04 (L73-74) | ○ |
| C-63 | Parser: parseSeries('n') | E-04 (L75-76) | ○ |
| C-64 | Parser: parseSeries('3') | E-04 (L77-78) | ○ |
| C-65 | Parser: parseSeries('2n+1') | E-04 (L80-87) | ○ |
| C-66 | Parser: parseSeries('-n+3') | E-04 (L84-85) | ○ |
| C-67 | Parser: parseSeries('+n') | E-04 (L85) | ○ |
| C-68 | Parser: parseSeries文字列トークンエラー | E-04 (L54-58) | ○ |
| C-69 | Reader: 初期化 | E-05 (L29-33) | ○ |
| C-70 | Reader: isEOF(非終端) | E-05 (L35-37) | ○ |
| C-71 | Reader: isEOF(終端) | E-05 (L35-37, L78-81) | ○ |
| C-72 | Reader: isEOF(空文字列) | E-05 (L31-37) | ○ |
| C-73 | Reader: getPosition | E-05 (L40-42) | ○ |
| C-74 | Reader: getRemainingLength | E-05 (L45-47) | ○ |
| C-75 | Reader: getRemainingLength(moveForward後) | E-05 (L45-47, L73-76) | ○ |
| C-76 | Reader: getSubstring | E-05 (L50-53) | ○ |
| C-77 | Reader: getSubstring(オフセット付き) | E-05 (L50-53) | ○ |
| C-78 | Reader: getOffset(発見) | E-05 (L55-60) | ○ |
| C-79 | Reader: getOffset(未発見) | E-05 (L55-60) | ○ |
| C-80 | Reader: findPattern(マッチ) | E-05 (L62-71) | ○ |
| C-81 | Reader: findPattern(非マッチ) | E-05 (L62-71) | ○ |
| C-82 | Reader: moveForward | E-05 (L73-76) | ○ |
| C-83 | Reader: moveToEnd | E-05 (L78-81) | ○ |
| C-84 | Token: 基本生成 | E-06 (L37-42) | ○ |
| C-85 | Token: isFileEnd(true) | E-06 (L62-65) | ○ |
| C-86 | Token: isFileEnd(false) | E-06 (L62-65) | ○ |
| C-87 | Token: isDelimiter(空配列) | E-06 (L67-78) | ○ |
| C-88 | Token: isDelimiter(値一致) | E-06 (L67-78) | ○ |
| C-89 | Token: isDelimiter(値不一致) | E-06 (L67-78) | ○ |
| C-90 | Token: isDelimiter(非デリミタ) | E-06 (L69-70) | ○ |
| C-91 | Token: isWhitespace | E-06 (L80-83) | ○ |
| C-92 | Token: isIdentifier | E-06 (L85-88) | ○ |
| C-93 | Token: isHash | E-06 (L90-93) | ○ |
| C-94 | Token: isNumber | E-06 (L95-98) | ○ |
| C-95 | Token: isString | E-06 (L100-103) | ○ |
| C-96 | Token: __toString(値あり) | E-06 (L105-112) | ○ |
| C-97 | Token: __toString(値なし) | E-06 (L105-112) | ○ |
| C-98 | TokenStream: push | E-07 (L48-53) | ○ |
| C-99 | TokenStream: getNext(順次取得) | E-07 (L70-84) | ○ |
| C-100 | TokenStream: getNext(空ストリーム例外) | E-07 (L79-81) | ○ |
| C-101 | TokenStream: getPeek(先読み) | E-07 (L89-97) | ○ |
| C-102 | TokenStream: getPeek(連続呼び出し) | E-07 (L91-93) | ○ |
| C-103 | TokenStream: getNextIdentifier(正常) | E-07 (L114-123) | ○ |
| C-104 | TokenStream: getNextIdentifier(エラー) | E-07 (L118-119) | ○ |
| C-105 | TokenStream: getNextIdentifierOrStar(識別子) | E-07 (L130-143) | ○ |
| C-106 | TokenStream: getNextIdentifierOrStar(スター) | E-07 (L138-140) | ○ |
| C-107 | TokenStream: getNextIdentifierOrStar(エラー) | E-07 (L142) | ○ |
| C-108 | TokenStream: skipWhitespace(空白あり) | E-07 (L148-155) | ○ |
| C-109 | TokenStream: skipWhitespace(空白なし) | E-07 (L148-155) | ○ |
| C-110 | TokenStream: getUsed | E-07 (L104-107) | ○ |
| C-111 | Specificity: 基本生成 | E-08 (L32-37) | ○ |
| C-112 | Specificity: plus加算 | E-08 (L39-42) | ○ |
| C-113 | Specificity: getValue計算 | E-08 (L44-47) | ○ |
| C-114 | Specificity: getValue(ゼロ) | E-08 (L44-47) | ○ |
| C-115 | Specificity: compareTo(a大) | E-08 (L53-57) | ○ |
| C-116 | Specificity: compareTo(a小) | E-08 (L53-57) | ○ |
| C-117 | Specificity: compareTo(b比較) | E-08 (L59-61) | ○ |
| C-118 | Specificity: compareTo(c比較) | E-08 (L63-65) | ○ |
| C-119 | Specificity: compareTo(等値) | E-08 (L67) | ○ |
| C-120 | ElementNode: 名前空間+要素名生成 | E-09 (L26-30) | ○ |
| C-121 | ElementNode: デフォルト生成 | E-09 (L27-29) | ○ |
| C-122 | ElementNode: getSpecificity(要素名あり) | E-09 (L42-45) | ○ |
| C-123 | ElementNode: getSpecificity(要素名なし) | E-09 (L42-45) | ○ |
| C-124 | ElementNode: __toString(名前空間あり) | E-09 (L47-52) | ○ |
| C-125 | ElementNode: __toString(名前空間なし) | E-09 (L47-52) | ○ |
| C-126 | ElementNode: __toString(ワイルドカード) | E-09 (L49) | ○ |
| C-127 | ClassNode: getSpecificity | E-10 (L42-45) | ○ |
| C-128 | ClassNode: __toString | E-10 (L47-50) | ○ |
| C-129 | HashNode: getSpecificity | E-11 (L42-45) | ○ |
| C-130 | HashNode: __toString | E-11 (L47-50) | ○ |
| C-131 | AttributeNode: getSpecificity | E-12 (L60-63) | ○ |
| C-132 | AttributeNode: __toString(exists) | E-12 (L65-73) | ○ |
| C-133 | AttributeNode: __toString(=) | E-12 (L65-73) | ○ |
| C-134 | CombinedSelectorNode: getSpecificity | E-13 (L48-51) | ○ |
| C-135 | CombinedSelectorNode: __toString(子孫) | E-13 (L53-58) | ○ |
| C-136 | CombinedSelectorNode: __toString(子) | E-13 (L53-58) | ○ |
| C-137 | FunctionNode: 名前小文字変換 | E-14 (L38) | ○ |
| C-138 | FunctionNode: getSpecificity | E-14 (L59-62) | ○ |
| C-139 | PseudoNode: 識別子小文字変換 | E-15 (L32) | ○ |
| C-140 | PseudoNode: getSpecificity | E-15 (L45-48) | ○ |
| C-141 | NegationNode: getSpecificity | E-16 (L42-45) | ○ |
| C-142 | MatchingNode: getSpecificity(最大詳細度) | E-17 (L36-44) | ○ |
| C-143 | MatchingNode: getSpecificity(空引数) | E-17 (L36-44) | ○ |
| C-144 | SpecificityAdjustmentNode: getSpecificity | E-18 (L35-38) | ○ |
| C-145 | SelectorNode: 疑似要素小文字変換 | E-19 (L32) | ○ |
| C-146 | SelectorNode: getSpecificity(疑似要素あり) | E-19 (L45-48) | ○ |
| C-147 | SelectorNode: getSpecificity(疑似要素なし) | E-19 (L45-48) | ○ |
| C-148 | AbstractNode: getNodeName | E-20 (L28-31) | ○ |
| C-149 | NodeExtension: setFlag(オン) | E-21 (L42-53) | ○ |
| C-150 | NodeExtension: setFlag(オフ) | E-21 (L42-53) | ○ |
| C-151 | NodeExtension: hasFlag(あり) | E-21 (L55-58) | ○ |
| C-152 | NodeExtension: hasFlag(なし) | E-21 (L55-58) | ○ |
| C-153 | NodeExtension: translateElement(基本) | E-21 (L183-210) | ○ |
| C-154 | NodeExtension: translateElement(ワイルドカード) | E-21 (L192-196) | ○ |
| C-155 | NodeExtension: translateElement(小文字変換) | E-21 (L187-189) | ○ |
| C-156 | NodeExtension: translateElement(名前空間付き) | E-21 (L198-201) | ○ |
| C-157 | CombinationExtension: translateDescendant | E-22 (L38-41) | ○ |
| C-158 | CombinationExtension: translateChild | E-22 (L43-46) | ○ |
| C-159 | CombinationExtension: translateDirectAdjacent | E-22 (L48-54) | ○ |
| C-160 | CombinationExtension: translateIndirectAdjacent | E-22 (L56-59) | ○ |
| C-161 | FunctionExtension: translateNthChild(odd) | E-23 (L48-101) | ○ |
| C-162 | FunctionExtension: translateNthChild(even) | E-23 (L48-101) | ○ |
| C-163 | FunctionExtension: translateNthChild(数値) | E-23 (L61-62) | ○ |
| C-164 | FunctionExtension: translateNthChild(0n+0境界値) | E-23 (L61-62) | △ |
| C-165 | FunctionExtension: translateNthChild(負のa) | E-23 (L65-73) | ○ |
| C-166 | FunctionExtension: translateNthLastChild | E-23 (L103-106) | ○ |
| C-167 | FunctionExtension: translateNthOfType | E-23 (L108-111) | ○ |
| C-168 | FunctionExtension: translateNthLastOfType(*)エラー | E-23 (L118-119) | ○ |
| C-169 | FunctionExtension: translateContains | E-23 (L128-141) | ○ |
| C-170 | FunctionExtension: translateContains引数エラー | E-23 (L131-134) | ○ |
| C-171 | FunctionExtension: translateLang | E-23 (L146-159) | ○ |
| C-172 | PseudoClassExtension: translateRoot | E-24 (L44-47) | ○ |
| C-173 | PseudoClassExtension: translateFirstChild | E-24 (L54-60) | ○ |
| C-174 | PseudoClassExtension: translateLastChild | E-24 (L62-68) | ○ |
| C-175 | PseudoClassExtension: translateFirstOfType | E-24 (L73-82) | ○ |
| C-176 | PseudoClassExtension: translateFirstOfType(*)エラー | E-24 (L75-77) | ○ |
| C-177 | PseudoClassExtension: translateLastOfType(*)エラー | E-24 (L89-91) | ○ |
| C-178 | PseudoClassExtension: translateOnlyChild | E-24 (L98-104) | ○ |
| C-179 | PseudoClassExtension: translateOnlyOfType | E-24 (L106-111) | ○ |
| C-180 | PseudoClassExtension: translateEmpty | E-24 (L113-116) | ○ |
| C-181 | AttributeMatchingExtension: translateExists | E-25 (L43-46) | ○ |
| C-182 | AttributeMatchingExtension: translateEquals | E-25 (L48-51) | ○ |
| C-183 | AttributeMatchingExtension: translateIncludes | E-25 (L53-60) | ○ |
| C-184 | AttributeMatchingExtension: translateIncludes(null値) | E-25 (L55-59) | △ |
| C-185 | AttributeMatchingExtension: translateDashMatch | E-25 (L62-70) | ○ |
| C-186 | AttributeMatchingExtension: translatePrefixMatch | E-25 (L72-79) | ○ |
| C-187 | AttributeMatchingExtension: translatePrefixMatch(null値) | E-25 (L74-78) | △ |
| C-188 | AttributeMatchingExtension: translateSuffixMatch | E-25 (L81-89) | ○ |
| C-189 | AttributeMatchingExtension: translateSubstringMatch | E-25 (L91-98) | ○ |
| C-190 | AttributeMatchingExtension: translateDifferent | E-25 (L100-107) | ○ |
| C-191 | AttributeMatchingExtension: translateDifferent(null値) | E-25 (L103) | △ |
| C-192 | HtmlExtension: コンストラクタでフラグ設定 | E-26 (L31-37) | ○ |
| C-193 | HtmlExtension: translateChecked | E-26 (L60-67) | ○ |
| C-194 | HtmlExtension: translateLink | E-26 (L69-72) | ○ |
| C-195 | HtmlExtension: translateDisabled | E-26 (L74-98) | ○ |
| C-196 | HtmlExtension: translateEnabled | E-26 (L100-131) | ○ |
| C-197 | HtmlExtension: translateSelected | E-26 (L154-157) | ○ |
| C-198 | HtmlExtension: translateInvalid | E-26 (L159-162) | ○ |
| C-199 | HtmlExtension: translateHover | E-26 (L164-167) | ○ |
| C-200 | HtmlExtension: translateVisited | E-26 (L169-172) | ○ |
| C-201 | HtmlExtension: translateLang(HTML版) | E-26 (L136-152) | ○ |
| C-202 | EmptyStringParser: 空文字列パース | E-28 (L34-39) | ○ |
| C-203 | EmptyStringParser: 非空文字列パース | E-28 (L37-41) | ○ |
| C-204 | ElementParser: 要素パース | E-29 (L30-43) | ○ |
| C-205 | ElementParser: 名前空間付きパース | E-29 (L38) | ○ |
| C-206 | ElementParser: ワイルドカードパース | E-29 (L38) | ○ |
| C-207 | ElementParser: 非マッチパース | E-29 (L38-43) | ○ |
| C-208 | ClassParser: クラスパース | E-30 (L31-47) | ○ |
| C-209 | ClassParser: 要素+クラスパース | E-30 (L40) | ○ |
| C-210 | ClassParser: 名前空間+クラスパース | E-30 (L40) | ○ |
| C-211 | ClassParser: 非マッチパース | E-30 (L40-46) | ○ |
| C-212 | HashParser: IDパース | E-31 (L31-48) | ○ |
| C-213 | HashParser: 要素+IDパース | E-31 (L40) | ○ |
| C-214 | HashParser: 非マッチパース | E-31 (L40-47) | ○ |
| C-215 | Tokenizer: 基本トークン化 | E-32 (L54-72) | ○ |
| C-216 | Tokenizer: 空白含みトークン化 | E-32 (L54-72) | ○ |
| C-217 | Tokenizer: ハッシュトークン化 | E-32 (L54-72) | ○ |
| C-218 | Tokenizer: 文字列トークン化 | E-32 (L54-72) | ○ |
| C-219 | Tokenizer: 数値トークン化 | E-32 (L54-72) | ○ |
| C-220 | Tokenizer: デリミタトークン化 | E-32 (L65-66) | ○ |
| C-221 | Tokenizer: コメントスキップ | E-32 (L59-63), E-40 | ○ |
| C-222 | TokenizerEscaping: Unicodeエスケープ | E-33 (L31-36, L46-62) | ○ |
| C-223 | TokenizerEscaping: バックスラッシュエスケープ | E-33 (L35) | ○ |
| C-224 | TokenizerEscaping: 改行エスケープ除去 | E-33 (L38-43) | ○ |
| C-225 | TokenizerPatterns: getIdentifierPattern | E-34 (L70-73) | ○ |
| C-226 | TokenizerPatterns: getHashPattern | E-34 (L75-78) | ○ |
| C-227 | TokenizerPatterns: getNumberPattern | E-34 (L80-83) | ○ |
| C-228 | TokenizerPatterns: getQuotedStringPattern | E-34 (L85-88) | ○ |
| C-229 | WhitespaceHandler: 空白ハンドル | E-35 (L30-42) | ○ |
| C-230 | WhitespaceHandler: 空白なしハンドル | E-35 (L33-35) | ○ |
| C-231 | IdentifierHandler: 識別子ハンドル | E-36 (L38-51) | ○ |
| C-232 | IdentifierHandler: 非識別子ハンドル | E-36 (L42-44) | ○ |
| C-233 | HashHandler: ハッシュハンドル | E-37 (L38-51) | ○ |
| C-234 | HashHandler: 非ハッシュハンドル | E-37 (L42-44) | ○ |
| C-235 | StringHandler: シングルクォート文字列 | E-38 (L40-69) | ○ |
| C-236 | StringHandler: ダブルクォート文字列 | E-38 (L40-69) | ○ |
| C-237 | StringHandler: 非文字列ハンドル | E-38 (L44-46) | ○ |
| C-238 | StringHandler: 未閉文字列エラー | E-38 (L56-63) | ○ |
| C-239 | NumberHandler: 数値ハンドル | E-39 (L36-48) | ○ |
| C-240 | NumberHandler: 小数ハンドル | E-39 (L36-48), E-34 (L51) | ○ |
| C-241 | NumberHandler: 非数値ハンドル | E-39 (L40-42) | ○ |
| C-242 | CommentHandler: コメントスキップ | E-40 (L29-44) | ○ |
| C-243 | CommentHandler: 未閉コメント | E-40 (L37-39) | ○ |
| C-244 | CommentHandler: 非コメントハンドル | E-40 (L31-33) | ○ |
| C-245 | SyntaxErrorException: unexpectedToken | E-41 (L26-29) | ○ |
| C-246 | SyntaxErrorException: pseudoElementFound | E-41 (L31-34) | ○ |
| C-247 | SyntaxErrorException: unclosedString | E-41 (L36-39) | ○ |
| C-248 | SyntaxErrorException: nestedNot | E-41 (L41-44) | ○ |
| C-249 | SyntaxErrorException: stringAsFunctionArgument | E-41 (L51-54) | ○ |
| C-250 | SyntaxErrorException: notAtTheStartOfASelector | E-41 (L46-49) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-CSS-007: 静的キャッシュ(`self::$htmlCache`, `self::$xmlCache`)の内部状態はリフレクションなしでは検証困難
  - 候補：同一入力の2回呼び出しで同一結果を確認する間接テスト / リフレクションによるキャッシュ確認
- UT-CSS-008: `EmptyStringParser`の`'' == $source`は`0`や`false`等の入力にも一致する可能性がある（PHP緩い比較）
  - 候補：`CssSelectorConverter`の統合テストで確認 / 直接`EmptyStringParser`をテスト
- UT-CSS-164: `nth-child(0n+0)`は`position() = 0`を生成するが、XPathの位置は1始まりのため常にfalseとなる
  - 候補：W3C CSS仕様との照合 / ブラウザ実装との比較
- UT-CSS-184/187: `null`値が渡された場合の`translateIncludes`/`translatePrefixMatch`は三項演算子で`'0'`を返す設計だが、型の安全性は未検証
  - 候補：実際のCSS入力から`null`値が渡されるシナリオの特定
- UT-CSS-191: `translateDifferent`の`null`値時のフォーマット文字列に分岐があり、意図通りかの確認が必要
  - 候補：ソースコード上の三項演算子のロジック確認

## 5) リスクフラグ（レビュー観点）
- リスク0（低リスク）：大部分のテストケースはソースコードの直接的なメソッドシグネチャ・ロジックから導出されており、信頼性が高い
- リスク1（中リスク）：キャッシュ関連のテスト(UT-CSS-007)は内部実装に依存するため、テスト実装時にリフレクション等の工夫が必要
- リスク1（中リスク）：`null`値のAttributeMatchingテスト(UT-CSS-184/187/191)は、CSSパーサーから実際にnull値が渡されるかの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがモジュール内の全publicメソッドをカバーしているか
- [ ] 正常系・異常系・境界値の各観点が主要メソッドで網羅されているか
- [ ] テストIDの連番が正しく割り振られているか（UT-CSS-001 ~ UT-CSS-250）
- [ ] 優先度の割り当てが適切か（ビジネスロジック=高、ユーティリティ=低）
- [ ] Nodeクラスの`getSpecificity()`のテストがCSS仕様と整合しているか
- [ ] `Parser::parseSeries()`の各パターンがCSS Selectors Level 3仕様と整合しているか
- [ ] HTML拡張の疑似クラス条件がHTML5仕様と整合しているか
