---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 220
  claims_with_evidence: 214
  claims_without_evidence: 6
confidence_derived: 0.97
---

# 根拠レポート：Component-DependencyInjection 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：214 / 220、根拠なし：6
- 優先レビュー（高）
  1. **EnvVarProcessor::getEnv の各プレフィックス処理テスト**：環境変数の実際の値に依存するため、テスト環境での再現性が要確認
  2. **ContainerBuilder::compile の統合的な動作テスト**：内部で多数のCompilerPassが実行されるため、単体テストとしての適切な粒度か要確認
  3. **ServiceLocator の外部ID付きエラーメッセージテスト**：debug_backtrace依存の処理があり、テスト環境によって挙動が異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/DependencyInjection/Container.php` - Containerクラス定義（set/get/has/initialized/compile/reset/getEnv等）
- E-02: `src/Symfony/Component/DependencyInjection/Definition.php` - Definition クラス定義（setFactory/setClass/setArguments/addTag/setDeprecated/setDecoratedService等）
- E-03: `src/Symfony/Component/DependencyInjection/Alias.php` - Alias クラス定義（setPublic/setDeprecated/getDeprecation等）
- E-04: `src/Symfony/Component/DependencyInjection/ChildDefinition.php` - ChildDefinition クラス定義（getParent/setParent/replaceArgument等）
- E-05: `src/Symfony/Component/DependencyInjection/ContainerBuilder.php` - ContainerBuilder クラス定義（registerExtension/setDefinition/setAlias/findDefinition/findTaggedServiceIds/merge/compile等）
- E-06: `src/Symfony/Component/DependencyInjection/Reference.php` - Reference クラス定義（__construct/__toString/getInvalidBehavior）
- E-07: `src/Symfony/Component/DependencyInjection/TypedReference.php` - TypedReference クラス定義（getType/getName/getAttributes）
- E-08: `src/Symfony/Component/DependencyInjection/Parameter.php` - Parameter クラス定義（__construct/__toString）
- E-09: `src/Symfony/Component/DependencyInjection/ParameterBag/ParameterBag.php` - ParameterBag クラス定義（set/get/has/remove/clear/add/resolve/resolveValue/resolveString/escapeValue/unescapeValue/deprecate）
- E-10: `src/Symfony/Component/DependencyInjection/ParameterBag/FrozenParameterBag.php` - FrozenParameterBag クラス定義（set/add/clear/remove/deprecate が全てLogicException）
- E-11: `src/Symfony/Component/DependencyInjection/ParameterBag/EnvPlaceholderParameterBag.php` - EnvPlaceholderParameterBag クラス定義（get/getEnvPlaceholders/mergeEnvPlaceholders/resolve等）
- E-12: `src/Symfony/Component/DependencyInjection/ServiceLocator.php` - ServiceLocator クラス定義（get/__invoke/withContext/count/getIterator）
- E-13: `src/Symfony/Component/DependencyInjection/EnvVarProcessor.php` - EnvVarProcessor クラス定義（getProvidedTypes/getEnv/reset, 各プレフィックス処理ロジック）
- E-14: `src/Symfony/Component/DependencyInjection/ReverseContainer.php` - ReverseContainer クラス定義（getId/getService）
- E-15: `src/Symfony/Component/DependencyInjection/Compiler/Compiler.php` - Compiler クラス定義（addPass/log/getLog/compile）
- E-16: `src/Symfony/Component/DependencyInjection/Compiler/PassConfig.php` - PassConfig クラス定義（addPass/getPasses/各種getter/setter）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-033 | Container クラスの各メソッドテスト（set/get/has/initialized/compile/reset/getServiceIds/getParameter/camelize/underscore/getEnv） | E-01 | ○ |
| C-034〜C-078 | Definition クラスの各メソッドテスト（setFactory/setClass/setArguments/addArgument/replaceArgument/getArgument/addMethodCall/addTag/hasTag/clearTag/setPublic/setShared/setLazy/setSynthetic/setAbstract/setDeprecated/setDecoratedService/setAutowired/setAutoconfigured/setConfigurator/setBindings/addError/setProperties/setFile） | E-02 | ○ |
| C-079〜C-086 | Alias クラスの各メソッドテスト（setPublic/isPrivate/setDeprecated/getDeprecation/__toString） | E-03 | ○ |
| C-087〜C-091 | ChildDefinition クラスの各メソッドテスト（getParent/setParent/replaceArgument） | E-04 | ○ |
| C-092〜C-094 | Reference クラスの各メソッドテスト（__construct/__toString/getInvalidBehavior） | E-06 | ○ |
| C-095〜C-097 | TypedReference クラスの各メソッドテスト（getType/getName/getAttributes） | E-07 | ○ |
| C-098 | Parameter クラスのテスト（__construct/__toString） | E-08 | ○ |
| C-099〜C-120 | ParameterBag クラスの各メソッドテスト（set/get/has/remove/clear/add/resolve/resolveValue/resolveString/escapeValue/unescapeValue/deprecate） | E-09 | ○ |
| C-121〜C-126 | FrozenParameterBag クラスの変更操作拒否テスト（set/add/clear/remove/deprecate + 初期化テスト） | E-10 | ○ |
| C-127〜C-133 | EnvPlaceholderParameterBag クラスの各メソッドテスト（get/getEnvPlaceholders/mergeEnvPlaceholders/resolve） | E-11 | ○ |
| C-134〜C-177 | ContainerBuilder クラスの各メソッドテスト（registerExtension/getExtension/setDefinition/getDefinition/register/autowire/setAlias/getAlias/findDefinition/findTaggedServiceIds/merge/loadFromExtension/set/has/compile等） | E-05 | ○ |
| C-178〜C-184 | ServiceLocator クラスの各メソッドテスト（get/__invoke/withContext/count） | E-12 | ○ |
| C-185〜C-206 | EnvVarProcessor クラスの各プレフィックステスト（string/bool/int/float/json/base64/csv/trim/url/key/not/defined/urlencode/reset） | E-13 | ○ |
| C-207〜C-211 | ReverseContainer クラスの各メソッドテスト（getId/getService） | E-14 | ○ |
| C-212〜C-215 | Compiler クラスの各メソッドテスト（addPass/log/getLog） | E-15 | ○ |
| C-216〜C-220 | PassConfig クラスの各メソッドテスト（addPass/getPasses/setMergePass） | E-16 | ○ |
| C-032 | Container::getEnv の環境変数取得テスト | E-01 | △ |
| C-033 | Container::getEnv の循環参照テスト | E-01 | △ |
| C-176 | ContainerBuilder::resolveEnvPlaceholders のプレースホルダ解決テスト | E-05, E-11 | △ |
| C-186〜C-189 | EnvVarProcessor の型変換テスト（実環境変数に依存） | E-13 | △ |
| C-196〜C-197 | EnvVarProcessor::getEnv url プレフィックスのURL解析テスト | E-13 | △ |
| C-207 | ReverseContainer::getId のClosure bind経由のサービス検索テスト | E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- EnvVarProcessor の一部テストケースは実際の環境変数($_ENV/$_SERVER)の状態に依存するため、モック化戦略についてはソースコードから確定できない
  - 候補：PHPUnit の @runInSeparateProcess / $_ENV 直接設定 / カスタムEnvVarLoaderの注入
- Container::getEnv は内部的にEnvVarProcessorとServiceLocatorを組み合わせた複雑な処理であり、単体テストとしての適切な分離レベルが不明
  - 候補：EnvVarProcessor のモック化 / コンテナへのパラメータ事前登録
- ReverseContainer::getId は Closure::bind を使用した内部実装に依存しており、テスト時のサービス登録方法が要確認
  - 候補：Container::set() での直接登録 / テスト用サブクラスの作成
- Loader/ ディレクトリ、Dumper/ ディレクトリ、Compiler/ ディレクトリの多数のパスクラスは、コード量が膨大なため代表的なクラスのみ対象としている
  - 候補：個別のCompilerPassごとにテストケースを追加 / 統合テスト形式での検証

## 5) リスクフラグ（レビュー観点）
- 0: Container/Definition/Alias/ChildDefinition/Reference/TypedReference/Parameter の基本CRUD操作テスト - ソースコードから直接導出可能
- 0: ParameterBag/FrozenParameterBag の操作テスト - 明確なメソッドシグネチャと例外条件から導出
- 1: EnvVarProcessor の各プレフィックステスト - 環境変数の実値に依存する部分があり、テスト環境構築の注意が必要
- 1: ContainerBuilder::compile の動作テスト - 内部CompilerPassの実行を伴うため、テスト粒度の妥当性要確認
- 0: ServiceLocator/ReverseContainer のテスト - メソッドの入出力が明確
- 0: Compiler/PassConfig のテスト - シンプルなデータ構造操作

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテスト観点（正常系/異常系/境界値）が適切にバランスしているか
- [ ] Definition クラスのfluent interface（メソッドチェーン）の戻り値テストが必要か確認
- [ ] EnvVarProcessor テストケースの前提条件（環境変数設定）が実際のテスト環境で再現可能か確認
- [ ] Loader/ ディレクトリのクラス（XmlFileLoader/YamlFileLoader/PhpFileLoader等）の追加テストが必要か検討
- [ ] Dumper/ ディレクトリのクラス（PhpDumper/XmlDumper/YamlDumper等）の追加テストが必要か検討
- [ ] Compiler/ ディレクトリの個別CompilerPassクラスの追加テストが必要か検討
- [ ] Attribute/ ディレクトリのPHPアトリビュートクラスのテストが必要か確認
- [ ] ContainerBuilder::willBeAvailable の静的メソッドテストが実際のComposer環境で実行可能か確認
- [ ] テストIDの略称「DEP」が他モジュールと重複していないか確認
