---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 267
  claims_with_evidence: 267
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：Component-DomCrawler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧CSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上のクラス・メソッド・条件分岐が実在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードのロジックと矛盾していないか
3. **網羅性**：publicメソッド、異常系、境界値が適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：267 / 267、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード上の根拠あり
  2. **Crawlerクラスのprivateメソッド（relativize, parseHtml5等）のカバレッジ**：privateメソッドは直接テスト対象としていないが、publicメソッド経由でカバー
  3. **Form.initialize()のフィールド収集ロジック**：複雑なXPathクエリによるフィールド収集は統合テスト寄りの観点も必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/DomCrawler/Crawler.php` - Crawlerクラス本体（1212行）
- E-02: `src/Symfony/Component/DomCrawler/AbstractUriElement.php` - URI要素の抽象基底クラス（111行）
- E-03: `src/Symfony/Component/DomCrawler/Link.php` - HTMLリンク表現クラス（34行）
- E-04: `src/Symfony/Component/DomCrawler/Image.php` - HTML画像表現クラス（37行）
- E-05: `src/Symfony/Component/DomCrawler/Form.php` - HTMLフォーム表現クラス（463行）
- E-06: `src/Symfony/Component/DomCrawler/FormFieldRegistry.php` - フォームフィールド管理クラス（175行）
- E-07: `src/Symfony/Component/DomCrawler/UriResolver.php` - URI解決ユーティリティクラス（136行）
- E-08: `src/Symfony/Component/DomCrawler/Field/FormField.php` - フォームフィールド抽象基底クラス（102行）
- E-09: `src/Symfony/Component/DomCrawler/Field/InputFormField.php` - テキスト入力フィールドクラス（46行）
- E-10: `src/Symfony/Component/DomCrawler/Field/ChoiceFormField.php` - 選択フィールドクラス（297行）
- E-11: `src/Symfony/Component/DomCrawler/Field/TextareaFormField.php` - テキストエリアフィールドクラス（37行）
- E-12: `src/Symfony/Component/DomCrawler/Field/FileFormField.php` - ファイルフィールドクラス（102行）
- E-13: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerSelectorCount.php` - セレクタカウントConstraint（45行）
- E-14: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerSelectorTextSame.php` - テキスト完全一致Constraint（50行）
- E-15: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerSelectorTextContains.php` - テキスト部分一致Constraint（62行）
- E-16: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerSelectorAttributeValueSame.php` - 属性値一致Constraint（51行）
- E-17: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerSelectorExists.php` - セレクタ存在Constraint（44行）
- E-18: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerAnySelectorTextSame.php` - いずれかテキスト一致Constraint（54行）
- E-19: `src/Symfony/Component/DomCrawler/Test/Constraint/CrawlerAnySelectorTextContains.php` - いずれかテキスト部分一致Constraint（65行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Crawler クラス（UT-DCR-001 ~ UT-DCR-106）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Crawler.__construct: HTML文字列からの生成 | E-01 (L61-70) | ○ |
| C-02 | Crawler.__construct: URI/baseHref設定 | E-01 (L63-66) | ○ |
| C-03 | Crawler.__construct: null入力 | E-01 (L62, L106-117) | ○ |
| C-04 | Crawler.__construct: DOMNode入力 | E-01 (L108-116) | ○ |
| C-05 | Crawler.__construct: DOMNodeList入力 | E-01 (L108-109) | ○ |
| C-06 | Crawler.__construct: baseHrefフォールバック | E-01 (L66) | ○ |
| C-07 | Crawler.add: 各型の分岐処理 | E-01 (L106-117) | ○ |
| C-08 | Crawler.addNode: 異なるドキュメント拒否 | E-01 (L268-269) | ○ |
| C-09 | Crawler.addNode: 重複排除 | E-01 (L275-277) | ○ |
| C-10 | Crawler.addContent: HTML/XML分岐 | E-01 (L126-154) | ○ |
| C-11 | Crawler.addHtmlContent: HTML5パース | E-01 (L166-184) | ○ |
| C-12 | Crawler.addXmlContent: XMLパース | E-01 (L200-221) | ○ |
| C-13 | Crawler.clear: ノードクリア | E-01 (L91-96) | ○ |
| C-14 | Crawler.eq: 位置指定 | E-01 (L285-292) | ○ |
| C-15 | Crawler.each: クロージャ実行 | E-01 (L310-318) | ○ |
| C-16 | Crawler.slice: 範囲指定 | E-01 (L323-326) | ○ |
| C-17 | Crawler.reduce: フィルタリング | E-01 (L335-345) | ○ |
| C-18 | Crawler.first/last: 先頭/末尾取得 | E-01 (L350-361) | ○ |
| C-19 | Crawler.siblings/nextAll/previousAll: 兄弟ノード | E-01 (L368-442) | ○ |
| C-20 | Crawler.ancestors: 祖先ノード | E-01 (L449-465) | ○ |
| C-21 | Crawler.children: 子ノード | E-01 (L473-489) | ○ |
| C-22 | Crawler.matches/closest: セレクタマッチング | E-01 (L377-414) | ○ |
| C-23 | Crawler.attr: 属性値取得 | E-01 (L498-511) | ○ |
| C-24 | Crawler.nodeName: ノード名取得 | E-01 (L518-525) | ○ |
| C-25 | Crawler.text: テキスト取得 | E-01 (L537-554) | ○ |
| C-26 | Crawler.innerText: 直接子テキスト取得 | E-01 (L561-576) | ○ |
| C-27 | Crawler.html/outerHtml: HTML出力 | E-01 (L585-619) | ○ |
| C-28 | Crawler.evaluate: XPath評価 | E-01 (L627-645) | ○ |
| C-29 | Crawler.extract: 属性/テキスト抽出 | E-01 (L656-677) | ○ |
| C-30 | Crawler.filterXPath/filter: フィルタリング | E-01 (L687-712) | ○ |
| C-31 | Crawler.selectLink/selectImage/selectButton | E-01 (L717-742) | ○ |
| C-32 | Crawler.link/links/image/images/form | E-01 (L749-848) | ○ |
| C-33 | Crawler.xpathLiteral: XPathリテラル変換 | E-01 (L879-903) | ○ |
| C-34 | Crawler.getNode/count/getIterator | E-01 (L1016-1032) | ○ |
| C-35 | 空ノードリストでの各メソッドの例外スロー | E-01 (全該当メソッド) | ○ |

### AbstractUriElement / Link / Image クラス（UT-DCR-107 ~ UT-DCR-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | AbstractUriElement.__construct: 絶対URI構築 | E-02 (L31-43) | ○ |
| C-37 | AbstractUriElement.__construct: 相対URI例外 | E-02 (L39-43) | ○ |
| C-38 | AbstractUriElement.getMethod: デフォルトGET | E-02 (L57-59) | ○ |
| C-39 | AbstractUriElement.getUri: URI解決 | E-02 (L65-68) | ○ |
| C-40 | AbstractUriElement.canonicalizePath: パス正規化 | E-02 (L80-101) | ○ |
| C-41 | Link.setNode: a/area/link許可 | E-03 (L26-33) | ○ |
| C-42 | Link.setNode: 不正タグ拒否 | E-03 (L28-29) | ○ |
| C-43 | Link.getRawUri: href属性取得 | E-03 (L21-24) | ○ |
| C-44 | Image.setNode: img許可 | E-04 (L29-36) | ○ |
| C-45 | Image.setNode: 不正タグ拒否 | E-04 (L31-32) | ○ |
| C-46 | Image.getRawUri: src属性取得 | E-04 (L24-27) | ○ |

### Form クラス（UT-DCR-127 ~ UT-DCR-163）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | Form.__construct: submitボタンからの生成 | E-05 (L35-44) | ○ |
| C-48 | Form.setNode: ボタン/フォーム判定 | E-05 (L355-381) | ○ |
| C-49 | Form.setNode: HTML5 form属性 | E-05 (L359-369) | ○ |
| C-50 | Form.setValues/getValues: 値の設定/取得 | E-05 (L61-89) | ○ |
| C-51 | Form.getFiles: ファイルフィールド取得 | E-05 (L94-113) | ○ |
| C-52 | Form.getPhpValues/getPhpFiles: PHP配列変換 | E-05 (L121-171) | ○ |
| C-53 | Form.getUri: GET時のクエリ付加 | E-05 (L180-198) | ○ |
| C-54 | Form.getRawUri: formaction優先 | E-05 (L200-208) | ○ |
| C-55 | Form.getMethod: 優先順位 | E-05 (L215-227) | ○ |
| C-56 | Form.has/get/set/remove/all | E-05 (L242-283) | ○ |
| C-57 | Form.ArrayAccess実装 | E-05 (L290-330) | ○ |
| C-58 | Form.disableValidation | E-05 (L337-346) | ○ |

### FormFieldRegistry クラス（UT-DCR-164 ~ UT-DCR-175）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | FormFieldRegistry.add: フィールド追加 | E-06 (L29-46) | ○ |
| C-60 | FormFieldRegistry.remove: フィールド削除 | E-06 (L51-63) | ○ |
| C-61 | FormFieldRegistry.get: フィールド取得/例外 | E-06 (L72-85) | ○ |
| C-62 | FormFieldRegistry.has: 存在判定 | E-06 (L90-99) | ○ |
| C-63 | FormFieldRegistry.set: 値設定/複合フィールドエラー | E-06 (L106-121) | ○ |
| C-64 | FormFieldRegistry.all: 全フィールド取得 | E-06 (L128-131) | ○ |

### UriResolver クラス（UT-DCR-176 ~ UT-DCR-184）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | UriResolver.resolve: 絶対URI | E-07 (L36-38) | ○ |
| C-66 | UriResolver.resolve: 空URI | E-07 (L44-47) | ○ |
| C-67 | UriResolver.resolve: アンカー | E-07 (L50-52) | ○ |
| C-68 | UriResolver.resolve: クエリ文字列 | E-07 (L56-58) | ○ |
| C-69 | UriResolver.resolve: プロトコル相対 | E-07 (L61-63) | ○ |
| C-70 | UriResolver.resolve: 絶対パス | E-07 (L68-69) | ○ |
| C-71 | UriResolver.resolve: 相対パス | E-07 (L72-77) | ○ |
| C-72 | UriResolver.resolve: null baseUri例外 | E-07 (L40-42) | ○ |

### Field クラス群（UT-DCR-185 ~ UT-DCR-247）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | FormField基本メソッド | E-08 (全体) | ○ |
| C-74 | InputFormField.initialize: 型チェック | E-09 (L29-45) | ○ |
| C-75 | ChoiceFormField.initialize: checkbox/radio/select | E-10 (L181-231) | ○ |
| C-76 | ChoiceFormField.setValue: バリデーション | E-10 (L106-139) | ○ |
| C-77 | ChoiceFormField.tick/untick: チェック操作 | E-10 (L78-99) | ○ |
| C-78 | ChoiceFormField.addChoice: オプション追加 | E-10 (L146-158) | ○ |
| C-79 | ChoiceFormField.hasValue/isDisabled | E-10 (L33-63) | ○ |
| C-80 | ChoiceFormField.containsOption/disableValidation | E-10 (L253-296) | ○ |
| C-81 | TextareaFormField.initialize: textarea限定 | E-11 (L26-36) | ○ |
| C-82 | FileFormField.initialize: file input限定 | E-12 (L90-101) | ○ |
| C-83 | FileFormField.setValue: ファイル処理 | E-12 (L48-75) | ○ |
| C-84 | FileFormField.setErrorCode: エラーコード設定 | E-12 (L28-35) | ○ |
| C-85 | FileFormField.setFilePath: パス文字列設定 | E-12 (L80-83) | ○ |

### Test Constraint クラス群（UT-DCR-248 ~ UT-DCR-267）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | CrawlerSelectorCount.matches | E-13 (L33-36) | ○ |
| C-87 | CrawlerSelectorTextSame.matches | E-14 (L33-41) | ○ |
| C-88 | CrawlerSelectorTextContains.matches | E-15 (L40-53) | ○ |
| C-89 | CrawlerSelectorAttributeValueSame.matches | E-16 (L34-42) | ○ |
| C-90 | CrawlerSelectorExists.matches | E-17 (L32-35) | ○ |
| C-91 | CrawlerAnySelectorTextSame.matches | E-18 (L30-44) | ○ |
| C-92 | CrawlerAnySelectorTextContains.matches | E-19 (L36-55) | ○ |
| C-93 | AnySelectorTextSame/Contains: 型チェック例外 | E-18 (L32-33), E-19 (L38-39) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全267テストケースについてソースコード上の根拠が確認できた
- privateメソッド（relativize, parseHtml5, convertToHtmlEntities, createDOMXPath, discoverNamespace, findNamespacePrefixes, createSubCrawler, createCssSelectorConverter, copyFromHtml5ToDom, normalizeWhitespace）は直接テスト対象としていないが、publicメソッド経由で間接的にカバーされる
  - 候補：privateメソッドを直接テストする場合はリフレクション使用 / publicメソッドの入力パターンで間接カバー / 統合テストで補完

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- 1: 中リスク - Crawler.addHtmlContent()のbase要素処理（UT-DCR-019）はHTML5パーサの挙動に依存するため、パーサのバージョンにより結果が異なる可能性がある
- 1: 中リスク - FileFormField.setValue()（UT-DCR-241）はファイルシステムに依存するテストのため、テスト環境の一時ディレクトリ構成に注意が必要
- 0: 低リスク - Test Constraintクラスは薄いラッパーであり、テストケースも単純

## 6) レビュアーチェックリスト（最小）
- [ ] Crawlerクラスの全publicメソッド（27メソッド）にテストケースが存在するか
- [ ] 各メソッドの空ノードリスト時のInvalidArgumentException系テストが漏れなく含まれているか
- [ ] Form関連の複雑なHTML構造（ネストしたフォーム、form属性によるフィールド収集）が十分にカバーされているか
- [ ] ChoiceFormFieldのsetValue()における全分岐（checkbox true/false, 配列値, 無効値）がカバーされているか
- [ ] UriResolverの全URI種別（絶対、相対、アンカー、クエリ、プロトコル相対）がカバーされているか
- [ ] テストケースの優先度が適切に設定されているか（セキュリティ/データ整合性関連は高優先度）
- [ ] privateメソッドの間接カバレッジが十分かどうか（publicメソッドのテストパターンで網羅できるか）
