---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 118
  claims_with_evidence: 112
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：Component-Dotenv 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：112 / 118、根拠なし：6
- 優先レビュー（高）
  1. **UT-DOT-032（ネストされたコマンド式）**：コマンド解決はOS依存（Windows非対応）であり、実際のテスト実行環境に依存
  2. **UT-DOT-064/065（putenv連携）**：putenvのスレッドセーフティ問題のためテスト環境に制約あり
  3. **UT-DOT-080/081（bootEnv .env.local.php）**：.env.local.phpのinclude動作はファイルシステムの実環境に依存
  4. **UT-DOT-094/105（composer.json連携）**：composer.jsonのruntime設定の存在は実行環境に依存
  5. **UT-DOT-085/086（APP_DEBUGの文字列/数値変換）**：filter_varの挙動に依存する部分がある

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Symfony/Component/Dotenv/Dotenv.php` - メインクラス（574行）
- E-02: `src/Symfony/Component/Dotenv/Command/DebugCommand.php` - デバッグコマンド（212行）
- E-03: `src/Symfony/Component/Dotenv/Command/DotenvDumpCommand.php` - ダンプコマンド（120行）
- E-04: `src/Symfony/Component/Dotenv/Exception/FormatException.php` - フォーマット例外（34行）
- E-05: `src/Symfony/Component/Dotenv/Exception/FormatExceptionContext.php` - 例外コンテキスト（44行）
- E-06: `src/Symfony/Component/Dotenv/Exception/PathException.php` - パス例外（25行）
- E-07: `src/Symfony/Component/Dotenv/Exception/ExceptionInterface.php` - 例外インタフェース（21行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DOT-001: デフォルト引数でインスタンス生成 | E-01 (L41-45) | ○ |
| C-02 | UT-DOT-002: カスタムキーでインスタンス生成 | E-01 (L41-45) | ○ |
| C-03 | UT-DOT-003: setProdEnvsが配列を設定 | E-01 (L50-55) | ○ |
| C-04 | UT-DOT-004: setProdEnvsに空配列 | E-01 (L50-55) | ○ |
| C-05 | UT-DOT-005: usePutenv有効化 | E-01 (L63-68) | ○ |
| C-06 | UT-DOT-006: usePutenv無効化 | E-01 (L63-68) | ○ |
| C-07 | UT-DOT-007: usePutenvデフォルト引数 | E-01 (L63) | ○ |
| C-08 | UT-DOT-008: 単純なキー=値パース | E-01 (L229-266) | ○ |
| C-09 | UT-DOT-009: 複数行パース | E-01 (L229-266) | ○ |
| C-10 | UT-DOT-010: シングルクォート値 | E-01 (L314-326) | ○ |
| C-11 | UT-DOT-011: ダブルクォート値 | E-01 (L327-348) | ○ |
| C-12 | UT-DOT-012: export接頭辞 | E-01 (L271) | ○ |
| C-13 | UT-DOT-013: コメント行スキップ | E-01 (L415-420) | ○ |
| C-14 | UT-DOT-014: インラインコメント | E-01 (L298, L378-380) | ○ |
| C-15 | UT-DOT-015: 空の値 | E-01 (L298-303) | ○ |
| C-16 | UT-DOT-016: 値なし変数 | E-01 (L256-258) | ○ |
| C-17 | UT-DOT-017: エスケープクォート | E-01 (L343) | ○ |
| C-18 | UT-DOT-018: \\n変換 | E-01 (L343) | ○ |
| C-19 | UT-DOT-019: \\r変換 | E-01 (L343) | ○ |
| C-20 | UT-DOT-020: 変数展開$VAR | E-01 (L471-535) | ○ |
| C-21 | UT-DOT-021: 変数展開${VAR} | E-01 (L471-535) | ○ |
| C-22 | UT-DOT-022: デフォルト値:- | E-01 (L516-527) | ○ |
| C-23 | UT-DOT-023: デフォルト値:= | E-01 (L524-526) | ○ |
| C-24 | UT-DOT-024: $エスケープ | E-01 (L488-491) | ○ |
| C-25 | UT-DOT-025: CRLF正規化 | E-01 (L232) | ○ |
| C-26 | UT-DOT-026: 空入力 | E-01 (L229-266) | ○ |
| C-27 | UT-DOT-027: 空行のみ | E-01 (L240-241, L415-420) | ○ |
| C-28 | UT-DOT-028: コメントのみ | E-01 (L415-420) | ○ |
| C-29 | UT-DOT-029: ダブルクォート内変数展開 | E-01 (L344-348) | ○ |
| C-30 | UT-DOT-030: シングルクォート内変数展開なし | E-01 (L314-326) | ○ |
| C-31 | UT-DOT-031: バックスラッシュエスケープ | E-01 (L347, L370) | ○ |
| C-32 | UT-DOT-032: ネストされたコマンド式 | E-01 (L389-413) | △ |
| C-33 | UT-DOT-033: pathパラメータ | E-01 (L231, L544-546) | ○ |
| C-34 | UT-DOT-034: 不正な変数名 | E-01 (L271-273) | ○ |
| C-35 | UT-DOT-035: 変数名後スペース | E-01 (L284-286) | ○ |
| C-36 | UT-DOT-036: =なし | E-01 (L276-282, L288-290) | ○ |
| C-37 | UT-DOT-037: 値前スペース | E-01 (L305-307) | ○ |
| C-38 | UT-DOT-038: シングルクォート未閉じ | E-01 (L318-321) | ○ |
| C-39 | UT-DOT-039: ダブルクォート未閉じ | E-01 (L330-331, L338-340) | ○ |
| C-40 | UT-DOT-040: 非クォートスペース値 | E-01 (L372-374) | ○ |
| C-41 | UT-DOT-041: export後値なし | E-01 (L276-279) | ○ |
| C-42 | UT-DOT-042: 括弧未閉じ | E-01 (L403-405, L408-410) | ○ |
| C-43 | UT-DOT-043: デフォルト値不正文字 | E-01 (L517-519) | ○ |
| C-44 | UT-DOT-044: 波括弧未閉じ | E-01 (L499-501) | ○ |
| C-45 | UT-DOT-045: アンダースコア変数名 | E-01 (L28, VARNAME_REGEX) | ○ |
| C-46 | UT-DOT-046: 1文字変数名 | E-01 (L28, VARNAME_REGEX) | ○ |
| C-47 | UT-DOT-047: 長い値 | E-01 (L296-387) | ○ |
| C-48 | UT-DOT-048: 値の連結 | E-01 (L313-382, do-while) | ○ |
| C-49 | UT-DOT-049: ファイル読み込み | E-01 (L79-82, L548-563) | ○ |
| C-50 | UT-DOT-050: 複数ファイル | E-01 (L79-82) | ○ |
| C-51 | UT-DOT-051: 存在しないファイル | E-01 (L551-553) | ○ |
| C-52 | UT-DOT-052: 読み取り不可ファイル | E-01 (L551-553) | ○ |
| C-53 | UT-DOT-053: ディレクトリ指定 | E-01 (L551) | ○ |
| C-54 | UT-DOT-054: BOM付きファイル | E-01 (L557-558) | ○ |
| C-55 | UT-DOT-055: 既存変数非上書き | E-01 (L79-82, L192-194) | ○ |
| C-56 | UT-DOT-056: overloadによる上書き | E-01 (L169-172) | ○ |
| C-57 | UT-DOT-057: 複数ファイルoverload | E-01 (L169-172) | ○ |
| C-58 | UT-DOT-058: $_ENV設定 | E-01 (L200) | ○ |
| C-59 | UT-DOT-059: $_SERVER設定 | E-01 (L201-203) | ○ |
| C-60 | UT-DOT-060: HTTP_接頭辞除外 | E-01 (L186, L201) | ○ |
| C-61 | UT-DOT-061: SYMFONY_DOTENV_VARS更新 | E-01 (L210-218) | ○ |
| C-62 | UT-DOT-062: 上書き防止 | E-01 (L192-194) | ○ |
| C-63 | UT-DOT-063: 上書き有効 | E-01 (L192) | ○ |
| C-64 | UT-DOT-064: putenv連携 | E-01 (L196-198) | △ |
| C-65 | UT-DOT-065: putenv非連携 | E-01 (L196) | △ |
| C-66 | UT-DOT-066: 空配列populate | E-01 (L185-218) | ○ |
| C-67 | UT-DOT-067: $_SERVER->$_ENV同期 | E-01 (L186-189) | ○ |
| C-68 | UT-DOT-068: 基本loadEnv | E-01 (L99-131) | ○ |
| C-69 | UT-DOT-069: .env.distフォールバック | E-01 (L105-109) | ○ |
| C-70 | UT-DOT-070: defaultEnv使用 | E-01 (L111-113) | ○ |
| C-71 | UT-DOT-071: .env.local読み込み | E-01 (L115-118) | ○ |
| C-72 | UT-DOT-072: test環境.env.local除外 | E-01 (L115) | ○ |
| C-73 | UT-DOT-073: 環境別ファイル | E-01 (L124-126) | ○ |
| C-74 | UT-DOT-074: 環境別ローカルファイル | E-01 (L128-130) | ○ |
| C-75 | UT-DOT-075: local環境早期リターン | E-01 (L120-122) | ○ |
| C-76 | UT-DOT-076: loadEnv上書きモード | E-01 (L99) | ○ |
| C-77 | UT-DOT-077: SYMFONY_DOTENV_PATH設定 | E-01 (L565-572) | ○ |
| C-78 | UT-DOT-078: カスタムenvKey | E-01 (L103) | ○ |
| C-79 | UT-DOT-079: envKeyパラメータ上書き | E-01 (L103) | ○ |
| C-80 | UT-DOT-080: .env.local.php優先使用 | E-01 (L142-148) | ○ |
| C-81 | UT-DOT-081: .env.local.php不在時フォールバック | E-01 (L149-151) | ○ |
| C-82 | UT-DOT-082: 本番環境デバッグフラグ | E-01 (L155-157) | ○ |
| C-83 | UT-DOT-083: 開発環境デバッグフラグ | E-01 (L155-157) | ○ |
| C-84 | UT-DOT-084: $_SERVER += $_ENV | E-01 (L153) | ○ |
| C-85 | UT-DOT-085: APP_DEBUG文字列変換 | E-01 (L157) | △ |
| C-86 | UT-DOT-086: APP_DEBUG '0'値 | E-01 (L157) | ○ |
| C-87 | UT-DOT-087: bootEnv上書きモード | E-01 (L146-148) | ○ |
| C-88 | UT-DOT-088: DebugCommand コンストラクタ | E-02 (L33-38) | ○ |
| C-89 | UT-DOT-089: DebugCommand 正常実行 | E-02 (L59-117) | ○ |
| C-90 | UT-DOT-090: Dotenv未初期化エラー | E-02 (L64-68) | ○ |
| C-91 | UT-DOT-091: フィルタ機能 | E-02 (L100-101, L138) | ○ |
| C-92 | UT-DOT-092: フィルタ不一致 | E-02 (L112-113) | ○ |
| C-93 | UT-DOT-093: カスタムパス | E-02 (L70) | ○ |
| C-94 | UT-DOT-094: composer.json連携 | E-02 (L73-79) | △ |
| C-95 | UT-DOT-095: test環境ファイルリスト | E-02 (L182-183) | ○ |
| C-96 | UT-DOT-096: dev環境ファイルリスト | E-02 (L182-183) | ○ |
| C-97 | UT-DOT-097: .env.distフォールバック | E-02 (L186-189) | ○ |
| C-98 | UT-DOT-098: 相対パス変換 | E-02 (L196-199) | ○ |
| C-99 | UT-DOT-099: 外部パスファイル名 | E-02 (L201) | ○ |
| C-100 | UT-DOT-100: コマンド補完 | E-02 (L119-124) | ○ |
| C-101 | UT-DOT-101: DotenvDumpCommand コンストラクタ | E-03 (L38-43) | ○ |
| C-102 | UT-DOT-102: 基本ダンプ | E-03 (L61-96) | ○ |
| C-103 | UT-DOT-103: emptyオプション | E-03 (L75-76) | ○ |
| C-104 | UT-DOT-104: 必須env引数 | E-03 (L49) | ○ |
| C-105 | UT-DOT-105: DotenvDumpCommand composer.json連携 | E-03 (L69-71) | △ |
| C-106 | UT-DOT-106: ファイルパス正規化 | E-03 (L64-67) | ○ |
| C-107 | UT-DOT-107: FormatExceptionメッセージ | E-04 (L21-28) | ○ |
| C-108 | UT-DOT-108: FormatException getContext | E-04 (L30-33) | ○ |
| C-109 | UT-DOT-109: FormatExceptionContext コンストラクタ | E-05 (L19-25) | ○ |
| C-110 | UT-DOT-110: getPath | E-05 (L27-29) | ○ |
| C-111 | UT-DOT-111: getLineno | E-05 (L31-33) | ○ |
| C-112 | UT-DOT-112: getDetails | E-05 (L35-43) | ○ |
| C-113 | UT-DOT-113: カーソル先頭 | E-05 (L39) | ○ |
| C-114 | UT-DOT-114: 長いデータカーソル位置 | E-05 (L39-40) | ○ |
| C-115 | UT-DOT-115: 改行エスケープ表示 | E-05 (L39-40) | ○ |
| C-116 | UT-DOT-116: PathExceptionメッセージ | E-06 (L21-24) | ○ |
| C-117 | UT-DOT-117: PathException カスタムcode | E-06 (L21) | ○ |
| C-118 | UT-DOT-118: PathException previous | E-06 (L21) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-DOT-032（ネストされたコマンド式）**: resolveCommandsメソッドはProcess componentに依存し、Windows環境では\LogicExceptionがスローされる。テスト環境がLinux/macOSであることが前提。
  - 候補：実行環境確認 / Process componentのモック / OS別テストケースの追加
- **UT-DOT-064/065（putenv連携）**: putenvはスレッドセーフでないため、テスト実行時に他テストとの干渉リスクがある。getenvの戻り値は実行環境に依存。
  - 候補：テスト分離の確認 / putenvのモック化 / テスト後のクリーンアップ
- **UT-DOT-085（APP_DEBUG文字列変換）**: filter_var($debug, FILTER_VALIDATE_BOOL)の挙動はPHPバージョンに依存する可能性がある。
  - 候補：PHPバージョン別テスト / filter_varの動作仕様確認
- **UT-DOT-094/105（composer.json連携）**: テスト実行時に適切なcomposer.jsonフィクスチャが必要。実際のファイルシステム操作が伴う。
  - 候補：フィクスチャファイル作成 / vfsStreamによる仮想ファイルシステム

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**: コマンド解決（resolveCommands）はOS依存のため、CIのOS設定に注意
- **リスク1（中リスク）**: putenvの使用はスレッドセーフでないため、並列テスト実行で問題が起きる可能性
- **リスク0（低リスク）**: ExceptionInterfaceはマーカーインタフェースのみで、テストケースは省略（instanceofテストで十分）
- **リスク1（中リスク）**: bootEnvの.env.local.phpのinclude動作はファイルシステムの状態に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Dotenv::parseメソッドの正常系テスト（UT-DOT-008〜033）が.env構文仕様を網羅しているか確認
- [ ] Dotenv::parseメソッドの異常系テスト（UT-DOT-034〜044）が全てのFormatExceptionパスをカバーしているか確認
- [ ] load/overload/populateメソッドの$_ENV/$_SERVER操作のテストが環境変数の競合を考慮しているか確認
- [ ] loadEnv/bootEnvのファイル読み込み優先順位テスト（UT-DOT-068〜087）がSymfonyの仕様と整合しているか確認
- [ ] DebugCommand/DotenvDumpCommandのテスト（UT-DOT-088〜106）がConsole componentのモック化を適切に行うか確認
- [ ] putenv連携テスト（UT-DOT-064/065）がテスト後のクリーンアップを適切に行うか確認
