---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 60
  claims_with_evidence: 57
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：Component-Emoji 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（Component-Emoji.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：57 / 60、根拠なし：3
- 優先レビュー（高）
  1. **UT-EMJ-006（gzip圧縮されたデータファイルの読み込み）**：実際にgz形式のファイルが存在するかの確認が必要
  2. **UT-EMJ-039（不正なUTF-8文字列の処理）**：intl Transliteratorの不正UTF-8処理の挙動が環境依存の可能性
  3. **UT-EMJ-060（QUICK_CHECK文字のfalse positive）**：strtrのmapに一致しない場合の実際の挙動の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/Emoji/EmojiTransliterator.php` - メインクラスのソースコード（145行）
- E-02: `src/Symfony/Component/Emoji/Util/GzipStreamWrapper.php` - ストリームラッパーユーティリティ（83行）
- E-03: `src/Symfony/Component/Emoji/composer.json` - パッケージ定義（依存関係・オートロード設定）
- E-04: `src/Symfony/Component/Emoji/Resources/data/` ディレクトリ - 174個のデータファイル（.php, .php.gz）
- E-05: REVERSEABLE_IDS定数定義（EmojiTransliterator.php 23-32行目）
- E-06: QUICK_CHECK定数定義（EmojiTransliterator.php 22行目）
- E-07: `create()` メソッド実装（EmojiTransliterator.php 42-79行目）
- E-08: `transliterate()` メソッド実装（EmojiTransliterator.php 115-144行目）
- E-09: `listIDs()` メソッド実装（EmojiTransliterator.php 96-113行目）
- E-10: `GzipStreamWrapper::require()` メソッド実装（GzipStreamWrapper.php 26-38行目）
- E-11: `stream_open()` メソッド実装（GzipStreamWrapper.php 40-46行目）
- E-12: `stream_stat()` メソッド実装（GzipStreamWrapper.php 68-82行目）
- E-13: `stream_set_option()` メソッド実装（GzipStreamWrapper.php 59-65行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-EMJ-001: 有効なIDでインスタンスが生成される | E-01, E-07 | ○ |
| C-02 | UT-EMJ-002: emoji-プレフィックスが自動補完される | E-07（46-48行目: str_starts_withチェック） | ○ |
| C-03 | UT-EMJ-003: 大文字IDが小文字に正規化される | E-07（44行目: strtolower呼び出し） | ○ |
| C-04 | UT-EMJ-004: REVERSE方向で逆IDインスタンスが生成される | E-05, E-07（50-58行目: REVERSE分岐） | ○ |
| C-05 | UT-EMJ-005: ロケールベースIDでインスタンス生成 | E-04, E-07 | ○ |
| C-06 | UT-EMJ-006: gzip圧縮データファイルが読み込まれる | E-07（61行目: .gz判定）, E-10 | △ |
| C-07 | UT-EMJ-007: 同一IDで2回呼び出しでキャッシュ使用 | E-07（70-71行目: static $maps） | ○ |
| C-08 | UT-EMJ-008: REVERSEABLE_IDSのIDにプレフィックス非付与 | E-05, E-07（46行目: isset条件） | ○ |
| C-09 | UT-EMJ-009: リバース不可IDでREVERSE指定時にIntlException | E-07（50-55行目: REVERSE分岐＋例外スロー） | ○ |
| C-10 | UT-EMJ-010: 存在しないIDでIntlException | E-07（60-64行目: ファイル存在チェック＋例外） | ○ |
| C-11 | UT-EMJ-011: パストラバーサルIDでIntlException | E-07（61行目: preg_matchパターン） | ○ |
| C-12 | UT-EMJ-012: 特殊文字IDでIntlException | E-07（61行目: preg_matchパターン） | ○ |
| C-13 | UT-EMJ-013: 空文字列IDでIntlException | E-07（61行目: ファイル存在チェック） | ○ |
| C-14 | UT-EMJ-014: createInverseで逆方向インスタンス生成 | E-01（81-84行目: createInverse実装） | ○ |
| C-15 | UT-EMJ-015: 逆方向から更に逆方向のインスタンス生成 | E-05（双方向マッピング定義） | ○ |
| C-16 | UT-EMJ-016: リバース不可IDでcreateInverseがIntlException | E-01（81-84行目）, E-07（50-55行目） | ○ |
| C-17 | UT-EMJ-017: transliterator未設定時にgetErrorCodeが0 | E-01（86-89行目: issetチェック） | ○ |
| C-18 | UT-EMJ-018: transliterator設定時にgetErrorCode委譲 | E-01（86-89行目: 三項演算子） | ○ |
| C-19 | UT-EMJ-019: transliterator未設定時にgetErrorMessageが空文字 | E-01（91-94行目: issetチェック） | ○ |
| C-20 | UT-EMJ-020: transliterator設定時にgetErrorMessage委譲 | E-01（91-94行目: 三項演算子） | ○ |
| C-21 | UT-EMJ-021: listIDsがIDリストを返却 | E-09, E-04 | ○ |
| C-22 | UT-EMJ-022: listIDsにemoji-githubが含まれる | E-04（emoji-github.phpファイル存在） | ○ |
| C-23 | UT-EMJ-023: listIDsにgithub-emojiが含まれる | E-04（github-emoji.phpファイル存在） | ○ |
| C-24 | UT-EMJ-024: .php.gzファイルの拡張子除去 | E-09（105-106行目: substr処理） | ○ |
| C-25 | UT-EMJ-025: listIDsの2回目呼出でキャッシュ使用 | E-09（98-102行目: static $ids） | ○ |
| C-26 | UT-EMJ-026: 絵文字がテキストに変換される | E-08, E-04 | ○ |
| C-27 | UT-EMJ-027: GitHubショートコードへの変換 | E-08, E-04（emoji-github.php） | ○ |
| C-28 | UT-EMJ-028: テキストから絵文字への逆変換 | E-08, E-04（text-emoji.php） | ○ |
| C-29 | UT-EMJ-029: 絵文字なし文字列がそのまま返却 | E-08（120行目: strcspnチェック） | ○ |
| C-30 | UT-EMJ-030: start引数で部分変換開始位置指定 | E-08（115行目: $start引数, 123-143行目: スライス処理） | ○ |
| C-31 | UT-EMJ-031: end引数で部分変換終了位置指定 | E-08（115行目: $end引数, 123-143行目: スライス処理） | ○ |
| C-32 | UT-EMJ-032: start+end両方指定で部分変換 | E-08（123-143行目: スライス処理） | ○ |
| C-33 | UT-EMJ-033: 複数絵文字の一括変換 | E-08（120行目: strtr） | ○ |
| C-34 | UT-EMJ-034: Slackショートコードへの変換 | E-04（emoji-slack.php存在） | ○ |
| C-35 | UT-EMJ-035: GitLabショートコードへの変換 | E-04（emoji-gitlab.php存在） | ○ |
| C-36 | UT-EMJ-036: 空文字列が空文字列として返却 | E-08（119-120行目: strlen/strcspn） | ○ |
| C-37 | UT-EMJ-037: 1文字絵文字の変換 | E-08（120行目: strtr） | ○ |
| C-38 | UT-EMJ-038: デフォルト引数で全体変換 | E-08（115行目: デフォルト引数, 119行目: 0/$start, -1/$end条件） | ○ |
| C-39 | UT-EMJ-039: 不正UTF-8文字列の処理 | E-08（119行目: preg_match('//u')で判定） | △ |
| C-40 | UT-EMJ-040: startが文字列長超過時にfalse | E-08（134行目: intl transliteratorに委譲） | ○ |
| C-41 | UT-EMJ-041: コロン始まりmapのquickCheck設定 | E-08（117行目: array_key_first条件分岐） | ○ |
| C-42 | UT-EMJ-042: QUICK_CHECK文字なしでstrtrスキップ | E-08（120行目: strcspn最適化） | ○ |
| C-43 | UT-EMJ-043: GzipStreamWrapper::requireで配列返却 | E-10 | ○ |
| C-44 | UT-EMJ-044: zlib未ロード時にLogicException | E-10（28-29行目: extension_loadedチェック） | ○ |
| C-45 | UT-EMJ-045: stream_openでcompress.zlib://プロトコル使用 | E-11（45行目: fopen呼び出し） | ○ |
| C-46 | UT-EMJ-046: stream_open内でstream_wrapper_restore呼出 | E-11（42行目: stream_wrapper_restore） | ○ |
| C-47 | UT-EMJ-047: 存在しないファイルでstream_openがfalse | E-11（45行目: fopen失敗時） | ○ |
| C-48 | UT-EMJ-048: stream_readで指定バイト数読込 | E-02（48-51行目: fread委譲） | ○ |
| C-49 | UT-EMJ-049: 0バイト読込要求時の挙動 | E-02（48-51行目） | ○ |
| C-50 | UT-EMJ-050: EOF未到達時にstream_eofがfalse | E-02（53-55行目: feof委譲） | ○ |
| C-51 | UT-EMJ-051: EOF到達時にstream_eofがtrue | E-02（53-55行目: feof委譲） | ○ |
| C-52 | UT-EMJ-052: STREAM_OPTION_BLOCKINGの設定 | E-13（61行目: match分岐） | ○ |
| C-53 | UT-EMJ-053: STREAM_OPTION_READ_TIMEOUTの設定 | E-13（62行目: match分岐） | ○ |
| C-54 | UT-EMJ-054: STREAM_OPTION_WRITE_BUFFERの設定 | E-13（63行目: match分岐） | ○ |
| C-55 | UT-EMJ-055: 不明オプションでfalse返却 | E-13（64行目: default分岐） | ○ |
| C-56 | UT-EMJ-056: stream_statがstat配列を返却 | E-12 | ○ |
| C-57 | UT-EMJ-057: 展開後サイズがstat配列に反映 | E-12（74-79行目: gzipフッター読取り） | ○ |
| C-58 | UT-EMJ-058: stat失敗時にfalse返却 | E-12（70-71行目: 条件分岐） | ○ |
| C-59 | UT-EMJ-059: 全REVERSEABLE_IDSペアの正逆変換 | E-05（8ペア定義） | ○ |
| C-60 | UT-EMJ-060: QUICK_CHECK文字のfalse positive処理 | E-06, E-08（120行目: strtr） | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-EMJ-006（gzip圧縮データファイルの読み込み）**：Resources/dataディレクトリ内に実際に.php.gz形式のファイルが存在するかの確認が必要。ディレクトリ一覧では174ファイルが確認されたが、gz形式の割合は未確認。
  - 候補：Resources/dataディレクトリのファイル拡張子別カウント / 実際のgzファイルの中身の検証
- **UT-EMJ-039（不正UTF-8文字列の処理）**：preg_match('//u')による判定は確認済みだが、intl Transliteratorに委譲された場合の具体的な挙動（エラーコード、例外の有無）がPHP/intlバージョンに依存する可能性がある。
  - 候補：PHP intl拡張のドキュメント / Transliterator::transliterateの仕様書
- **UT-EMJ-060（QUICK_CHECK文字のfalse positive）**：strtrがmapに一致しないキーをどう扱うかはPHP仕様に依存。strtrはmapに一致しない文字をそのまま返すため、理論的には正しいが、実際のmapデータでの検証が望ましい。
  - 候補：PHPマニュアル strtr関数 / 実際のemoji-text.phpデータファイル

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**：GzipStreamWrapperのstream_wrapper_unregister/restoreによるfileプロトコルの一時的な置換は、並行処理環境では競合状態を引き起こす可能性がある。テストケース自体は正しいが、テスト実行環境での副作用に注意。
- **リスク0（低リスク）**：static変数によるキャッシュ（$maps, $ids）はテスト間の状態汚染を引き起こす可能性がある。テスト実行順序に依存するテストケースが存在する場合に注意。
- **リスク0（低リスク）**：ReflectionClass::newInstanceWithoutConstructorを使用したインスタンス生成は、PHPバージョンアップ時に挙動が変わる可能性があるが、現時点では安定。

## 6) レビュアーチェックリスト（最小）
- [ ] EmojiTransliteratorの全publicメソッド（create, createInverse, getErrorCode, getErrorMessage, listIDs, transliterate）がテストケースでカバーされているか
- [ ] GzipStreamWrapperの全publicメソッド（require, stream_open, stream_read, stream_eof, stream_set_option, stream_stat）がテストケースでカバーされているか
- [ ] REVERSEABLE_IDSの全8エントリに対するテストケースが存在するか（UT-EMJ-059）
- [ ] 正常系・異常系・境界値の各テスト観点が適切にバランスされているか
- [ ] セキュリティ関連のテストケース（パストラバーサル: UT-EMJ-011, 不正文字: UT-EMJ-012）が含まれているか
- [ ] 不正UTF-8入力（UT-EMJ-039）の期待結果が実際のintl拡張の挙動と一致するか
- [ ] gzipファイルの読み込みテスト（UT-EMJ-006, UT-EMJ-043）がzlib拡張の有無を前提条件として適切に記述しているか
