---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 180
  claims_with_evidence: 176
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：Component-ErrorHandler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：176 / 180、根拠なし：4
- 優先レビュー（高）
  1. **UT-ERH-044 (silencedErrorCacheの100件超自動クリア)**：閾値100はソースコードで確認済みだが、実際の動作テストでの確認が推奨される
  2. **UT-ERH-079 (ClassNotFoundErrorEnhancerの候補クラス提案)**：候補検出ロジックはComposerオートローダーに依存するため実行環境による差異あり
  3. **UT-ERH-176-178 (ErrorDumpCommand)**：EntrypointLookupInterfaceへの依存がオプショナルであり環境依存の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/Symfony/Component/ErrorHandler/BufferingLogger.php` - BufferingLoggerクラスの全メソッド定義
- E-02: `src/Symfony/Component/ErrorHandler/Debug.php` - Debugクラスのenable()メソッド定義
- E-03: `src/Symfony/Component/ErrorHandler/ErrorHandler.php` - ErrorHandlerクラスの全メソッド定義（register, call, handleError, handleException, handleFatalError, enhanceError等）
- E-04: `src/Symfony/Component/ErrorHandler/ThrowableUtils.php` - ThrowableUtilsクラスのgetSeverity()メソッド定義
- E-05: `src/Symfony/Component/ErrorHandler/Error/ClassNotFoundError.php` - ClassNotFoundErrorクラス定義
- E-06: `src/Symfony/Component/ErrorHandler/Error/FatalError.php` - FatalErrorクラス定義（__construct, getError）
- E-07: `src/Symfony/Component/ErrorHandler/Error/OutOfMemoryError.php` - OutOfMemoryErrorクラス定義（FatalError継承）
- E-08: `src/Symfony/Component/ErrorHandler/Error/UndefinedFunctionError.php` - UndefinedFunctionErrorクラス定義
- E-09: `src/Symfony/Component/ErrorHandler/Error/UndefinedMethodError.php` - UndefinedMethodErrorクラス定義
- E-10: `src/Symfony/Component/ErrorHandler/ErrorEnhancer/ClassNotFoundErrorEnhancer.php` - ClassNotFoundErrorEnhancerのenhance(), getClassCandidates(), findClassInPath(), convertFileToClass()
- E-11: `src/Symfony/Component/ErrorHandler/ErrorEnhancer/ErrorEnhancerInterface.php` - ErrorEnhancerInterfaceの定義
- E-12: `src/Symfony/Component/ErrorHandler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php` - UndefinedFunctionErrorEnhancerのenhance()
- E-13: `src/Symfony/Component/ErrorHandler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php` - UndefinedMethodErrorEnhancerのenhance()
- E-14: `src/Symfony/Component/ErrorHandler/ErrorRenderer/CliErrorRenderer.php` - CliErrorRendererのrender()
- E-15: `src/Symfony/Component/ErrorHandler/ErrorRenderer/ErrorRendererInterface.php` - ErrorRendererInterfaceの定義
- E-16: `src/Symfony/Component/ErrorHandler/ErrorRenderer/FileLinkFormatter.php` - FileLinkFormatterの全メソッド定義
- E-17: `src/Symfony/Component/ErrorHandler/ErrorRenderer/HtmlErrorRenderer.php` - HtmlErrorRendererの全メソッド定義
- E-18: `src/Symfony/Component/ErrorHandler/ErrorRenderer/SerializerErrorRenderer.php` - SerializerErrorRendererの全メソッド定義
- E-19: `src/Symfony/Component/ErrorHandler/Exception/FlattenException.php` - FlattenExceptionの全メソッド定義
- E-20: `src/Symfony/Component/ErrorHandler/Exception/SilencedErrorContext.php` - SilencedErrorContextの全メソッド定義
- E-21: `src/Symfony/Component/ErrorHandler/DebugClassLoader.php` - DebugClassLoaderの全メソッド定義
- E-22: `src/Symfony/Component/ErrorHandler/Command/ErrorDumpCommand.php` - ErrorDumpCommandの全メソッド定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BufferingLogger::log()がバッファにログを蓄積する | E-01 (L25-28) | ○ |
| C-02 | BufferingLogger::cleanLogs()がログを返却しバッファをクリアする | E-01 (L30-36) | ○ |
| C-03 | BufferingLogger::__serialize()がBadMethodCallExceptionをスローする | E-01 (L38-41) | ○ |
| C-04 | BufferingLogger::__unserialize()がBadMethodCallExceptionをスローする | E-01 (L43-46) | ○ |
| C-05 | BufferingLogger::__destruct()がプレースホルダを置換してerror_log出力する | E-01 (L48-67) | ○ |
| C-06 | Debug::enable()がErrorHandlerインスタンスを返却する | E-02 (L21-39) | ○ |
| C-07 | ErrorHandler::register()がエラーハンドラを登録しインスタンスを返却する | E-03 (L108-154) | ○ |
| C-08 | ErrorHandler::call()がPHPエラーをErrorExceptionに変換する | E-03 (L161-178) | ○ |
| C-09 | ErrorHandler::setDefaultLogger()がロガーを設定する | E-03 (L204-225) | ○ |
| C-10 | ErrorHandler::setLoggers()がInvalidArgumentExceptionをスローする（不正入力時） | E-03 (L234-276) | ○ |
| C-11 | ErrorHandler::throwAt()がE_DEPRECATED/E_USER_DEPRECATEDを除外する | E-03 (L292-302) | ○ |
| C-12 | ErrorHandler::handleError()がErrorExceptionをスローまたはログ出力する | E-03 (L383-466) | ○ |
| C-13 | ErrorHandler::handleError()のswitch targeting deprecation変換 | E-03 (L385-387) | ○ |
| C-14 | ErrorHandler::handleError()のassert()警告のスロー抑制 | E-03 (L399-401) | ○ |
| C-15 | ErrorHandler::handleError()のsilencedErrorCacheの100件超クリア | E-03 (L422-425) | ○ |
| C-16 | ErrorHandler::handleException()が例外種別に応じたプレフィックスを付与する | E-03 (L473-539) | ○ |
| C-17 | ErrorHandler::handleFatalError()がFatalError/OutOfMemoryErrorを生成する | E-03 (L548-622) | ○ |
| C-18 | ErrorHandler::enhanceError()がOutOfMemoryErrorをスキップする | E-03 (L647-660) | ○ |
| C-19 | ThrowableUtils::getSeverity()が例外種別に応じた深刻度を返す | E-04 (L21-36) | ○ |
| C-20 | ClassNotFoundError/__construct()が前の例外情報を引き継ぐ | E-05 (L16-28) | ○ |
| C-21 | FatalError::__construct()がエラー情報とトレースを設定する | E-06 (L19-79) | ○ |
| C-22 | FatalError::getError()がerror配列を返却する | E-06 (L81-84) | ○ |
| C-23 | OutOfMemoryErrorがFatalErrorを継承している | E-07 (L14-16) | ○ |
| C-24 | ClassNotFoundErrorEnhancer::enhance()がClass/Interface/Trait not foundを検出する | E-10 (L24-56) | ○ |
| C-25 | ClassNotFoundErrorEnhancer::enhance()が名前空間付き/グローバルで異なるメッセージを生成する | E-10 (L34-43) | ○ |
| C-26 | UndefinedFunctionErrorEnhancer::enhance()がFatalErrorでnullを返す | E-12 (L24-26) | ○ |
| C-27 | UndefinedFunctionErrorEnhancer::enhance()が関連しないメッセージでnullを返す | E-12 (L36-38, L42-44) | ○ |
| C-28 | UndefinedMethodErrorEnhancer::enhance()がLevenshtein距離で候補を検出する | E-13 (L44-50) | ○ |
| C-29 | CliErrorRenderer::render()がFlattenExceptionを返却する | E-14 (L26-45) | ○ |
| C-30 | HtmlErrorRenderer::render()がContent-Typeヘッダを設定する | E-17 (L62-73) | ○ |
| C-31 | HtmlErrorRenderer::render()がdebugモードでX-Debug-Exceptionヘッダを付与する | E-17 (L65-68) | ○ |
| C-32 | HtmlErrorRenderer::isDebug()がRequestStackに基づきデバッグ判定する | E-17 (L96-104) | ○ |
| C-33 | HtmlErrorRenderer::getAndCleanOutputBuffer()が出力バッファを処理する | E-17 (L106-123) | ○ |
| C-34 | FileLinkFormatter::__construct()がIDE名からフォーマットを解決する | E-16 (L32-47) | ○ |
| C-35 | FileLinkFormatter::format()がファイルリンクを生成する | E-16 (L49-63) | ○ |
| C-36 | FileLinkFormatter::generateUrlFormat()がルーターからURL形式を生成する | E-16 (L75-82) | ○ |
| C-37 | SerializerErrorRenderer::render()がシリアライザでフォーマットする | E-18 (L47-71) | ○ |
| C-38 | SerializerErrorRenderer::render()がNotEncodableValueExceptionでフォールバックする | E-18 (L66-67) | ○ |
| C-39 | SerializerErrorRenderer::getPreferredFormat()がリクエストなしで例外をスローする | E-18 (L73-82) | ○ |
| C-40 | FlattenException::createFromThrowable()がHTTPステータスコードを設定する | E-19 (L50-86) | ○ |
| C-41 | FlattenException::setMessage()が匿名クラス名を正規化する | E-19 (L228-237) | ○ |
| C-42 | FlattenException::setTrace()がトレースを構造化する | E-19 (L304-339) | ○ |
| C-43 | FlattenException::flattenArgs()が10000件超で切り詰める | E-19 (L360-361) | ○ |
| C-44 | FlattenException::flattenArgs()が10階層超で切り詰める | E-19 (L368-369) | ○ |
| C-45 | FlattenException::getAsString()がpreviousチェーンを'Next'で連結する | E-19 (L413-439) | ○ |
| C-46 | SilencedErrorContext::jsonSerialize()が全プロパティを含む配列を返す | E-20 (L53-62) | ○ |
| C-47 | DebugClassLoader::enable()が全オートローダーをラップする | E-21 (L189-210) | ○ |
| C-48 | DebugClassLoader::disable()がラップを解除する | E-21 (L215-232) | ○ |
| C-49 | DebugClassLoader::loadClass()でクラス名の不一致を検出する | E-21 (L294-319, L321-367) | ○ |
| C-50 | DebugClassLoader::checkAnnotations()が@final/@deprecated/@internalを検出する | E-21 (L369-673) | ○ |
| C-51 | ErrorDumpCommand::execute()がHTMLファイルをダンプする | E-22 (L55-66) | ○ |
| C-52 | ErrorDumpCommand::dump()がforceオプションで既存ディレクトリを削除する | E-22 (L74-76) | ○ |
| C-53 | Debug::enable()のCLI環境でのdisplay_errors設定 | E-02 (L25-30) | △ |
| C-54 | ErrorHandler::handleError()の再帰防止メカニズム | E-03 (L453-462) | △ |
| C-55 | DebugClassLoader::darwinRealpath()のMacOS固有パス正規化 | E-21 (L714-780) | △ |
| C-56 | ClassNotFoundErrorEnhancer::getClassCandidates()のComposerオートローダー依存 | E-10 (L68-106) | △ |

## 4) 不足情報（Unknown / Missing）
- **CLI環境固有の動作 (C-53)**: PHP_SAPI='cli'かつlog_errors/error_log設定に依存するため、実行環境によって挙動が異なる可能性がある
  - 候補：PHP実行環境のSAPI設定 / ini設定ファイル / テスト環境のphp.ini
- **再帰防止メカニズム (C-54)**: isRecursiveフラグの動作は、ロガー実装が例外をスローするケースに依存する
  - 候補：ロガー実装のエラー発生パターン / ErrorHandlerの内部状態管理
- **MacOS固有のパス正規化 (C-55)**: darwinRealpath()はPHP_OS_FAMILY='Darwin'でのみ使用され、テスト環境に依存する
  - 候補：MacOS HFS+ファイルシステム仕様 / テスト環境のOS情報
- **Composerオートローダー依存 (C-56)**: getClassCandidates()はComposer ClassLoaderに依存しており、テスト環境のオートローダー構成に依存する
  - 候補：composer.jsonのautoload設定 / テスト用オートローダーの構成

## 5) リスクフラグ（レビュー観点）
- 0: ErrorHandler::register()、handleError()、handleException()のテストケース -- ソースコードから直接導出、低リスク
- 0: FlattenExceptionの全getter/setterペア -- 単純なプロパティアクセス、低リスク
- 0: ErrorEnhancer系の正規表現パターンマッチ -- ソースコードの正規表現パターンと完全一致、低リスク
- 1: DebugClassLoader::checkAnnotations()の複雑な分岐 -- 多くの条件分岐があり、全パスのテストケースが網羅されているか要確認、中リスク
- 1: ErrorHandler::handleFatalError()のシャットダウン関数 -- PHPランタイムの状態に依存する部分があるため、テスト実行時の注意が必要、中リスク
- 1: HtmlErrorRendererの各privateメソッド -- privateメソッドの直接テストは困難であり、render()経由の間接テストが必要、中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 全publicメソッドに対してテストケースが存在するか確認
- [ ] ErrorHandler::handleError()の各条件分岐（thrownErrors, loggedErrors, screamedErrors）が網羅されているか確認
- [ ] FlattenException::createFromThrowable()のHttpExceptionInterface/RequestExceptionInterface/通常Exceptionの3パターンが網羅されているか確認
- [ ] ErrorEnhancer系の正規表現パターンマッチが正しいメッセージフォーマットを想定しているか確認
- [ ] DebugClassLoader::checkAnnotations()の@final/@deprecated/@internal/@methodアノテーション処理が網羅されているか確認
- [ ] ErrorDumpCommandのコンストラクタ依存（Filesystem, ErrorRendererInterface, EntrypointLookupInterface）のモック設計が適切か確認
- [ ] BufferingLogger::__destruct()のコンテキスト型（scalar, Stringable, DateTimeInterface, object, その他）の全分岐が網羅されているか確認
- [ ] テストID（UT-ERH-xxx）の連番が正しく、重複がないことを確認
